'''
Defines a function that allows L{Task} classes to register their names to 
suggest all possible event names and defaults to buffer to an 
L{AEMonitor.EventMonitor}s.

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2005 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made 
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''
# recommendation for which tasks should be displayed by default by EventMonitor
_default_types = []
# all registered Task types; used to build display menu in EventMonitor
_all_types = []

def registerTaskType(name, default):
  '''
  Called once by every L{Task} class to register itself for buffering and 
  filtering by an L{AEMonitor.EventMonitor}.
  
  @param name: Name of the L{Task}
  @type name: string
  @param default: Should this L{Task} be buffered by default?
  @type default: boolean
  '''
  global _default_types
  global _all_types
  _all_types.append(name)
  if default:
    _default_types.append(name)