'''
Defines a class that subclasses L{GSpeech} to support the Festival speech engine
via gnome-speech.

@author: Peter Parente
@organization: IBM Corporation
@copyright: Copyright (c) 2006 IBM Corporation
@license: Common Public License 1.0

All rights reserved. This program and the accompanying materials are made
available under the terms of the Common Public License v1.0 which accompanies
this distribution, and is available at
U{http://www.opensource.org/licenses/cpl1.0.php}
'''
import AEOutput
import GSpeech

class FestivalSpeech(GSpeech.GSpeech):
  '''
  Defines a class to send output from LSR to Festival using the gnome-speech
  API. Stores the Festival speech server OAFIID in L{DEVICE_IID} so that the
  base class can initialize the engine.
  '''
  DEVICE_IID = 'OAFIID:GNOME_Speech_SynthesisDriver_Festival:proto0.3'
  
  def useThread(self):
    '''
    @return: False since Festival output is asynchronous via gnome-speech (at
      present)
    @rtype: boolean
    '''
    return False
  
  def getCommandChars(self):
    '''
    Returns an empty string since this device does not use markup for sending 
    commands by default.

    Overrides L{AEOutput.Base.AEOutput.getCommandChars}

    @return: An empty string since this implementation allows any character.
    @rtype: string
    '''
    return ''