#include "sw-status-update-ginterface.h"

#include "sw-marshals.h"

static const DBusGObjectInfo _sw_status_update_iface_object_info;

struct _SwStatusUpdateIfaceClass {
    GTypeInterface parent_class;
    sw_status_update_iface_update_status_impl update_status;
};

enum {
    SIGNAL_STATUS_UPDATE_IFACE_StatusUpdated,
    N_STATUS_UPDATE_IFACE_SIGNALS
};
static guint status_update_iface_signals[N_STATUS_UPDATE_IFACE_SIGNALS] = {0};

static void sw_status_update_iface_base_init (gpointer klass);

GType
sw_status_update_iface_get_type (void)
{
  static GType type = 0;

  if (G_UNLIKELY (type == 0))
    {
      static const GTypeInfo info = {
        sizeof (SwStatusUpdateIfaceClass),
        sw_status_update_iface_base_init, /* base_init */
        NULL, /* base_finalize */
        NULL, /* class_init */
        NULL, /* class_finalize */
        NULL, /* class_data */
        0,
        0, /* n_preallocs */
        NULL /* instance_init */
      };

      type = g_type_register_static (G_TYPE_INTERFACE,
          "SwStatusUpdateIface", &info, 0);
    }

  return type;
}

/**
 * sw_status_update_iface_update_status_impl:
 * @self: The object implementing this interface
 * @in_status_message: const gchar * (FIXME, generate documentation)
 * @in_fields: GHashTable * (FIXME, generate documentation)
 * @context: Used to return values or throw an error
 *
 * The signature of an implementation of the D-Bus method
 * UpdateStatus on interface com.meego.libsocialweb.StatusUpdate.
 */
static void
sw_status_update_iface_update_status (SwStatusUpdateIface *self,
    const gchar *in_status_message,
    GHashTable *in_fields,
    DBusGMethodInvocation *context)
{
  sw_status_update_iface_update_status_impl impl = (SW_STATUS_UPDATE_IFACE_GET_CLASS (self)->update_status);

  if (impl != NULL)
    {
      (impl) (self,
        in_status_message,
        in_fields,
        context);
    }
  else
    {
      GError e = { DBUS_GERROR, 
           DBUS_GERROR_UNKNOWN_METHOD,
           "Method not implemented" };

      dbus_g_method_return_error (context, &e);
    }
}

/**
 * sw_status_update_iface_implement_update_status:
 * @klass: A class whose instances implement this interface
 * @impl: A callback used to implement the UpdateStatus D-Bus method
 *
 * Register an implementation for the UpdateStatus method in the vtable
 * of an implementation of this interface. To be called from
 * the interface init function.
 */
void
sw_status_update_iface_implement_update_status (SwStatusUpdateIfaceClass *klass, sw_status_update_iface_update_status_impl impl)
{
  klass->update_status = impl;
}

/**
 * sw_status_update_iface_emit_status_updated:
 * @instance: The object implementing this interface
 * @arg_success: gboolean  (FIXME, generate documentation)
 *
 * Type-safe wrapper around g_signal_emit to emit the
 * StatusUpdated signal on interface com.meego.libsocialweb.StatusUpdate.
 */
void
sw_status_update_iface_emit_status_updated (gpointer instance,
    gboolean arg_success)
{
  g_assert (instance != NULL);
  g_assert (G_TYPE_CHECK_INSTANCE_TYPE (instance, SW_TYPE_STATUS_UPDATE_IFACE));
  g_signal_emit (instance,
      status_update_iface_signals[SIGNAL_STATUS_UPDATE_IFACE_StatusUpdated],
      0,
      arg_success);
}

static inline void
sw_status_update_iface_base_init_once (gpointer klass G_GNUC_UNUSED)
{
  dbus_g_object_type_install_info (sw_status_update_iface_get_type (),
      &_sw_status_update_iface_object_info);

  /**
   * SwStatusUpdateIface::status-updated:
   * @arg_success: gboolean  (FIXME, generate documentation)
   *
   * The StatusUpdated D-Bus signal is emitted whenever this GObject signal is.
   */
  status_update_iface_signals[SIGNAL_STATUS_UPDATE_IFACE_StatusUpdated] =
  g_signal_new ("status-updated",
      G_OBJECT_CLASS_TYPE (klass),
      G_SIGNAL_RUN_LAST|G_SIGNAL_DETAILED,
      0,
      NULL, NULL,
      g_cclosure_marshal_VOID__BOOLEAN,
      G_TYPE_NONE,
      1,
      G_TYPE_BOOLEAN);

}
static void
sw_status_update_iface_base_init (gpointer klass)
{
  static gboolean initialized = FALSE;

  if (!initialized)
    {
      initialized = TRUE;
      sw_status_update_iface_base_init_once (klass);
    }
}
static const DBusGMethodInfo _sw_status_update_iface_methods[] = {
  { (GCallback) sw_status_update_iface_update_status, sw_marshal_VOID__STRING_BOXED_POINTER, 0 },
};

static const DBusGObjectInfo _sw_status_update_iface_object_info = {
  0,
  _sw_status_update_iface_methods,
  1,
"com.meego.libsocialweb.StatusUpdate\0UpdateStatus\0A\0status_message\0I\0s\0fields\0I\0a{ss}\0\0\0",
"com.meego.libsocialweb.StatusUpdate\0StatusUpdated\0\0",
"\0\0",
};


