// Generated by gtkmmproc -- DO NOT MODIFY!


#include <librsvgmm/rsvg.h>
#include <librsvgmm/private/rsvg_p.h>

/* Copyright (c) 2009  Daniel Elstner <daniel.kitta@gmail.com>
 *
 * This file is part of librsvgmm.
 *
 * librsvgmm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2.1 of the License,
 * or (at your option) any later version.
 *
 * librsvgmm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <librsvg/rsvg-cairo.h>
#include <librsvg/librsvg-enum-types.h>
#include <librsvgmm/wrap_init.h>

namespace Rsvg
{

void init()
{
  rsvg_init();
  Glib::init();
  Rsvg::wrap_init();
}

void term()
{
  rsvg_term();
}

void set_default_dpi(double dpi)
{
  rsvg_set_default_dpi(dpi);
}

void set_default_dpi(double dpi_x, double dpi_y)
{
  rsvg_set_default_dpi_x_y(dpi_x, dpi_y);
}

} // namespace Rsvg

namespace
{
} // anonymous namespace


Rsvg::Error::Error(Rsvg::Error::Code error_code, const Glib::ustring& error_message)
:
  Glib::Error (RSVG_ERROR, error_code, error_message)
{}

Rsvg::Error::Error(GError* gobject)
:
  Glib::Error (gobject)
{}

Rsvg::Error::Code Rsvg::Error::code() const
{
  return static_cast<Code>(Glib::Error::code());
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Rsvg::Error::throw_func(GError* gobject)
{
  throw Rsvg::Error(gobject);
}
#else
//When not using exceptions, we just pass the Exception object around without throwing it:
std::auto_ptr<Glib::Error> Rsvg::Error::throw_func(GError* gobject)
{
  return std::auto_ptr<Glib::Error>(new Rsvg::Error(gobject));
}
#endif //GLIBMM_EXCEPTIONS_ENABLED

// static
GType Glib::Value<Rsvg::Error::Code>::value_type()
{
  return rsvg_error_get_type();
}


namespace Glib
{

Glib::RefPtr<Rsvg::Handle> wrap(RsvgHandle* object, bool take_copy)
{
  return Glib::RefPtr<Rsvg::Handle>( dynamic_cast<Rsvg::Handle*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Rsvg
{


/* The *_Class implementation: */

const Glib::Class& Handle_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Handle_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(rsvg_handle_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Handle_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
}

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


Glib::ObjectBase* Handle_Class::wrap_new(GObject* object)
{
  return new Handle((RsvgHandle*)object);
}


/* The implementation: */

RsvgHandle* Handle::gobj_copy()
{
  reference();
  return gobj();
}

Handle::Handle(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Handle::Handle(RsvgHandle* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Handle::~Handle()
{}


Handle::CppClassType Handle::handle_class_; // initialize static member

GType Handle::get_type()
{
  return handle_class_.init().get_type();
}


GType Handle::get_base_type()
{
  return rsvg_handle_get_type();
}


Handle::Handle()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(handle_class_.init()))
{
  

}

Glib::RefPtr<Handle> Handle::create()
{
  return Glib::RefPtr<Handle>( new Handle() );
}
#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<Handle> Handle::create_from_data(const guint8* data, gsize data_len)
#else
Glib::RefPtr<Handle> Handle::create_from_data(const guint8* data, gsize data_len, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<Handle> retvalue = Glib::wrap(rsvg_handle_new_from_data(data, data_len, &(gerror)));

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;
}


#ifdef GLIBMM_EXCEPTIONS_ENABLED
Glib::RefPtr<Handle> Handle::create_from_file(const std::string& file_name)
#else
Glib::RefPtr<Handle> Handle::create_from_file(const std::string& file_name, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  Glib::RefPtr<Handle> retvalue = Glib::wrap(rsvg_handle_new_from_file(file_name.c_str(), &(gerror)));

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  return retvalue;
}


void Handle::set_dpi(double dpi)
{
rsvg_handle_set_dpi(gobj(), dpi); 
}

void Handle::set_dpi(double dpi_x, double dpi_y)
{
rsvg_handle_set_dpi_x_y(gobj(), dpi_x, dpi_y); 
}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Handle::write(const guint8* buf, gsize count)
#else
void Handle::write(const guint8* buf, gsize count, std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  rsvg_handle_write(gobj(), buf, count, &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED


}

#ifdef GLIBMM_EXCEPTIONS_ENABLED
void Handle::close()
#else
void Handle::close(std::auto_ptr<Glib::Error>& error)
#endif //GLIBMM_EXCEPTIONS_ENABLED
{
  GError* gerror = 0;
  rsvg_handle_close(gobj(), &(gerror));
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
#else
  if(gerror)
    error = ::Glib::Error::throw_exception(gerror);
#endif //GLIBMM_EXCEPTIONS_ENABLED


}

Glib::ustring Handle::get_base_uri() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(rsvg_handle_get_base_uri(const_cast<RsvgHandle*>(gobj())));
}

void Handle::set_base_uri(const Glib::ustring& base_uri)
{
rsvg_handle_set_base_uri(gobj(), base_uri.c_str()); 
}

void Handle::get_dimensions(DimensionData& dimension_data) const
{
rsvg_handle_get_dimensions(const_cast<RsvgHandle*>(gobj()), &(dimension_data)); 
}

bool Handle::get_dimensions_sub(DimensionData& dimension_data, const Glib::ustring& id) const
{
  return rsvg_handle_get_dimensions_sub(const_cast<RsvgHandle*>(gobj()), &(dimension_data), id.c_str());
}

bool Handle::get_position_sub(PositionData& position_data, const Glib::ustring& id) const
{
  return rsvg_handle_get_position_sub(const_cast<RsvgHandle*>(gobj()), &(position_data), id.c_str());
}

bool Handle::has_sub(const Glib::ustring& id) const
{
  return rsvg_handle_has_sub(const_cast<RsvgHandle*>(gobj()), id.c_str());
}

bool Handle::render(const Cairo::RefPtr<Cairo::Context>& cr) const
{
  return rsvg_handle_render_cairo(const_cast<RsvgHandle*>(gobj()), (cr)->cobj());
}

bool Handle::render_sub(const Cairo::RefPtr<Cairo::Context>& cr, const Glib::ustring& id) const
{
  return rsvg_handle_render_cairo_sub(const_cast<RsvgHandle*>(gobj()), (cr)->cobj(), id.c_str());
}

Glib::ustring Handle::get_title() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(rsvg_handle_get_title(const_cast<RsvgHandle*>(gobj())));
}

Glib::ustring Handle::get_desc() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(rsvg_handle_get_desc(const_cast<RsvgHandle*>(gobj())));
}

Glib::ustring Handle::get_metadata() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(rsvg_handle_get_metadata(const_cast<RsvgHandle*>(gobj())));
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<double> Handle::property_dpi_x() 
{
  return Glib::PropertyProxy<double>(this, "dpi-x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<double> Handle::property_dpi_x() const
{
  return Glib::PropertyProxy_ReadOnly<double>(this, "dpi-x");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<double> Handle::property_dpi_y() 
{
  return Glib::PropertyProxy<double>(this, "dpi-y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<double> Handle::property_dpi_y() const
{
  return Glib::PropertyProxy_ReadOnly<double>(this, "dpi-y");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Handle::property_base_uri() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "base-uri");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Handle::property_base_uri() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "base-uri");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Handle::property_width() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "width");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Handle::property_height() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "height");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<double> Handle::property_em() const
{
  return Glib::PropertyProxy_ReadOnly<double>(this, "em");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<double> Handle::property_ex() const
{
  return Glib::PropertyProxy_ReadOnly<double>(this, "ex");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Handle::property_title() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "title");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Handle::property_desc() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "desc");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Handle::property_metadata() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "metadata");
}
#endif //GLIBMM_PROPERTIES_ENABLED


#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED

#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED


} // namespace Rsvg


