
#include <glib.h>

// Disable the 'const' function attribute of the get_type() functions.
// GCC would optimize them out because we don't use the return value.
#undef  G_GNUC_CONST
#define G_GNUC_CONST /* empty */

#include <librsvgmm/wrap_init.h>
#include <glibmm/error.h>
#include <glibmm/object.h>

// #include the widget headers so that we can call the get_type() static methods:

#include "rsvg.h"

extern "C"
{

//Declarations of the *_get_type() functions:

GType rsvg_handle_get_type(void);

//Declarations of the *_error_quark() functions:

GQuark rsvg_error_quark(void);
} // extern "C"


//Declarations of the *_Class::wrap_new() methods, instead of including all the private headers:

namespace Rsvg {  class Handle_Class { public: static Glib::ObjectBase* wrap_new(GObject*); };  }

namespace Rsvg { 

void wrap_init()
{
  // Register Error domains:
  Glib::Error::register_domain(rsvg_error_quark(), &Rsvg::Error::throw_func);

// Map gtypes to gtkmm wrapper-creation functions:
  Glib::wrap_register(rsvg_handle_get_type(), &Rsvg::Handle_Class::wrap_new);

  // Register the gtkmm gtypes:
  Rsvg::Handle::get_type();

} // wrap_init()

} //Rsvg


