// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBRSVGMM_RSVG_H
#define _LIBRSVGMM_RSVG_H

#include <librsvgmmconfig.h>


#include <glibmm.h>

/* Copyright (c) 2009  Daniel Elstner <daniel.kitta@gmail.com>
 *
 * This file is part of librsvgmm.
 *
 * librsvgmm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2.1 of the License,
 * or (at your option) any later version.
 *
 * librsvgmm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <cairomm/cairomm.h>
#include <librsvg/rsvg.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _RsvgHandle RsvgHandle;
typedef struct _RsvgHandleClass RsvgHandleClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Rsvg
{ class Handle_Class; } // namespace Rsvg
namespace Rsvg
{

/** Initialize librsvgmm for use.
 */
void init();

/** Shut down librsvgmm.
 */
void term();

class Error : public Glib::Error
{
public:
  enum Code
  {
    FAILED
  };

  Error(Code error_code, const Glib::ustring& error_message);
  explicit Error(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static void throw_func(GError* gobject);
#else
  //When not using exceptions, we just pass the Exception object around without throwing it:
  static std::auto_ptr<Glib::Error> throw_func(GError* gobject);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  friend void wrap_init(); // uses throw_func()
#endif
};

} // namespace Rsvg

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Rsvg::Error::Code> : public Glib::Value_Enum<Rsvg::Error::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Rsvg
{


/** Sets the DPI for the all future pixel calculations.
 * Common values are 75, 90, and 300 DPI. Passing a number <= 0 to @a dpi
 * will reset the DPI to whatever the default value happens to be.
 * @param dpi Dots per inch (aka pixels per inch)
 */
void set_default_dpi(double dpi);

/** Sets the DPI for the all future pixel calculations.
 * Common values are 75, 90, and 300 DPI. Passing a number <= 0 to @a dpi_x
 * or @a dpi_y will reset the DPI to whatever the default value happens to be.
 * @param dpi_x Horizontal dots per inch (aka pixels per inch)
 * @param dpi_y Vertical dots per inch (aka pixels per inch)
 */
void set_default_dpi(double dpi_x, double dpi_y);

struct DimensionData : RsvgDimensionData
{
  DimensionData() { width = 0; height = 0; em = 0.0; ex = 0.0; }
};

struct PositionData : RsvgPositionData
{
  PositionData() { x = 0; y = 0; }
};


class Handle : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Handle CppObjectType;
  typedef Handle_Class CppClassType;
  typedef RsvgHandle BaseObjectType;
  typedef RsvgHandleClass BaseClassType;

private:  friend class Handle_Class;
  static CppClassType handle_class_;

private:
  // noncopyable
  Handle(const Handle&);
  Handle& operator=(const Handle&);

protected:
  explicit Handle(const Glib::ConstructParams& construct_params);
  explicit Handle(RsvgHandle* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Handle();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  RsvgHandle*       gobj()       { return reinterpret_cast<RsvgHandle*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const RsvgHandle* gobj() const { return reinterpret_cast<RsvgHandle*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  RsvgHandle* gobj_copy();

private:


protected:
  Handle();

public:
  
  static Glib::RefPtr<Handle> create();

  
  /** Loads the SVG specified by #data.
   * @param data The SVG data.
   * @param data_len The length of #data, in bytes.
   * @return A RsvgHandle or <tt>0</tt> if an error occurs.
   * @newin{2,14}.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static Glib::RefPtr<Handle> create_from_data(const guint8* data, gsize data_len);
#else
  static Glib::RefPtr<Handle> create_from_data(const guint8* data, gsize data_len, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Loads the SVG specified by #file_name.
   * @param file_name The file name to load. If built with gnome-vfs, can be a URI.
   * @return A RsvgHandle or <tt>0</tt> if an error occurs.
   * @newin{2,14}.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static Glib::RefPtr<Handle> create_from_file(const std::string& file_name);
#else
  static Glib::RefPtr<Handle> create_from_file(const std::string& file_name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Sets the DPI for the outgoing pixbuf. Common values are
   * 75, 90, and 300 DPI. Passing a number <= 0 to #dpi will 
   * reset the DPI to whatever the default value happens to be.
   * 
   * @newin{2,8}
   * @param dpi Dots Per Inch (aka Pixels Per Inch).
   */
  void set_dpi(double dpi);
  
  /** Sets the DPI for the outgoing pixbuf. Common values are
   * 75, 90, and 300 DPI. Passing a number <= 0 to #dpi_x or #dpi_y will 
   * reset the DPI to whatever the default value happens to be.
   * 
   * @newin{2,8}
   * @param dpi_x Dots Per Inch (aka Pixels Per Inch).
   * @param dpi_y Dots Per Inch (aka Pixels Per Inch).
   */
  void set_dpi(double dpi_x, double dpi_y);

  
  /** Loads the next @a count bytes of the image.  This will return #<tt>true</tt> if the data
   * was loaded successful, and #<tt>false</tt> if an error occurred.  In the latter case,
   * the loader will be closed, and will not accept further writes. If <tt>false</tt> is
   * returned, @a error will be set to an error from the Rsvg::ERROR domain.
   * @param buf Pointer to svg data.
   * @param count Length of the @a buf buffer in bytes.
   * @return #<tt>true</tt> if the write was successful, or #<tt>false</tt> if there was an
   * error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void write(const guint8* buf, gsize count);
#else
  void write(const guint8* buf, gsize count, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Closes @a handle, to indicate that loading the image is complete.  This will
   * return #<tt>true</tt> if the loader closed successfully.  Note that @a handle isn't
   * freed until @a g_object_unref is called.
   * @return #<tt>true</tt> if the loader closed successfully, or #<tt>false</tt> if there was
   * an error.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  void close();
#else
  void close(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Gets the base uri for this Rsvg::Handle.
   * @return The base uri, possibly null
   * @newin{2,9} (really present in 2.8 as well).
   */
  Glib::ustring get_base_uri() const;
  
  /** Set the base URI for this SVG. This can only be called before write()
   * has been called.
   * 
   * @newin{2,9}
   * @param base_uri The base uri.
   */
  void set_base_uri(const Glib::ustring& base_uri);

  
  /** Get the SVG's size. Do not call from within the size_func callback, because an infinite loop will occur.
   * 
   * @newin{2,14}
   * @param dimension_data A place to store the SVG's size.
   */
  void get_dimensions(DimensionData& dimension_data) const;
  
  /** Get the size of a subelement of the SVG file. Do not call from within the size_func callback, because an infinite loop will occur.
   * 
   * @newin{2,22}
   * @param dimension_data A place to store the SVG's size.
   * @param id An element's id within the SVG, or <tt>0</tt> to get the dimension of the whole SVG. 
   * For example, if you have a layer called "layer1" for that you want to get the dimension, 
   * pass "#layer1" as the id.
   */
  bool get_dimensions_sub(DimensionData& dimension_data,
                                       const Glib::ustring& id) const;
  
  /** Get the position of a subelement of the SVG file. Do not call from within
   * the size_func callback, because an infinite loop will occur.
   * 
   * @newin{2,22}
   * @param position_data A place to store the SVG fragment's position.
   * @param id An element's id within the SVG.
   * For example, if you have a layer called "layer1" for that you want to get
   * the position, pass "#layer1" as the id.
   */
  bool get_position_sub(PositionData& position_data,
                                     const Glib::ustring& id) const;
  
  /** Checks whether the element @a id exists in the SVG document.
   * @param id An element's id within the SVG.
   * @return <tt>true</tt> if @a id exists in the SVG document
   * 
   * @newin{2,22}.
   */
  bool has_sub(const Glib::ustring& id) const;

  
  /** Draws a SVG to a Cairo surface
   * 
   * @newin{2,14}
   * @param cr A Cairo renderer.
   */
  bool render(const Cairo::RefPtr<Cairo::Context>& cr) const;
  
  /** Draws a subset of a SVG to a Cairo surface
   * 
   * @newin{2,14}
   * @param cr A Cairo renderer.
   * @param id An element's id within the SVG, or <tt>0</tt> to render the whole SVG. For
   * example, if you have a layer called "layer1" that you wish to render, pass 
   * "##layer1" as the id.
   */
  bool render_sub(const Cairo::RefPtr<Cairo::Context>& cr,
                               const Glib::ustring& id) const;

  
  /** Returns: The SVG's title
   * @return The SVG's title
   * 
   * @newin{2,4}.
   */
  Glib::ustring get_title() const;
  
  /** Returns: The SVG's description
   * @return The SVG's description
   * 
   * @newin{2,4}.
   */
  Glib::ustring get_desc() const;
  
  /** Returns: The SVG's title
   * @return The SVG's title
   * 
   * @newin{2,9}.
   */
  Glib::ustring get_metadata() const;

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Horizontal resolution.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_dpi_x() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Horizontal resolution.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_dpi_x() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Vertical resolution.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<double> property_dpi_y() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Vertical resolution.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_dpi_y() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Base URI.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_base_uri() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Base URI.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_base_uri() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Image width.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Image height.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<int> property_height() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** em.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_em() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** ex.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<double> property_ex() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** SVG file title.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_title() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** SVG file description.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_desc() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** SVG file metadata.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_metadata() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Rsvg


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Rsvg::Handle
   */
  Glib::RefPtr<Rsvg::Handle> wrap(RsvgHandle* object, bool take_copy = false);
}


#endif /* _LIBRSVGMM_RSVG_H */

