// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use ListModel;
use ffi;
#[cfg(any(feature = "v2_44", feature = "dox"))]
use glib;
use glib::object::IsA;
use glib::translate::*;
use std::fmt;

glib_wrapper! {
    pub struct ListStore(Object<ffi::GListStore, ffi::GListStoreClass, ListStoreClass>) @implements ListModel;

    match fn {
        get_type => || ffi::g_list_store_get_type(),
    }
}

impl ListStore {
    #[cfg(any(feature = "v2_44", feature = "dox"))]
    pub fn new(item_type: glib::types::Type) -> ListStore {
        unsafe {
            from_glib_full(ffi::g_list_store_new(item_type.to_glib()))
        }
    }
}

pub const NONE_LIST_STORE: Option<&ListStore> = None;

pub trait ListStoreExt: 'static {
    #[cfg(any(feature = "v2_44", feature = "dox"))]
    fn append<P: IsA<glib::Object>>(&self, item: &P);

    #[cfg(any(feature = "v2_44", feature = "dox"))]
    fn insert<P: IsA<glib::Object>>(&self, position: u32, item: &P);

    //#[cfg(any(feature = "v2_44", feature = "dox"))]
    //fn insert_sorted<P: IsA<glib::Object>>(&self, item: &P, compare_func: /*Unimplemented*/FnMut(/*Unimplemented*/Fundamental: Pointer, /*Unimplemented*/Fundamental: Pointer) -> i32, user_data: /*Unimplemented*/Option<Fundamental: Pointer>) -> u32;

    #[cfg(any(feature = "v2_44", feature = "dox"))]
    fn remove(&self, position: u32);

    #[cfg(any(feature = "v2_44", feature = "dox"))]
    fn remove_all(&self);

    //#[cfg(any(feature = "v2_46", feature = "dox"))]
    //fn sort(&self, compare_func: /*Unimplemented*/FnMut(/*Unimplemented*/Fundamental: Pointer, /*Unimplemented*/Fundamental: Pointer) -> i32, user_data: /*Unimplemented*/Option<Fundamental: Pointer>);

    #[cfg(any(feature = "v2_44", feature = "dox"))]
    fn splice(&self, position: u32, n_removals: u32, additions: &[glib::Object]);
}

impl<O: IsA<ListStore>> ListStoreExt for O {
    #[cfg(any(feature = "v2_44", feature = "dox"))]
    fn append<P: IsA<glib::Object>>(&self, item: &P) {
        unsafe {
            ffi::g_list_store_append(self.as_ref().to_glib_none().0, item.as_ref().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_44", feature = "dox"))]
    fn insert<P: IsA<glib::Object>>(&self, position: u32, item: &P) {
        unsafe {
            ffi::g_list_store_insert(self.as_ref().to_glib_none().0, position, item.as_ref().to_glib_none().0);
        }
    }

    //#[cfg(any(feature = "v2_44", feature = "dox"))]
    //fn insert_sorted<P: IsA<glib::Object>>(&self, item: &P, compare_func: /*Unimplemented*/FnMut(/*Unimplemented*/Fundamental: Pointer, /*Unimplemented*/Fundamental: Pointer) -> i32, user_data: /*Unimplemented*/Option<Fundamental: Pointer>) -> u32 {
    //    unsafe { TODO: call ffi::g_list_store_insert_sorted() }
    //}

    #[cfg(any(feature = "v2_44", feature = "dox"))]
    fn remove(&self, position: u32) {
        unsafe {
            ffi::g_list_store_remove(self.as_ref().to_glib_none().0, position);
        }
    }

    #[cfg(any(feature = "v2_44", feature = "dox"))]
    fn remove_all(&self) {
        unsafe {
            ffi::g_list_store_remove_all(self.as_ref().to_glib_none().0);
        }
    }

    //#[cfg(any(feature = "v2_46", feature = "dox"))]
    //fn sort(&self, compare_func: /*Unimplemented*/FnMut(/*Unimplemented*/Fundamental: Pointer, /*Unimplemented*/Fundamental: Pointer) -> i32, user_data: /*Unimplemented*/Option<Fundamental: Pointer>) {
    //    unsafe { TODO: call ffi::g_list_store_sort() }
    //}

    #[cfg(any(feature = "v2_44", feature = "dox"))]
    fn splice(&self, position: u32, n_removals: u32, additions: &[glib::Object]) {
        let n_additions = additions.len() as u32;
        unsafe {
            ffi::g_list_store_splice(self.as_ref().to_glib_none().0, position, n_removals, additions.to_glib_none().0, n_additions);
        }
    }
}

impl fmt::Display for ListStore {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        write!(f, "ListStore")
    }
}
