// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use AppInfo;
use Cancellable;
use Error;
use FileCreateFlags;
use FileIOStream;
use FileInfo;
use FileInputStream;
use FileOutputStream;
use FileQueryInfoFlags;
use FileType;
use ffi;
use glib;
use glib::object::IsA;
use glib::translate::*;
use glib_ffi;
use gobject_ffi;
use std;
use std::mem;
use std::ptr;

glib_wrapper! {
    pub struct File(Object<ffi::GFile, ffi::GFileIface>);

    match fn {
        get_type => || ffi::g_file_get_type(),
    }
}

impl File {
    pub fn new_for_commandline_arg(arg: &str) -> File {
        unsafe {
            from_glib_full(ffi::g_file_new_for_commandline_arg(arg.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_36", feature = "dox"))]
    pub fn new_for_commandline_arg_and_cwd<P: AsRef<std::path::Path>>(arg: &str, cwd: P) -> File {
        unsafe {
            from_glib_full(ffi::g_file_new_for_commandline_arg_and_cwd(arg.to_glib_none().0, cwd.as_ref().to_glib_none().0))
        }
    }

    pub fn new_for_path<P: AsRef<std::path::Path>>(path: P) -> File {
        unsafe {
            from_glib_full(ffi::g_file_new_for_path(path.as_ref().to_glib_none().0))
        }
    }

    pub fn new_for_uri(uri: &str) -> File {
        unsafe {
            from_glib_full(ffi::g_file_new_for_uri(uri.to_glib_none().0))
        }
    }

    pub fn new_tmp<P: AsRef<std::path::Path>>(tmpl: P) -> Result<(File, FileIOStream), Error> {
        unsafe {
            let mut iostream = ptr::null_mut();
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_new_tmp(tmpl.as_ref().to_glib_none().0, &mut iostream, &mut error);
            if error.is_null() { Ok((from_glib_full(ret), from_glib_full(iostream))) } else { Err(from_glib_full(error)) }
        }
    }

    pub fn parse_name(parse_name: &str) -> Option<File> {
        unsafe {
            from_glib_full(ffi::g_file_parse_name(parse_name.to_glib_none().0))
        }
    }
}

pub trait FileExt {
    fn append_to<'a, P: Into<Option<&'a Cancellable>>>(&self, flags: FileCreateFlags, cancellable: P) -> Result<FileOutputStream, Error>;

    fn append_to_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<FileOutputStream, Error>) + Send + 'static>(&self, flags: FileCreateFlags, io_priority: glib::Priority, cancellable: P, callback: Q);

    //fn copy<'a, 'b, P: IsA<File>, Q: Into<Option<&'a Cancellable>>, R: Into<Option<&'b /*Unimplemented*/FileProgressCallback>>, S: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, destination: &P, flags: /*Ignored*/FileCopyFlags, cancellable: Q, progress_callback: R, progress_callback_data: S) -> Result<(), Error>;

    //fn copy_async<'a, 'b, P: IsA<File>, Q: Into<Option<&'a Cancellable>>, R: Into<Option<&'b /*Unimplemented*/FileProgressCallback>>, S: Into<Option</*Unimplemented*/Fundamental: Pointer>>, T: FnOnce(Result<(), Error>) + Send + 'static>(&self, destination: &P, flags: /*Ignored*/FileCopyFlags, io_priority: glib::Priority, cancellable: Q, progress_callback: R, progress_callback_data: S, callback: T);

    //fn copy_attributes<'a, P: IsA<File>, Q: Into<Option<&'a Cancellable>>>(&self, destination: &P, flags: /*Ignored*/FileCopyFlags, cancellable: Q) -> Result<(), Error>;

    fn create<'a, P: Into<Option<&'a Cancellable>>>(&self, flags: FileCreateFlags, cancellable: P) -> Result<FileOutputStream, Error>;

    fn create_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<FileOutputStream, Error>) + Send + 'static>(&self, flags: FileCreateFlags, io_priority: glib::Priority, cancellable: P, callback: Q);

    fn create_readwrite<'a, P: Into<Option<&'a Cancellable>>>(&self, flags: FileCreateFlags, cancellable: P) -> Result<FileIOStream, Error>;

    fn create_readwrite_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<FileIOStream, Error>) + Send + 'static>(&self, flags: FileCreateFlags, io_priority: glib::Priority, cancellable: P, callback: Q);

    fn delete<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result<(), Error>;

    #[cfg(any(feature = "v2_34", feature = "dox"))]
    fn delete_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<(), Error>) + Send + 'static>(&self, io_priority: glib::Priority, cancellable: P, callback: Q);

    fn dup(&self) -> Option<File>;

    //#[deprecated]
    //fn eject_mountable<'a, 'b, P: Into<Option<&'a Cancellable>>, Q: Into<Option<&'b /*Unimplemented*/AsyncReadyCallback>>, R: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, flags: /*Ignored*/MountUnmountFlags, cancellable: P, callback: Q, user_data: R);

    //fn eject_mountable_with_operation<'a, 'b, 'c, P: Into<Option<&'a MountOperation>>, Q: Into<Option<&'b Cancellable>>, R: Into<Option<&'c /*Unimplemented*/AsyncReadyCallback>>, S: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, flags: /*Ignored*/MountUnmountFlags, mount_operation: P, cancellable: Q, callback: R, user_data: S);

    //fn enumerate_children<'a, P: Into<Option<&'a Cancellable>>>(&self, attributes: &str, flags: FileQueryInfoFlags, cancellable: P) -> Result</*Ignored*/FileEnumerator, Error>;

    fn equal<P: IsA<File>>(&self, file2: &P) -> bool;

    //fn find_enclosing_mount<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result</*Ignored*/Mount, Error>;

    fn get_basename(&self) -> Option<std::path::PathBuf>;

    fn get_child<P: AsRef<std::path::Path>>(&self, name: P) -> Option<File>;

    fn get_child_for_display_name(&self, display_name: &str) -> Result<File, Error>;

    fn get_parent(&self) -> Option<File>;

    fn get_parse_name(&self) -> Option<String>;

    fn get_path(&self) -> Option<std::path::PathBuf>;

    fn get_relative_path<P: IsA<File>>(&self, descendant: &P) -> Option<std::path::PathBuf>;

    fn get_uri(&self) -> Option<String>;

    fn get_uri_scheme(&self) -> Option<String>;

    fn has_parent<'a, P: IsA<File> + 'a, Q: Into<Option<&'a P>>>(&self, parent: Q) -> bool;

    fn has_prefix<P: IsA<File>>(&self, prefix: &P) -> bool;

    fn has_uri_scheme(&self, uri_scheme: &str) -> bool;

    fn is_native(&self) -> bool;

    fn load_contents<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result<(Vec<u8>, String), Error>;

    fn load_contents_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<(Vec<u8>, String), Error>) + Send + 'static>(&self, cancellable: P, callback: Q);

    //fn load_partial_contents_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<(Vec<u8>, String), Error>) + Send + 'static>(&self, cancellable: P, read_more_callback: /*Unknown conversion*//*Unimplemented*/FileReadMoreCallback, callback: Q);

    fn make_directory<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result<(), Error>;

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    fn make_directory_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<(), Error>) + Send + 'static>(&self, io_priority: glib::Priority, cancellable: P, callback: Q);

    fn make_directory_with_parents<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result<(), Error>;

    fn make_symbolic_link<'a, P: AsRef<std::path::Path>, Q: Into<Option<&'a Cancellable>>>(&self, symlink_value: P, cancellable: Q) -> Result<(), Error>;

    //#[cfg(any(feature = "v2_38", feature = "dox"))]
    //fn measure_disk_usage<'a, 'b, P: Into<Option<&'a Cancellable>>, Q: Into<Option<&'b /*Unimplemented*/FileMeasureProgressCallback>>, R: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, flags: /*Ignored*/FileMeasureFlags, cancellable: P, progress_callback: Q, progress_data: R) -> Result<(u64, u64, u64), Error>;

    //#[cfg(any(feature = "v2_38", feature = "dox"))]
    //fn measure_disk_usage_async<'a, 'b, P: Into<Option<&'a Cancellable>>, Q: Into<Option<&'b /*Unimplemented*/FileMeasureProgressCallback>>, R: Into<Option</*Unimplemented*/Fundamental: Pointer>>, S: FnOnce(Result<(u64, u64, u64), Error>) + Send + 'static>(&self, flags: /*Ignored*/FileMeasureFlags, io_priority: glib::Priority, cancellable: P, progress_callback: Q, progress_data: R, callback: S);

    //fn monitor<'a, P: Into<Option<&'a Cancellable>>>(&self, flags: /*Ignored*/FileMonitorFlags, cancellable: P) -> Result</*Ignored*/FileMonitor, Error>;

    //fn monitor_directory<'a, P: Into<Option<&'a Cancellable>>>(&self, flags: /*Ignored*/FileMonitorFlags, cancellable: P) -> Result</*Ignored*/FileMonitor, Error>;

    //fn monitor_file<'a, P: Into<Option<&'a Cancellable>>>(&self, flags: /*Ignored*/FileMonitorFlags, cancellable: P) -> Result</*Ignored*/FileMonitor, Error>;

    //fn mount_enclosing_volume<'a, 'b, 'c, P: Into<Option<&'a MountOperation>>, Q: Into<Option<&'b Cancellable>>, R: Into<Option<&'c /*Unimplemented*/AsyncReadyCallback>>, S: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, flags: /*Ignored*/MountMountFlags, mount_operation: P, cancellable: Q, callback: R, user_data: S);

    //fn mount_mountable<'a, 'b, 'c, P: Into<Option<&'a MountOperation>>, Q: Into<Option<&'b Cancellable>>, R: Into<Option<&'c /*Unimplemented*/AsyncReadyCallback>>, S: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, flags: /*Ignored*/MountMountFlags, mount_operation: P, cancellable: Q, callback: R, user_data: S);

    //fn move_<'a, 'b, P: IsA<File>, Q: Into<Option<&'a Cancellable>>, R: Into<Option<&'b /*Unimplemented*/FileProgressCallback>>, S: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, destination: &P, flags: /*Ignored*/FileCopyFlags, cancellable: Q, progress_callback: R, progress_callback_data: S) -> Result<(), Error>;

    fn open_readwrite<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result<FileIOStream, Error>;

    fn open_readwrite_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<FileIOStream, Error>) + Send + 'static>(&self, io_priority: glib::Priority, cancellable: P, callback: Q);

    //fn poll_mountable<'a, 'b, P: Into<Option<&'a Cancellable>>, Q: Into<Option<&'b /*Unimplemented*/AsyncReadyCallback>>, R: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, cancellable: P, callback: Q, user_data: R);

    fn query_default_handler<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result<AppInfo, Error>;

    fn query_exists<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> bool;

    fn query_file_type<'a, P: Into<Option<&'a Cancellable>>>(&self, flags: FileQueryInfoFlags, cancellable: P) -> FileType;

    fn query_filesystem_info<'a, P: Into<Option<&'a Cancellable>>>(&self, attributes: &str, cancellable: P) -> Result<FileInfo, Error>;

    fn query_filesystem_info_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<FileInfo, Error>) + Send + 'static>(&self, attributes: &str, io_priority: glib::Priority, cancellable: P, callback: Q);

    fn query_info<'a, P: Into<Option<&'a Cancellable>>>(&self, attributes: &str, flags: FileQueryInfoFlags, cancellable: P) -> Result<FileInfo, Error>;

    fn query_info_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<FileInfo, Error>) + Send + 'static>(&self, attributes: &str, flags: FileQueryInfoFlags, io_priority: glib::Priority, cancellable: P, callback: Q);

    //fn query_settable_attributes<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result</*Ignored*/FileAttributeInfoList, Error>;

    //fn query_writable_namespaces<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result</*Ignored*/FileAttributeInfoList, Error>;

    fn read<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result<FileInputStream, Error>;

    fn read_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<FileInputStream, Error>) + Send + 'static>(&self, io_priority: glib::Priority, cancellable: P, callback: Q);

    fn replace<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b Cancellable>>>(&self, etag: P, make_backup: bool, flags: FileCreateFlags, cancellable: Q) -> Result<FileOutputStream, Error>;

    fn replace_async<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b Cancellable>>, R: FnOnce(Result<FileOutputStream, Error>) + Send + 'static>(&self, etag: P, make_backup: bool, flags: FileCreateFlags, io_priority: glib::Priority, cancellable: Q, callback: R);

    fn replace_contents<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b Cancellable>>>(&self, contents: &[u8], etag: P, make_backup: bool, flags: FileCreateFlags, cancellable: Q) -> Result<String, Error>;

    fn replace_contents_async<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b Cancellable>>, R: FnOnce(Result<String, Error>) + Send + 'static>(&self, contents: &[u8], etag: P, make_backup: bool, flags: FileCreateFlags, cancellable: Q, callback: R);

    //#[cfg(any(feature = "v2_40", feature = "dox"))]
    //fn replace_contents_bytes_async<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b Cancellable>>, R: /*Unimplemented*/AsyncReadyCallback>(&self, contents: &glib::Bytes, etag: P, make_backup: bool, flags: FileCreateFlags, cancellable: Q, callback: R);

    fn replace_readwrite<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b Cancellable>>>(&self, etag: P, make_backup: bool, flags: FileCreateFlags, cancellable: Q) -> Result<FileIOStream, Error>;

    fn replace_readwrite_async<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b Cancellable>>, R: FnOnce(Result<FileIOStream, Error>) + Send + 'static>(&self, etag: P, make_backup: bool, flags: FileCreateFlags, io_priority: glib::Priority, cancellable: Q, callback: R);

    fn resolve_relative_path<P: AsRef<std::path::Path>>(&self, relative_path: P) -> Option<File>;

    //fn set_attribute<'a, P: Into<Option</*Unimplemented*/Fundamental: Pointer>>, Q: Into<Option<&'a Cancellable>>>(&self, attribute: &str, type_: /*Ignored*/FileAttributeType, value_p: P, flags: FileQueryInfoFlags, cancellable: Q) -> Result<(), Error>;

    fn set_attribute_byte_string<'a, P: Into<Option<&'a Cancellable>>>(&self, attribute: &str, value: &str, flags: FileQueryInfoFlags, cancellable: P) -> Result<(), Error>;

    fn set_attribute_int32<'a, P: Into<Option<&'a Cancellable>>>(&self, attribute: &str, value: i32, flags: FileQueryInfoFlags, cancellable: P) -> Result<(), Error>;

    fn set_attribute_int64<'a, P: Into<Option<&'a Cancellable>>>(&self, attribute: &str, value: i64, flags: FileQueryInfoFlags, cancellable: P) -> Result<(), Error>;

    fn set_attribute_string<'a, P: Into<Option<&'a Cancellable>>>(&self, attribute: &str, value: &str, flags: FileQueryInfoFlags, cancellable: P) -> Result<(), Error>;

    fn set_attribute_uint32<'a, P: Into<Option<&'a Cancellable>>>(&self, attribute: &str, value: u32, flags: FileQueryInfoFlags, cancellable: P) -> Result<(), Error>;

    fn set_attribute_uint64<'a, P: Into<Option<&'a Cancellable>>>(&self, attribute: &str, value: u64, flags: FileQueryInfoFlags, cancellable: P) -> Result<(), Error>;

    fn set_attributes_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<FileInfo, Error>) + Send + 'static>(&self, info: &FileInfo, flags: FileQueryInfoFlags, io_priority: glib::Priority, cancellable: P, callback: Q);

    fn set_attributes_from_info<'a, P: Into<Option<&'a Cancellable>>>(&self, info: &FileInfo, flags: FileQueryInfoFlags, cancellable: P) -> Result<(), Error>;

    fn set_display_name<'a, P: Into<Option<&'a Cancellable>>>(&self, display_name: &str, cancellable: P) -> Result<File, Error>;

    fn set_display_name_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<File, Error>) + Send + 'static>(&self, display_name: &str, io_priority: glib::Priority, cancellable: P, callback: Q);

    //fn start_mountable<'a, 'b, 'c, P: Into<Option<&'a MountOperation>>, Q: Into<Option<&'b Cancellable>>, R: Into<Option<&'c /*Unimplemented*/AsyncReadyCallback>>, S: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, flags: /*Ignored*/DriveStartFlags, start_operation: P, cancellable: Q, callback: R, user_data: S);

    //fn stop_mountable<'a, 'b, 'c, P: Into<Option<&'a MountOperation>>, Q: Into<Option<&'b Cancellable>>, R: Into<Option<&'c /*Unimplemented*/AsyncReadyCallback>>, S: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, flags: /*Ignored*/MountUnmountFlags, mount_operation: P, cancellable: Q, callback: R, user_data: S);

    fn supports_thread_contexts(&self) -> bool;

    fn trash<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result<(), Error>;

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    fn trash_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<(), Error>) + Send + 'static>(&self, io_priority: glib::Priority, cancellable: P, callback: Q);

    //#[deprecated]
    //fn unmount_mountable<'a, 'b, P: Into<Option<&'a Cancellable>>, Q: Into<Option<&'b /*Unimplemented*/AsyncReadyCallback>>, R: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, flags: /*Ignored*/MountUnmountFlags, cancellable: P, callback: Q, user_data: R);

    //fn unmount_mountable_with_operation<'a, 'b, 'c, P: Into<Option<&'a MountOperation>>, Q: Into<Option<&'b Cancellable>>, R: Into<Option<&'c /*Unimplemented*/AsyncReadyCallback>>, S: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, flags: /*Ignored*/MountUnmountFlags, mount_operation: P, cancellable: Q, callback: R, user_data: S);
}

impl<O: IsA<File>> FileExt for O {
    fn append_to<'a, P: Into<Option<&'a Cancellable>>>(&self, flags: FileCreateFlags, cancellable: P) -> Result<FileOutputStream, Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_append_to(self.to_glib_none().0, flags.to_glib(), cancellable.0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn append_to_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<FileOutputStream, Error>) + Send + 'static>(&self, flags: FileCreateFlags, io_priority: glib::Priority, cancellable: P, callback: Q) {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let user_data: Box<Box<Q>> = Box::new(Box::new(callback));
        unsafe extern "C" fn append_to_async_trampoline<Q: FnOnce(Result<FileOutputStream, Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            callback_guard!();
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_append_to_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<Q>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = append_to_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_append_to_async(self.to_glib_none().0, flags.to_glib(), io_priority.to_glib(), cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    //fn copy<'a, 'b, P: IsA<File>, Q: Into<Option<&'a Cancellable>>, R: Into<Option<&'b /*Unimplemented*/FileProgressCallback>>, S: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, destination: &P, flags: /*Ignored*/FileCopyFlags, cancellable: Q, progress_callback: R, progress_callback_data: S) -> Result<(), Error> {
    //    unsafe { TODO: call ffi::g_file_copy() }
    //}

    //fn copy_async<'a, 'b, P: IsA<File>, Q: Into<Option<&'a Cancellable>>, R: Into<Option<&'b /*Unimplemented*/FileProgressCallback>>, S: Into<Option</*Unimplemented*/Fundamental: Pointer>>, T: FnOnce(Result<(), Error>) + Send + 'static>(&self, destination: &P, flags: /*Ignored*/FileCopyFlags, io_priority: glib::Priority, cancellable: Q, progress_callback: R, progress_callback_data: S, callback: T) {
    //    unsafe { TODO: call ffi::g_file_copy_async() }
    //}

    //fn copy_attributes<'a, P: IsA<File>, Q: Into<Option<&'a Cancellable>>>(&self, destination: &P, flags: /*Ignored*/FileCopyFlags, cancellable: Q) -> Result<(), Error> {
    //    unsafe { TODO: call ffi::g_file_copy_attributes() }
    //}

    fn create<'a, P: Into<Option<&'a Cancellable>>>(&self, flags: FileCreateFlags, cancellable: P) -> Result<FileOutputStream, Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_create(self.to_glib_none().0, flags.to_glib(), cancellable.0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn create_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<FileOutputStream, Error>) + Send + 'static>(&self, flags: FileCreateFlags, io_priority: glib::Priority, cancellable: P, callback: Q) {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let user_data: Box<Box<Q>> = Box::new(Box::new(callback));
        unsafe extern "C" fn create_async_trampoline<Q: FnOnce(Result<FileOutputStream, Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            callback_guard!();
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_create_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<Q>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = create_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_create_async(self.to_glib_none().0, flags.to_glib(), io_priority.to_glib(), cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    fn create_readwrite<'a, P: Into<Option<&'a Cancellable>>>(&self, flags: FileCreateFlags, cancellable: P) -> Result<FileIOStream, Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_create_readwrite(self.to_glib_none().0, flags.to_glib(), cancellable.0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn create_readwrite_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<FileIOStream, Error>) + Send + 'static>(&self, flags: FileCreateFlags, io_priority: glib::Priority, cancellable: P, callback: Q) {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let user_data: Box<Box<Q>> = Box::new(Box::new(callback));
        unsafe extern "C" fn create_readwrite_async_trampoline<Q: FnOnce(Result<FileIOStream, Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            callback_guard!();
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_create_readwrite_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<Q>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = create_readwrite_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_create_readwrite_async(self.to_glib_none().0, flags.to_glib(), io_priority.to_glib(), cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    fn delete<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result<(), Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_delete(self.to_glib_none().0, cancellable.0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_34", feature = "dox"))]
    fn delete_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<(), Error>) + Send + 'static>(&self, io_priority: glib::Priority, cancellable: P, callback: Q) {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let user_data: Box<Box<Q>> = Box::new(Box::new(callback));
        unsafe extern "C" fn delete_async_trampoline<Q: FnOnce(Result<(), Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            callback_guard!();
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_delete_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<Q>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = delete_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_delete_async(self.to_glib_none().0, io_priority.to_glib(), cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    fn dup(&self) -> Option<File> {
        unsafe {
            from_glib_full(ffi::g_file_dup(self.to_glib_none().0))
        }
    }

    //fn eject_mountable<'a, 'b, P: Into<Option<&'a Cancellable>>, Q: Into<Option<&'b /*Unimplemented*/AsyncReadyCallback>>, R: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, flags: /*Ignored*/MountUnmountFlags, cancellable: P, callback: Q, user_data: R) {
    //    unsafe { TODO: call ffi::g_file_eject_mountable() }
    //}

    //fn eject_mountable_with_operation<'a, 'b, 'c, P: Into<Option<&'a MountOperation>>, Q: Into<Option<&'b Cancellable>>, R: Into<Option<&'c /*Unimplemented*/AsyncReadyCallback>>, S: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, flags: /*Ignored*/MountUnmountFlags, mount_operation: P, cancellable: Q, callback: R, user_data: S) {
    //    unsafe { TODO: call ffi::g_file_eject_mountable_with_operation() }
    //}

    //fn enumerate_children<'a, P: Into<Option<&'a Cancellable>>>(&self, attributes: &str, flags: FileQueryInfoFlags, cancellable: P) -> Result</*Ignored*/FileEnumerator, Error> {
    //    unsafe { TODO: call ffi::g_file_enumerate_children() }
    //}

    fn equal<P: IsA<File>>(&self, file2: &P) -> bool {
        unsafe {
            from_glib(ffi::g_file_equal(self.to_glib_none().0, file2.to_glib_none().0))
        }
    }

    //fn find_enclosing_mount<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result</*Ignored*/Mount, Error> {
    //    unsafe { TODO: call ffi::g_file_find_enclosing_mount() }
    //}

    fn get_basename(&self) -> Option<std::path::PathBuf> {
        unsafe {
            from_glib_full(ffi::g_file_get_basename(self.to_glib_none().0))
        }
    }

    fn get_child<P: AsRef<std::path::Path>>(&self, name: P) -> Option<File> {
        unsafe {
            from_glib_full(ffi::g_file_get_child(self.to_glib_none().0, name.as_ref().to_glib_none().0))
        }
    }

    fn get_child_for_display_name(&self, display_name: &str) -> Result<File, Error> {
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_get_child_for_display_name(self.to_glib_none().0, display_name.to_glib_none().0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn get_parent(&self) -> Option<File> {
        unsafe {
            from_glib_full(ffi::g_file_get_parent(self.to_glib_none().0))
        }
    }

    fn get_parse_name(&self) -> Option<String> {
        unsafe {
            from_glib_full(ffi::g_file_get_parse_name(self.to_glib_none().0))
        }
    }

    fn get_path(&self) -> Option<std::path::PathBuf> {
        unsafe {
            from_glib_full(ffi::g_file_get_path(self.to_glib_none().0))
        }
    }

    fn get_relative_path<P: IsA<File>>(&self, descendant: &P) -> Option<std::path::PathBuf> {
        unsafe {
            from_glib_full(ffi::g_file_get_relative_path(self.to_glib_none().0, descendant.to_glib_none().0))
        }
    }

    fn get_uri(&self) -> Option<String> {
        unsafe {
            from_glib_full(ffi::g_file_get_uri(self.to_glib_none().0))
        }
    }

    fn get_uri_scheme(&self) -> Option<String> {
        unsafe {
            from_glib_full(ffi::g_file_get_uri_scheme(self.to_glib_none().0))
        }
    }

    fn has_parent<'a, P: IsA<File> + 'a, Q: Into<Option<&'a P>>>(&self, parent: Q) -> bool {
        let parent = parent.into();
        let parent = parent.to_glib_none();
        unsafe {
            from_glib(ffi::g_file_has_parent(self.to_glib_none().0, parent.0))
        }
    }

    fn has_prefix<P: IsA<File>>(&self, prefix: &P) -> bool {
        unsafe {
            from_glib(ffi::g_file_has_prefix(self.to_glib_none().0, prefix.to_glib_none().0))
        }
    }

    fn has_uri_scheme(&self, uri_scheme: &str) -> bool {
        unsafe {
            from_glib(ffi::g_file_has_uri_scheme(self.to_glib_none().0, uri_scheme.to_glib_none().0))
        }
    }

    fn is_native(&self) -> bool {
        unsafe {
            from_glib(ffi::g_file_is_native(self.to_glib_none().0))
        }
    }

    fn load_contents<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result<(Vec<u8>, String), Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut contents = ptr::null_mut();
            let mut length = mem::uninitialized();
            let mut etag_out = ptr::null_mut();
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_load_contents(self.to_glib_none().0, cancellable.0, &mut contents, &mut length, &mut etag_out, &mut error);
            if error.is_null() { Ok((FromGlibContainer::from_glib_full_num(contents, length as usize), from_glib_full(etag_out))) } else { Err(from_glib_full(error)) }
        }
    }

    fn load_contents_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<(Vec<u8>, String), Error>) + Send + 'static>(&self, cancellable: P, callback: Q) {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let user_data: Box<Box<Q>> = Box::new(Box::new(callback));
        unsafe extern "C" fn load_contents_async_trampoline<Q: FnOnce(Result<(Vec<u8>, String), Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            callback_guard!();
            let mut error = ptr::null_mut();
            let mut contents = ptr::null_mut();
            let mut length = mem::uninitialized();
            let mut etag_out = ptr::null_mut();
            let _ = ffi::g_file_load_contents_finish(_source_object as *mut _, res, &mut contents, &mut length, &mut etag_out, &mut error);
            let result = if error.is_null() { Ok((FromGlibContainer::from_glib_full_num(contents, length as usize), from_glib_full(etag_out))) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<Q>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = load_contents_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_load_contents_async(self.to_glib_none().0, cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    //fn load_partial_contents_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<(Vec<u8>, String), Error>) + Send + 'static>(&self, cancellable: P, read_more_callback: /*Unknown conversion*//*Unimplemented*/FileReadMoreCallback, callback: Q) {
    //    unsafe { TODO: call ffi::g_file_load_partial_contents_async() }
    //}

    fn make_directory<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result<(), Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_make_directory(self.to_glib_none().0, cancellable.0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    fn make_directory_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<(), Error>) + Send + 'static>(&self, io_priority: glib::Priority, cancellable: P, callback: Q) {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let user_data: Box<Box<Q>> = Box::new(Box::new(callback));
        unsafe extern "C" fn make_directory_async_trampoline<Q: FnOnce(Result<(), Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            callback_guard!();
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_make_directory_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<Q>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = make_directory_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_make_directory_async(self.to_glib_none().0, io_priority.to_glib(), cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    fn make_directory_with_parents<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result<(), Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_make_directory_with_parents(self.to_glib_none().0, cancellable.0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn make_symbolic_link<'a, P: AsRef<std::path::Path>, Q: Into<Option<&'a Cancellable>>>(&self, symlink_value: P, cancellable: Q) -> Result<(), Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_make_symbolic_link(self.to_glib_none().0, symlink_value.as_ref().to_glib_none().0, cancellable.0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    //#[cfg(any(feature = "v2_38", feature = "dox"))]
    //fn measure_disk_usage<'a, 'b, P: Into<Option<&'a Cancellable>>, Q: Into<Option<&'b /*Unimplemented*/FileMeasureProgressCallback>>, R: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, flags: /*Ignored*/FileMeasureFlags, cancellable: P, progress_callback: Q, progress_data: R) -> Result<(u64, u64, u64), Error> {
    //    unsafe { TODO: call ffi::g_file_measure_disk_usage() }
    //}

    //#[cfg(any(feature = "v2_38", feature = "dox"))]
    //fn measure_disk_usage_async<'a, 'b, P: Into<Option<&'a Cancellable>>, Q: Into<Option<&'b /*Unimplemented*/FileMeasureProgressCallback>>, R: Into<Option</*Unimplemented*/Fundamental: Pointer>>, S: FnOnce(Result<(u64, u64, u64), Error>) + Send + 'static>(&self, flags: /*Ignored*/FileMeasureFlags, io_priority: glib::Priority, cancellable: P, progress_callback: Q, progress_data: R, callback: S) {
    //    unsafe { TODO: call ffi::g_file_measure_disk_usage_async() }
    //}

    //fn monitor<'a, P: Into<Option<&'a Cancellable>>>(&self, flags: /*Ignored*/FileMonitorFlags, cancellable: P) -> Result</*Ignored*/FileMonitor, Error> {
    //    unsafe { TODO: call ffi::g_file_monitor() }
    //}

    //fn monitor_directory<'a, P: Into<Option<&'a Cancellable>>>(&self, flags: /*Ignored*/FileMonitorFlags, cancellable: P) -> Result</*Ignored*/FileMonitor, Error> {
    //    unsafe { TODO: call ffi::g_file_monitor_directory() }
    //}

    //fn monitor_file<'a, P: Into<Option<&'a Cancellable>>>(&self, flags: /*Ignored*/FileMonitorFlags, cancellable: P) -> Result</*Ignored*/FileMonitor, Error> {
    //    unsafe { TODO: call ffi::g_file_monitor_file() }
    //}

    //fn mount_enclosing_volume<'a, 'b, 'c, P: Into<Option<&'a MountOperation>>, Q: Into<Option<&'b Cancellable>>, R: Into<Option<&'c /*Unimplemented*/AsyncReadyCallback>>, S: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, flags: /*Ignored*/MountMountFlags, mount_operation: P, cancellable: Q, callback: R, user_data: S) {
    //    unsafe { TODO: call ffi::g_file_mount_enclosing_volume() }
    //}

    //fn mount_mountable<'a, 'b, 'c, P: Into<Option<&'a MountOperation>>, Q: Into<Option<&'b Cancellable>>, R: Into<Option<&'c /*Unimplemented*/AsyncReadyCallback>>, S: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, flags: /*Ignored*/MountMountFlags, mount_operation: P, cancellable: Q, callback: R, user_data: S) {
    //    unsafe { TODO: call ffi::g_file_mount_mountable() }
    //}

    //fn move_<'a, 'b, P: IsA<File>, Q: Into<Option<&'a Cancellable>>, R: Into<Option<&'b /*Unimplemented*/FileProgressCallback>>, S: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, destination: &P, flags: /*Ignored*/FileCopyFlags, cancellable: Q, progress_callback: R, progress_callback_data: S) -> Result<(), Error> {
    //    unsafe { TODO: call ffi::g_file_move() }
    //}

    fn open_readwrite<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result<FileIOStream, Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_open_readwrite(self.to_glib_none().0, cancellable.0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn open_readwrite_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<FileIOStream, Error>) + Send + 'static>(&self, io_priority: glib::Priority, cancellable: P, callback: Q) {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let user_data: Box<Box<Q>> = Box::new(Box::new(callback));
        unsafe extern "C" fn open_readwrite_async_trampoline<Q: FnOnce(Result<FileIOStream, Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            callback_guard!();
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_open_readwrite_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<Q>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = open_readwrite_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_open_readwrite_async(self.to_glib_none().0, io_priority.to_glib(), cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    //fn poll_mountable<'a, 'b, P: Into<Option<&'a Cancellable>>, Q: Into<Option<&'b /*Unimplemented*/AsyncReadyCallback>>, R: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, cancellable: P, callback: Q, user_data: R) {
    //    unsafe { TODO: call ffi::g_file_poll_mountable() }
    //}

    fn query_default_handler<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result<AppInfo, Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_query_default_handler(self.to_glib_none().0, cancellable.0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn query_exists<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> bool {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            from_glib(ffi::g_file_query_exists(self.to_glib_none().0, cancellable.0))
        }
    }

    fn query_file_type<'a, P: Into<Option<&'a Cancellable>>>(&self, flags: FileQueryInfoFlags, cancellable: P) -> FileType {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            from_glib(ffi::g_file_query_file_type(self.to_glib_none().0, flags.to_glib(), cancellable.0))
        }
    }

    fn query_filesystem_info<'a, P: Into<Option<&'a Cancellable>>>(&self, attributes: &str, cancellable: P) -> Result<FileInfo, Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_query_filesystem_info(self.to_glib_none().0, attributes.to_glib_none().0, cancellable.0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn query_filesystem_info_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<FileInfo, Error>) + Send + 'static>(&self, attributes: &str, io_priority: glib::Priority, cancellable: P, callback: Q) {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let user_data: Box<Box<Q>> = Box::new(Box::new(callback));
        unsafe extern "C" fn query_filesystem_info_async_trampoline<Q: FnOnce(Result<FileInfo, Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            callback_guard!();
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_query_filesystem_info_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<Q>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = query_filesystem_info_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_query_filesystem_info_async(self.to_glib_none().0, attributes.to_glib_none().0, io_priority.to_glib(), cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    fn query_info<'a, P: Into<Option<&'a Cancellable>>>(&self, attributes: &str, flags: FileQueryInfoFlags, cancellable: P) -> Result<FileInfo, Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_query_info(self.to_glib_none().0, attributes.to_glib_none().0, flags.to_glib(), cancellable.0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn query_info_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<FileInfo, Error>) + Send + 'static>(&self, attributes: &str, flags: FileQueryInfoFlags, io_priority: glib::Priority, cancellable: P, callback: Q) {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let user_data: Box<Box<Q>> = Box::new(Box::new(callback));
        unsafe extern "C" fn query_info_async_trampoline<Q: FnOnce(Result<FileInfo, Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            callback_guard!();
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_query_info_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<Q>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = query_info_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_query_info_async(self.to_glib_none().0, attributes.to_glib_none().0, flags.to_glib(), io_priority.to_glib(), cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    //fn query_settable_attributes<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result</*Ignored*/FileAttributeInfoList, Error> {
    //    unsafe { TODO: call ffi::g_file_query_settable_attributes() }
    //}

    //fn query_writable_namespaces<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result</*Ignored*/FileAttributeInfoList, Error> {
    //    unsafe { TODO: call ffi::g_file_query_writable_namespaces() }
    //}

    fn read<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result<FileInputStream, Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_read(self.to_glib_none().0, cancellable.0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn read_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<FileInputStream, Error>) + Send + 'static>(&self, io_priority: glib::Priority, cancellable: P, callback: Q) {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let user_data: Box<Box<Q>> = Box::new(Box::new(callback));
        unsafe extern "C" fn read_async_trampoline<Q: FnOnce(Result<FileInputStream, Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            callback_guard!();
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_read_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<Q>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = read_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_read_async(self.to_glib_none().0, io_priority.to_glib(), cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    fn replace<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b Cancellable>>>(&self, etag: P, make_backup: bool, flags: FileCreateFlags, cancellable: Q) -> Result<FileOutputStream, Error> {
        let etag = etag.into();
        let etag = etag.to_glib_none();
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_replace(self.to_glib_none().0, etag.0, make_backup.to_glib(), flags.to_glib(), cancellable.0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn replace_async<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b Cancellable>>, R: FnOnce(Result<FileOutputStream, Error>) + Send + 'static>(&self, etag: P, make_backup: bool, flags: FileCreateFlags, io_priority: glib::Priority, cancellable: Q, callback: R) {
        let etag = etag.into();
        let etag = etag.to_glib_none();
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let user_data: Box<Box<R>> = Box::new(Box::new(callback));
        unsafe extern "C" fn replace_async_trampoline<R: FnOnce(Result<FileOutputStream, Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            callback_guard!();
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_replace_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<R>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = replace_async_trampoline::<R>;
        unsafe {
            ffi::g_file_replace_async(self.to_glib_none().0, etag.0, make_backup.to_glib(), flags.to_glib(), io_priority.to_glib(), cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    fn replace_contents<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b Cancellable>>>(&self, contents: &[u8], etag: P, make_backup: bool, flags: FileCreateFlags, cancellable: Q) -> Result<String, Error> {
        let etag = etag.into();
        let etag = etag.to_glib_none();
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let length = contents.len() as usize;
        unsafe {
            let mut new_etag = ptr::null_mut();
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_replace_contents(self.to_glib_none().0, contents.to_glib_none().0, length, etag.0, make_backup.to_glib(), flags.to_glib(), &mut new_etag, cancellable.0, &mut error);
            if error.is_null() { Ok(from_glib_full(new_etag)) } else { Err(from_glib_full(error)) }
        }
    }

    fn replace_contents_async<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b Cancellable>>, R: FnOnce(Result<String, Error>) + Send + 'static>(&self, contents: &[u8], etag: P, make_backup: bool, flags: FileCreateFlags, cancellable: Q, callback: R) {
        let etag = etag.into();
        let etag = etag.to_glib_none();
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let length = contents.len() as usize;
        let user_data: Box<Box<R>> = Box::new(Box::new(callback));
        unsafe extern "C" fn replace_contents_async_trampoline<R: FnOnce(Result<String, Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            callback_guard!();
            let mut error = ptr::null_mut();
            let mut new_etag = ptr::null_mut();
            let _ = ffi::g_file_replace_contents_finish(_source_object as *mut _, res, &mut new_etag, &mut error);
            let result = if error.is_null() { Ok(from_glib_full(new_etag)) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<R>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = replace_contents_async_trampoline::<R>;
        unsafe {
            ffi::g_file_replace_contents_async(self.to_glib_none().0, contents.to_glib_none().0, length, etag.0, make_backup.to_glib(), flags.to_glib(), cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    //#[cfg(any(feature = "v2_40", feature = "dox"))]
    //fn replace_contents_bytes_async<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b Cancellable>>, R: /*Unimplemented*/AsyncReadyCallback>(&self, contents: &glib::Bytes, etag: P, make_backup: bool, flags: FileCreateFlags, cancellable: Q, callback: R) {
    //    unsafe { TODO: call ffi::g_file_replace_contents_bytes_async() }
    //}

    fn replace_readwrite<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b Cancellable>>>(&self, etag: P, make_backup: bool, flags: FileCreateFlags, cancellable: Q) -> Result<FileIOStream, Error> {
        let etag = etag.into();
        let etag = etag.to_glib_none();
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_replace_readwrite(self.to_glib_none().0, etag.0, make_backup.to_glib(), flags.to_glib(), cancellable.0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn replace_readwrite_async<'a, 'b, P: Into<Option<&'a str>>, Q: Into<Option<&'b Cancellable>>, R: FnOnce(Result<FileIOStream, Error>) + Send + 'static>(&self, etag: P, make_backup: bool, flags: FileCreateFlags, io_priority: glib::Priority, cancellable: Q, callback: R) {
        let etag = etag.into();
        let etag = etag.to_glib_none();
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let user_data: Box<Box<R>> = Box::new(Box::new(callback));
        unsafe extern "C" fn replace_readwrite_async_trampoline<R: FnOnce(Result<FileIOStream, Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            callback_guard!();
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_replace_readwrite_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<R>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = replace_readwrite_async_trampoline::<R>;
        unsafe {
            ffi::g_file_replace_readwrite_async(self.to_glib_none().0, etag.0, make_backup.to_glib(), flags.to_glib(), io_priority.to_glib(), cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    fn resolve_relative_path<P: AsRef<std::path::Path>>(&self, relative_path: P) -> Option<File> {
        unsafe {
            from_glib_full(ffi::g_file_resolve_relative_path(self.to_glib_none().0, relative_path.as_ref().to_glib_none().0))
        }
    }

    //fn set_attribute<'a, P: Into<Option</*Unimplemented*/Fundamental: Pointer>>, Q: Into<Option<&'a Cancellable>>>(&self, attribute: &str, type_: /*Ignored*/FileAttributeType, value_p: P, flags: FileQueryInfoFlags, cancellable: Q) -> Result<(), Error> {
    //    unsafe { TODO: call ffi::g_file_set_attribute() }
    //}

    fn set_attribute_byte_string<'a, P: Into<Option<&'a Cancellable>>>(&self, attribute: &str, value: &str, flags: FileQueryInfoFlags, cancellable: P) -> Result<(), Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_set_attribute_byte_string(self.to_glib_none().0, attribute.to_glib_none().0, value.to_glib_none().0, flags.to_glib(), cancellable.0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_attribute_int32<'a, P: Into<Option<&'a Cancellable>>>(&self, attribute: &str, value: i32, flags: FileQueryInfoFlags, cancellable: P) -> Result<(), Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_set_attribute_int32(self.to_glib_none().0, attribute.to_glib_none().0, value, flags.to_glib(), cancellable.0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_attribute_int64<'a, P: Into<Option<&'a Cancellable>>>(&self, attribute: &str, value: i64, flags: FileQueryInfoFlags, cancellable: P) -> Result<(), Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_set_attribute_int64(self.to_glib_none().0, attribute.to_glib_none().0, value, flags.to_glib(), cancellable.0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_attribute_string<'a, P: Into<Option<&'a Cancellable>>>(&self, attribute: &str, value: &str, flags: FileQueryInfoFlags, cancellable: P) -> Result<(), Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_set_attribute_string(self.to_glib_none().0, attribute.to_glib_none().0, value.to_glib_none().0, flags.to_glib(), cancellable.0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_attribute_uint32<'a, P: Into<Option<&'a Cancellable>>>(&self, attribute: &str, value: u32, flags: FileQueryInfoFlags, cancellable: P) -> Result<(), Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_set_attribute_uint32(self.to_glib_none().0, attribute.to_glib_none().0, value, flags.to_glib(), cancellable.0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_attribute_uint64<'a, P: Into<Option<&'a Cancellable>>>(&self, attribute: &str, value: u64, flags: FileQueryInfoFlags, cancellable: P) -> Result<(), Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_set_attribute_uint64(self.to_glib_none().0, attribute.to_glib_none().0, value, flags.to_glib(), cancellable.0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_attributes_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<FileInfo, Error>) + Send + 'static>(&self, info: &FileInfo, flags: FileQueryInfoFlags, io_priority: glib::Priority, cancellable: P, callback: Q) {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let user_data: Box<Box<Q>> = Box::new(Box::new(callback));
        unsafe extern "C" fn set_attributes_async_trampoline<Q: FnOnce(Result<FileInfo, Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            callback_guard!();
            let mut error = ptr::null_mut();
            let mut info = ptr::null_mut();
            let _ = ffi::g_file_set_attributes_finish(_source_object as *mut _, res, &mut info, &mut error);
            let result = if error.is_null() { Ok(from_glib_full(info)) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<Q>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = set_attributes_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_set_attributes_async(self.to_glib_none().0, info.to_glib_none().0, flags.to_glib(), io_priority.to_glib(), cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    fn set_attributes_from_info<'a, P: Into<Option<&'a Cancellable>>>(&self, info: &FileInfo, flags: FileQueryInfoFlags, cancellable: P) -> Result<(), Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_set_attributes_from_info(self.to_glib_none().0, info.to_glib_none().0, flags.to_glib(), cancellable.0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_display_name<'a, P: Into<Option<&'a Cancellable>>>(&self, display_name: &str, cancellable: P) -> Result<File, Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_set_display_name(self.to_glib_none().0, display_name.to_glib_none().0, cancellable.0, &mut error);
            if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) }
        }
    }

    fn set_display_name_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<File, Error>) + Send + 'static>(&self, display_name: &str, io_priority: glib::Priority, cancellable: P, callback: Q) {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let user_data: Box<Box<Q>> = Box::new(Box::new(callback));
        unsafe extern "C" fn set_display_name_async_trampoline<Q: FnOnce(Result<File, Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            callback_guard!();
            let mut error = ptr::null_mut();
            let ret = ffi::g_file_set_display_name_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(from_glib_full(ret)) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<Q>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = set_display_name_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_set_display_name_async(self.to_glib_none().0, display_name.to_glib_none().0, io_priority.to_glib(), cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    //fn start_mountable<'a, 'b, 'c, P: Into<Option<&'a MountOperation>>, Q: Into<Option<&'b Cancellable>>, R: Into<Option<&'c /*Unimplemented*/AsyncReadyCallback>>, S: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, flags: /*Ignored*/DriveStartFlags, start_operation: P, cancellable: Q, callback: R, user_data: S) {
    //    unsafe { TODO: call ffi::g_file_start_mountable() }
    //}

    //fn stop_mountable<'a, 'b, 'c, P: Into<Option<&'a MountOperation>>, Q: Into<Option<&'b Cancellable>>, R: Into<Option<&'c /*Unimplemented*/AsyncReadyCallback>>, S: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, flags: /*Ignored*/MountUnmountFlags, mount_operation: P, cancellable: Q, callback: R, user_data: S) {
    //    unsafe { TODO: call ffi::g_file_stop_mountable() }
    //}

    fn supports_thread_contexts(&self) -> bool {
        unsafe {
            from_glib(ffi::g_file_supports_thread_contexts(self.to_glib_none().0))
        }
    }

    fn trash<'a, P: Into<Option<&'a Cancellable>>>(&self, cancellable: P) -> Result<(), Error> {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        unsafe {
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_trash(self.to_glib_none().0, cancellable.0, &mut error);
            if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) }
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    fn trash_async<'a, P: Into<Option<&'a Cancellable>>, Q: FnOnce(Result<(), Error>) + Send + 'static>(&self, io_priority: glib::Priority, cancellable: P, callback: Q) {
        let cancellable = cancellable.into();
        let cancellable = cancellable.to_glib_none();
        let user_data: Box<Box<Q>> = Box::new(Box::new(callback));
        unsafe extern "C" fn trash_async_trampoline<Q: FnOnce(Result<(), Error>) + Send + 'static>(_source_object: *mut gobject_ffi::GObject, res: *mut ffi::GAsyncResult, user_data: glib_ffi::gpointer)
        {
            callback_guard!();
            let mut error = ptr::null_mut();
            let _ = ffi::g_file_trash_finish(_source_object as *mut _, res, &mut error);
            let result = if error.is_null() { Ok(()) } else { Err(from_glib_full(error)) };
            let callback: Box<Box<Q>> = Box::from_raw(user_data as *mut _);
            callback(result);
        }
        let callback = trash_async_trampoline::<Q>;
        unsafe {
            ffi::g_file_trash_async(self.to_glib_none().0, io_priority.to_glib(), cancellable.0, Some(callback), Box::into_raw(user_data) as *mut _);
        }
    }

    //fn unmount_mountable<'a, 'b, P: Into<Option<&'a Cancellable>>, Q: Into<Option<&'b /*Unimplemented*/AsyncReadyCallback>>, R: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, flags: /*Ignored*/MountUnmountFlags, cancellable: P, callback: Q, user_data: R) {
    //    unsafe { TODO: call ffi::g_file_unmount_mountable() }
    //}

    //fn unmount_mountable_with_operation<'a, 'b, 'c, P: Into<Option<&'a MountOperation>>, Q: Into<Option<&'b Cancellable>>, R: Into<Option<&'c /*Unimplemented*/AsyncReadyCallback>>, S: Into<Option</*Unimplemented*/Fundamental: Pointer>>>(&self, flags: /*Ignored*/MountUnmountFlags, mount_operation: P, cancellable: Q, callback: R, user_data: S) {
    //    unsafe { TODO: call ffi::g_file_unmount_mountable_with_operation() }
    //}
}
