/* LibGTcpSocket: src/gtcp-dns.c
 *
 * Copyright (C) 2001 James M. Cape
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License as
 * published by the Free Software Foundation; version 2 of the
 * License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

/*

GLib 2.0 DNS lookup backend.

Notes on editing:
	Tab size: 4
*/


#ifndef __GTCP_DNS_H__
#define __GTCP_DNS_H__ 1

#include <glib.h>
#include <glib-object.h>

#include "gtcp-socket-types.h"

G_BEGIN_DECLS

#define GTCP_TYPE_DNS_ENTRY		(gtcp_dns_entry_get_type ())
#define GTCP_DNS_ENTRY(ptr)		((GTcpDNSEntry *)(ptr))
#define GTCP_DNS_INVALID_HANDLE	-1


typedef glong GTcpDNSHandle;
typedef struct _GTcpDNSEntry GTcpDNSEntry;

typedef void (*GTcpDNSCallbackFunc) (const GTcpDNSEntry * entry,
									 gpointer user_data);


struct _GTcpDNSEntry
{
	GTcpLookupStatus status;

	gchar *hostname;
	GSList *aliases;
	GSList *ip_addresses;
};


GTcpDNSHandle gtcp_dns_get (const gchar * address,
							GTcpDNSCallbackFunc callback,
							gpointer user_data);
void gtcp_dns_cancel (GTcpDNSHandle handle);

void gtcp_dns_entry_free (GTcpDNSEntry * entry);
GTcpDNSEntry *gtcp_dns_entry_copy (const GTcpDNSEntry *src);

GType gtcp_dns_entry_get_type (void);


G_END_DECLS 
#endif /* __GTCP_DNS_H__ */
