/* Stock icons, buttons, and menu items.
   Copyright (C) 1997, 1998 Free Software Foundation
   All rights reserved.

   The Gnome Library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public License as
   published by the Free Software Foundation; either version 2 of the
   License, or (at your option) any later version.

   The Gnome Library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with the Gnome Library; see the file COPYING.LIB.  If not,
   write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.

   Author: Eckehard Berns
*/
/*
  @NOTATION@
*/

#ifndef __GNOME_STOCK_ICONS_H__
#define __GNOME_STOCK_ICONS_H__

#include <glib/gmacros.h>
#include <gtk/gtkiconfactory.h>

G_BEGIN_DECLS

extern void init_gnome_stock_icons (void);

#define GNOME_STOCK_TIMER "gnome-stock-timer"
#define GNOME_STOCK_TIMER_STOP "gnome-stock-timer-stop"
#define GNOME_STOCK_TRASH "gnome-stock-trash"
#define GNOME_STOCK_TRASH_FULL "gnome-stock-trash-full"

#define GNOME_STOCK_SCORES "gnome-stock-scores"
#define GNOME_STOCK_ABOUT "gnome-stock-about"
#define GNOME_STOCK_BLANK "gnome-stock-blank"

#define GNOME_STOCK_VOLUME "gnome-stock-volume"
#define GNOME_STOCK_MIDI "gnome-stock-midi"
#define GNOME_STOCK_MIC "gnome-stock-mic"
#define GNOME_STOCK_LINE_IN "gnome-stock-line-in"

#define GNOME_STOCK_MAIL "gnome-stock-mail"
#define GNOME_STOCK_MAIL_RCV "gnome-stock-mail-rcv"
#define GNOME_STOCK_MAIL_SND "gnome-stock-mail-snd"
#define GNOME_STOCK_MAIL_RPL "gnome-stock-mail-rpl"
#define GNOME_STOCK_MAIL_FWD "gnome-stock-mail-fwd"
#define GNOME_STOCK_MAIL_NEW "gnome-stock-mail-new"
#define GNOME_STOCK_ATTACH "gnome-stock-attach"

#define GNOME_STOCK_BOOK_RED "gnome-stock-book-red"
#define GNOME_STOCK_BOOK_GREEN "gnome-stock-book-green"
#define GNOME_STOCK_BOOK_BLUE "gnome-stock-book-blue"
#define GNOME_STOCK_BOOK_YELLOW "gnome-stock-book-yellow"
#define GNOME_STOCK_BOOK_OPEN "gnome-stock-book-open"

#define GNOME_STOCK_MULTIPLE_FILE "gnome-stock-multiple-file"
#define GNOME_STOCK_NOT "gnome-stock-not"

#define GNOME_STOCK_TABLE_BORDERS "gnome-stock-table-borders"
#define GNOME_STOCK_TABLE_FILL "gnome-stock-table-fill"

#define GNOME_STOCK_TEXT_INDENT "gnome-stock-text-indent"
#define GNOME_STOCK_TEXT_UNINDENT "gnome-stock-text-unindent"
#define GNOME_STOCK_TEXT_BULLETED_LIST "gnome-stock-text-bulleted-list"
#define GNOME_STOCK_TEXT_NUMBERED_LIST "gnome-stock-text-numbered-list"

/* And now for some deprecated items, you should use the GTK_STOCK_
 * equivalents for these.  Note that the BUTTON ones are now defined
 * in gnome-dialog.h and also deprecated in favour of the GTK_STOCK_
 * ones */

#ifndef GNOME_DISABLE_DEPRECATED

#define GNOME_STOCK_PIXMAP_NEW         GTK_STOCK_NEW
#define GNOME_STOCK_PIXMAP_OPEN        GTK_STOCK_OPEN
#define GNOME_STOCK_PIXMAP_CLOSE       GTK_STOCK_CLOSE
#define GNOME_STOCK_PIXMAP_REVERT      GTK_STOCK_REVERT_TO_SAVED
#define GNOME_STOCK_PIXMAP_SAVE        GTK_STOCK_SAVE
#define GNOME_STOCK_PIXMAP_SAVE_AS     GTK_STOCK_SAVE_AS
#define GNOME_STOCK_PIXMAP_CUT         GTK_STOCK_CUT
#define GNOME_STOCK_PIXMAP_COPY        GTK_STOCK_COPY
#define GNOME_STOCK_PIXMAP_PASTE       GTK_STOCK_PASTE
#define GNOME_STOCK_PIXMAP_CLEAR       GTK_STOCK_CLEAR
#define GNOME_STOCK_PIXMAP_PROPERTIES  GTK_STOCK_PROPERTIES
#define GNOME_STOCK_PIXMAP_PREFERENCES GTK_STOCK_PREFERENCES
#define GNOME_STOCK_PIXMAP_HELP        GTK_STOCK_HELP
#define GNOME_STOCK_PIXMAP_SCORES      GNOME_STOCK_PIXMAP_SCORES
#define GNOME_STOCK_PIXMAP_PRINT       GTK_STOCK_PRINT
#define GNOME_STOCK_PIXMAP_SEARCH      GTK_STOCK_FIND
#define GNOME_STOCK_PIXMAP_SRCHRPL     GTK_STOCK_FIND_AND_REPLACE
#define GNOME_STOCK_PIXMAP_BACK        GTK_STOCK_GO_BACK
#define GNOME_STOCK_PIXMAP_FORWARD     GTK_STOCK_GO_FORWARD
#define GNOME_STOCK_PIXMAP_FIRST       GTK_STOCK_GOTO_FIRST
#define GNOME_STOCK_PIXMAP_LAST        GTK_STOCK_GOTO_LAST
#define GNOME_STOCK_PIXMAP_HOME        GTK_STOCK_HOME
#define GNOME_STOCK_PIXMAP_STOP        GTK_STOCK_STOP
#define GNOME_STOCK_PIXMAP_REFRESH     GTK_STOCK_REFRESH
#define GNOME_STOCK_PIXMAP_UNDO        GTK_STOCK_UNDO
#define GNOME_STOCK_PIXMAP_REDO        GTK_STOCK_REDO
#define GNOME_STOCK_PIXMAP_TIMER       GNOME_STOCK_TIMER
#define GNOME_STOCK_PIXMAP_TIMER_STOP  GNOME_STOCK_TIMER_STOP
#define GNOME_STOCK_PIXMAP_MAIL	       GNOME_STOCK_MAIL
#define GNOME_STOCK_PIXMAP_MAIL_RCV    GNOME_STOCK_MAIL_RCV
#define GNOME_STOCK_PIXMAP_MAIL_SND    GNOME_STOCK_MAIL_SND
#define GNOME_STOCK_PIXMAP_MAIL_RPL    GNOME_STOCK_MAIL_RPL
#define GNOME_STOCK_PIXMAP_MAIL_FWD    GNOME_STOCK_MAIL_FWD
#define GNOME_STOCK_PIXMAP_MAIL_NEW    GNOME_STOCK_MAIL_NEW
#define GNOME_STOCK_PIXMAP_TRASH       GNOME_STOCK_TRASH
#define GNOME_STOCK_PIXMAP_TRASH_FULL  GNOME_STOCK_TRASH_FULL
#define GNOME_STOCK_PIXMAP_UNDELETE    GTK_STOCK_UNDELETE
#define GNOME_STOCK_PIXMAP_SPELLCHECK  GTK_STOCK_SPELL_CHECK
#define GNOME_STOCK_PIXMAP_MIC         GNOME_STOCK_MIC
#define GNOME_STOCK_PIXMAP_LINE_IN     GNOME_STOCK_LINE_IN
#define GNOME_STOCK_PIXMAP_CDROM       GTK_STOCK_CDROM
#define GNOME_STOCK_PIXMAP_VOLUME      GNOME_STOCK_VOLUME
#define GNOME_STOCK_PIXMAP_MIDI        GNOME_STOCK_MIDI
#define GNOME_STOCK_PIXMAP_BOOK_RED    GNOME_STOCK_BOOK_RED
#define GNOME_STOCK_PIXMAP_BOOK_GREEN  GNOME_STOCK_BOOK_GREEN
#define GNOME_STOCK_PIXMAP_BOOK_BLUE   GNOME_STOCK_BOOK_BLUE
#define GNOME_STOCK_PIXMAP_BOOK_YELLOW GNOME_STOCK_BOOK_YELLOW
#define GNOME_STOCK_PIXMAP_BOOK_OPEN   GNOME_STOCK_BOOK_OPEN
#define GNOME_STOCK_PIXMAP_ABOUT       GNOME_STOCK_ABOUT
#define GNOME_STOCK_PIXMAP_QUIT        GTK_STOCK_QUIT
#define GNOME_STOCK_PIXMAP_MULTIPLE    GNOME_STOCK_MULTIPLE_FILE
#define GNOME_STOCK_PIXMAP_NOT         GNOME_STOCK_NOT
#define GNOME_STOCK_PIXMAP_CONVERT     GTK_STOCK_CONVERT
#define GNOME_STOCK_PIXMAP_JUMP_TO     GTK_STOCK_JUMP_TO
#define GNOME_STOCK_PIXMAP_UP          GTK_STOCK_GO_UP
#define GNOME_STOCK_PIXMAP_DOWN        GTK_STOCK_GO_DOWN
#define GNOME_STOCK_PIXMAP_TOP         GTK_STOCK_GOTO_TOP
#define GNOME_STOCK_PIXMAP_BOTTOM      GTK_STOCK_GOTO_BOTTOM
#define GNOME_STOCK_PIXMAP_ATTACH      GNOME_STOCK_ATTACH
#define GNOME_STOCK_PIXMAP_INDEX       GTK_STOCK_INDEX
#define GNOME_STOCK_PIXMAP_FONT        GTK_STOCK_SELECT_FONT
#define GNOME_STOCK_PIXMAP_EXEC        GTK_STOCK_EXECUTE

#define GNOME_STOCK_PIXMAP_ALIGN_LEFT    GTK_STOCK_JUSTIFY_LEFT
#define GNOME_STOCK_PIXMAP_ALIGN_RIGHT   GTK_STOCK_JUSTIFY_RIGHT
#define GNOME_STOCK_PIXMAP_ALIGN_CENTER  GTK_STOCK_JUSTIFY_CENTER
#define GNOME_STOCK_PIXMAP_ALIGN_JUSTIFY GTK_STOCK_JUSTIFY_FILL

#define GNOME_STOCK_PIXMAP_TEXT_BOLD      GTK_STOCK_BOLD
#define GNOME_STOCK_PIXMAP_TEXT_ITALIC    GTK_STOCK_ITALIC
#define GNOME_STOCK_PIXMAP_TEXT_UNDERLINE GTK_STOCK_UNDERLINE
#define GNOME_STOCK_PIXMAP_TEXT_STRIKEOUT GTK_STOCK_STRIKETHROUGH

#define GNOME_STOCK_PIXMAP_TEXT_INDENT    GNOME_STOCK_TEXT_INDENT
#define GNOME_STOCK_PIXMAP_TEXT_UNINDENT  GNOME_STOCK_TEXT_UNINDENT

#define GNOME_STOCK_PIXMAP_EXIT        GNOME_STOCK_PIXMAP_QUIT

#define GNOME_STOCK_PIXMAP_COLORSELECTOR GTK_STOCK_SELECT_COLOR

#define GNOME_STOCK_PIXMAP_ADD    GTK_STOCK_ADD
#define GNOME_STOCK_PIXMAP_REMOVE GTK_STOCK_REMOVE

#define GNOME_STOCK_PIXMAP_TABLE_BORDERS GNOME_STOCK_TABLE_BORDERS
#define GNOME_STOCK_PIXMAP_TABLE_FILL GNOME_STOCK_TABLE_FILL

#define GNOME_STOCK_PIXMAP_TEXT_BULLETED_LIST GNOME_STOCK_TEXT_BULLETED_LIST
#define GNOME_STOCK_PIXMAP_TEXT_NUMBERED_LIST GNOME_STOCK_TEXT_NUMBERED_LIST

/*  menus  */

#define GNOME_STOCK_MENU_BLANK        GNOME_STOCK_BLANK
#define GNOME_STOCK_MENU_NEW          GTK_STOCK_NEW
#define GNOME_STOCK_MENU_SAVE         GTK_STOCK_SAVE
#define GNOME_STOCK_MENU_SAVE_AS      GTK_STOCK_SAVE_AS
#define GNOME_STOCK_MENU_REVERT       GTK_STOCK_REVERT_TO_SAVED
#define GNOME_STOCK_MENU_OPEN         GTK_STOCK_OPEN
#define GNOME_STOCK_MENU_CLOSE        GTK_STOCK_CLOSE
#define GNOME_STOCK_MENU_QUIT         GTK_STOCK_QUIT
#define GNOME_STOCK_MENU_CUT          GTK_STOCK_CUT
#define GNOME_STOCK_MENU_COPY         GTK_STOCK_COPY
#define GNOME_STOCK_MENU_PASTE        GTK_STOCK_PASTE
#define GNOME_STOCK_MENU_PROP         GTK_STOCK_PROPERTIES
#define GNOME_STOCK_MENU_PREF         GTK_STOCK_PREFERENCES
#define GNOME_STOCK_MENU_ABOUT        GNOME_STOCK_ABOUT
#define GNOME_STOCK_MENU_SCORES       GNOME_STOCK_SCORES
#define GNOME_STOCK_MENU_UNDO         GTK_STOCK_UNDO
#define GNOME_STOCK_MENU_REDO         GTK_STOCK_REDO
#define GNOME_STOCK_MENU_PRINT        GTK_STOCK_PRINT
#define GNOME_STOCK_MENU_SEARCH       GTK_STOCK_FIND
#define GNOME_STOCK_MENU_SRCHRPL      GTK_STOCK_FIND_AND_REPLACE
#define GNOME_STOCK_MENU_BACK         GTK_STOCK_GO_BACK
#define GNOME_STOCK_MENU_FORWARD      GTK_STOCK_GO_FORWARD
#define GNOME_STOCK_MENU_FIRST        GTK_STOCK_GOTO_FIRST
#define GNOME_STOCK_MENU_LAST         GTK_STOCK_GOTO_LAST
#define GNOME_STOCK_MENU_HOME         GTK_STOCK_HOME
#define GNOME_STOCK_MENU_STOP         GTK_STOCK_STOP
#define GNOME_STOCK_MENU_REFRESH      GTK_STOCK_REFRESH
#define GNOME_STOCK_MENU_MAIL         GNOME_STOCK_MAIL
#define GNOME_STOCK_MENU_MAIL_RCV     GNOME_STOCK_MAIL_RCV
#define GNOME_STOCK_MENU_MAIL_SND     GNOME_STOCK_MAIL_SND
#define GNOME_STOCK_MENU_MAIL_RPL     GNOME_STOCK_MAIL_RPL
#define GNOME_STOCK_MENU_MAIL_FWD     GNOME_STOCK_MAIL_FWD
#define GNOME_STOCK_MENU_MAIL_NEW     GNOME_STOCK_MAIL_NEW
#define GNOME_STOCK_MENU_TRASH        GNOME_STOCK_TRASH
#define GNOME_STOCK_MENU_TRASH_FULL   GNOME_STOCK_TRASH_FULL
#define GNOME_STOCK_MENU_UNDELETE     GTK_STOCK_UNDELETE
#define GNOME_STOCK_MENU_TIMER        GNOME_STOCK_TIMER
#define GNOME_STOCK_MENU_TIMER_STOP   GNOME_STOCK_TIMER_STOP
#define GNOME_STOCK_MENU_SPELLCHECK   GTK_STOCK_SPELL_CHECK
#define GNOME_STOCK_MENU_MIC          GNOME_STOCK_MIC
#define GNOME_STOCK_MENU_LINE_IN      GNOME_STOCK_LINE_IN
#define GNOME_STOCK_MENU_CDROM	      GTK_STOCK_CDROM
#define GNOME_STOCK_MENU_VOLUME       GNOME_STOCK_VOLUME
#define GNOME_STOCK_MENU_MIDI         GNOME_STOCK_MIDI
#define GNOME_STOCK_MENU_BOOK_RED     GNOME_STOCK_BOOK_RED
#define GNOME_STOCK_MENU_BOOK_GREEN   GNOME_STOCK_BOOK_GREEN
#define GNOME_STOCK_MENU_BOOK_BLUE    GNOME_STOCK_BOOK_BLUE
#define GNOME_STOCK_MENU_BOOK_YELLOW  GNOME_STOCK_BOOK_YELLOW
#define GNOME_STOCK_MENU_BOOK_OPEN    GNOME_STOCK_BOOK_OPEN
#define GNOME_STOCK_MENU_CONVERT      GTK_STOCK_CONVERT
#define GNOME_STOCK_MENU_JUMP_TO      GTK_STOCK_JUMP_TO
#define GNOME_STOCK_MENU_UP           GTK_STOCK_GO_UP
#define GNOME_STOCK_MENU_DOWN         GTK_STOCK_GO_DOWN
#define GNOME_STOCK_MENU_TOP          GTK_STOCK_GOTO_TOP
#define GNOME_STOCK_MENU_BOTTOM       GTK_STOCK_GOTO_BOTTOM
#define GNOME_STOCK_MENU_ATTACH       GNOME_STOCK_ATTACH
#define GNOME_STOCK_MENU_INDEX        GTK_STOCK_INDEX
#define GNOME_STOCK_MENU_FONT         GTK_STOCK_SELECT_FONT
#define GNOME_STOCK_MENU_EXEC         GTK_STOCK_EXECUTE

#define GNOME_STOCK_MENU_ALIGN_LEFT     GTK_STOCK_JUSTIFY_LEFT
#define GNOME_STOCK_MENU_ALIGN_RIGHT    GTK_STOCK_JUSTIFY_RIGHT
#define GNOME_STOCK_MENU_ALIGN_CENTER   GTK_STOCK_JUSTIFY_CENTER
#define GNOME_STOCK_MENU_ALIGN_JUSTIFY  GTK_STOCK_JUSTIFY_FILL

#define GNOME_STOCK_MENU_TEXT_BOLD      GTK_STOCK_BOLD
#define GNOME_STOCK_MENU_TEXT_ITALIC    GTK_STOCK_ITALIC
#define GNOME_STOCK_MENU_TEXT_UNDERLINE GTK_STOCK_UNDERLINE
#define GNOME_STOCK_MENU_TEXT_STRIKEOUT GTK_STOCK_STRIKETHROUGH

#define GNOME_STOCK_MENU_EXIT     GNOME_STOCK_MENU_QUIT

#endif /* GNOME_DISABLE_DEPRECATED */

G_END_DECLS

#endif /* GNOME_STOCK_ICONS_H */
