//$Id: examplewindow.cc,v 1.1 2004/08/30 19:51:38 murrayc Exp $ -*- c++ -*-

/* gtkmm example Copyright (C) 2002 gtkmm development team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include "examplewindow.h"
#include <iostream>

ExampleWindow::ExampleWindow():m_button_preview("Preview"),m_button_print_dialog("Print Dialog")
{
   
  set_title("Print UI Test");
  set_border_width(10);

  m_button_preview.signal_clicked().connect( sigc::mem_fun(*this, &ExampleWindow::on_button_preview) );
  m_button_print_dialog.signal_clicked().connect( sigc::mem_fun(*this, &ExampleWindow::on_button_print_dialog) );
  
  Gtk::VBox *vb=Gtk::manage(new Gtk::VBox());

  vb->add(m_button_preview);
  vb->add(m_button_print_dialog);

  add(*vb);

  show_all_children();
  init_print();
}

ExampleWindow::~ExampleWindow()
{
}

void  ExampleWindow::init_print()
{
  refConfig = Gnome::Print::Config::get_default();
  if(!refConfig)
  {
    std::cerr << "Config is null." << std::endl;
    return;
  }
  refConfig->set("Printer", "GENERIC");
  refJob = Gnome::Print::Job::create(refConfig);
  
  refJob->set_print_to_file("p.ps");

  refConfig->set(GNOME_PRINT_KEY_PAPER_SIZE, "A4");

  
  Glib::RefPtr<Gnome::Print::Context> refContext = refJob->get_context();
  if(!refContext)
  {
    std::cerr << "Context is null." << std::endl;
    return;
  }
    
  refContext->begin_page("1");


  //Print some text on the page:
    
  Glib::RefPtr<Gnome::Print::Font> refFontLuxi = Gnome::Print::Font::find_closest("Luxi Sans Bold", 12);
  if(!refFontLuxi)
  {
    std::cerr << "Font is null: Font not found." << std::endl;
    return;
  }
  
  refContext->set_font(refFontLuxi);
  refContext->move_to(100, 200);
  refContext->show("The quick brown fox jumps over the lazy dog.");


  //Print some more text underneath the first text: 
  Glib::RefPtr<Gnome::Print::Font> refFont2 = Gnome::Print::Font::find_closest("Sans Bold", 12);
  refContext->set_font(refFont2);
  refContext->move_to(100, 180);
  refContext->show("Some more text.");

  refContext->show_page();
  refContext->begin_page("2");
  refContext->set_font(refFontLuxi);
  refContext->move_to(100, 200);
  refContext->show("The quick brown fox jumps over the lazy dog.");
  refContext->set_font(refFont2);
  refContext->move_to(100, 180);
  refContext->show("Some more text.");
  refContext->show_page();

  refJob->close();
//  refJob->print();

}

void ExampleWindow::on_button_preview()
{
	Gnome::Print::UI::JobPreview *previewWindows=(new Gnome::Print::UI::JobPreview(refJob,"TestPrint Preview"));
	previewWindows->show();
}


void ExampleWindow::on_button_print_dialog()
{
	Gnome::Print::UI::PrintDialog dialog(refJob,"TestPrint PrintDialog");
	dialog.run();

}

