/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 *  gnome-font-compat.h - basic user visible handle to scaled typeface
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *  Authors:
 *    Jody Goldberg <jody@ximian.com>
 *    Miguel de Icaza <miguel@ximian.com>
 *    Lauris Kaplinski <lauris@ximian.com>
 *    Christopher James Lahey <clahey@ximian.com>
 *    Michael Meeks <michael@ximian.com>
 *    Morten Welinder <terra@diku.dk>
 *
 *  Copyright (C) 2000-2001 Ximian Inc. and authors
 */

#ifndef __GNOME_FONT_COMPAT_H__
#define __GNOME_FONT_COMPAT_H__

#include <glib.h>

G_BEGIN_DECLS

#include <libgnomeprint/gnome-font-face.h>

/* Various backward compatibility typedefs */
typedef struct _GnomeFontFacePrivate GnomeFontFacePrivate;
typedef struct _GnomeFontFace GnomeFontUnsized;
typedef struct _GnomeFontFace GnomeFontMap;

/*
 * Various backward-compatibility and conveninence methods
 *
 * NB! Those usually do not scale for international fonts, so use with
 * caution.
 */



gchar * gnome_font_face_get_pfa (const GnomeFontFace * face);


/* Font */
#ifdef PRESERVE_COMPATIBILITY
/*
 * Compatibility
 */
/* typedef struct
 * {
 *  GnomeFontUnsized *unsized_font;   font before scaling
 *  GnomeFont *gnome_font;            scaled font
 *  double scale;                     scaling factor requested by a view
 * 
 *  char *x_font_name;                x name that got us gdk_font
 *  GdkFont *gdk_font;                used for drawing
 * } GnomeDisplayFont;
 */

typedef struct _GnomeRFont GnomeDisplayFont;

GnomeDisplayFont * gnome_font_get_display_font (GnomeFont *font);
const char * gnome_font_weight_to_string (GnomeFontWeight gfw);
GnomeFontWeight string_to_gnome_font_weight (const char *weight);
GnomeDisplayFont * gnome_get_display_font (const char * family, GnomeFontWeight weight, gboolean italic, double points, double scale);
int gnome_display_font_height (GnomeDisplayFont * gdf);

/*
 * These are for attribute reading
 *
 * If writing fresh code, use rfont methods directly
 */
const GnomeFontFace * gnome_display_font_get_face (const GnomeDisplayFont * gdf);
const GnomeFont * gnome_display_font_get_font (const GnomeDisplayFont * gdf);
gdouble gnome_display_font_get_scale (const GnomeDisplayFont * gdf);
const gchar * gnome_display_font_get_x_font_name (const GnomeDisplayFont * gdf);
GdkFont * gnome_display_font_get_gdk_font (const GnomeDisplayFont * gdf);

void gnome_display_font_ref (GnomeDisplayFont * gdf);
void gnome_display_font_unref (GnomeDisplayFont * gdf);
#endif

G_END_DECLS

#endif
