
#include <libgnomedbmm.h>

class PictureFormDemo: public Gtk::Window
{
public:
  static const char* FILE;

  PictureFormDemo(const Glib::RefPtr<Gnome::Gda::Dict>& dict);
};

const char* PictureFormDemo::FILE = __FILE__;

PictureFormDemo::PictureFormDemo(const Glib::RefPtr<Gnome::Gda::Dict>& dict):
  Gtk::Window(Gtk::WINDOW_TOPLEVEL)
{
  Gtk::VBox* box = Gtk::manage(new Gtk::VBox(false, 5));
  Gtk::Label* label = Gtk::manage(new Gtk::Label("The following GnomeDbForm widget displays data from the 'pictures' table.\n\n"
                                                 "The pictures are stored as BLOB inside the database and\n"
                                                 "are displayed using the 'picture' plugin (right click to \n"
                                                 "open a menu, or double click to load an image)."));

  Glib::ustring update_query = "UPDATE pictures SET "
                               "pict=##/*name:'+1' type:'GdaBinary'*/ "
                               "WHERE id=##/*name:'-0' type:gint*/";

  Glib::ustring delete_query = "DELETE FROM pictures WHERE id=##/*name:'-0' type:gint*/";

  Glib::ustring insert_query = "INSERT INTO pictures (pict) "
                               "VALUES (##/*name:'+1' type:'GdaBinary'*/)";

  Glib::RefPtr<Gnome::Gda::Query> query = Gnome::Gda::Query::create(dict);
  Glib::RefPtr<Gnome::Gda::DataModelQuery> model;

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
    query->set_sql_text("SELECT id, pict FROM pictures");

    model = Gnome::Gda::DataModelQuery::create(query);
    model->set_modification_query(update_query);
    model->set_modification_query(delete_query);
    model->set_modification_query(insert_query);
  }
  catch(const Glib::Error& e)
  {
    std::cerr << e.what() << std::endl;
  }
#else
  std::auto_ptr<Glib::Error> error;
  query->set_sql_text("SELECT id, pict FROM pictures", error);

  model = Gnome::Gda::DataModelQuery::create(query);
  model->set_modification_query(update_query, error);
  model->set_modification_query(delete_query, error);
  model->set_modification_query(insert_query, error);

  if(error.get() != NULL)
    std::cerr << error->what() << std::endl;
#endif // GLIBMM_EXCEPTIONS_ENABLED

  Gnome::Db::Form* form = Gtk::manage(new Gnome::Db::Form(model));

  // Specify that we want to use the 'picture' plugin
  Gnome::Db::RawForm* raw_form = form->get_raw_form();
  Glib::RefPtr<Gnome::Gda::ParameterList> data_set = raw_form->get_data_set();
  Glib::RefPtr<Gnome::Gda::Parameter> param = data_set->find_param("pict");

#ifdef GLIBMM_PROPERTIES_ENABLED
  param->property_entry_plugin() = "picture";
#else
  g_object_set(param->gobj(), "entry_plugin", "picture", NULL);
#endif // GLIBMM_PROPERTIES_ENABLED

  box->pack_start(*label, Gtk::PACK_SHRINK);
  box->pack_start(*form);
  add(*box);

  show_all_children();
}
