
#include <libgnomedbmm.h>

class ReadWriteGridDemo: public Gtk::Window
{
public:
  static const char* FILE;

  ReadWriteGridDemo(const Glib::RefPtr<Gnome::Gda::Dict>& dict);
};

const char* ReadWriteGridDemo::FILE = __FILE__;

ReadWriteGridDemo::ReadWriteGridDemo(const Glib::RefPtr<Gnome::Gda::Dict>& dict):
  Gtk::Window(Gtk::WINDOW_TOPLEVEL)
{
  Gtk::VBox* box = Gtk::manage(new Gtk::VBox(false, 5));
  Gtk::Label* label = Gtk::manage(new Gtk::Label("The following GnomeDbGrid widget displays data from the 'products' table.\n\n"
                                                 "As modification queries are provided, the data is read-write\n"
                                                 "(except for the 'price' field as these queries voluntarily omit that field)."));

  Glib::RefPtr<Gnome::Gda::Query> query = Gnome::Gda::Query::create(dict);
  Glib::RefPtr<Gnome::Gda::DataModelQuery> model;

  const Glib::ustring update_query = "UPDATE products set "
                                     "ref=##/*name:'+0' type:gchararray*/, "
                                     "category=##/*name:'+1' type:gint*/,"
                                     "name=##/*name:'+2' type:gchararray*/, "
                                     "wh_stored=##/*name:'+4' type:gint*/ "
                                     "WHERE ref=##/*name:'-0' type:gchararray*/";

  const Glib::ustring delete_query = "DELETE FROM products WHERE ref=##/*name:'-0' type:gchararray*/";

  const Glib::ustring insert_query = "INSERT INTO products (ref, category, name, price, wh_stored) "
                                     "VALUES (##/*name:'+0' type:gchararray*/, "
                                     "##/*name:'+1' type:gint*/, "
                                     "##/*name:'+2' type:gchararray*/, "
                                     "1.0, "
                                     "##/*name:'+4' type:gint*/)";

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  try
  {
    query->set_sql_text("SELECT * FROM products");

    model = Gnome::Gda::DataModelQuery::create(query);
    model->set_modification_query(update_query);
    model->set_modification_query(delete_query);
    model->set_modification_query(insert_query);
  }
  catch(const Glib::Error& e)
  {
    std::cerr << e.what() << std::endl;
  }
#else
  std::auto_ptr<Glib::Error> error;
  query->set_sql_text("SELECT * FROM products", error);

  model = Gnome::Gda::DataModelQuery::create(query);
  model->set_modification_query(update_query, error);
  model->set_modification_query(delete_query, error);
  model->set_modification_query(insert_query, error);
  if(error.get() != NULL)
    std::cerr << error->what() << std::endl;
#endif // GLIBMM_EXCEPTIONS_ENABLED

  Gnome::Db::Grid* grid = Gtk::manage(new Gnome::Db::Grid(model));

  box->pack_start(*label, Gtk::PACK_SHRINK);
  box->pack_start(*grid);
  add(*box);

  show_all_children();
}
