/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301,  USA
 */

#include <libgnomedbmm.h>
#include <libgdamm.h>

#include <iostream>

int main(int argc, char* argv[])
{
  Gnome::Db::init("Queries example", "1.0", argc, argv);

  Glib::RefPtr<Gnome::Gda::Dict> dict = Gnome::Gda::Dict::create();
  try
  {
    Glib::RefPtr<Gnome::Gda::Client> client = Gnome::Gda::Client::create();
    Glib::ustring connection_string = "DB_DIR=" LIBGNOMEDB_DATADIR ";DB_NAME=demo_db";

    Glib::RefPtr<Gnome::Gda::Connection> cnc = client->open_connection_from_string("SQLite", connection_string, "" /* username */, "" /* password */);
    dict->set_connection(cnc);

    dict->update_dbms_meta_data();
  }
  catch(const Glib::Error& err)
  {
    std::cerr << "Exception caught: " << err.what() << std::endl;
    return 1;
  }

  Glib::RefPtr<Gnome::Gda::Query> query = Gnome::Gda::Query::create(dict);

  // This adds a target to our query. A target specifies the table from
  // which to SELECT fields:
  query->add_target( Gnome::Gda::QueryTarget::create(query, "products") );

  // This adds a field we want to SELECT:
  query->add_field(Gnome::Gda::QueryFieldField::create(query, "ref"));

  // There is also a convenience function. Note that "ref" could also be other
  // SQL expressions, for example '*'.
  query->add_field_from_sql("category");

  // Prints "SELECT ref, t1.category FROM products AS t1":
  std::cout << query->get_sql_text() << std::endl;

  return 0;
}
