
#include <libgnomedbmm.h>

class PictureGridDemo: public Gtk::Window
{
public:
  static const char* FILE;

  PictureGridDemo(const Glib::RefPtr<Gnome::Gda::Dict>& dict);
};

const char* PictureGridDemo::FILE = __FILE__;

PictureGridDemo::PictureGridDemo(const Glib::RefPtr<Gnome::Gda::Dict>& dict):
  Gtk::Window(Gtk::WINDOW_TOPLEVEL)
{
  Gtk::VBox* box = Gtk::manage(new Gtk::VBox(false, 5));
  Gtk::Label* label = Gtk::manage(new Gtk::Label("The following GnomeDbGrid widget displays data from the 'pictures' table.\n\n"
                                                 "The pictures are stored as BLOB inside the database and\n"
                                                 "are displayed using the 'picture' plugin (right click to \n"
                                                 "open a menu, or double click to load an image)."));

  Glib::RefPtr<Gnome::Gda::Query> query = Gnome::Gda::Query::create(dict);
  query->set_sql_text("SELECT id, pict FROM pictures");

  Glib::RefPtr<Gnome::Gda::DataModelQuery> model = Gnome::Gda::DataModelQuery::create(query);
  model->set_modification_query("UPDATE pictures SET "
                                "pict=##/*name:'+1' type:'GdaBinary'*/ "
                                "WHERE id=##/*name:'-0' type:gint*/");

  model->set_modification_query("DELETE FROM pictures WHERE id=##/*name:'-0' type:gint*/");

  model->set_modification_query("INSERT INTO pictures (pict) "
                                "VALUES (##/*name:'+1' type:'GdaBinary'*/)");

  Gnome::Db::Grid* grid = Gtk::manage(new Gnome::Db::Grid(model));

  // Specify that we want to use the 'picture' plugin
  Gnome::Db::RawGrid* raw_grid = grid->property_raw_grid();
  Glib::RefPtr<Gnome::Gda::ParameterList> data_set = raw_grid->get_current_data();
  Glib::RefPtr<Gnome::Gda::Parameter> param = data_set->find_param("pict");
  param->property_entry_plugin() = "picture";

  box->pack_start(*label, Gtk::PACK_SHRINK);
  box->pack_start(*grid);
  add(*box);

  show_all_children();
}
