#include <libgnomedbmm.h>
#include <gtkmm.h>

int main(int argc, char* argv[])
{
  Gtk::Main kit(argc, argv);
  Gnome::Db::init("Example", "1.0", argc, argv);

  Glib::RefPtr<Gnome::Gda::Client> client = Gnome::Gda::Client::create();
  Glib::RefPtr<Gnome::Gda::Connection> connection = client->open_connection_from_string("SQLite", "DB_DIR=" LIBGNOMEDB_DATADIR ";DB_NAME=demo_db", "" /* username */, "" /* password */); 
  Glib::RefPtr<Gnome::Gda::DataModel> model = connection->execute_select_command("SELECT * FROM products");

  Gnome::Db::Grid grid(model);
  Gnome::Db::RawGrid* raw_grid = grid.get_raw_grid();
  raw_grid->get_column(0)->set_title("ID");
  raw_grid->get_column(1)->set_title("Category");
  raw_grid->get_column(2)->set_title("Name");
  raw_grid->get_column(3)->set_title("Price");
  raw_grid->get_column(4)->set_title("Stored");

  Gtk::Window window;
  window.set_title("Libgnomedbmm example window");
  window.set_default_size(400, 400);
  window.add(grid);
  window.show_all();

  kit.run(window);
  return 0;
}
