#include <stdlib.h>
#include <goocanvas.h>
#include <libgnomedb/libgnomedb.h>
#include <gnome-db-goo-text.h>
#include <gnome-db-goo-entity.h>
#include <gnome-db-goo-db-relations.h>
#include <gnome-db-goo-query-struct.h>
#include <libgda/graph/gda-dict-reg-graphs.h>

static gboolean on_delete_event (GtkWidget *window, GdkEvent *event, gpointer unused_data);
static void auto_layout_cb (GtkButton *button, GnomeDbGoo *canvas);  
static void center_display_cb (GtkButton *button, GnomeDbGoo *canvas);  
static void destroy_widget_cb (GtkButton *button, GtkWidget *wid);  

int
main (int argc, char *argv[])
{
	GtkWidget *window, *scrolled_win, *canvas, *nb, *vb, *button, *bbox;
	GooCanvasItem *root, *item;
	GdaQuery *query;
	GdaDict *dict;
	GdaDictTable *table;
	GdaDictDatabase *db;
	GdaGraph *graph;

	/* Initialize GTK+. */
	gtk_set_locale ();
	gnome_db_init ("Goo Canvas test", "1.0", argc, argv);
  
	/* dictionary */
	dict = gda_dict_new ();
	if (argc == 2)
		gda_dict_load_xml_file (dict, argv[1], NULL);
	else
		gda_dict_load_xml_file (dict, "../extra/demos/demo_dict.xml", NULL);

	/* Create the window and widgets. */
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_window_set_default_size (GTK_WINDOW (window), 640, 600);
	gtk_widget_show (window);
	g_signal_connect (window, "delete_event", (GtkSignalFunc) on_delete_event,
			  NULL);
  
	/* notebook */
	nb = gtk_notebook_new ();
	gtk_container_add (GTK_CONTAINER (window), nb);
	gtk_notebook_set_tab_pos (GTK_NOTEBOOK (nb), GTK_POS_LEFT);

	/*
	 * Basic GooCanvas 
	 */
	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
					GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_widget_show (scrolled_win);
	gtk_notebook_append_page (GTK_NOTEBOOK (nb), scrolled_win, gtk_label_new ("Basic"));
  
	canvas = goo_canvas_new ();
	gtk_widget_set_size_request (canvas, 600, 450);
	goo_canvas_set_bounds (GOO_CANVAS (canvas), 0, 0, 600, 450);
	gtk_container_add (GTK_CONTAINER (scrolled_win), canvas);
  
	root = goo_canvas_get_root_item (GOO_CANVAS (canvas));

	/* GnomeDbGooText */
	item = gnome_db_goo_text_new (root, "GnomeDbGooText", 100., 100., NULL);
	item = gnome_db_goo_text_new (root, "GnomeDbGooText", 100., 120., NULL);
	item = gnome_db_goo_text_new (root, "GnomeDbGooText", 100., 140., NULL);
  
	/* Entity: table */
	db = gda_dict_get_database (dict);
	table = gda_dict_database_get_table_by_name (db, "customers");
	if (table) 
		item = gnome_db_goo_entity_new (root, GDA_ENTITY (table), 200., 200., NULL);

	/* Entity: query */
	query = gda_query_new_from_sql (NULL, "SELECT field1, field2, field3 FROM mytable", NULL);
	gda_object_set_name (GDA_OBJECT (query), "query1");
	item = gnome_db_goo_entity_new (root, GDA_ENTITY (query), 300., 100., NULL);
	query = gda_query_new_from_sql (NULL, "SELECT vary_long_field1, field2, field3 FROM myt", NULL);
	gda_object_set_name (GDA_OBJECT (query), "query2");
	item = gnome_db_goo_entity_new (root, GDA_ENTITY (query), 300., 300., NULL);
	goo_canvas_item_translate (item, 20., 30.);

	/*
	 * test GnomeDbGooDbRelations
	 */
	vb = gtk_vbox_new (FALSE, 5);
	gtk_notebook_append_page (GTK_NOTEBOOK (nb), vb, gtk_label_new ("DbRelations"));

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
					GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start (GTK_BOX (vb), scrolled_win, TRUE, TRUE, 0);

	graph = (GdaGraph*) gda_dict_get_object_by_name (dict, GDA_TYPE_GRAPH, "Global");
	canvas = gnome_db_goo_db_relations_new (dict);
	gtk_widget_set_size_request (canvas, 600, 450);
	gtk_container_add (GTK_CONTAINER (scrolled_win), canvas);
	g_object_set (canvas, "graph", graph, NULL);
	/*gda_object_dump (graph, 5);*/

	bbox = gtk_hbutton_box_new ();
	gtk_box_pack_start (GTK_BOX (vb), bbox, FALSE, TRUE, 0);

	button = gtk_button_new_with_label ("Auto layout");
	gtk_box_pack_start (GTK_BOX (bbox), button, FALSE, TRUE, 0);
	g_signal_connect (G_OBJECT (button), "clicked",
			  G_CALLBACK (auto_layout_cb), canvas);

	button = gtk_button_new_with_label ("Center");
	gtk_box_pack_start (GTK_BOX (bbox), button, FALSE, TRUE, 0);
	g_signal_connect (G_OBJECT (button), "clicked",
			  G_CALLBACK (center_display_cb), canvas);

	button = gtk_button_new_with_label ("Destroy");
	gtk_box_pack_start (GTK_BOX (bbox), button, FALSE, TRUE, 0);
	g_signal_connect (G_OBJECT (button), "clicked",
			  G_CALLBACK (destroy_widget_cb), canvas);

#define ALLBUILD
#ifdef ALLBUILD
	/*
	 * test GnomeDbGooQueryStruct: No default graph
	 */
	vb = gtk_vbox_new (FALSE, 5);
	gtk_notebook_append_page (GTK_NOTEBOOK (nb), vb, gtk_label_new ("QueryStruct (no graph)"));

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
					GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start (GTK_BOX (vb), scrolled_win, TRUE, TRUE, 0);

	query = gda_query_new_from_sql (dict, "SELECT c.name, s.name FROM customers c join salesrep s on "
					"(s.id=c.default_served_by and s.name=c.name)", NULL);
	gda_object_set_name (GDA_OBJECT (query), "query1");
	/*gda_object_dump (query, 0);*/

	canvas = gnome_db_goo_query_struct_new (query, NULL);
	gtk_widget_set_size_request (canvas, 600, 450);
	gtk_container_add (GTK_CONTAINER (scrolled_win), canvas);

	bbox = gtk_hbutton_box_new ();
	gtk_box_pack_start (GTK_BOX (vb), bbox, FALSE, TRUE, 0);

	button = gtk_button_new_with_label ("Auto layout");
	gtk_box_pack_start (GTK_BOX (bbox), button, FALSE, TRUE, 0);
	g_signal_connect (G_OBJECT (button), "clicked",
			  G_CALLBACK (auto_layout_cb), canvas);

	button = gtk_button_new_with_label ("Center");
	gtk_box_pack_start (GTK_BOX (bbox), button, FALSE, TRUE, 0);
	g_signal_connect (G_OBJECT (button), "clicked",
			  G_CALLBACK (center_display_cb), canvas);

	button = gtk_button_new_with_label ("Destroy");
	gtk_box_pack_start (GTK_BOX (bbox), button, FALSE, TRUE, 0);
	g_signal_connect (G_OBJECT (button), "clicked",
			  G_CALLBACK (destroy_widget_cb), canvas);

	/*
	 * test GnomeDbGooQueryStruct: With default graph
	 */
	vb = gtk_vbox_new (FALSE, 5);
	gtk_notebook_append_page (GTK_NOTEBOOK (nb), vb, gtk_label_new ("QueryStruct (with graph)"));

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
					GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start (GTK_BOX (vb), scrolled_win, TRUE, TRUE, 0);

	query = gda_query_new_from_sql (dict, "SELECT c.name, s.name FROM customers c join salesrep s", NULL);
	gda_object_set_name (GDA_OBJECT (query), "query1");
	/*gda_object_dump (query, 0);*/

	graph = gda_graphs_get_graph_for_object (dict, G_OBJECT (query));
	if (!graph) {
		graph = GDA_GRAPH (gda_graph_query_new (query));
		gda_graph_query_sync_targets (GDA_GRAPH_QUERY (graph));
		gda_dict_assume_object_as (gda_object_get_dict (GDA_OBJECT (query)),
					   (GdaObject *) graph, GDA_TYPE_GRAPH);
		g_object_unref (graph);
	}

	canvas = gnome_db_goo_query_struct_new (query, graph);
	gtk_widget_set_size_request (canvas, 600, 450);
	gtk_container_add (GTK_CONTAINER (scrolled_win), canvas);

	bbox = gtk_hbutton_box_new ();
	gtk_box_pack_start (GTK_BOX (vb), bbox, FALSE, TRUE, 0);

	button = gtk_button_new_with_label ("Auto layout");
	gtk_box_pack_start (GTK_BOX (bbox), button, FALSE, TRUE, 0);
	g_signal_connect (G_OBJECT (button), "clicked",
			  G_CALLBACK (auto_layout_cb), canvas);

	button = gtk_button_new_with_label ("Center");
	gtk_box_pack_start (GTK_BOX (bbox), button, FALSE, TRUE, 0);
	g_signal_connect (G_OBJECT (button), "clicked",
			  G_CALLBACK (center_display_cb), canvas);

	button = gtk_button_new_with_label ("Destroy");
	gtk_box_pack_start (GTK_BOX (bbox), button, FALSE, TRUE, 0);
	g_signal_connect (G_OBJECT (button), "clicked",
			  G_CALLBACK (destroy_widget_cb), canvas);

	/*
	 * test GnomeDbGooQueryStruct: inactive query
	 */
	vb = gtk_vbox_new (FALSE, 5);
	gtk_notebook_append_page (GTK_NOTEBOOK (nb), vb, gtk_label_new ("QueryStruct (inactive)"));

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
					GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start (GTK_BOX (vb), scrolled_win, TRUE, TRUE, 0);

	query = gda_query_new_from_sql (NULL, "SELECT c.name, s.name FROM customers c join salesrep s", NULL);
	gda_object_set_name (GDA_OBJECT (query), "query1");
	/*gda_object_dump (query, 0);*/

	canvas = gnome_db_goo_query_struct_new (query, NULL);
	gtk_widget_set_size_request (canvas, 600, 450);
	gtk_container_add (GTK_CONTAINER (scrolled_win), canvas);

	bbox = gtk_hbutton_box_new ();
	gtk_box_pack_start (GTK_BOX (vb), bbox, FALSE, TRUE, 0);

	button = gtk_button_new_with_label ("Auto layout");
	gtk_box_pack_start (GTK_BOX (bbox), button, FALSE, TRUE, 0);
	g_signal_connect (G_OBJECT (button), "clicked",
			  G_CALLBACK (auto_layout_cb), canvas);

	button = gtk_button_new_with_label ("Center");
	gtk_box_pack_start (GTK_BOX (bbox), button, FALSE, TRUE, 0);
	g_signal_connect (G_OBJECT (button), "clicked",
			  G_CALLBACK (center_display_cb), canvas);

	button = gtk_button_new_with_label ("Destroy");
	gtk_box_pack_start (GTK_BOX (bbox), button, FALSE, TRUE, 0);
	g_signal_connect (G_OBJECT (button), "clicked",
			  G_CALLBACK (destroy_widget_cb), canvas);

	/*
	 * test GnomeDbGooDbRelations side by side
	 */
	GtkWidget *paned;

	paned = gtk_hpaned_new ();
	gtk_notebook_append_page (GTK_NOTEBOOK (nb), paned, gtk_label_new ("2 DbRelations"));

	graph = (GdaGraph*) gda_dict_get_object_by_name (dict, GDA_TYPE_GRAPH, "Global");

	
	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
					GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_paned_add1 (GTK_PANED (paned), scrolled_win);

	canvas = gnome_db_goo_db_relations_new (dict);
	gtk_widget_set_size_request (canvas, 400, 450);
	gtk_container_add (GTK_CONTAINER (scrolled_win), canvas);
	g_object_set (canvas, "graph", graph, NULL);

	scrolled_win = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_win),
					GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_paned_add2 (GTK_PANED (paned), scrolled_win);

	canvas = gnome_db_goo_db_relations_new (dict);
	gtk_widget_set_size_request (canvas, 400, 450);
	gtk_container_add (GTK_CONTAINER (scrolled_win), canvas);
	g_object_set (canvas, "graph", graph, NULL);
#endif
       
	/* Pass control to the GTK+ main event loop. */
	gtk_widget_show_all (nb);
	gtk_notebook_set_current_page (GTK_NOTEBOOK (nb), 2);
	gtk_main ();
  
	return 0;
}  

static void
auto_layout_cb (GtkButton *button, GnomeDbGoo *canvas)
{
	gnome_db_goo_perform_auto_layout (canvas, TRUE, GNOME_DB_GOO_LAYOUT_DEFAULT);
}

static void
center_display_cb (GtkButton *button, GnomeDbGoo *canvas)
{
	gnome_db_goo_center (canvas);
}

static void
destroy_widget_cb (GtkButton *button, GtkWidget *wid)
{
	gtk_widget_destroy (wid);
}
  
static gboolean
on_delete_event (GtkWidget *window, GdkEvent  *event, gpointer   unused_data)
{
	exit (0);
}

