/* GNOME DB library
 * Copyright (C) 1999-2002 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gnome_db_data_source_selector_h__)
#  define __gnome_db_data_source_selector_h__

#include <gtk/gtkcombobox.h>

G_BEGIN_DECLS

#define GNOME_DB_TYPE_DATA_SOURCE_SELECTOR            (gnome_db_data_source_selector_get_type())
#define GNOME_DB_DATA_SOURCE_SELECTOR(obj)            (G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_DB_TYPE_DATA_SOURCE_SELECTOR, GnomeDbDataSourceSelector))
#define GNOME_DB_DATA_SOURCE_SELECTOR_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST (klass, GNOME_DB_TYPE_DATA_SOURCE_SELECTOR, GnomeDbDataSourceSelectorClass))
#define GNOME_DB_IS_DATA_SOURCE_SELECTOR(obj)         (G_TYPE_CHECK_INSTANCE_TYPE (obj, GNOME_DB_TYPE_DATA_SOURCE_SELECTOR))
#define GNOME_DB_IS_DATA_SOURCE_SELECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_DB_TYPE_DATA_SOURCE_SELECTOR))

typedef struct _GnomeDbDataSourceSelector        GnomeDbDataSourceSelector;
typedef struct _GnomeDbDataSourceSelectorClass   GnomeDbDataSourceSelectorClass;
typedef struct _GnomeDbDataSourceSelectorPrivate GnomeDbDataSourceSelectorPrivate;

struct _GnomeDbDataSourceSelector {
	GtkComboBox                       combo;
	GnomeDbDataSourceSelectorPrivate *priv;
};

struct _GnomeDbDataSourceSelectorClass {
	GtkComboBoxClass                  parent_class;
};

GType      gnome_db_data_source_selector_get_type (void);
GtkWidget *gnome_db_data_source_selector_new      (const gchar *name);
gchar     *gnome_db_data_source_selector_get_dsn  (GnomeDbDataSourceSelector *selector);
void       gnome_db_data_source_selector_set_dsn  (GnomeDbDataSourceSelector *selector, const gchar *dsn);

G_END_DECLS

#endif
