/* gnome-db-canvas-fkconstraint.h
 *
 * Copyright (C) 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GNOME_DB_CANVAS_FKCONSTRAINT__
#define __GNOME_DB_CANVAS_FKCONSTRAINT__

#include "gnome-db-canvas-item.h"

G_BEGIN_DECLS

/*
 * 
 * "Drag item" GnomeCanvas item: a GnomeDbCanvasItem item which is used to represent
 * an element being dragged, and destroys itself when the mouse button is released
 *
 */

#define GNOME_DB_TYPE_CANVAS_FKCONSTRAINT          (gnome_db_canvas_fkconstraint_get_type())
#define GNOME_DB_CANVAS_FKCONSTRAINT(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_canvas_fkconstraint_get_type(), GnomeDbCanvasFkconstraint)
#define GNOME_DB_CANVAS_FKCONSTRAINT_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_canvas_fkconstraint_get_type (), GnomeDbCanvasFkconstraintClass)
#define GNOME_DB_IS_CANVAS_FKCONSTRAINT(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_canvas_fkconstraint_get_type ())


typedef struct _GnomeDbCanvasFkconstraint        GnomeDbCanvasFkconstraint;
typedef struct _GnomeDbCanvasFkconstraintClass   GnomeDbCanvasFkconstraintClass;
typedef struct _GnomeDbCanvasFkconstraintPrivate GnomeDbCanvasFkconstraintPrivate;


/* struct for the object's data */
struct _GnomeDbCanvasFkconstraint
{
	GnomeDbCanvasItem           object;

	GnomeDbCanvasFkconstraintPrivate *priv;
};

/* struct for the object's class */
struct _GnomeDbCanvasFkconstraintClass
{
	GnomeDbCanvasItemClass   parent_class;
};

/* generic widget's functions */
GType      gnome_db_canvas_fkconstraint_get_type       (void);

void       gnome_db_canvas_fkconstraint_add_constraint (GnomeDbCanvasFkconstraint *cc, GdaDictConstraint *fkcons);

G_END_DECLS

#endif
