/* gnome-db-data-widget.h
 *
 * Copyright (C) 2004 - 2005 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_DATA_WIDGET_H_
#define __GNOME_DB_DATA_WIDGET_H_

#include <glib-object.h>
#include <gtk/gtk.h>
#include <libgda/gda-data-model.h>
#include "gnome-db-decl.h"
#include "gnome-db-enums.h"

G_BEGIN_DECLS

#define GNOME_DB_TYPE_DATA_WIDGET          (gnome_db_data_widget_get_type())
#define GNOME_DB_DATA_WIDGET(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_DB_TYPE_DATA_WIDGET, GnomeDbDataWidget)
#define IS_GNOME_DB_DATA_WIDGET(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, GNOME_DB_TYPE_DATA_WIDGET)
#define GNOME_DB_DATA_WIDGET_GET_IFACE(obj)  (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GNOME_DB_TYPE_DATA_WIDGET, GnomeDbDataWidgetIface))



/* struct for the interface */
struct _GnomeDbDataWidgetIface
{
	GTypeInterface           g_iface;

	/* virtual table */
	void                 (* set_mode)            (GnomeDbDataWidget *iface, guint mode);
	void                 (* col_set_show)        (GnomeDbDataWidget *iface, gint column, gboolean shown);
	void                 (* set_column_editable) (GnomeDbDataWidget *iface, gint column, gboolean editable);
	void                 (* show_column_actions) (GnomeDbDataWidget *iface, gint column, gboolean show_actions);
	void                 (* show_global_actions) (GnomeDbDataWidget *iface, gboolean show_actions);
	GtkActionGroup      *(* get_actions_group)   (GnomeDbDataWidget *iface);
	GnomeDbDataSet      *(* get_params_set)      (GnomeDbDataWidget *iface);
	GnomeDbDataSet      *(* get_data_set)        (GnomeDbDataWidget *iface);

	GdaDataModel        *(* get_gda_model)       (GnomeDbDataWidget *iface);
	void                 (* set_gda_model)       (GnomeDbDataWidget *iface, GnomeDbDict *dict, GdaDataModel *model);
	void                 (* set_title)           (GnomeDbDataWidget *iface, const gchar *title);
	void                 (* set_show_title)      (GnomeDbDataWidget *iface, gboolean show);
	void                 (* set_t_i_from_stock)  (GnomeDbDataWidget *iface, const gchar *stock_id, GtkIconSize size);
};

GType           gnome_db_data_widget_get_type                  (void) G_GNUC_CONST;

void            gnome_db_data_widget_set_mode                  (GnomeDbDataWidget *iface, guint mode);
void            gnome_db_data_widget_global_show_actions       (GnomeDbDataWidget *iface, gboolean show_actions);
GtkActionGroup *gnome_db_data_widget_get_actions_group         (GnomeDbDataWidget *iface);
void            gnome_db_data_widget_perform_action            (GnomeDbDataWidget *iface, GnomeDbAction action);

void            gnome_db_data_widget_column_show               (GnomeDbDataWidget *iface, gint column);
void            gnome_db_data_widget_column_hide               (GnomeDbDataWidget *iface, gint column);
void            gnome_db_data_widget_column_set_editable       (GnomeDbDataWidget *iface, gint column, gboolean editable);
void            gnome_db_data_widget_column_show_actions       (GnomeDbDataWidget *iface, gint column, gboolean show_actions);

GdaDataModel   *gnome_db_data_widget_get_gda_model             (GnomeDbDataWidget *iface);
void            gnome_db_data_widget_set_gda_model             (GnomeDbDataWidget *iface, GnomeDbDict *dict, GdaDataModel *model);
GnomeDbDataSet *gnome_db_data_widget_get_params                (GnomeDbDataWidget *iface);
GnomeDbDataSet *gnome_db_data_widget_get_data                  (GnomeDbDataWidget *iface);

void            gnome_db_data_widget_set_title                 (GnomeDbDataWidget *iface, const gchar *title);
void            gnome_db_data_widget_set_show_title            (GnomeDbDataWidget *iface, gboolean show);
void            gnome_db_data_widget_set_title_icon_from_stock (GnomeDbDataWidget *iface, const gchar *stock_id, GtkIconSize size);



G_END_DECLS

#endif
