/* gnome-db-selector.h
 *
 * Copyright (C) 2002 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifndef __GNOME_DB_SELECTOR__
#define __GNOME_DB_SELECTOR__

#include <gtk/gtk.h>
#include "gnome-db-dict.h"

G_BEGIN_DECLS

#define GNOME_DB_TYPE_SELECTOR          (gnome_db_selector_get_type())
#define GNOME_DB_SELECTOR(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_selector_get_type(), GnomeDbSelector)
#define GNOME_DB_SELECTOR_CLASS(klass)  G_TYPE_CHECK_CLASS_CAST (klass, gnome_db_selector_get_type (), GnomeDbSelectorClass)
#define IS_GNOME_DB_SELECTOR(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_selector_get_type ())


typedef struct _GnomeDbSelector      GnomeDbSelector;
typedef struct _GnomeDbSelectorClass GnomeDbSelectorClass;
typedef struct _GnomeDbSelectorPriv  GnomeDbSelectorPriv;

typedef enum {
	GNOME_DB_SELECTOR_DATA_TYPES  = 1 << 0,
	GNOME_DB_SELECTOR_FUNCTIONS   = 1 << 1,
	GNOME_DB_SELECTOR_AGGREGATES  = 1 << 2,
	/* database structure */
	GNOME_DB_SELECTOR_TABLES      = 1 << 3,
	GNOME_DB_SELECTOR_FIELDS      = 1 << 5,
	/* queries */
	GNOME_DB_SELECTOR_QUERIES     = 1 << 4,
	GNOME_DB_SELECTOR_TARGETS     = 1 << 6,
	GNOME_DB_SELECTOR_JOINS       = 1 << 7,
	GNOME_DB_SELECTOR_QVIS_FIELDS = 1 << 8,
	GNOME_DB_SELECTOR_QALL_FIELDS = 1 << 9,
	GNOME_DB_SELECTOR_SUB_QUERIES = 1 << 10,
	GNOME_DB_SELECTOR_TARGETS_CTS = 1 << 13,
	/* graphs */
	GNOME_DB_SELECTOR_GRAPHS      = 1 << 11,
	/* layouts */
	GNOME_DB_SELECTOR_FORMS       = 1 << 12
} GnomeDbSelectorMode;

typedef enum {
	GNOME_DB_SELECTOR_COLUMN_OWNER        = 1 << 1,
	GNOME_DB_SELECTOR_COLUMN_COMMENTS     = 1 << 2,
	GNOME_DB_SELECTOR_COLUMN_TYPE         = 1 << 3,
	GNOME_DB_SELECTOR_COLUMN_FIELD_LENGTH = 1 << 4,
	GNOME_DB_SELECTOR_COLUMN_FIELD_NNUL   = 1 << 5,
	GNOME_DB_SELECTOR_COLUMN_FIELD_DEFAULT= 1 << 6,
	GNOME_DB_SELECTOR_COLUMN_QFIELD_VALUE = 1 << 7,
	GNOME_DB_SELECTOR_COLUMN_QFIELD_TYPE  = 1 << 8
} GnomeDbSelectorColumn;

/* struct for the object's data */
struct _GnomeDbSelector
{
	GtkVBox             object;

	GnomeDbSelectorPriv *priv;
};

/* struct for the object's class */
struct _GnomeDbSelectorClass
{
	GtkVBoxClass        parent_class;

	void              (*selection_changed) (GnomeDbSelector *mgsel, GObject *sel_object);
};

/* 
 * Generic widget's methods 
*/
GType      gnome_db_selector_get_type            (void);
GtkWidget *gnome_db_selector_new                 (GnomeDbDict *dict, GObject *ref_object, gulong mode, gulong columns);

/*
 * Widget's manipulations
 */
void       gnome_db_selector_set_mode_columns           (GnomeDbSelector *mgsel, GObject *ref_object, gulong mode, gulong columns);
gboolean   gnome_db_selector_set_selected_object        (GnomeDbSelector *mgsel, GObject *selection);
void       gnome_db_selector_set_headers_visible        (GnomeDbSelector *mgsel, gboolean visible);
void       gnome_db_selector_set_column_label           (GnomeDbSelector *mgsel, guint column, const gchar *label);
void       gnome_db_selector_expand_all                 (GnomeDbSelector *mgsel);
void       gnome_db_selector_collapse_all               (GnomeDbSelector *mgsel);

/*
 * Getting information
 */
GObject     *gnome_db_selector_get_selected_object        (GnomeDbSelector *mgsel);
GObject     *gnome_db_selector_get_selected_object_parent (GnomeDbSelector *mgsel);

G_END_DECLS

#endif



