/* gnome-db-canvas-cursor.c
 *
 * Copyright (C) 2002 - 2004 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#include "gnome-db-decl.h"
#include "gnome-db-canvas-cursor.h"
#include "marshal.h"

static void gnome_db_canvas_cursor_class_init (GnomeDbCanvasCursorClass * class);
static void gnome_db_canvas_cursor_init       (GnomeDbCanvasCursor * drag);
static void gnome_db_canvas_cursor_finalize    (GObject   * object);

static void gnome_db_canvas_cursor_set_property    (GObject *object,
						guint param_id,
						const GValue *value,
						GParamSpec *pspec);
static void gnome_db_canvas_cursor_get_property    (GObject *object,
						guint param_id,
						GValue *value,
						GParamSpec *pspec);


enum
{
	PROP_00,
	PROP_FILLCOLOR
};


/* get a pointer to the parents to be able to call their destructor */
static GObjectClass *cursor_parent_class = NULL;

GType
gnome_db_canvas_cursor_get_type (void)
{
	static GType type = 0;

        if (!type) {
		static const GTypeInfo info = {
			sizeof (GnomeDbCanvasCursorClass),
			(GBaseInitFunc) NULL,
			(GBaseFinalizeFunc) NULL,
			(GClassInitFunc) gnome_db_canvas_cursor_class_init,
			NULL,
			NULL,
			sizeof (GnomeDbCanvasCursor),
			0,
			(GInstanceInitFunc) gnome_db_canvas_cursor_init
		};		

		type = g_type_register_static (GNOME_DB_TYPE_CANVAS_ITEM, "GnomeDbCanvasCursor", &info, 0);
	}

	return type;
}

	

static void
gnome_db_canvas_cursor_class_init (GnomeDbCanvasCursorClass * class)
{
	GObjectClass   *object_class = G_OBJECT_CLASS (class);

	cursor_parent_class = g_type_class_peek_parent (class);

	object_class->finalize = gnome_db_canvas_cursor_finalize;

	/* Properties */
	object_class->set_property = gnome_db_canvas_cursor_set_property;
	object_class->get_property = gnome_db_canvas_cursor_get_property;

	g_object_class_install_property
                (object_class, PROP_FILLCOLOR,
                 g_param_spec_pointer ("fill_color", NULL, NULL, (G_PARAM_READABLE | G_PARAM_WRITABLE)));
}

static int cursor_item_event(GnomeDbCanvasCursor *cur, GdkEvent *event, gpointer data);

static void
gnome_db_canvas_cursor_init (GnomeDbCanvasCursor * cursor)
{
	cursor->item = NULL;

	g_signal_connect(G_OBJECT(cursor),"event",
			 G_CALLBACK (cursor_item_event), NULL);
}

static int 
cursor_item_event(GnomeDbCanvasCursor *cur, GdkEvent *event, gpointer data)
{
	gboolean done = TRUE;
	
	switch (event->type) {
	case GDK_BUTTON_RELEASE:
		gtk_object_destroy (GTK_OBJECT (cur));
		break;
	default:
		done = FALSE;
		break;
	}

	return done;	
}

static void
gnome_db_canvas_cursor_finalize (GObject   * object)
{
	g_return_if_fail (object != NULL);
	g_return_if_fail (IS_GNOME_DB_CANVAS_CURSOR (object));

	gnome_canvas_item_ungrab (GNOME_CANVAS_ITEM (object), GDK_CURRENT_TIME);

	/* for the parent class */
	cursor_parent_class->finalize (object);
}

static void post_init (GnomeDbCanvasCursor * cursor);

static void 
gnome_db_canvas_cursor_set_property    (GObject *object,
				    guint param_id,
				    const GValue *value,
				    GParamSpec *pspec)
{
	GnomeDbCanvasCursor *cd;
	gchar *str;

	cd = GNOME_DB_CANVAS_CURSOR (object);
	if (!cd->item)
		post_init (cd);

	switch (param_id) {
	case PROP_FILLCOLOR:
		str = g_value_get_pointer (value);
		gnome_canvas_item_set (cd->item, "fill_color", str, NULL);
		break;
	}

}

static void 
gnome_db_canvas_cursor_get_property    (GObject *object,
				    guint param_id,
				    GValue *value,
				    GParamSpec *pspec)
{
	g_print ("Get Property\n");
}



static void 
post_init (GnomeDbCanvasCursor * cursor)
{
	cursor->item = gnome_canvas_item_new(GNOME_CANVAS_GROUP (cursor),
					   GNOME_TYPE_CANVAS_RECT,
					   "x1", (double) 0,
					   "y1", (double) 0,
					   "x2", (double) 20,
					   "y2", (double) 7,
					   "outline_color", "black",
					   "fill_color", "white",
					   "width_pixels", 2,
					   NULL);
}
