/* gnome-db-field.h
 *
 * Copyright (C) 2003 Vivien Malerba
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */


#ifndef __GNOME_DB_FIELD_H_
#define __GNOME_DB_FIELD_H_

#include <glib-object.h>
#include "gnome-db-decl.h"

G_BEGIN_DECLS

#define GNOME_DB_TYPE_FIELD          (gnome_db_field_get_type())
#define GNOME_DB_FIELD(obj)          G_TYPE_CHECK_INSTANCE_CAST (obj, gnome_db_field_get_type(), GnomeDbField)
#define IS_GNOME_DB_FIELD(obj)       G_TYPE_CHECK_INSTANCE_TYPE (obj, gnome_db_field_get_type ())
#define GNOME_DB_FIELD_GET_IFACE(obj)  (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GNOME_DB_TYPE_FIELD, GnomeDbFieldIface))


/* struct for the interface */
struct _GnomeDbFieldIface
{
	GTypeInterface           g_iface;

	/* virtual table */
	GnomeDbEntity         *(* get_entity)      (GnomeDbField *iface);
	GnomeDbServerDataType *(* get_data_type)   (GnomeDbField *iface);
	const gchar           *(* get_alias)       (GnomeDbField *iface);
};

GType                  gnome_db_field_get_type        (void) G_GNUC_CONST;

GnomeDbEntity         *gnome_db_field_get_entity      (GnomeDbField *iface);
GnomeDbServerDataType *gnome_db_field_get_data_type   (GnomeDbField *iface);
const gchar           *gnome_db_field_get_name        (GnomeDbField *iface);
const gchar           *gnome_db_field_get_description (GnomeDbField *iface);

G_END_DECLS

#endif
