/* GNOME-DB Components
 * Copyright (C) 2000-2003 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Library General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include <libgnomeui/gnome-about.h>
#include <libgnomedb/gnome-db-i18n.h>
#include <libgnomedb/gnome-db-window.h>
#include "db-shell.h"

typedef struct {
	GtkWidget *shell;
	GdaConnection *cnc;
} DbShellData;

static void
command_about (BonoboUIComponent *uic, void *data, const char *path)
{
	GdkPixbuf *icon;
	GtkWidget *dialog;
	const gchar *authors[] = {
		"Rodrigo Moya <rodrigo@gnome-db.org>",
		"Vivien Malerba <malerba@gnome-db.org>",
		"Carlos Perello Marin <carlos@gnome-db.org>",
		"Gonzalo Paniagua Javier <gonzalo@gnome-db.org>",
		NULL
	};
	const gchar *documenters[] = {
		"Rodrigo Moya <rodrigo@gnome-db.org>",
		NULL
	};
	const gchar *translator_credits =
		"Christian Rose <menthos@menthos.com> Swedish translations\n" \
		"Kjartan Maraas <kmaraas@online.no> Norwegian translation\n";
	DbShellData *dsd = data;

	icon = gdk_pixbuf_new_from_file (LIBGNOMEDB_ICONSDIR "/gnome-db.png", NULL);

	dialog = gnome_about_new ("GNOME-DB", VERSION,
				  "(C) 1998-2003 GNOME Foundation",
				  _("Database services for the GNOME Desktop"),
				  authors,
				  documenters,
				  translator_credits,
				  icon);
	g_signal_connect (G_OBJECT (dialog), "destroy",
			  G_CALLBACK (gtk_widget_destroyed),
			  &dialog);
	gtk_window_set_transient_for (GTK_WINDOW (dialog), GTK_WINDOW (dsd->shell));
	gtk_widget_show (dialog);

}

static void
command_close (BonoboUIComponent *uic, void *data, const char *path)
{
	DbShellData *dsd = data;

	gnome_db_window_close (GNOME_DB_WINDOW (dsd->shell));
}

static void
command_preferences (BonoboUIComponent *uic, void *data, const char *path)
{
}

static BonoboUIVerb db_shell_verbs [] = {
	BONOBO_UI_VERB ("FileClose", command_close),
	BONOBO_UI_VERB ("SettingsPreferences", command_preferences),
	BONOBO_UI_VERB ("HelpAbout", command_about),

	BONOBO_UI_VERB_END
};

static void
shell_closed_cb (GnomeDbWindow *window, gpointer user_data)
{
	DbShellData *dsd = user_data;

	dsd->shell = NULL;
	dsd->cnc = NULL;
	g_free (dsd);
}

GtkWidget *
db_shell_new (const gchar *title, GtkWidget *widget, GdaConnection *cnc)
{
	DbShellData *dsd;

	dsd = g_new0 (DbShellData, 1);
	dsd->cnc = cnc;

	/* create the main window */
	dsd->shell = gnome_db_window_new (title, PREFIX,
					  LIBGNOMEDB_UIDIR "/gnome-components-shell.xml",
					  db_shell_verbs, dsd);
	g_signal_connect_after (dsd->shell, "close", G_CALLBACK (shell_closed_cb), dsd);

	gnome_db_window_set_contents (GNOME_DB_WINDOW (dsd->shell), widget);
	gtk_widget_show (widget);
	gtk_window_set_default_size (GTK_WINDOW (dsd->shell), 400, 350);
	gtk_widget_show (dsd->shell);

	return dsd->shell;
}
