/* GNOME DB library
 * Copyright (C) 1999-2002 The GNOME Foundation.
 *
 * AUTHORS:
 *      Rodrigo Moya <rodrigo@gnome-db.org>
 *
 * This Library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This Library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this Library; see the file COPYING.LIB.  If not,
 * write to the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#if !defined(__gnome_db_form_h__)
#  define __gnome_db_form_h__

#include <libgda/gda-data-model.h>
#include <gtk/gtkframe.h>

G_BEGIN_DECLS

#define GNOME_DB_TYPE_FORM            (gnome_db_form_get_type())
#define GNOME_DB_FORM(obj)            (G_TYPE_CHECK_INSTANCE_CAST (obj, GNOME_DB_TYPE_FORM, GnomeDbForm))
#define GNOME_DB_FORM_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST (klass, GNOME_DB_TYPE_FORM, GnomeDbFormClass))
#define GNOME_DB_IS_FORM(obj)         (G_TYPE_CHECK_INSTANCE_TYPE (obj, GNOME_DB_TYPE_FORM))
#define GNOME_DB_IS_FORM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GNOME_DB_TYPE_FORM))

typedef struct _GnomeDbForm        GnomeDbForm;
typedef struct _GnomeDbFormClass   GnomeDbFormClass;
typedef struct _GnomeDbFormPrivate GnomeDbFormPrivate;

struct _GnomeDbForm {
	GtkFrame frame;
	GnomeDbFormPrivate *priv;
};

struct _GnomeDbFormClass {
	GtkFrameClass parent_class;

	/* signals */
	void (* model_changed) (GnomeDbForm *form);
};

typedef enum {
	GNOME_DB_FORM_TYPE_NAVIGATOR,
	GNOME_DB_FORM_TYPE_LIST
} GnomeDbFormType;

GType            gnome_db_form_get_type (void);
GtkWidget       *gnome_db_form_new (void);
GnomeDbFormType  gnome_db_form_get_form_type (GnomeDbForm *form);
void             gnome_db_form_set_form_type (GnomeDbForm *form, GnomeDbFormType type);
GdaDataModel    *gnome_db_form_get_model (GnomeDbForm *form);
void             gnome_db_form_set_model (GnomeDbForm *form, GdaDataModel *model);


G_END_DECLS

#endif
