
#include <libgnomecanvasmm/pixbuf.h>
#include <libgnomecanvasmm/private/pixbuf_p.h>

/* $Id: pixbuf.ccg,v 1.2 2002/02/24 20:41:19 murrayc Exp $ */

/* pixbuf.cc
 *
 * Copyright (C) 2002 The libgnomecanvasmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


namespace Gnome
{

namespace Canvas
{

Pixbuf::Pixbuf (Group& parent, 
                double x, double y, 
                const Glib::RefPtr<Gdk::Pixbuf>& image)
  : Item (GNOME_CANVAS_ITEM (g_object_new (get_type (), NULL)))
{
  item_construct (parent);
  set ("x", x, 
       "y", y, 
       "pixbuf", image->gobj (),
       "width", (double) gdk_pixbuf_get_width (image->gobj ()),
       "height", (double) gdk_pixbuf_get_height (image->gobj ()),
       NULL);
}


Pixbuf::Pixbuf (Group& parent)
  : Item (GNOME_CANVAS_ITEM (g_object_new (get_type (), NULL)))
{
  item_construct (parent);
}


}

}


namespace
{
} // anonymous namespace


namespace Glib
{

Gnome::Canvas::Pixbuf* wrap(GnomeCanvasPixbuf* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gnome::Canvas::Pixbuf *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gnome
{

namespace Canvas
{


/* The *_Class implementation: */

GType Pixbuf_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        GType gtype_base = gnome_canvas_pixbuf_get_type();
        Glib::ustring gtypename = "gtkmm__" + Glib::ustring( g_type_name(gtype_base) ); //This prefix is also used by libglademm to calculate gtkmm gtypes from gtk+ gtypes.
        gtype_ = g_type_register_static(gtype_base, gtypename.c_str(), &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Pixbuf_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Pixbuf_Class::wrap_new(GObject* o)
{
  return manage(new Pixbuf((GnomeCanvasPixbuf*)(o)));
}


/* The implementation: */

Pixbuf::Pixbuf(GnomeCanvasPixbuf* castitem)
: Item((GnomeCanvasItem*)(castitem))
{}

Pixbuf::~Pixbuf()
{
  destroy_();
}

Pixbuf::CppClassType Pixbuf::pixbuf_class_; //Initialize static member.

GType Pixbuf::get_type()
{
  return pixbuf_class_.get_type();
}

GType Pixbuf::get_base_type()
{
  return gnome_canvas_pixbuf_get_type();
}


Glib::PropertyProxy<Gdk::Pixbuf> Pixbuf::property_pixbuf()
{
  return Glib::PropertyProxy<Gdk::Pixbuf>(this, "pixbuf");
}

Glib::PropertyProxy<double> Pixbuf::property_width()
{
  return Glib::PropertyProxy<double>(this, "width");
}

Glib::PropertyProxy<bool> Pixbuf::property_width_set()
{
  return Glib::PropertyProxy<bool>(this, "width_set");
}

Glib::PropertyProxy<bool> Pixbuf::property_width_in_pixels()
{
  return Glib::PropertyProxy<bool>(this, "width_in_pixels");
}

Glib::PropertyProxy<double> Pixbuf::property_height()
{
  return Glib::PropertyProxy<double>(this, "height");
}

Glib::PropertyProxy<bool> Pixbuf::property_height_set()
{
  return Glib::PropertyProxy<bool>(this, "height_set");
}

Glib::PropertyProxy<bool> Pixbuf::property_height_in_pixels()
{
  return Glib::PropertyProxy<bool>(this, "height_in_pixels");
}

Glib::PropertyProxy<double> Pixbuf::property_x()
{
  return Glib::PropertyProxy<double>(this, "x");
}

Glib::PropertyProxy<bool> Pixbuf::property_x_in_pixels()
{
  return Glib::PropertyProxy<bool>(this, "x_in_pixels");
}

Glib::PropertyProxy<double> Pixbuf::property_y()
{
  return Glib::PropertyProxy<double>(this, "y");
}

Glib::PropertyProxy<bool> Pixbuf::property_y_in_pixels()
{
  return Glib::PropertyProxy<bool>(this, "y_in_pixels");
}

Glib::PropertyProxy<Gtk::AnchorType> Pixbuf::property_anchor()
{
  return Glib::PropertyProxy<Gtk::AnchorType>(this, "anchor");
}


} // namespace Canvas

} // namespace Gnome

