
#include <libgnomecanvasmm/line.h>
#include <libgnomecanvasmm/private/line_p.h>

/* $Id: line.ccg,v 1.4 2002/03/25 11:56:45 aholzmann Exp $ */

/* line.ccg
 *
 * Copyright (C) 1998 EMC Capital Management Inc.
 * Developed by Havoc Pennington <hp@pobox.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

//#include <libgnomecanvasmm/group.h>

namespace Gnome
{

namespace Canvas
{

Points::Points(size_type nbpoints)
: std::vector<Art::Point>(nbpoints), points_(0), owned_(false)
{}

Points::Points(GnomeCanvasPoints *castitem)
: points_(castitem),owned_(false)
{
  reserve(points_->num_points);

  //GnomeCanvasPoints has an array of doubles, used 2 at a time:
  int i = 0;
  for(iterator it = begin(); i < points_->num_points; i += 2, ++it)
  {
    (*it).set_x(points_->coords[i]);
    (*it).set_y(points_->coords[i+1]);
  }
}

Points::~Points()
{
  if (owned_ && points_)
    gnome_canvas_points_free(points_);
}

Points::operator bool() const
{
  return (!is_null());
}

bool Points::is_null() const
{
  return size() == 0;
}

GnomeCanvasPoints* Points::_gobj() const
{
  int i = 0;
  
  if(!points_)
  {
    points_ = gnome_canvas_points_new(size());
    owned_ = true;
  }
  else if(size() != static_cast<unsigned int>(points_->num_points))
  {
    if (owned_)
     gnome_canvas_points_free(points_);

    points_ = gnome_canvas_points_new(size());
    owned_ = true;
  }
  
  for(const_iterator it = begin(); it != end(); ++it, i+=2)
  {
    points_->coords[i] = (*it).get_x();
    points_->coords[i+1] = (*it).get_y();
  }

  return points_;
}


Line::Line(Group& parentx)
  : Item(GNOME_CANVAS_ITEM(g_object_new(get_type(),0)))
{
  item_construct(parentx);
}

Line::Line(Group& parentx, const Points& points)
  : Item(GNOME_CANVAS_ITEM(g_object_new(get_type(),0)))
{
  item_construct(parentx);
  property_points().set_value(points);
}

} /* namespace Canvas */
} /* namespace Gnome */


namespace
{
} // anonymous namespace


namespace Glib
{

Gnome::Canvas::Line* wrap(GnomeCanvasLine* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gnome::Canvas::Line *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gnome
{

namespace Canvas
{


/* The *_Class implementation: */

GType Line_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        GType gtype_base = gnome_canvas_line_get_type();
        Glib::ustring gtypename = "gtkmm__" + Glib::ustring( g_type_name(gtype_base) ); //This prefix is also used by libglademm to calculate gtkmm gtypes from gtk+ gtypes.
        gtype_ = g_type_register_static(gtype_base, gtypename.c_str(), &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Line_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
}


Glib::ObjectBase* Line_Class::wrap_new(GObject* o)
{
  return manage(new Line((GnomeCanvasLine*)(o)));
}


/* The implementation: */

Line::Line(GnomeCanvasLine* castitem)
: Item((GnomeCanvasItem*)(castitem))
{}

Line::~Line()
{
  destroy_();
}

Line::CppClassType Line::line_class_; //Initialize static member.

GType Line::get_type()
{
  return line_class_.get_type();
}

GType Line::get_base_type()
{
  return gnome_canvas_line_get_type();
}


Glib::PropertyProxy<Points> Line::property_points()
{
  return Glib::PropertyProxy<Points>(this, "points");
}

Glib::PropertyProxy<Glib::ustring> Line::property_fill_color()
{
  return Glib::PropertyProxy<Glib::ustring>(this, "fill_color");
}

Glib::PropertyProxy<Gdk::Color> Line::property_fill_color_gdk()
{
  return Glib::PropertyProxy<Gdk::Color>(this, "fill_color_gdk");
}

Glib::PropertyProxy<guint> Line::property_fill_color_rgba()
{
  return Glib::PropertyProxy<guint>(this, "fill_color_rgba");
}

Glib::PropertyProxy< Glib::RefPtr<Gdk::Drawable> > Line::property_fill_stipple()
{
  return Glib::PropertyProxy< Glib::RefPtr<Gdk::Drawable> >(this, "fill_stipple");
}

Glib::PropertyProxy<guint> Line::property_width_pixels()
{
  return Glib::PropertyProxy<guint>(this, "width_pixels");
}

Glib::PropertyProxy<double> Line::property_width_units()
{
  return Glib::PropertyProxy<double>(this, "width_units");
}

Glib::PropertyProxy<Gdk::CapStyle> Line::property_cap_style()
{
  return Glib::PropertyProxy<Gdk::CapStyle>(this, "cap_style");
}

Glib::PropertyProxy<Gdk::JoinStyle> Line::property_join_style()
{
  return Glib::PropertyProxy<Gdk::JoinStyle>(this, "join_style");
}

Glib::PropertyProxy<Gdk::LineStyle> Line::property_line_style()
{
  return Glib::PropertyProxy<Gdk::LineStyle>(this, "line_style");
}

Glib::PropertyProxy<bool> Line::property_first_arrowhead()
{
  return Glib::PropertyProxy<bool>(this, "first_arrowhead");
}

Glib::PropertyProxy<bool> Line::property_last_arrowhead()
{
  return Glib::PropertyProxy<bool>(this, "last_arrowhead");
}

Glib::PropertyProxy<bool> Line::property_smooth()
{
  return Glib::PropertyProxy<bool>(this, "smooth");
}

Glib::PropertyProxy<guint> Line::property_spline_steps()
{
  return Glib::PropertyProxy<guint>(this, "spline_steps");
}

Glib::PropertyProxy<double> Line::property_arrow_shape_a()
{
  return Glib::PropertyProxy<double>(this, "arrow_shape_a");
}

Glib::PropertyProxy<double> Line::property_arrow_shape_b()
{
  return Glib::PropertyProxy<double>(this, "arrow_shape_b");
}

Glib::PropertyProxy<double> Line::property_arrow_shape_c()
{
  return Glib::PropertyProxy<double>(this, "arrow_shape_c");
}


} // namespace Canvas

} // namespace Gnome

