
#include <libgnomecanvasmm/item.h>
#include <libgnomecanvasmm/private/item_p.h>

// -*- C++ -*-
/* $Id: item.ccg,v 1.2 2002/03/16 11:31:57 murrayc Exp $ */

/* item.cc
 *
 * Copyright (C) 1998 EMC Capital Management Inc.
 * Developed by Havoc Pennington <hp@pobox.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

extern "C" 
{
#include <stdarg.h>
}

#include <libgnomecanvasmm/canvas.h>
#include <libgnomecanvasmm/group.h>
#include <libgnomecanvas/gnome-canvas-util.h>

namespace Gnome
{

namespace Canvas
{

void
Item::item_construct(Group& group)
{
  gnome_canvas_item_construct(GNOME_CANVAS_ITEM(gobj()), group.gobj(),
                              0, 0);
}

void
Item::item_construct(Group& group, const gchar* first_arg_name,
                                 va_list ap)
{
  gnome_canvas_item_construct(GNOME_CANVAS_ITEM(gobj()), group.gobj(),
                              first_arg_name,
                              ap);
}

void 
Item::set(const gchar* first_arg_name, ...)
{
  va_list args;
  va_start(args,first_arg_name);
  gnome_canvas_item_set_valist(gobj(), first_arg_name, args);
  va_end(args);
}

int Item::grab(unsigned int event_mask, const Gdk::Cursor& cursor, guint32 etime)
{
  return gnome_canvas_item_grab(gobj(), event_mask, const_cast<GdkCursor*>(cursor.gobj()), etime);
}

int Item::grab(unsigned int event_mask, guint32 etime)
{
  return gnome_canvas_item_grab(gobj(), event_mask, 0, etime);
}

void
Item::affine_relative(const Art::AffineTrans &affine)
{
  gnome_canvas_item_affine_relative (gobj(), affine.gobj());
}

void
Item::affine_absolute (const Art::AffineTrans &affine)
{
  gnome_canvas_item_affine_absolute (gobj(), affine.gobj());
}

Art::AffineTrans
Item::get_i2w_affine() const
{
  double tmp[6] = {0};
  
  gnome_canvas_item_i2w_affine(const_cast<GnomeCanvasItem*>(gobj()), tmp);
  return Art::AffineTrans(tmp);
}

Art::AffineTrans
Item::get_i2c_affine() const
{
  double tmp[6] = {0};
  
  gnome_canvas_item_i2c_affine(const_cast<GnomeCanvasItem*>(gobj()), tmp);
  return Art::AffineTrans(tmp);
}

} /* namespace Canvas */
} /* namespace Gnome */


namespace
{


gboolean Item_signal_event_callback(GnomeCanvasItem*, GdkEvent* p0,void* data)
{
  using namespace Gnome::Canvas;
  typedef SigC::Slot1<bool,GdkEvent*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    return static_cast<int>(((*(SlotType::Proxy)(slot->proxy_))
        (p0, slot)));
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}

gboolean Item_signal_event_notify_callback(GnomeCanvasItem*, GdkEvent* p0,void* data)
{
  using namespace Gnome::Canvas;
  typedef SigC::Slot1<void,GdkEvent*> SlotType;

  try
  {
    SigC::SlotNode *const slot = Glib::SignalProxyNormal::data_to_slot(data);
    (*(SlotType::Proxy)(slot->proxy_))
        (p0, slot);
  }
  catch(...)
  {
    Glib::exception_handlers_invoke();
  }

  typedef gboolean RType;
  return RType();
}


const Glib::SignalProxyInfo Item_signal_event_info =
{
  "event",
  (GCallback) &Item_signal_event_callback,
  (GCallback) &Item_signal_event_notify_callback
};

} // anonymous namespace


namespace Glib
{

Gnome::Canvas::Item* wrap(GnomeCanvasItem* object, bool take_copy /* = false */)
{
  return dynamic_cast<Gnome::Canvas::Item *> (Glib::wrap_auto ((GObject*)(object), take_copy));
}

} /* namespace Glib */

namespace Gnome
{

namespace Canvas
{


/* The *_Class implementation: */

GType Item_Class::get_type()
  {
    if (!gtype_) //Create the GType if necessary.
      {
        //Make sure that the parent type has been created:
        CppClassParent::CppObjectType::get_type();

        //Create a derived C type.
        //These init funcs will, in turn, call the init functions in the base C type.
        GTypeInfo info =
          {
            sizeof(BaseClassType), /* class_size */
            0, /* base_init */
            0, /* base_finalize */
            (GClassInitFunc) &class_init_function, /* class_init */
            0, /* class_finalize */
            0, /* class_data */
            sizeof(BaseObjectType), /* instance_size */
            0, /* n_preallocs */
            0, /* instance_init */
	    0 /* value_table */
          };

        GType gtype_base = gnome_canvas_item_get_type();
        Glib::ustring gtypename = "gtkmm__" + Glib::ustring( g_type_name(gtype_base) ); //This prefix is also used by libglademm to calculate gtkmm gtypes from gtk+ gtypes.
        gtype_ = g_type_register_static(gtype_base, gtypename.c_str(), &info, GTypeFlags(0));

  //Add derived versions of interfaces, if the C type implements any interfaces:
      }
    return gtype_;
  }
void Item_Class::class_init_function(BaseClassType* klass)
{
  CppClassParent::class_init_function((CppClassParent::BaseClassType*) klass);
  klass->update = &update_vfunc_callback;
  klass->realize = &realize_vfunc_callback;
  klass->unrealize = &unrealize_vfunc_callback;
  klass->map = &map_vfunc_callback;
  klass->unmap = &unmap_vfunc_callback;
  klass->coverage = &coverage_vfunc_callback;
  klass->draw = &draw_vfunc_callback;
  klass->render = &render_vfunc_callback;
  klass->point = &point_vfunc_callback;
  klass->bounds = &bounds_vfunc_callback;
  klass->event = &event_callback;
}


void Item_Class::update_vfunc_callback(GnomeCanvasItem* self, double* affine, ArtSVP* clip_path, int flags)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->update(affine, clip_path, flags);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->update)
      (*base->update)(self, affine, clip_path, flags);
  }
}

void Item_Class::realize_vfunc_callback(GnomeCanvasItem* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->realize();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->realize)
      (*base->realize)(self);
  }
}

void Item_Class::unrealize_vfunc_callback(GnomeCanvasItem* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->unrealize();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->unrealize)
      (*base->unrealize)(self);
  }
}

void Item_Class::map_vfunc_callback(GnomeCanvasItem* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->map();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->map)
      (*base->map)(self);
  }
}

void Item_Class::unmap_vfunc_callback(GnomeCanvasItem* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->unmap();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->unmap)
      (*base->unmap)(self);
  }
}

ArtUta* Item_Class::coverage_vfunc_callback(GnomeCanvasItem* self)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->coverage();
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->coverage)
      (*base->coverage)(self);
  }

  typedef ArtUta* RType;
  return RType();
}

void Item_Class::draw_vfunc_callback(GnomeCanvasItem* self, GdkDrawable* drawable, int x, int y, int width, int height)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->draw(drawable, x, y, width, height);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->draw)
      (*base->draw)(self, drawable, x, y, width, height);
  }
}

void Item_Class::render_vfunc_callback(GnomeCanvasItem* self, GnomeCanvasBuf* buf)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->render(buf);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->render)
      (*base->render)(self, buf);
  }
}

double Item_Class::point_vfunc_callback(GnomeCanvasItem* self, double x, double y, int cx, int cy, GnomeCanvasItem** actual_item)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return obj->point(x, y, cx, cy, actual_item);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->point)
      (*base->point)(self, x, y, cx, cy, actual_item);
  }

  typedef double RType;
  return RType();
}

void Item_Class::bounds_vfunc_callback(GnomeCanvasItem* self, double* x1, double* y1, double* x2, double* y2)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      obj->bounds(x1, y1, x2, y2);
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->bounds)
      (*base->bounds)(self, x1, y1, x2, y2);
  }
}


gboolean Item_Class::event_callback(GnomeCanvasItem* self, GdkEvent* p0)
{
  CppObjectType *const obj = dynamic_cast<CppObjectType*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  if(obj)
  {
    try
    {
      return static_cast<int>(obj->on_event(p0));
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
  }
  else
  {
    BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class.
);
    g_assert(base != 0);

    if(base->event)
      (*base->event)(self, p0);
  }

  typedef gboolean RType;
  return RType();
}


Glib::ObjectBase* Item_Class::wrap_new(GObject* o)
{
  return manage(new Item((GnomeCanvasItem*)(o)));
}


/* The implementation: */

Item::Item(GnomeCanvasItem* castitem)
: Gtk::Object((GtkObject*)(castitem))
{}

Item::~Item()
{
  destroy_();
}

Item::CppClassType Item::item_class_; //Initialize static member.

GType Item::get_type()
{
  return item_class_.get_type();
}

GType Item::get_base_type()
{
  return gnome_canvas_item_get_type();
}

void Item::move(double dx, double dy)
{
  gnome_canvas_item_move(gobj(), dx, dy);
}

void Item::raise(int positions)
{
  gnome_canvas_item_raise(gobj(), positions);
}

void Item::lower(int positions)
{
  gnome_canvas_item_lower(gobj(), positions);
}

void Item::raise_to_top()
{
  gnome_canvas_item_raise_to_top(gobj());
}

void Item::lower_to_bottom()
{
  gnome_canvas_item_lower_to_bottom(gobj());
}

void Item::ungrab(guint32 etime)
{
  gnome_canvas_item_ungrab(gobj(), etime);
}

void Item::w2i(double& x, double& y)
{
  gnome_canvas_item_w2i(gobj(), &(x), &(y));
}

void Item::i2w(double& x, double& y)
{
  gnome_canvas_item_i2w(gobj(), &(x), &(y));
}

void Item::grab_focus()
{
  gnome_canvas_item_grab_focus(gobj());
}

void Item::get_bounds(double& x1, double& y1, double& x2, double& y2) const
{
  gnome_canvas_item_get_bounds(const_cast<GnomeCanvasItem*>(gobj()), &(x1), &(y1), &(x2), &(y2));
}

void Item::show()
{
  gnome_canvas_item_show(gobj());
}

void Item::hide()
{
  gnome_canvas_item_hide(gobj());
}

void Item::reparent(Group& new_group)
{
  gnome_canvas_item_reparent(gobj(), (new_group).gobj());
}

Canvas* Item::get_canvas() const
{
  return Glib::wrap(gobj()->canvas);
}

void Item::request_update()
{
  gnome_canvas_item_request_update(gobj());
}

void Item::reset_bounds()
{
  gnome_canvas_item_reset_bounds(gobj());
}

void Item::update_svp(ArtSVP ** p_svp, ArtSVP * new_svp)
{
  gnome_canvas_item_update_svp(gobj(), p_svp, new_svp);
}

void Item::update_svp_clip(ArtSVP ** p_svp, ArtSVP * new_svp, ArtSVP * clip_svp)
{
  gnome_canvas_item_update_svp_clip(gobj(), p_svp, new_svp, clip_svp);
}

void Item::request_redraw_svp(const ArtSVP* svp)
{
  gnome_canvas_item_request_redraw_svp(gobj(), svp);
}

void Item::update_bbox(int x1, int y1, int x2, int y2)
{
  gnome_canvas_update_bbox(gobj(), x1, y1, x2, y2);
}


Glib::SignalProxy1<bool,GdkEvent*> Item::signal_event()
{
  return Glib::SignalProxy1<bool,GdkEvent*>(this, &Item_signal_event_info);
}


Glib::PropertyProxy<Group*> Item::property_parent()
{
  return Glib::PropertyProxy<Group*>(this, "parent");
}


bool Gnome::Canvas::Item::on_event(GdkEvent* p1)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->event)
    return (*base->event)(gobj(),p1);

  typedef bool RType;
  return RType();
}


void Gnome::Canvas::Item::update(double* affine, ArtSVP* clip_path, int flags)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->update)
    (*base->update)(gobj(),affine,clip_path,flags);
}

void Gnome::Canvas::Item::realize()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->realize)
    (*base->realize)(gobj());
}

void Gnome::Canvas::Item::unrealize()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->unrealize)
    (*base->unrealize)(gobj());
}

void Gnome::Canvas::Item::map()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->map)
    (*base->map)(gobj());
}

void Gnome::Canvas::Item::unmap()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->unmap)
    (*base->unmap)(gobj());
}

ArtUta* Gnome::Canvas::Item::coverage()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->coverage)
    return (*base->coverage)(gobj());

  typedef ArtUta* RType;
  return RType();
}

void Gnome::Canvas::Item::draw(GdkDrawable* drawable, int x, int y, int width, int height)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->draw)
    (*base->draw)(gobj(),drawable,x,y,width,height);
}

void Gnome::Canvas::Item::render(GnomeCanvasBuf* buf)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->render)
    (*base->render)(gobj(),buf);
}

double Gnome::Canvas::Item::point(double x, double y, int cx, int cy, GnomeCanvasItem** actual_item)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->point)
    return (*base->point)(gobj(),x,y,cx,cy,actual_item);

  typedef double RType;
  return RType();
}

void Gnome::Canvas::Item::bounds(double* x1, double* y1, double* x2, double* y2)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class.
);
  g_assert(base != 0);

  if(base->bounds)
    (*base->bounds)(gobj(),x1,y1,x2,y2);
}


} // namespace Canvas

} // namespace Gnome

