/*
 * Java-Gnome Bindings Library
 *
 * Copyright 1998-2004 the Java-Gnome Team, all rights reserved.
 *
 * The Java-Gnome bindings library is free software distributed under
 * the terms of the GNU Library General Public License version 2.
 */

package org.gnu.gnome;
import org.gnu.glib.GObject;
import org.gnu.glib.Type;
import org.gnu.gtk.GtkObject;
/**
 * The GnomeCanvasItem is the base class of all items that a
 * GnomeCanvas displays.
 */
public class CanvasItem extends GtkObject {
	
	protected CanvasItem(CanvasGroup group, int type) {
		super(gnome_canvas_item_new(group.getHandle(), type));
	}
	/**
	 * Constructs an instance of CanvasItem from a native widget resource.
	 * @param handle The handle to the native widget.
	 */
	CanvasItem(int handle) {
		super(handle);
	}

	/**
	 * Apply an absolute affine transformation to the item.
	 * @param affine the affine to apply.
	 */
	public void affineAbsolute(double[] affine) {
		gnome_canvas_item_affine_absolute(getHandle(), affine);
	}

	/**
	 * Apply a relative affine transformation to the item.
	 * @param affine The affine to apply.
	 */
	public void affineRelative(double[] affine) {
		gnome_canvas_item_affine_relative(getHandle(), affine);
	}

	/**
	 * Returns the parent canvas for this item.
	 * @return The parent canvas.
	 */
	public Canvas getCanvas() {
		int hndl = getCanvas(getHandle());
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (Canvas)obj;
		return new Canvas(hndl);
	}

	/**
	 * Return the parent canvas group for this item.
	 * @return The parent cavas group.
	 */
	public CanvasGroup getParent() {
		int hndl = getParent(getHandle());
		GObject obj = retrieveGObject(hndl);
		if (null != obj)
			return (CanvasGroup)obj;
		return new CanvasGroup(hndl);
	}

	/**
	 * X1 coordinate fo the bounding box for this item (in canvas coordinates).
	 * @return The X1 coordinate.
	 */
	public double getX1() {
		return getX1(getHandle());
	}

	/**
	 * X2 coordinate fo the bounding box for this item (in canvas coordinates).
	 * @return The X2 coordinate.
	 */
	public double getX2() {
		return getX2(getHandle());
	}

	/**
	 * Y1 coordinate fo the bounding box for this item (in canvas coordinates).
	 * @return The Y1 coordinate.
	 */
	public double getY1() {
		return getY1(getHandle());
	}

	/**
	 * Y2 coordinate fo the bounding box for this item (in canvas coordinates).
	 * @return The Y2 coordinate.
	 */
	public double getY2() {
		return getY2(getHandle());
	}

	/**
	 * Hide the item (make it invisible).  If the item is already invisible, it
	 * has no effect.
	 */
	public void hide() {
		gnome_canvas_item_hide(getHandle());
	}

	/**
	 * Lower the item in the z-order of its parent group by the specified
	 * number of positions.
	 * @param positions The number of positions to lower the item.
	 */
	public void lower(int positions) {
		gnome_canvas_item_lower(getHandle(), positions);
	}

	/**
	 * Lower the item to the bottom of its parent group's z-order.
	 */
	public void lowerToBotton() {
		gnome_canvas_item_lower_to_bottom(getHandle());
	}

	/**
	 * Move the item by the specified amount.
	 * @param x The amount to move the item horizontally.
	 * @param y The amount to move the item vertically.
	 */
	public void move(double x, double y) {
		gnome_canvas_item_move(getHandle(), x, y);
	}

	/**
	 * Raise the item in the z-order of its parent group by the specified
	 * number of positions.
	 * @param positions The number of positions to raise the item.
	 */
	public void raise(int positions) {
		gnome_canvas_item_raise(getHandle(), positions);
	}

	/**
	 * Raise the item to the top of its parent group's z-order.
	 */
	public void raiseToTop() {
		gnome_canvas_item_raise_to_top(getHandle());
	}

	/**
	 * Show the item (make it visible).  If the item is already shown, it has
	 * no effect.
	 */
	public void show() {
		gnome_canvas_item_show(getHandle());
	}

	/**
	 * Retrieve the runtime type used by the GLib library.
	 */
	public static Type getType() {
		return new Type(gnome_canvas_item_get_type());
	}

	/****************************************
	 * BEGINNING OF GENERATED CODE
	 ****************************************/
	native static final protected int getCanvas(int cptr);
	native static final protected int getParent(int cptr);
	native static final protected double getX1(int cptr);
	native static final protected double getY1(int cptr);
	native static final protected double getX2(int cptr);
	native static final protected double getY2(int cptr);
	native static final protected int gnome_canvas_item_get_type();
	native static final protected void gnome_canvas_item_move(int item, double dx, double dy);
	native static final protected void gnome_canvas_item_affine_relative(int item, double[] affine);
	native static final protected void gnome_canvas_item_affine_absolute(int item, double[] affine);
	native static final protected void gnome_canvas_item_raise(int item, int position);
	native static final protected void gnome_canvas_item_raise_to_top(int item);
	native static final protected void gnome_canvas_item_lower(int item, int positions);
	native static final protected void gnome_canvas_item_lower_to_bottom(int item);
	native static final protected void gnome_canvas_item_show(int item);
	native static final protected void gnome_canvas_item_hide(int item);
	native static final protected int gnome_canvas_item_grab(int item, int event_mask, int cursor, int etime);
	native static final protected void gnome_canvas_item_ungrab(int item, int etime);
	native static final protected void gnome_canvas_item_reparent(int item, int new_group);
	native static final protected void gnome_canvas_item_grab_focus(int item);
	native static final protected void gnome_canvas_item_request_update(int item);
	native static final protected int gnome_canvas_item_new(int group, int type);
	/****************************************
	 * END OF GENERATED CODE
	 ****************************************/
}
