/* traversable.c generated by valac 0.18.0.57-8d977, the Vala compiler
 * generated from traversable.vala, do not modify */

/* traversable.vala
 *
 * Copyright (C) 2011-2012  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;
typedef struct _Block7Data Block7Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;
typedef struct _Block8Data Block8Data;
#define _gee_lazy_unref0(var) ((var == NULL) ? NULL : (var = (gee_lazy_unref (var), NULL)))
typedef struct _Block9Data Block9Data;
#define _a_destroy_func0(var) (((var == NULL) || (a_destroy_func == NULL)) ? NULL : (var = (a_destroy_func (var), NULL)))
typedef struct _Block10Data Block10Data;
typedef struct _Block11Data Block11Data;
typedef struct _Block12Data Block12Data;
typedef struct _Block13Data Block13Data;
typedef struct _Block14Data Block14Data;
typedef struct _Block15Data Block15Data;
typedef struct _Block16Data Block16Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, void* user_data);
typedef gboolean (*GeeForallFunc) (gpointer g, void* user_data);
typedef GeeLazy* (*GeeUnfoldFunc) (void* user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END
} GeeTraversableStream;

typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, void* user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, void* user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, void* user_data);
struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeTraversable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeTraversable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeTraversable* self);
	gboolean (*foreach) (GeeTraversable* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
	GType (*get_element_type) (GeeTraversable* self);
};

struct _Block7Data {
	int _ref_count_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeIterator* _self_;
	GeeStreamFunc f;
	gpointer f_target;
	GDestroyNotify f_target_destroy_notify;
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeIterable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeIterable* self);
	GeeIterator* (*iterator) (GeeIterable* self);
};

struct _Block8Data {
	int _ref_count_;
	Block7Data * _data7_;
	GeeTraversableStream str;
	gboolean need_next;
};

typedef gpointer (*GeeLazyFunc) (void* user_data);
struct _Block9Data {
	int _ref_count_;
	Block8Data * _data8_;
};

struct _Block10Data {
	int _ref_count_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeFoldFunc f;
	gpointer f_target;
	gpointer seed;
};

struct _Block11Data {
	int _ref_count_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeMapFunc f;
	gpointer f_target;
};

struct _Block12Data {
	int _ref_count_;
	Block11Data * _data11_;
	GeeLazy* item;
};

struct _Block13Data {
	int _ref_count_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gboolean seed_emitted;
	GeeFoldFunc f;
	gpointer f_target;
	gpointer seed;
};

struct _Block14Data {
	int _ref_count_;
	Block13Data * _data13_;
	GeeLazy* item;
};

struct _Block15Data {
	int _ref_count_;
	GeeTraversable * self;
	GeePredicate pred;
	gpointer pred_target;
	GDestroyNotify pred_target_destroy_notify;
};

struct _Block16Data {
	int _ref_count_;
	GeeTraversable * self;
	gint offset;
	gint length;
};



gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_lazy (GValue* value, gpointer v_object);
void gee_value_take_lazy (GValue* value, gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
gboolean gee_traversable_foreach (GeeTraversable* self, GeeForallFunc f, void* f_target);
GeeIterator* gee_traversable_stream (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
static GeeIterator* gee_traversable_real_stream (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
GType gee_iterable_get_type (void) G_GNUC_CONST;
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
gboolean gee_iterator_get_valid (GeeIterator* self);
static gpointer _____lambda3_ (Block8Data* _data8_);
gpointer gee_iterator_get (GeeIterator* self);
static gpointer ______lambda3__gee_lazy_func (gpointer self);
GeeLazy* gee_lazy_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLazyFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
GeeLazy* gee_lazy_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLazyFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
GeeIterator* gee_iterator_unfold (GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeUnfoldFunc f, void* f_target, GDestroyNotify f_target_destroy_notify, GeeLazy* current);
static GeeLazy* ______lambda4_ (Block8Data* _data8_);
static GeeLazy* _______lambda4__gee_unfold_func (gpointer self);
static GeeLazy* ____lambda5_ (Block8Data* _data8_);
static GeeLazy* _____lambda5__gee_unfold_func (gpointer self);
static GeeLazy* ___lambda6_ (Block8Data* _data8_);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (void * _userdata_);
gboolean gee_iterator_next (GeeIterator* self);
static gpointer ___lambda7_ (Block9Data* _data9_);
static gpointer ____lambda7__gee_lazy_func (gpointer self);
static GeeLazy* ____lambda6__gee_unfold_func (gpointer self);
GeeIterator* gee_iterable_iterator (GeeIterable* self);
gpointer gee_traversable_fold (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
static gpointer gee_traversable_real_fold (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (void * _userdata_);
static gboolean __lambda8_ (Block10Data* _data10_, gpointer item);
static gboolean ___lambda8__gee_forall_func (gpointer g, gpointer self);
GeeIterator* gee_traversable_map (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
static GeeIterator* gee_traversable_real_map (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static GeeTraversableStream __lambda9_ (Block11Data* _data11_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val);
static Block12Data* block12_data_ref (Block12Data* _data12_);
static void block12_data_unref (void * _userdata_);
static gpointer ___lambda10_ (Block12Data* _data12_);
gpointer gee_lazy_get (GeeLazy* self);
static gpointer ____lambda10__gee_lazy_func (gpointer self);
static GeeTraversableStream ___lambda9__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self);
GeeIterator* gee_traversable_scan (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
static GeeIterator* gee_traversable_real_scan (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static GeeTraversableStream __lambda11_ (Block13Data* _data13_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val);
static Block14Data* block14_data_ref (Block14Data* _data14_);
static void block14_data_unref (void * _userdata_);
GeeLazy* gee_lazy_new_from_value (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer item);
GeeLazy* gee_lazy_construct_from_value (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer item);
static gpointer ___lambda12_ (Block14Data* _data14_);
static gpointer ____lambda12__gee_lazy_func (gpointer self);
static GeeTraversableStream ___lambda11__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self);
GeeIterator* gee_traversable_filter (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
static GeeIterator* gee_traversable_real_filter (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
static Block15Data* block15_data_ref (Block15Data* _data15_);
static void block15_data_unref (void * _userdata_);
static GeeTraversableStream __lambda13_ (Block15Data* _data15_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val);
static GeeTraversableStream ___lambda13__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self);
GeeIterator* gee_traversable_chop (GeeTraversable* self, gint offset, gint length);
static GeeIterator* gee_traversable_real_chop (GeeTraversable* self, gint offset, gint length);
static Block16Data* block16_data_ref (Block16Data* _data16_);
static void block16_data_unref (void * _userdata_);
static GeeTraversableStream __lambda14_ (Block16Data* _data16_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val);
static GeeTraversableStream ___lambda14__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self);
GType gee_traversable_get_element_type (GeeTraversable* self);


GType gee_traversable_stream_get_type (void) {
	static volatile gsize gee_traversable_stream_type_id__volatile = 0;
	if (g_once_init_enter (&gee_traversable_stream_type_id__volatile)) {
		static const GEnumValue values[] = {{GEE_TRAVERSABLE_STREAM_YIELD, "GEE_TRAVERSABLE_STREAM_YIELD", "yield"}, {GEE_TRAVERSABLE_STREAM_CONTINUE, "GEE_TRAVERSABLE_STREAM_CONTINUE", "continue"}, {GEE_TRAVERSABLE_STREAM_END, "GEE_TRAVERSABLE_STREAM_END", "end"}, {0, NULL, NULL}};
		GType gee_traversable_stream_type_id;
		gee_traversable_stream_type_id = g_enum_register_static ("GeeTraversableStream", values);
		g_once_init_leave (&gee_traversable_stream_type_id__volatile, gee_traversable_stream_type_id);
	}
	return gee_traversable_stream_type_id__volatile;
}


/**
 * Apply function to each element returned by iterator untill last element
 * or function return ''false''.
 *
 * ''{@link Iterator} implementation:'' Operation moves the iterator
 * to last element in iteration or the first element that returned ''false''.
 * If iterator points at some element it will be included in iteration.
 *
 * @return ''false'' if the argument returned ''false'' at last invocation and
 *         ''true'' otherwise.
 */
gboolean gee_traversable_foreach (GeeTraversable* self, GeeForallFunc f, void* f_target) {
#line 65 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 65 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->foreach (self, f, f_target);
#line 322 "traversable.c"
}


/**
 * Stream function is an abstract function allowing writing many
 * operations.
 *
 * The stream function accepts three parameter:
 *
 *   1. state. It is usually the last returned value from function but
 *      it may be {@link Stream.END} when {@link Stream.CONTINUE} was
 *      returned and there was no more elements.
 *   1. input. It is valid only if first argument is
 *      {@link Stream.CONTINUE}
 *   1. output. It is valid only if result is Stream.YIELD
 *
 * It may return one of 3 results:
 *
 *   1. {@link Stream.YIELD}. It means that value was yielded and can
 *      be passed to outgoing iterator.
 *   1. {@link Stream.CONTINUE}. It means that the function needs to be
 *      called with next element or with {@link Stream.END} if it is
 *      end of stream). If the state element was Stream.END during the
 *      current iteration function ''must not'' return {@link Stream.CONTINUE}
 *   1. Stream.END. It means that the last argument was yielded.
 *
 * If the function yields the value immediately then the returning iterator
 * is {@link Iterator.valid} and points to this value as well as in case when the
 * parent iterator is {@link Iterator.valid} and function yields
 * after consuming 1 input. In other case returned iterator is invalid.
 *
 * Note: In {@link Iterator} implementation: if iterator is
 *    {@link Iterator.valid} the current value should be fed
 *    immediately to function if during initial call function returns
 *    {@link Stream.CONTINUE}. The parent iterator cannot be used before
 *    the functions return {@link Stream.END} afterwards it points on the
 *    last element consumed.
 *
 * @param f function generating stream
 * @return iterator containing values yielded by stream
 */
static Block7Data* block7_data_ref (Block7Data* _data7_) {
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_atomic_int_inc (&_data7_->_ref_count_);
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return _data7_;
#line 369 "traversable.c"
}


static void block7_data_unref (void * _userdata_) {
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
#line 378 "traversable.c"
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		self = _data7_->self;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_type = _data7_->a_type;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_dup_func = _data7_->a_dup_func;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_destroy_func = _data7_->a_destroy_func;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_g_object_unref0 (_data7_->_self_);
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		(_data7_->f_target_destroy_notify == NULL) ? NULL : (_data7_->f_target_destroy_notify (_data7_->f_target), NULL);
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data7_->f = NULL;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data7_->f_target = NULL;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data7_->f_target_destroy_notify = NULL;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_g_object_unref0 (self);
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		g_slice_free (Block7Data, _data7_);
#line 405 "traversable.c"
	}
}


static gpointer _g_object_ref0 (gpointer self) {
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return self ? g_object_ref (self) : NULL;
#line 413 "traversable.c"
}


static Block8Data* block8_data_ref (Block8Data* _data8_) {
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_atomic_int_inc (&_data8_->_ref_count_);
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return _data8_;
#line 422 "traversable.c"
}


static void block8_data_unref (void * _userdata_) {
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
#line 431 "traversable.c"
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		self = _data8_->_data7_->self;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_type = _data8_->_data7_->a_type;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_dup_func = _data8_->_data7_->a_dup_func;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_destroy_func = _data8_->_data7_->a_destroy_func;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		block7_data_unref (_data8_->_data7_);
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data8_->_data7_ = NULL;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		g_slice_free (Block8Data, _data8_);
#line 450 "traversable.c"
	}
}


static gpointer _____lambda3_ (Block8Data* _data8_) {
	Block7Data* _data7_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer result = NULL;
	GeeIterator* _tmp0_;
	gpointer _tmp1_ = NULL;
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data7_ = _data8_->_data7_;
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data7_->self;
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_type = _data7_->a_type;
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_dup_func = _data7_->a_dup_func;
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_destroy_func = _data7_->a_destroy_func;
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = _data7_->_self_;
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = gee_iterator_get (_tmp0_);
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = _tmp1_;
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 482 "traversable.c"
}


static gpointer ______lambda3__gee_lazy_func (gpointer self) {
	gpointer result;
	result = _____lambda3_ (self);
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 491 "traversable.c"
}


static GeeLazy* ______lambda4_ (Block8Data* _data8_) {
	Block7Data* _data7_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeLazy* result = NULL;
#line 123 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data7_ = _data8_->_data7_;
#line 123 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data7_->self;
#line 123 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_type = _data7_->a_type;
#line 123 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_dup_func = _data7_->a_dup_func;
#line 123 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_destroy_func = _data7_->a_destroy_func;
#line 123 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = NULL;
#line 123 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 516 "traversable.c"
}


static GeeLazy* _______lambda4__gee_unfold_func (gpointer self) {
	GeeLazy* result;
	result = ______lambda4_ (self);
#line 123 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 525 "traversable.c"
}


static GeeLazy* ____lambda5_ (Block8Data* _data8_) {
	Block7Data* _data7_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeLazy* result = NULL;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data7_ = _data8_->_data7_;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data7_->self;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_type = _data7_->a_type;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_dup_func = _data7_->a_dup_func;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_destroy_func = _data7_->a_destroy_func;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = NULL;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 550 "traversable.c"
}


static GeeLazy* _____lambda5__gee_unfold_func (gpointer self) {
	GeeLazy* result;
	result = ____lambda5_ (self);
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 559 "traversable.c"
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_atomic_int_inc (&_data9_->_ref_count_);
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return _data9_;
#line 568 "traversable.c"
}


static void block9_data_unref (void * _userdata_) {
	Block9Data* _data9_;
	_data9_ = (Block9Data*) _userdata_;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
#line 577 "traversable.c"
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		self = _data9_->_data8_->_data7_->self;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_type = _data9_->_data8_->_data7_->a_type;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_dup_func = _data9_->_data8_->_data7_->a_dup_func;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_destroy_func = _data9_->_data8_->_data7_->a_destroy_func;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		block8_data_unref (_data9_->_data8_);
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data9_->_data8_ = NULL;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		g_slice_free (Block9Data, _data9_);
#line 596 "traversable.c"
	}
}


static gpointer ___lambda7_ (Block9Data* _data9_) {
	Block8Data* _data8_;
	Block7Data* _data7_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer result = NULL;
	GeeIterator* _tmp0_;
	gpointer _tmp1_ = NULL;
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data8_ = _data9_->_data8_;
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data7_ = _data8_->_data7_;
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data7_->self;
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_type = _data7_->a_type;
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_dup_func = _data7_->a_dup_func;
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_destroy_func = _data7_->a_destroy_func;
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = _data7_->_self_;
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = gee_iterator_get (_tmp0_);
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = _tmp1_;
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 631 "traversable.c"
}


static gpointer ____lambda7__gee_lazy_func (gpointer self) {
	gpointer result;
	result = ___lambda7_ (self);
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 640 "traversable.c"
}


static GeeLazy* ___lambda6_ (Block8Data* _data8_) {
	Block7Data* _data7_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeLazy* result = NULL;
	Block9Data* _data9_;
	GeeLazy* val;
	GeeTraversableStream _tmp0_;
	GeeTraversableStream _tmp16_;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data7_ = _data8_->_data7_;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data7_->self;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_type = _data7_->a_type;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_dup_func = _data7_->a_dup_func;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_destroy_func = _data7_->a_destroy_func;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data9_ = g_slice_new0 (Block9Data);
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data9_->_ref_count_ = 1;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data9_->_data8_ = block8_data_ref (_data8_);
#line 139 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	val = NULL;
#line 140 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = _data8_->str;
#line 140 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (_tmp0_ != GEE_TRAVERSABLE_STREAM_CONTINUE) {
#line 677 "traversable.c"
		GeeStreamFunc _tmp1_;
		void* _tmp1__target;
		GeeLazy* _tmp2_ = NULL;
		GeeTraversableStream _tmp3_ = 0;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp1_ = _data7_->f;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp1__target = _data7_->f_target;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp3_ = _tmp1_ (GEE_TRAVERSABLE_STREAM_YIELD, NULL, &_tmp2_, _tmp1__target);
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_gee_lazy_unref0 (val);
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		val = _tmp2_;
#line 141 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data8_->str = _tmp3_;
#line 694 "traversable.c"
	}
#line 142 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	while (TRUE) {
#line 698 "traversable.c"
		GeeTraversableStream _tmp4_;
		gboolean _tmp5_;
		GeeStreamFunc _tmp12_;
		void* _tmp12__target;
		GeeLazy* _tmp13_;
		GeeLazy* _tmp14_ = NULL;
		GeeTraversableStream _tmp15_ = 0;
#line 142 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp4_ = _data8_->str;
#line 142 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		if (!(_tmp4_ == GEE_TRAVERSABLE_STREAM_CONTINUE)) {
#line 142 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			break;
#line 712 "traversable.c"
		}
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp5_ = _data8_->need_next;
#line 143 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		if (_tmp5_) {
#line 718 "traversable.c"
			GeeIterator* _tmp6_;
			gboolean _tmp7_ = FALSE;
#line 144 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp6_ = _data7_->_self_;
#line 144 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp7_ = gee_iterator_next (_tmp6_);
#line 144 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (!_tmp7_) {
#line 727 "traversable.c"
				GeeStreamFunc _tmp8_;
				void* _tmp8__target;
				GeeLazy* _tmp9_ = NULL;
				GeeTraversableStream _tmp10_ = 0;
				GeeTraversableStream _tmp11_;
#line 145 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp8_ = _data7_->f;
#line 145 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp8__target = _data7_->f_target;
#line 145 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp10_ = _tmp8_ (GEE_TRAVERSABLE_STREAM_END, NULL, &_tmp9_, _tmp8__target);
#line 145 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (val);
#line 145 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				val = _tmp9_;
#line 145 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_data8_->str = _tmp10_;
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp11_ = _data8_->str;
#line 146 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_vala_assert (_tmp11_ != GEE_TRAVERSABLE_STREAM_CONTINUE, "str != Traversable.Stream.CONTINUE");
#line 147 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				break;
#line 751 "traversable.c"
			}
		} else {
#line 150 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_data8_->need_next = TRUE;
#line 756 "traversable.c"
		}
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp12_ = _data7_->f;
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp12__target = _data7_->f_target;
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp13_ = gee_lazy_new (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), ____lambda7__gee_lazy_func, block9_data_ref (_data9_), block9_data_unref);
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp15_ = _tmp12_ (GEE_TRAVERSABLE_STREAM_CONTINUE, _tmp13_, &_tmp14_, _tmp12__target);
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_gee_lazy_unref0 (val);
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		val = _tmp14_;
#line 152 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data8_->str = _tmp15_;
#line 772 "traversable.c"
	}
#line 154 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp16_ = _data8_->str;
#line 154 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	switch (_tmp16_) {
#line 154 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_YIELD:
#line 780 "traversable.c"
		{
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = val;
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			block9_data_unref (_data9_);
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_data9_ = NULL;
#line 156 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 790 "traversable.c"
		}
#line 154 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_END:
#line 794 "traversable.c"
		{
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = NULL;
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (val);
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			block9_data_unref (_data9_);
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_data9_ = NULL;
#line 158 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 806 "traversable.c"
		}
		default:
		{
#line 160 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			g_assert_not_reached ();
#line 812 "traversable.c"
		}
	}
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_gee_lazy_unref0 (val);
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	block9_data_unref (_data9_);
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data9_ = NULL;
#line 821 "traversable.c"
}


static GeeLazy* ____lambda6__gee_unfold_func (gpointer self) {
	GeeLazy* result;
	result = ___lambda6_ (self);
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 830 "traversable.c"
}


static gpointer _gee_lazy_ref0 (gpointer self) {
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return self ? gee_lazy_ref (self) : NULL;
#line 837 "traversable.c"
}


static GeeIterator* gee_traversable_real_stream (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify) {
	GeeIterator* result = NULL;
	Block7Data* _data7_;
	GeeStreamFunc _tmp0_;
	void* _tmp0__target;
	GeeIterable* iself = NULL;
	GeeIterator* _tmp1_;
	GeeIterator* _tmp2_;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data7_ = g_slice_new0 (Block7Data);
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data7_->_ref_count_ = 1;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data7_->self = g_object_ref (self);
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data7_->a_type = a_type;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data7_->a_dup_func = a_dup_func;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data7_->a_destroy_func = a_destroy_func;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = f;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0__target = f_target;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	(_data7_->f_target_destroy_notify == NULL) ? NULL : (_data7_->f_target_destroy_notify (_data7_->f_target), NULL);
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data7_->f = NULL;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data7_->f_target = NULL;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data7_->f_target_destroy_notify = NULL;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data7_->f = _tmp0_;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data7_->f_target = _tmp0__target;
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data7_->f_target_destroy_notify = f_target_destroy_notify;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (self, GEE_TYPE_ITERATOR) ? ((GeeIterator*) self) : NULL);
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_g_object_unref0 (_data7_->_self_);
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data7_->_self_ = _tmp1_;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp2_ = _data7_->_self_;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (_tmp2_ != NULL) {
#line 889 "traversable.c"
		Block8Data* _data8_;
		GeeLazy* initial;
		GeeStreamFunc _tmp3_;
		void* _tmp3__target;
		GeeLazy* _tmp4_ = NULL;
		GeeTraversableStream _tmp5_ = 0;
		GeeTraversableStream _tmp6_;
		GeeLazy* _tmp20_;
		GeeLazy* _tmp21_;
		GeeIterator* _tmp22_ = NULL;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data8_ = g_slice_new0 (Block8Data);
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data8_->_ref_count_ = 1;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data8_->_data7_ = block7_data_ref (_data7_);
#line 111 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		initial = NULL;
#line 112 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data8_->need_next = TRUE;
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp3_ = _data7_->f;
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp3__target = _data7_->f_target;
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp5_ = _tmp3_ (GEE_TRAVERSABLE_STREAM_YIELD, NULL, &_tmp4_, _tmp3__target);
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_gee_lazy_unref0 (initial);
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		initial = _tmp4_;
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data8_->str = _tmp5_;
#line 114 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp6_ = _data8_->str;
#line 114 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		switch (_tmp6_) {
#line 114 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			case GEE_TRAVERSABLE_STREAM_CONTINUE:
#line 928 "traversable.c"
			{
				GeeIterator* _tmp7_;
				gboolean _tmp8_;
				gboolean _tmp9_;
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp7_ = _data7_->_self_;
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp8_ = gee_iterator_get_valid (_tmp7_);
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp9_ = _tmp8_;
#line 116 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (_tmp9_) {
#line 941 "traversable.c"
					GeeStreamFunc _tmp10_;
					void* _tmp10__target;
					GeeLazy* _tmp11_;
					GeeLazy* _tmp12_ = NULL;
					GeeTraversableStream _tmp13_ = 0;
					GeeTraversableStream _tmp14_;
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_tmp10_ = _data7_->f;
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_tmp10__target = _data7_->f_target;
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_tmp11_ = gee_lazy_new (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), ______lambda3__gee_lazy_func, block8_data_ref (_data8_), block8_data_unref);
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_tmp13_ = _tmp10_ (GEE_TRAVERSABLE_STREAM_CONTINUE, _tmp11_, &_tmp12_, _tmp10__target);
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (initial);
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					initial = _tmp12_;
#line 117 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_data8_->str = _tmp13_;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_tmp14_ = _data8_->str;
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					switch (_tmp14_) {
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						case GEE_TRAVERSABLE_STREAM_YIELD:
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						case GEE_TRAVERSABLE_STREAM_CONTINUE:
#line 970 "traversable.c"
						{
#line 121 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							break;
#line 974 "traversable.c"
						}
#line 118 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						case GEE_TRAVERSABLE_STREAM_END:
#line 978 "traversable.c"
						{
							GeeIterator* _tmp15_ = NULL;
#line 123 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_tmp15_ = gee_iterator_unfold (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, _______lambda4__gee_unfold_func, block8_data_ref (_data8_), block8_data_unref, NULL);
#line 123 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							result = _tmp15_;
#line 123 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_gee_lazy_unref0 (initial);
#line 123 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							block8_data_unref (_data8_);
#line 123 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_data8_ = NULL;
#line 123 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_g_object_unref0 (iself);
#line 123 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							block7_data_unref (_data7_);
#line 123 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_data7_ = NULL;
#line 123 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							return result;
#line 999 "traversable.c"
						}
						default:
						{
#line 125 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							g_assert_not_reached ();
#line 1005 "traversable.c"
						}
					}
				}
#line 128 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				break;
#line 1011 "traversable.c"
			}
#line 114 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			case GEE_TRAVERSABLE_STREAM_YIELD:
#line 1015 "traversable.c"
			{
				GeeIterator* _tmp16_;
				gboolean _tmp17_;
				gboolean _tmp18_;
#line 130 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp16_ = _data7_->_self_;
#line 130 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp17_ = gee_iterator_get_valid (_tmp16_);
#line 130 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp18_ = _tmp17_;
#line 130 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (_tmp18_) {
#line 131 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_data8_->need_next = FALSE;
#line 1030 "traversable.c"
				}
#line 132 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				break;
#line 1034 "traversable.c"
			}
#line 114 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			case GEE_TRAVERSABLE_STREAM_END:
#line 1038 "traversable.c"
			{
				GeeIterator* _tmp19_ = NULL;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp19_ = gee_iterator_unfold (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, _____lambda5__gee_unfold_func, block8_data_ref (_data8_), block8_data_unref, NULL);
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = _tmp19_;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (initial);
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				block8_data_unref (_data8_);
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_data8_ = NULL;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_g_object_unref0 (iself);
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				block7_data_unref (_data7_);
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_data7_ = NULL;
#line 134 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 1059 "traversable.c"
			}
			default:
			{
#line 136 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				g_assert_not_reached ();
#line 1065 "traversable.c"
			}
		}
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp20_ = initial;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp21_ = _gee_lazy_ref0 (_tmp20_);
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp22_ = gee_iterator_unfold (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ____lambda6__gee_unfold_func, block8_data_ref (_data8_), block8_data_unref, _tmp21_);
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		result = _tmp22_;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_gee_lazy_unref0 (initial);
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		block8_data_unref (_data8_);
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data8_ = NULL;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_g_object_unref0 (iself);
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		block7_data_unref (_data7_);
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data7_ = NULL;
#line 138 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		return result;
#line 1090 "traversable.c"
	} else {
		GeeIterable* _tmp23_;
		GeeIterable* _tmp24_;
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp23_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (self, GEE_TYPE_ITERABLE) ? ((GeeIterable*) self) : NULL);
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_g_object_unref0 (iself);
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		iself = _tmp23_;
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_tmp24_ = iself;
#line 163 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		if (_tmp24_ != NULL) {
#line 1104 "traversable.c"
			GeeIterable* _tmp25_;
			GeeIterator* _tmp26_ = NULL;
			GeeIterator* _tmp27_;
			GeeStreamFunc _tmp28_;
			void* _tmp28__target;
			GDestroyNotify _tmp28__target_destroy_notify;
			GeeIterator* _tmp29_ = NULL;
			GeeIterator* _tmp30_;
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp25_ = iself;
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp26_ = gee_iterable_iterator (_tmp25_);
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp27_ = _tmp26_;
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp28_ = _data7_->f;
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp28__target = _data7_->f_target;
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp28__target_destroy_notify = _data7_->f_target_destroy_notify;
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_data7_->f_target_destroy_notify = NULL;
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp29_ = gee_traversable_stream ((GeeTraversable*) _tmp27_, a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, _tmp28_, _tmp28__target, _tmp28__target_destroy_notify);
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp30_ = _tmp29_;
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_g_object_unref0 (_tmp27_);
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = _tmp30_;
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_g_object_unref0 (iself);
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			block7_data_unref (_data7_);
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_data7_ = NULL;
#line 164 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 1143 "traversable.c"
		} else {
#line 166 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			g_assert_not_reached ();
#line 1147 "traversable.c"
		}
	}
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_g_object_unref0 (iself);
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	block7_data_unref (_data7_);
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data7_ = NULL;
#line 1156 "traversable.c"
}


GeeIterator* gee_traversable_stream (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify) {
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 105 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->stream (self, a_type, a_dup_func, a_destroy_func, f, f_target, f_target_destroy_notify);
#line 1165 "traversable.c"
}


/**
 * Standard aggregation function.
 *
 * It takes a function, seed and first element, returns the new seed and
 * progress to next element when the operation repeats.
 *
 * Note: Default implementation uses {@link foreach}.
 *
 * Note: In {@link Iterator} implementation operation moves the
 *    iterator to last element in iteration. If iterator is
 *    {@link Iterator.valid} the current element will be considered
 *    as well.
 *
 */
static Block10Data* block10_data_ref (Block10Data* _data10_) {
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_atomic_int_inc (&_data10_->_ref_count_);
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return _data10_;
#line 1188 "traversable.c"
}


static void block10_data_unref (void * _userdata_) {
	Block10Data* _data10_;
	_data10_ = (Block10Data*) _userdata_;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
#line 1197 "traversable.c"
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		self = _data10_->self;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_type = _data10_->a_type;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_dup_func = _data10_->a_dup_func;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_destroy_func = _data10_->a_destroy_func;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_a_destroy_func0 (_data10_->seed);
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_g_object_unref0 (self);
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		g_slice_free (Block10Data, _data10_);
#line 1216 "traversable.c"
	}
}


static gboolean __lambda8_ (Block10Data* _data10_, gpointer item) {
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gboolean result = FALSE;
	GeeFoldFunc _tmp0_;
	void* _tmp0__target;
	gpointer _tmp1_;
	gpointer _tmp2_;
	gpointer _tmp3_ = NULL;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data10_->self;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_type = _data10_->a_type;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_dup_func = _data10_->a_dup_func;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_destroy_func = _data10_->a_destroy_func;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = _data10_->f;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0__target = _data10_->f_target;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = item;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	item = NULL;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp2_ = _data10_->seed;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data10_->seed = NULL;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp3_ = _tmp0_ (_tmp1_, _tmp2_, _tmp0__target);
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_a_destroy_func0 (_data10_->seed);
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data10_->seed = _tmp3_;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = TRUE;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	((item == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 1264 "traversable.c"
}


static gboolean ___lambda8__gee_forall_func (gpointer g, gpointer self) {
	gboolean result;
	result = __lambda8_ (self, g);
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 1273 "traversable.c"
}


static gpointer gee_traversable_real_fold (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed) {
	gpointer result = NULL;
	Block10Data* _data10_;
	GeeFoldFunc _tmp0_;
	void* _tmp0__target;
	gconstpointer _tmp1_;
	gpointer _tmp2_;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data10_ = g_slice_new0 (Block10Data);
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data10_->_ref_count_ = 1;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data10_->self = g_object_ref (self);
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data10_->a_type = a_type;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data10_->a_dup_func = a_dup_func;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data10_->a_destroy_func = a_destroy_func;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = f;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0__target = f_target;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data10_->f = _tmp0_;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data10_->f_target = _tmp0__target;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = seed;
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_a_destroy_func0 (_data10_->seed);
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data10_->seed = _tmp1_;
#line 186 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	gee_traversable_foreach (self, ___lambda8__gee_forall_func, _data10_);
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp2_ = _data10_->seed;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data10_->seed = NULL;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = _tmp2_;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	block10_data_unref (_data10_);
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data10_ = NULL;
#line 187 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 1324 "traversable.c"
}


gpointer gee_traversable_fold (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed) {
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 184 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->fold (self, a_type, a_dup_func, a_destroy_func, f, f_target, seed);
#line 1333 "traversable.c"
}


/**
 * Produces an iterator pointing at elements generated by function passed.
 *
 * Iterator is lazy evaluated but value is force-evaluated when
 * iterator moves to next element. ({@link Iterator.next})
 *
 * Note: Default implementation uses {@link stream}.
 *
 * Note: In {@link Iterator} implementation if the parent iterator is
 *    {@link Iterator.valid} so is the returned one. Using the parent
 *    iterator is not allowed before the inner iterator {@link Iterator.next}
 *    return false and then it points on its last element.
 *    The resulting iterator is {@link Iterator.valid} if the parent
 *    iterator is.
 *
 * @param f Mapping function
 * @return Iterator listing mapped value
 */
static Block11Data* block11_data_ref (Block11Data* _data11_) {
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_atomic_int_inc (&_data11_->_ref_count_);
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return _data11_;
#line 1360 "traversable.c"
}


static void block11_data_unref (void * _userdata_) {
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
#line 1369 "traversable.c"
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		self = _data11_->self;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_type = _data11_->a_type;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_dup_func = _data11_->a_dup_func;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_destroy_func = _data11_->a_destroy_func;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_g_object_unref0 (self);
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		g_slice_free (Block11Data, _data11_);
#line 1386 "traversable.c"
	}
}


static Block12Data* block12_data_ref (Block12Data* _data12_) {
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_atomic_int_inc (&_data12_->_ref_count_);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return _data12_;
#line 1396 "traversable.c"
}


static void block12_data_unref (void * _userdata_) {
	Block12Data* _data12_;
	_data12_ = (Block12Data*) _userdata_;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (g_atomic_int_dec_and_test (&_data12_->_ref_count_)) {
#line 1405 "traversable.c"
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		self = _data12_->_data11_->self;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_type = _data12_->_data11_->a_type;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_dup_func = _data12_->_data11_->a_dup_func;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_destroy_func = _data12_->_data11_->a_destroy_func;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_gee_lazy_unref0 (_data12_->item);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		block11_data_unref (_data12_->_data11_);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data12_->_data11_ = NULL;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		g_slice_free (Block12Data, _data12_);
#line 1426 "traversable.c"
	}
}


static gpointer ___lambda10_ (Block12Data* _data12_) {
	Block11Data* _data11_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer result = NULL;
	GeeLazy* _tmp0_;
	gpointer _tmp1_ = NULL;
	gpointer tmp;
	GeeMapFunc _tmp2_;
	void* _tmp2__target;
	gpointer _tmp3_;
	gpointer _tmp4_ = NULL;
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data11_ = _data12_->_data11_;
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data11_->self;
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_type = _data11_->a_type;
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_dup_func = _data11_->a_dup_func;
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_destroy_func = _data11_->a_destroy_func;
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = _data12_->item;
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = gee_lazy_get (_tmp0_);
#line 216 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	tmp = _tmp1_;
#line 217 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_gee_lazy_unref0 (_data12_->item);
#line 217 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data12_->item = NULL;
#line 218 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp2_ = _data11_->f;
#line 218 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp2__target = _data11_->f_target;
#line 218 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp3_ = tmp;
#line 218 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	tmp = NULL;
#line 218 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp4_ = _tmp2_ (_tmp3_, _tmp2__target);
#line 218 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = _tmp4_;
#line 218 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_a_destroy_func0 (tmp);
#line 218 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 1481 "traversable.c"
}


static gpointer ____lambda10__gee_lazy_func (gpointer self) {
	gpointer result;
	result = ___lambda10_ (self);
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 1490 "traversable.c"
}


static GeeTraversableStream __lambda9_ (Block11Data* _data11_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val) {
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeLazy* _vala_val = NULL;
	GeeTraversableStream result = 0;
	Block12Data* _data12_;
	GeeLazy* _tmp0_;
	GeeTraversableStream _tmp1_;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data11_->self;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_type = _data11_->a_type;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_dup_func = _data11_->a_dup_func;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_destroy_func = _data11_->a_destroy_func;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data12_ = g_slice_new0 (Block12Data);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data12_->_ref_count_ = 1;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data12_->_data11_ = block11_data_ref (_data11_);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = item;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_gee_lazy_unref0 (_data12_->item);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data12_->item = _tmp0_;
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = state;
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	switch (_tmp1_) {
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_YIELD:
#line 1530 "traversable.c"
		{
#line 212 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (_vala_val);
#line 212 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_vala_val = NULL;
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = GEE_TRAVERSABLE_STREAM_CONTINUE;
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			block12_data_unref (_data12_);
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_data12_ = NULL;
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (val) {
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				*val = _vala_val;
#line 1546 "traversable.c"
			} else {
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 1550 "traversable.c"
			}
#line 213 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 1554 "traversable.c"
		}
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
#line 1558 "traversable.c"
		{
			GeeLazy* _tmp2_;
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp2_ = gee_lazy_new (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ____lambda10__gee_lazy_func, block12_data_ref (_data12_), block12_data_unref);
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (_vala_val);
#line 215 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_vala_val = _tmp2_;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = GEE_TRAVERSABLE_STREAM_YIELD;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			block12_data_unref (_data12_);
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_data12_ = NULL;
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (val) {
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				*val = _vala_val;
#line 1577 "traversable.c"
			} else {
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 1581 "traversable.c"
			}
#line 220 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 1585 "traversable.c"
		}
#line 210 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_END:
#line 1589 "traversable.c"
		{
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (_vala_val);
#line 222 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_vala_val = NULL;
#line 223 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = GEE_TRAVERSABLE_STREAM_END;
#line 223 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			block12_data_unref (_data12_);
#line 223 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_data12_ = NULL;
#line 223 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (val) {
#line 223 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				*val = _vala_val;
#line 1605 "traversable.c"
			} else {
#line 223 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 1609 "traversable.c"
			}
#line 223 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 1613 "traversable.c"
		}
		default:
		{
#line 225 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			g_assert_not_reached ();
#line 1619 "traversable.c"
		}
	}
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (val) {
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		*val = _vala_val;
#line 1626 "traversable.c"
	} else {
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_gee_lazy_unref0 (_vala_val);
#line 1630 "traversable.c"
	}
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	block12_data_unref (_data12_);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data12_ = NULL;
#line 1636 "traversable.c"
}


static GeeTraversableStream ___lambda9__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self) {
	GeeTraversableStream result;
	result = __lambda9_ (self, state, g, lazy);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 1645 "traversable.c"
}


static GeeIterator* gee_traversable_real_map (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target) {
	GeeIterator* result = NULL;
	Block11Data* _data11_;
	GeeMapFunc _tmp0_;
	void* _tmp0__target;
	GeeIterator* _tmp1_ = NULL;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data11_ = g_slice_new0 (Block11Data);
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data11_->_ref_count_ = 1;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data11_->self = g_object_ref (self);
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data11_->a_type = a_type;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data11_->a_dup_func = a_dup_func;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data11_->a_destroy_func = a_destroy_func;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = f;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0__target = f_target;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data11_->f = _tmp0_;
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data11_->f_target = _tmp0__target;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = gee_traversable_stream (self, a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ___lambda9__gee_stream_func, block11_data_ref (_data11_), block11_data_unref);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = _tmp1_;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	block11_data_unref (_data11_);
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data11_ = NULL;
#line 209 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 1685 "traversable.c"
}


GeeIterator* gee_traversable_map (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target) {
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 208 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->map (self, a_type, a_dup_func, a_destroy_func, f, f_target);
#line 1694 "traversable.c"
}


/**
 * Creates a new iterator that is initially pointing to seed. Then
 * subsequent values are obtained after applying the function to previous
 * value and the subsequent items.
 *
 * The resulting iterator is always valid and it contains the seed value.
 *
 * Note: Default implementation uses {@link stream}.
 *
 * Note: When the method is called on {@link Iterator} using the parent
 *    iterator is not allowed befor the inner iterator
 *    {@link Iterator.next} return false and then it points on its last
 *    element. The resulting iterator is {@link Iterator.valid}.
 *
 * @param f Folding function
 * @param seed original seed value
 * @return Iterator containing values of subsequent values of seed
 */
static Block13Data* block13_data_ref (Block13Data* _data13_) {
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_atomic_int_inc (&_data13_->_ref_count_);
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return _data13_;
#line 1721 "traversable.c"
}


static void block13_data_unref (void * _userdata_) {
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
#line 1730 "traversable.c"
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		self = _data13_->self;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_type = _data13_->a_type;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_dup_func = _data13_->a_dup_func;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_destroy_func = _data13_->a_destroy_func;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_a_destroy_func0 (_data13_->seed);
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_g_object_unref0 (self);
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		g_slice_free (Block13Data, _data13_);
#line 1749 "traversable.c"
	}
}


static Block14Data* block14_data_ref (Block14Data* _data14_) {
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_atomic_int_inc (&_data14_->_ref_count_);
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return _data14_;
#line 1759 "traversable.c"
}


static void block14_data_unref (void * _userdata_) {
	Block14Data* _data14_;
	_data14_ = (Block14Data*) _userdata_;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (g_atomic_int_dec_and_test (&_data14_->_ref_count_)) {
#line 1768 "traversable.c"
		GeeTraversable * self;
		GType a_type;
		GBoxedCopyFunc a_dup_func;
		GDestroyNotify a_destroy_func;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		self = _data14_->_data13_->self;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_type = _data14_->_data13_->a_type;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_dup_func = _data14_->_data13_->a_dup_func;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		a_destroy_func = _data14_->_data13_->a_destroy_func;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_gee_lazy_unref0 (_data14_->item);
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		block13_data_unref (_data14_->_data13_);
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data14_->_data13_ = NULL;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		g_slice_free (Block14Data, _data14_);
#line 1789 "traversable.c"
	}
}


static gpointer ___lambda12_ (Block14Data* _data14_) {
	Block13Data* _data13_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer result = NULL;
	GeeLazy* _tmp0_;
	gpointer _tmp1_ = NULL;
	gpointer tmp;
	GeeFoldFunc _tmp2_;
	void* _tmp2__target;
	gpointer _tmp3_;
	gpointer _tmp4_;
	gpointer _tmp5_ = NULL;
	gconstpointer _tmp6_;
	gpointer _tmp7_;
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_ = _data14_->_data13_;
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data13_->self;
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_type = _data13_->a_type;
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_dup_func = _data13_->a_dup_func;
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_destroy_func = _data13_->a_destroy_func;
#line 263 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = _data14_->item;
#line 263 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = gee_lazy_get (_tmp0_);
#line 263 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	tmp = _tmp1_;
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_gee_lazy_unref0 (_data14_->item);
#line 264 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data14_->item = NULL;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp2_ = _data13_->f;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp2__target = _data13_->f_target;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp3_ = tmp;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	tmp = NULL;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp4_ = _data13_->seed;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->seed = NULL;
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp5_ = _tmp2_ (_tmp3_, _tmp4_, _tmp2__target);
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_a_destroy_func0 (_data13_->seed);
#line 265 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->seed = _tmp5_;
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp6_ = _data13_->seed;
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp7_ = ((_tmp6_ != NULL) && (a_dup_func != NULL)) ? a_dup_func ((gpointer) _tmp6_) : ((gpointer) _tmp6_);
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = _tmp7_;
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_a_destroy_func0 (tmp);
#line 266 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 1859 "traversable.c"
}


static gpointer ____lambda12__gee_lazy_func (gpointer self) {
	gpointer result;
	result = ___lambda12_ (self);
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 1868 "traversable.c"
}


static GeeTraversableStream __lambda11_ (Block13Data* _data13_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val) {
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeLazy* _vala_val = NULL;
	GeeTraversableStream result = 0;
	Block14Data* _data14_;
	GeeLazy* _tmp0_;
	GeeTraversableStream _tmp1_;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data13_->self;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_type = _data13_->a_type;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_dup_func = _data13_->a_dup_func;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	a_destroy_func = _data13_->a_destroy_func;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data14_ = g_slice_new0 (Block14Data);
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data14_->_ref_count_ = 1;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data14_->_data13_ = block13_data_ref (_data13_);
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = item;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_gee_lazy_unref0 (_data14_->item);
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data14_->item = _tmp0_;
#line 251 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = state;
#line 251 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	switch (_tmp1_) {
#line 251 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_YIELD:
#line 1908 "traversable.c"
		{
#line 253 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (_data13_->seed_emitted) {
#line 254 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 254 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_vala_val = NULL;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				block14_data_unref (_data14_);
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_data14_ = NULL;
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (val) {
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*val = _vala_val;
#line 1926 "traversable.c"
				} else {
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (_vala_val);
#line 1930 "traversable.c"
				}
#line 255 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 1934 "traversable.c"
			} else {
				gconstpointer _tmp2_;
				GeeLazy* _tmp3_;
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp2_ = _data13_->seed;
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp3_ = gee_lazy_new_from_value (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, _tmp2_);
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 257 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_vala_val = _tmp3_;
#line 258 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_data13_->seed_emitted = TRUE;
#line 259 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = GEE_TRAVERSABLE_STREAM_YIELD;
#line 259 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				block14_data_unref (_data14_);
#line 259 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_data14_ = NULL;
#line 259 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (val) {
#line 259 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*val = _vala_val;
#line 1958 "traversable.c"
				} else {
#line 259 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (_vala_val);
#line 1962 "traversable.c"
				}
#line 259 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 1966 "traversable.c"
			}
		}
#line 251 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
#line 1971 "traversable.c"
		{
			GeeLazy* _tmp4_;
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp4_ = gee_lazy_new (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ____lambda12__gee_lazy_func, block14_data_ref (_data14_), block14_data_unref);
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (_vala_val);
#line 262 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_vala_val = _tmp4_;
#line 268 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = GEE_TRAVERSABLE_STREAM_YIELD;
#line 268 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			block14_data_unref (_data14_);
#line 268 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_data14_ = NULL;
#line 268 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (val) {
#line 268 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				*val = _vala_val;
#line 1990 "traversable.c"
			} else {
#line 268 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 1994 "traversable.c"
			}
#line 268 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 1998 "traversable.c"
		}
#line 251 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_END:
#line 2002 "traversable.c"
		{
#line 270 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (_vala_val);
#line 270 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_vala_val = NULL;
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = GEE_TRAVERSABLE_STREAM_END;
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			block14_data_unref (_data14_);
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_data14_ = NULL;
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (val) {
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				*val = _vala_val;
#line 2018 "traversable.c"
			} else {
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 2022 "traversable.c"
			}
#line 271 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 2026 "traversable.c"
		}
		default:
		{
#line 273 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			g_assert_not_reached ();
#line 2032 "traversable.c"
		}
	}
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (val) {
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		*val = _vala_val;
#line 2039 "traversable.c"
	} else {
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_gee_lazy_unref0 (_vala_val);
#line 2043 "traversable.c"
	}
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	block14_data_unref (_data14_);
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data14_ = NULL;
#line 2049 "traversable.c"
}


static GeeTraversableStream ___lambda11__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self) {
	GeeTraversableStream result;
	result = __lambda11_ (self, state, g, lazy);
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 2058 "traversable.c"
}


static GeeIterator* gee_traversable_real_scan (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed) {
	GeeIterator* result = NULL;
	Block13Data* _data13_;
	GeeFoldFunc _tmp0_;
	void* _tmp0__target;
	gconstpointer _tmp1_;
	GeeIterator* _tmp2_ = NULL;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_ = g_slice_new0 (Block13Data);
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->_ref_count_ = 1;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->self = g_object_ref (self);
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->a_type = a_type;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->a_dup_func = a_dup_func;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->a_destroy_func = a_destroy_func;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = f;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0__target = f_target;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->f = _tmp0_;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->f_target = _tmp0__target;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = seed;
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_a_destroy_func0 (_data13_->seed);
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->seed = _tmp1_;
#line 249 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_->seed_emitted = FALSE;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp2_ = gee_traversable_stream (self, a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ___lambda11__gee_stream_func, block13_data_ref (_data13_), block13_data_unref);
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = _tmp2_;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	block13_data_unref (_data13_);
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data13_ = NULL;
#line 250 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 2107 "traversable.c"
}


GeeIterator* gee_traversable_scan (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed) {
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 248 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->scan (self, a_type, a_dup_func, a_destroy_func, f, f_target, seed);
#line 2116 "traversable.c"
}


/**
 * Creates a new iterator that contains only values that fullfills the
 * predicate.
 *
 * Note: When the method is called on {@link Iterator} using the parent
 *    iterator is not allowed befor the inner iterator
 *    {@link Iterator.next} return false and then it points on its last
 *    element. The resulting iterator is {@link Iterator.valid} if parent
 *    iterator is {@link Iterator.valid} and value it is pointing on
 *    fullfills the predicate.
 *
 * @param f Folding function
 * @return Iterator containing values of subsequent values of seed
 */
static Block15Data* block15_data_ref (Block15Data* _data15_) {
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_atomic_int_inc (&_data15_->_ref_count_);
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return _data15_;
#line 2139 "traversable.c"
}


static void block15_data_unref (void * _userdata_) {
	Block15Data* _data15_;
	_data15_ = (Block15Data*) _userdata_;
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (g_atomic_int_dec_and_test (&_data15_->_ref_count_)) {
#line 2148 "traversable.c"
		GeeTraversable * self;
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		self = _data15_->self;
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		(_data15_->pred_target_destroy_notify == NULL) ? NULL : (_data15_->pred_target_destroy_notify (_data15_->pred_target), NULL);
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data15_->pred = NULL;
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data15_->pred_target = NULL;
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_data15_->pred_target_destroy_notify = NULL;
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_g_object_unref0 (self);
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		g_slice_free (Block15Data, _data15_);
#line 2164 "traversable.c"
	}
}


static GeeTraversableStream __lambda13_ (Block15Data* _data15_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val) {
	GeeTraversable * self;
	GeeLazy* _vala_val = NULL;
	GeeTraversableStream result = 0;
	GeeTraversableStream _tmp0_;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data15_->self;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = state;
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	switch (_tmp0_) {
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_YIELD:
#line 2182 "traversable.c"
		{
#line 296 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (_vala_val);
#line 296 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_vala_val = NULL;
#line 297 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = GEE_TRAVERSABLE_STREAM_CONTINUE;
#line 297 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (item);
#line 297 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (val) {
#line 297 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				*val = _vala_val;
#line 2196 "traversable.c"
			} else {
#line 297 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 2200 "traversable.c"
			}
#line 297 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 2204 "traversable.c"
		}
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
#line 2208 "traversable.c"
		{
			GeeLazy* _tmp1_;
			gpointer _tmp2_ = NULL;
			gpointer g;
			GeePredicate _tmp3_;
			void* _tmp3__target;
			gconstpointer _tmp4_;
			gboolean _tmp5_ = FALSE;
#line 299 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp1_ = item;
#line 299 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp2_ = gee_lazy_get (_tmp1_);
#line 299 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			g = _tmp2_;
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp3_ = _data15_->pred;
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp3__target = _data15_->pred_target;
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp4_ = g;
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp5_ = _tmp3_ (_tmp4_, _tmp3__target);
#line 300 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (_tmp5_) {
#line 2233 "traversable.c"
				GeeLazy* _tmp6_;
				GeeLazy* _tmp7_;
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp6_ = item;
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp7_ = _gee_lazy_ref0 (_tmp6_);
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 301 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_vala_val = _tmp7_;
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = GEE_TRAVERSABLE_STREAM_YIELD;
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				((g == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (g = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (g), NULL));
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (item);
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (val) {
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*val = _vala_val;
#line 2254 "traversable.c"
				} else {
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (_vala_val);
#line 2258 "traversable.c"
				}
#line 302 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 2262 "traversable.c"
			} else {
#line 304 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 304 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_vala_val = NULL;
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				((g == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (g = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (g), NULL));
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (item);
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (val) {
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*val = _vala_val;
#line 2278 "traversable.c"
				} else {
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (_vala_val);
#line 2282 "traversable.c"
				}
#line 305 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 2286 "traversable.c"
			}
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			((g == NULL) || (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (g = (GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self) (g), NULL));
#line 2290 "traversable.c"
		}
#line 294 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_END:
#line 2294 "traversable.c"
		{
#line 308 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (_vala_val);
#line 308 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_vala_val = NULL;
#line 309 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = GEE_TRAVERSABLE_STREAM_END;
#line 309 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (item);
#line 309 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (val) {
#line 309 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				*val = _vala_val;
#line 2308 "traversable.c"
			} else {
#line 309 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 2312 "traversable.c"
			}
#line 309 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 2316 "traversable.c"
		}
		default:
		{
#line 311 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			g_assert_not_reached ();
#line 2322 "traversable.c"
		}
	}
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_gee_lazy_unref0 (item);
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (val) {
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		*val = _vala_val;
#line 2331 "traversable.c"
	} else {
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_gee_lazy_unref0 (_vala_val);
#line 2335 "traversable.c"
	}
}


static GeeTraversableStream ___lambda13__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self) {
	GeeTraversableStream result;
	result = __lambda13_ (self, state, g, lazy);
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 2345 "traversable.c"
}


static GeeIterator* gee_traversable_real_filter (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify) {
	GeeIterator* result = NULL;
	Block15Data* _data15_;
	GeePredicate _tmp0_;
	void* _tmp0__target;
	GeeIterator* _tmp1_ = NULL;
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data15_ = g_slice_new0 (Block15Data);
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data15_->_ref_count_ = 1;
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data15_->self = g_object_ref (self);
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = pred;
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0__target = pred_target;
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	(_data15_->pred_target_destroy_notify == NULL) ? NULL : (_data15_->pred_target_destroy_notify (_data15_->pred_target), NULL);
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data15_->pred = NULL;
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data15_->pred_target = NULL;
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data15_->pred_target_destroy_notify = NULL;
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data15_->pred = _tmp0_;
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data15_->pred_target = _tmp0__target;
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data15_->pred_target_destroy_notify = pred_target_destroy_notify;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = gee_traversable_stream (self, GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), ___lambda13__gee_stream_func, block15_data_ref (_data15_), block15_data_unref);
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = _tmp1_;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	block15_data_unref (_data15_);
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data15_ = NULL;
#line 293 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 2389 "traversable.c"
}


GeeIterator* gee_traversable_filter (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify) {
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 292 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->filter (self, pred, pred_target, pred_target_destroy_notify);
#line 2398 "traversable.c"
}


/**
 * Creates a new iterator which contains elements from iterable. The
 * first argument states the offset i.e. number of elements the iterator
 * skips by default.
 *
 * Note: In {@link Iterator} implementation resulting iterator is
 *    {@link Iterator.valid} when parent iterator is
 *    {@link Iterator.valid} and the offset is 0. Using the parent
 *    iterator is not allowed before the inner iterator
 *    {@link Iterator.next} return false and then it points on its last
 *    element.
 *
 * @param offset the offset to first element the iterator is pointing to
 * @param length maximum number of elements iterator may return. Negative
 *        value means that the number is unbounded
 */
static Block16Data* block16_data_ref (Block16Data* _data16_) {
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_atomic_int_inc (&_data16_->_ref_count_);
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return _data16_;
#line 2423 "traversable.c"
}


static void block16_data_unref (void * _userdata_) {
	Block16Data* _data16_;
	_data16_ = (Block16Data*) _userdata_;
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (g_atomic_int_dec_and_test (&_data16_->_ref_count_)) {
#line 2432 "traversable.c"
		GeeTraversable * self;
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		self = _data16_->self;
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_g_object_unref0 (self);
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		g_slice_free (Block16Data, _data16_);
#line 2440 "traversable.c"
	}
}


static GeeTraversableStream __lambda14_ (Block16Data* _data16_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val) {
	GeeTraversable * self;
	GeeLazy* _vala_val = NULL;
	GeeTraversableStream result = 0;
	GeeTraversableStream _tmp0_;
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = _data16_->self;
#line 335 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = state;
#line 335 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	switch (_tmp0_) {
#line 335 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_YIELD:
#line 2458 "traversable.c"
		{
			gint _tmp1_;
#line 337 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (_vala_val);
#line 337 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_vala_val = NULL;
#line 338 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp1_ = _data16_->offset;
#line 338 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (_tmp1_ > 0) {
#line 339 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
#line 339 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (item);
#line 339 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (val) {
#line 339 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*val = _vala_val;
#line 2477 "traversable.c"
				} else {
#line 339 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (_vala_val);
#line 2481 "traversable.c"
				}
#line 339 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 2485 "traversable.c"
			} else {
				gint _tmp2_;
#line 340 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp2_ = _data16_->length;
#line 340 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (_tmp2_ > 0) {
#line 2492 "traversable.c"
					GeeTraversableStream _tmp3_ = 0;
					gint _tmp4_;
					GeeTraversableStream _tmp5_;
#line 341 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_tmp4_ = _data16_->length;
#line 341 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					if (_tmp4_ != 0) {
#line 341 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_tmp3_ = GEE_TRAVERSABLE_STREAM_CONTINUE;
#line 2502 "traversable.c"
					} else {
#line 341 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_tmp3_ = GEE_TRAVERSABLE_STREAM_END;
#line 2506 "traversable.c"
					}
#line 341 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_tmp5_ = _tmp3_;
#line 341 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					result = _tmp5_;
#line 341 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (item);
#line 341 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					if (val) {
#line 341 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						*val = _vala_val;
#line 2518 "traversable.c"
					} else {
#line 341 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_gee_lazy_unref0 (_vala_val);
#line 2522 "traversable.c"
					}
#line 341 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					return result;
#line 2526 "traversable.c"
				} else {
					gint _tmp6_;
#line 342 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_tmp6_ = _data16_->length;
#line 342 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					if (_tmp6_ == 0) {
#line 343 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						result = GEE_TRAVERSABLE_STREAM_END;
#line 343 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_gee_lazy_unref0 (item);
#line 343 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						if (val) {
#line 343 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							*val = _vala_val;
#line 2541 "traversable.c"
						} else {
#line 343 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_gee_lazy_unref0 (_vala_val);
#line 2545 "traversable.c"
						}
#line 343 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						return result;
#line 2549 "traversable.c"
					} else {
#line 345 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						result = GEE_TRAVERSABLE_STREAM_CONTINUE;
#line 345 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						_gee_lazy_unref0 (item);
#line 345 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						if (val) {
#line 345 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							*val = _vala_val;
#line 2559 "traversable.c"
						} else {
#line 345 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
							_gee_lazy_unref0 (_vala_val);
#line 2563 "traversable.c"
						}
#line 345 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
						return result;
#line 2567 "traversable.c"
					}
				}
			}
		}
#line 335 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
#line 2574 "traversable.c"
		{
			gint _tmp7_;
#line 348 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_tmp7_ = _data16_->offset;
#line 348 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (_tmp7_ == 0) {
#line 2581 "traversable.c"
				GeeLazy* _tmp8_;
				GeeLazy* _tmp9_;
				gint _tmp10_;
#line 349 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp8_ = item;
#line 349 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp9_ = _gee_lazy_ref0 (_tmp8_);
#line 349 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 349 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_vala_val = _tmp9_;
#line 350 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp10_ = _data16_->length;
#line 350 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_data16_->length = _tmp10_ - 1;
#line 351 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = GEE_TRAVERSABLE_STREAM_YIELD;
#line 351 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (item);
#line 351 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (val) {
#line 351 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*val = _vala_val;
#line 2605 "traversable.c"
				} else {
#line 351 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (_vala_val);
#line 2609 "traversable.c"
				}
#line 351 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 2613 "traversable.c"
			} else {
				gint _tmp11_;
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 353 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_vala_val = NULL;
#line 354 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_tmp11_ = _data16_->offset;
#line 354 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_data16_->offset = _tmp11_ - 1;
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (item);
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				if (val) {
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					*val = _vala_val;
#line 2632 "traversable.c"
				} else {
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
					_gee_lazy_unref0 (_vala_val);
#line 2636 "traversable.c"
				}
#line 355 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				return result;
#line 2640 "traversable.c"
			}
		}
#line 335 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		case GEE_TRAVERSABLE_STREAM_END:
#line 2645 "traversable.c"
		{
#line 358 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (_vala_val);
#line 358 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_vala_val = NULL;
#line 359 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			result = GEE_TRAVERSABLE_STREAM_END;
#line 359 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			_gee_lazy_unref0 (item);
#line 359 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			if (val) {
#line 359 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				*val = _vala_val;
#line 2659 "traversable.c"
			} else {
#line 359 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
				_gee_lazy_unref0 (_vala_val);
#line 2663 "traversable.c"
			}
#line 359 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			return result;
#line 2667 "traversable.c"
		}
		default:
		{
#line 361 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
			g_assert_not_reached ();
#line 2673 "traversable.c"
		}
	}
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_gee_lazy_unref0 (item);
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (val) {
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		*val = _vala_val;
#line 2682 "traversable.c"
	} else {
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		_gee_lazy_unref0 (_vala_val);
#line 2686 "traversable.c"
	}
}


static GeeTraversableStream ___lambda14__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self) {
	GeeTraversableStream result;
	result = __lambda14_ (self, state, g, lazy);
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 2696 "traversable.c"
}


static GeeIterator* gee_traversable_real_chop (GeeTraversable* self, gint offset, gint length) {
	GeeIterator* result = NULL;
	Block16Data* _data16_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeIterator* _tmp3_ = NULL;
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data16_ = g_slice_new0 (Block16Data);
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data16_->_ref_count_ = 1;
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data16_->self = g_object_ref (self);
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp0_ = offset;
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data16_->offset = _tmp0_;
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp1_ = length;
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data16_->length = _tmp1_;
#line 333 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp2_ = _data16_->offset;
#line 333 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_vala_assert (_tmp2_ >= 0, "offset >= 0");
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_tmp3_ = gee_traversable_stream (self, GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self), (GBoxedCopyFunc) GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_dup_func (self), GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_destroy_func (self), ___lambda14__gee_stream_func, block16_data_ref (_data16_), block16_data_unref);
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = _tmp3_;
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	block16_data_unref (_data16_);
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	_data16_ = NULL;
#line 334 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 2735 "traversable.c"
}


GeeIterator* gee_traversable_chop (GeeTraversable* self, gint offset, gint length) {
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 332 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->chop (self, offset, length);
#line 2744 "traversable.c"
}


GType gee_traversable_get_element_type (GeeTraversable* self) {
#line 370 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	g_return_val_if_fail (self != NULL, 0UL);
#line 370 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->get_element_type (self);
#line 2753 "traversable.c"
}


static GType gee_traversable_real_get_element_type (GeeTraversable* base) {
	GType result;
	GeeTraversable* self;
#line 370 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	self = base;
#line 370 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	result = GEE_TRAVERSABLE_GET_INTERFACE (self)->get_g_type (self);
#line 370 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	return result;
#line 2766 "traversable.c"
}


static void gee_traversable_base_init (GeeTraversableIface * iface) {
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	static gboolean initialized = FALSE;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
	if (!initialized) {
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		initialized = TRUE;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		iface->stream = gee_traversable_real_stream;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		iface->fold = gee_traversable_real_fold;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		iface->map = gee_traversable_real_map;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		iface->scan = gee_traversable_real_scan;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		iface->filter = gee_traversable_real_filter;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		iface->chop = gee_traversable_real_chop;
#line 53 "/home/mpiechotka/Projects/contributions/libgee/gee/traversable.vala"
		iface->get_element_type = gee_traversable_real_get_element_type;
#line 2791 "traversable.c"
	}
}


/**
 * It's a common interface for {@link Iterator} and {@link Iterable}. It
 * provides a fast, high level functions.
 *
 * ''{@link Iterator} implementation:'' Please note that most of the functions
 * affect the state of the iterator by moving it forward.
 * Even if the iterator is {@link BidirIterator} it ''must not''
 * rewind the state.
 *
 * ''{@link Iterable} implementation:'' validy ({@link Iterator.valid})
 * of returned iterator is the same as for invalid
 * iterator. In other words the following code is semantically equivalent:
 *
 * {{{
 *     var x = iterable.function (args);
 *     var x = iterable.iterator ().function(args);
 * }}}
 *
 * @since 0.7.0
 */
GType gee_traversable_get_type (void) {
	static volatile gsize gee_traversable_type_id__volatile = 0;
	if (g_once_init_enter (&gee_traversable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTraversableIface), (GBaseInitFunc) gee_traversable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_traversable_type_id;
		gee_traversable_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeTraversable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_traversable_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gee_traversable_type_id__volatile, gee_traversable_type_id);
	}
	return gee_traversable_type_id__volatile;
}



