/* traversable.c generated by valac 0.14.0.16-dae8, the Vala compiler
 * generated from traversable.vala, do not modify */

/* traversable.vala
 *
 * Copyright (C) 2011  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;
#define _a_destroy_func0(var) NULL
typedef struct _Block5Data Block5Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block6Data Block6Data;
#define _gee_lazy_unref0(var) ((var == NULL) ? NULL : (var = (gee_lazy_unref (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;
typedef struct _Block9Data Block9Data;
typedef struct _Block10Data Block10Data;
#define _g_destroy_func0(var) NULL
typedef struct _Block11Data Block11Data;

typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, void* user_data);
typedef void (*GeeForallFunc) (gpointer g, void* user_data);
typedef GeeLazy* (*GeeUnfoldFunc) (void* user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END
} GeeTraversableStream;

typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, void* user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, void* user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, void* user_data);
struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	void (*foreach) (GeeTraversable* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate f, void* f_target, GDestroyNotify f_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
};

struct _Block5Data {
	int _ref_count_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeFoldFunc f;
	gpointer f_target;
	gpointer seed;
};

struct _Block6Data {
	int _ref_count_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeMapFunc f;
	gpointer f_target;
};

struct _Block7Data {
	int _ref_count_;
	Block6Data * _data6_;
	GeeLazy* item;
};

typedef gpointer (*GeeLazyFunc) (void* user_data);
struct _Block8Data {
	int _ref_count_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gboolean seed_emitted;
	GeeFoldFunc f;
	gpointer f_target;
	gpointer seed;
};

struct _Block9Data {
	int _ref_count_;
	Block8Data * _data8_;
	GeeLazy* item;
};

struct _Block10Data {
	int _ref_count_;
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeePredicate pred;
	gpointer pred_target;
	GDestroyNotify pred_target_destroy_notify;
};

struct _Block11Data {
	int _ref_count_;
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	gint offset;
	gint length;
};



gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_lazy (GValue* value, gpointer v_object);
void gee_value_take_lazy (GValue* value, gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
void gee_traversable_foreach (GeeTraversable* self, GeeForallFunc f, void* f_target);
GeeIterator* gee_traversable_stream (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
gpointer gee_traversable_fold (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
static gpointer gee_traversable_real_fold (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (Block5Data* _data5_);
static void __lambda10_ (Block5Data* _data5_, gpointer item);
static void ___lambda10__gee_forall_func (gpointer g, gpointer self);
GeeIterator* gee_traversable_map (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
static GeeIterator* gee_traversable_real_map (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (Block6Data* _data6_);
static GeeTraversableStream __lambda11_ (Block6Data* _data6_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (Block7Data* _data7_);
static gpointer ___lambda12_ (Block7Data* _data7_);
gpointer gee_lazy_get (GeeLazy* self);
static gpointer ____lambda12__gee_lazy_func (gpointer self);
GeeLazy* gee_lazy_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLazyFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
GeeLazy* gee_lazy_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeLazyFunc func, void* func_target, GDestroyNotify func_target_destroy_notify);
static GeeTraversableStream ___lambda11__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self);
GeeIterator* gee_traversable_scan (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
static GeeIterator* gee_traversable_real_scan (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (Block8Data* _data8_);
static GeeTraversableStream __lambda13_ (Block8Data* _data8_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val);
static Block9Data* block9_data_ref (Block9Data* _data9_);
static void block9_data_unref (Block9Data* _data9_);
GeeLazy* gee_lazy_new_from_value (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer item);
GeeLazy* gee_lazy_construct_from_value (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, gconstpointer item);
static gpointer ___lambda14_ (Block9Data* _data9_);
static gpointer ____lambda14__gee_lazy_func (gpointer self);
static GeeTraversableStream ___lambda13__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self);
GeeIterator* gee_traversable_filter (GeeTraversable* self, GeePredicate f, void* f_target, GDestroyNotify f_target_destroy_notify);
GeeIterator* gee_traversable_chop (GeeTraversable* self, gint offset, gint length);
GeeIterator* gee_traversable_filter_impl (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTraversable* input, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
static Block10Data* block10_data_ref (Block10Data* _data10_);
static void block10_data_unref (Block10Data* _data10_);
static GeeTraversableStream __lambda3_ (Block10Data* _data10_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val);
static GeeTraversableStream ___lambda3__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self);
GeeIterator* gee_traversable_chop_impl (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTraversable* input, gint offset, gint length);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (Block11Data* _data11_);
static GeeTraversableStream __lambda4_ (Block11Data* _data11_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val);
static GeeTraversableStream ___lambda4__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self);


GType gee_traversable_stream_get_type (void) {
	static volatile gsize gee_traversable_stream_type_id__volatile = 0;
	if (g_once_init_enter (&gee_traversable_stream_type_id__volatile)) {
		static const GEnumValue values[] = {{GEE_TRAVERSABLE_STREAM_YIELD, "GEE_TRAVERSABLE_STREAM_YIELD", "yield"}, {GEE_TRAVERSABLE_STREAM_CONTINUE, "GEE_TRAVERSABLE_STREAM_CONTINUE", "continue"}, {GEE_TRAVERSABLE_STREAM_END, "GEE_TRAVERSABLE_STREAM_END", "end"}, {0, NULL, NULL}};
		GType gee_traversable_stream_type_id;
		gee_traversable_stream_type_id = g_enum_register_static ("GeeTraversableStream", values);
		g_once_init_leave (&gee_traversable_stream_type_id__volatile, gee_traversable_stream_type_id);
	}
	return gee_traversable_stream_type_id__volatile;
}


/**
 * Apply function to each element returned by iterator. 
 *
 * ''{@link Iterator} implementation:'' Operation moves the iterator
 * to last element in iteration. If iterator points at some element it
 * will be included in iteration.
 */
void gee_traversable_foreach (GeeTraversable* self, GeeForallFunc f, void* f_target) {
	g_return_if_fail (self != NULL);
	GEE_TRAVERSABLE_GET_INTERFACE (self)->foreach (self, f, f_target);
}


/**
 * Stream function is an abstract function allowing writing many
 * operations.
 *
 * The stream function accepts three parameter:
 *
 *   1. state. It is usually the last returned value from function but
 *      it may be {@link Stream.END} when {@link Stream.CONTINUE} was
 *      returned and threre was no more elements.
 *   2. input. It is valid only if first argument is
 *      {@link Stream.CONTINUE}
 *   3. output. It is valid only if result is Stream.YIELD
 *
 * It may return one of 3 results:
 *
 *   1. {@link Stream.YIELD}. It means that value was yielded and can
 *      be passed to outgoint iterator.
 *   2. {@link Stream.CONTINUE}. It means that the function needs to be
 *      called with next element or with {@link Stream.END} if it is
 *      end of stream). If the state element was Stream.END during the
 *      current iteration function ''must not'' return {@link Stream.CONTINUE}
 *   3. Stream.END. It means that the last argument was yielded.
 *
 * If the function yields the value immidiatly then the returning iterator
 * is {@link valid} and points to this value as well as in case when the
 * parent iterator is {@link Iterator.valid valid} and function yields
 * after consuming 1 input. In other case returned iterator is invalid.
 *
 * ''{@link Iterator} implementation:'' If iterator is
 * {@link Iterator.valid valid} the current value should be fed
 * immidiatly to function if during initial call function returns
 * {@link Stream.CONTINUE}. The parent iterator cannot be used before
 * the functions return {@link Stream.END} afterwards it points on the
 * last element consumed.
 *
 * @param f function generating stream
 * @return iterator containing values yielded by stream
 */
GeeIterator* gee_traversable_stream (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->stream (self, a_type, a_dup_func, a_destroy_func, f, f_target, f_target_destroy_notify);
}


/**
 * Standard aggragation function.
 *
 * It takes a function, seed and first element, returns the new seed and
 * progress to next element when the operation repeats.
 *
 * ''Note:'' Default implementation uses {@link foreach}.
 *
 * ''{@link Iterator} implementation:'' Operation moves the iterator to
 * last element in iteration. If iterator is
 * {@link Iterator.valid valid} the current element will be considered
 * as well.
 *
 */
static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (Block5Data* _data5_) {
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		_g_object_unref0 (_data5_->self);
		_a_destroy_func0 (_data5_->seed);
		g_slice_free (Block5Data, _data5_);
	}
}


static void __lambda10_ (Block5Data* _data5_, gpointer item) {
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeFoldFunc _tmp0_;
	void* _tmp0__target;
	gpointer _tmp1_;
	gpointer _tmp2_;
	gpointer _tmp3_ = NULL;
	self = _data5_->self;
	a_type = _data5_->a_type;
	a_dup_func = _data5_->a_dup_func;
	a_destroy_func = _data5_->a_destroy_func;
	_tmp0_ = _data5_->f;
	_tmp0__target = _data5_->f_target;
	_tmp1_ = item;
	item = NULL;
	_tmp2_ = _data5_->seed;
	_data5_->seed = NULL;
	_tmp3_ = _tmp0_ (_tmp1_, _tmp2_, _tmp0__target);
	_a_destroy_func0 (_data5_->seed);
	_data5_->seed = _tmp3_;
	NULL;
}


static void ___lambda10__gee_forall_func (gpointer g, gpointer self) {
	__lambda10_ (self, g);
}


static gpointer gee_traversable_real_fold (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed) {
	gpointer result = NULL;
	Block5Data* _data5_;
	GeeFoldFunc _tmp0_;
	void* _tmp0__target;
	gconstpointer _tmp1_;
	gpointer _tmp2_;
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_data5_->a_type = a_type;
	_data5_->a_dup_func = a_dup_func;
	_data5_->a_destroy_func = a_destroy_func;
	_tmp0_ = f;
	_tmp0__target = f_target;
	_data5_->f = _tmp0_;
	_data5_->f_target = _tmp0__target;
	_tmp1_ = seed;
	_a_destroy_func0 (_data5_->seed);
	_data5_->seed = _tmp1_;
	gee_traversable_foreach (self, ___lambda10__gee_forall_func, _data5_);
	_tmp2_ = _data5_->seed;
	_data5_->seed = NULL;
	result = _tmp2_;
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return result;
}


gpointer gee_traversable_fold (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->fold (self, a_type, a_dup_func, a_destroy_func, f, f_target, seed);
}


/**
 * Produces an iterator pointing at elements generated by function passed.
 *
 * Iterator is lazy evaulated but value is force-evaulated when
 * iterator {@link Iterator.nextmoves to next element}.
 *
 * ''Note:'' Default implementation uses {@link stream}.
 *
 * ''{@link Iterator} implementation:'' If the parent iterator is
 * {@link Iterator.valid valid} so is the returned one. Using the parent
 * iterator is not allowed befor the inner iterator {@link Iterator.next
 * next} return false and then it points on its last element.
 *
 * @param f Mapping function
 * @return Iterator listing mapped value
 */
static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (Block6Data* _data6_) {
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_g_object_unref0 (_data6_->self);
		g_slice_free (Block6Data, _data6_);
	}
}


static Block7Data* block7_data_ref (Block7Data* _data7_) {
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}


static void block7_data_unref (Block7Data* _data7_) {
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		block6_data_unref (_data7_->_data6_);
		_data7_->_data6_ = NULL;
		_gee_lazy_unref0 (_data7_->item);
		g_slice_free (Block7Data, _data7_);
	}
}


static gpointer ___lambda12_ (Block7Data* _data7_) {
	Block6Data* _data6_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer result = NULL;
	GeeLazy* _tmp0_;
	gpointer _tmp1_ = NULL;
	gpointer tmp;
	GeeMapFunc _tmp2_;
	void* _tmp2__target;
	gpointer _tmp3_;
	gpointer _tmp4_ = NULL;
	_data6_ = _data7_->_data6_;
	self = _data6_->self;
	a_type = _data6_->a_type;
	a_dup_func = _data6_->a_dup_func;
	a_destroy_func = _data6_->a_destroy_func;
	_tmp0_ = _data7_->item;
	_tmp1_ = gee_lazy_get (_tmp0_);
	tmp = _tmp1_;
	_gee_lazy_unref0 (_data7_->item);
	_data7_->item = NULL;
	_tmp2_ = _data6_->f;
	_tmp2__target = _data6_->f_target;
	_tmp3_ = tmp;
	tmp = NULL;
	_tmp4_ = _tmp2_ (_tmp3_, _tmp2__target);
	result = _tmp4_;
	_a_destroy_func0 (tmp);
	return result;
}


static gpointer ____lambda12__gee_lazy_func (gpointer self) {
	gpointer result;
	result = ___lambda12_ (self);
	return result;
}


static GeeTraversableStream __lambda11_ (Block6Data* _data6_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val) {
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeLazy* _vala_val = NULL;
	GeeTraversableStream result = 0;
	Block7Data* _data7_;
	GeeLazy* _tmp0_;
	GeeTraversableStream _tmp1_;
	self = _data6_->self;
	a_type = _data6_->a_type;
	a_dup_func = _data6_->a_dup_func;
	a_destroy_func = _data6_->a_destroy_func;
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->_data6_ = block6_data_ref (_data6_);
	_tmp0_ = item;
	_gee_lazy_unref0 (_data7_->item);
	_data7_->item = _tmp0_;
	_tmp1_ = state;
	switch (_tmp1_) {
		case GEE_TRAVERSABLE_STREAM_YIELD:
		{
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			result = GEE_TRAVERSABLE_STREAM_CONTINUE;
			block7_data_unref (_data7_);
			_data7_ = NULL;
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
		{
			GeeLazy* _tmp2_;
			_tmp2_ = gee_lazy_new (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ____lambda12__gee_lazy_func, block7_data_ref (_data7_), block7_data_unref);
			_gee_lazy_unref0 (_vala_val);
			_vala_val = _tmp2_;
			result = GEE_TRAVERSABLE_STREAM_YIELD;
			block7_data_unref (_data7_);
			_data7_ = NULL;
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		case GEE_TRAVERSABLE_STREAM_END:
		{
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			result = GEE_TRAVERSABLE_STREAM_END;
			block7_data_unref (_data7_);
			_data7_ = NULL;
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	if (val) {
		*val = _vala_val;
	} else {
		_gee_lazy_unref0 (_vala_val);
	}
	block7_data_unref (_data7_);
	_data7_ = NULL;
}


static GeeTraversableStream ___lambda11__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self) {
	GeeTraversableStream result;
	result = __lambda11_ (self, state, g, lazy);
	return result;
}


static GeeIterator* gee_traversable_real_map (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target) {
	GeeIterator* result = NULL;
	Block6Data* _data6_;
	GeeMapFunc _tmp0_;
	void* _tmp0__target;
	GeeIterator* _tmp1_ = NULL;
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_data6_->self = g_object_ref (self);
	_data6_->a_type = a_type;
	_data6_->a_dup_func = a_dup_func;
	_data6_->a_destroy_func = a_destroy_func;
	_tmp0_ = f;
	_tmp0__target = f_target;
	_data6_->f = _tmp0_;
	_data6_->f_target = _tmp0__target;
	_tmp1_ = gee_traversable_stream (self, a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ___lambda11__gee_stream_func, block6_data_ref (_data6_), block6_data_unref);
	result = _tmp1_;
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return result;
}


GeeIterator* gee_traversable_map (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->map (self, a_type, a_dup_func, a_destroy_func, f, f_target);
}


/**
 * Creates a new iterator that is initialy pointing to seed. Then
 * subsequent values are obtained after applying the function to previous
 * value and the subsequent items.
 *
 * The resulting iterator is always valid and it contains the seed value.
 *
 * ''Note:'' Default implementation uses {@link stream}.
 *
 * ''{@link Iterator} implementation:'' Using the parent
 * iterator is not allowed befor the inner iterator {@link Iterator.next
 * next} return false and then it points on its last element.
 *
 * @param f Folding function
 * @param seed original seed value
 * @return Iterator containing values of subsequent values of seed
 */
static Block8Data* block8_data_ref (Block8Data* _data8_) {
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}


static void block8_data_unref (Block8Data* _data8_) {
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		_g_object_unref0 (_data8_->self);
		_a_destroy_func0 (_data8_->seed);
		g_slice_free (Block8Data, _data8_);
	}
}


static Block9Data* block9_data_ref (Block9Data* _data9_) {
	g_atomic_int_inc (&_data9_->_ref_count_);
	return _data9_;
}


static void block9_data_unref (Block9Data* _data9_) {
	if (g_atomic_int_dec_and_test (&_data9_->_ref_count_)) {
		block8_data_unref (_data9_->_data8_);
		_data9_->_data8_ = NULL;
		_gee_lazy_unref0 (_data9_->item);
		g_slice_free (Block9Data, _data9_);
	}
}


static gpointer ___lambda14_ (Block9Data* _data9_) {
	Block8Data* _data8_;
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	gpointer result = NULL;
	GeeLazy* _tmp0_;
	gpointer _tmp1_ = NULL;
	gpointer tmp;
	GeeFoldFunc _tmp2_;
	void* _tmp2__target;
	gpointer _tmp3_;
	gpointer _tmp4_;
	gpointer _tmp5_ = NULL;
	gconstpointer _tmp6_;
	gpointer _tmp7_;
	_data8_ = _data9_->_data8_;
	self = _data8_->self;
	a_type = _data8_->a_type;
	a_dup_func = _data8_->a_dup_func;
	a_destroy_func = _data8_->a_destroy_func;
	_tmp0_ = _data9_->item;
	_tmp1_ = gee_lazy_get (_tmp0_);
	tmp = _tmp1_;
	_gee_lazy_unref0 (_data9_->item);
	_data9_->item = NULL;
	_tmp2_ = _data8_->f;
	_tmp2__target = _data8_->f_target;
	_tmp3_ = tmp;
	tmp = NULL;
	_tmp4_ = _data8_->seed;
	_data8_->seed = NULL;
	_tmp5_ = _tmp2_ (_tmp3_, _tmp4_, _tmp2__target);
	_a_destroy_func0 (_data8_->seed);
	_data8_->seed = _tmp5_;
	_tmp6_ = _data8_->seed;
	_tmp7_ = ((_tmp6_ != NULL) && (a_dup_func != NULL)) ? a_dup_func ((gpointer) _tmp6_) : ((gpointer) _tmp6_);
	result = _tmp7_;
	_a_destroy_func0 (tmp);
	return result;
}


static gpointer ____lambda14__gee_lazy_func (gpointer self) {
	gpointer result;
	result = ___lambda14_ (self);
	return result;
}


static GeeTraversableStream __lambda13_ (Block8Data* _data8_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val) {
	GeeTraversable * self;
	GType a_type;
	GBoxedCopyFunc a_dup_func;
	GDestroyNotify a_destroy_func;
	GeeLazy* _vala_val = NULL;
	GeeTraversableStream result = 0;
	Block9Data* _data9_;
	GeeLazy* _tmp0_;
	GeeTraversableStream _tmp1_;
	self = _data8_->self;
	a_type = _data8_->a_type;
	a_dup_func = _data8_->a_dup_func;
	a_destroy_func = _data8_->a_destroy_func;
	_data9_ = g_slice_new0 (Block9Data);
	_data9_->_ref_count_ = 1;
	_data9_->_data8_ = block8_data_ref (_data8_);
	_tmp0_ = item;
	_gee_lazy_unref0 (_data9_->item);
	_data9_->item = _tmp0_;
	_tmp1_ = state;
	switch (_tmp1_) {
		case GEE_TRAVERSABLE_STREAM_YIELD:
		{
			if (_data8_->seed_emitted) {
				_gee_lazy_unref0 (_vala_val);
				_vala_val = NULL;
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
				block9_data_unref (_data9_);
				_data9_ = NULL;
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			} else {
				gconstpointer _tmp2_;
				GeeLazy* _tmp3_;
				_tmp2_ = _data8_->seed;
				_tmp3_ = gee_lazy_new_from_value (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, _tmp2_);
				_gee_lazy_unref0 (_vala_val);
				_vala_val = _tmp3_;
				_data8_->seed_emitted = TRUE;
				result = GEE_TRAVERSABLE_STREAM_YIELD;
				block9_data_unref (_data9_);
				_data9_ = NULL;
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			}
		}
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
		{
			GeeLazy* _tmp4_;
			_tmp4_ = gee_lazy_new (a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ____lambda14__gee_lazy_func, block9_data_ref (_data9_), block9_data_unref);
			_gee_lazy_unref0 (_vala_val);
			_vala_val = _tmp4_;
			result = GEE_TRAVERSABLE_STREAM_YIELD;
			block9_data_unref (_data9_);
			_data9_ = NULL;
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		case GEE_TRAVERSABLE_STREAM_END:
		{
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			result = GEE_TRAVERSABLE_STREAM_END;
			block9_data_unref (_data9_);
			_data9_ = NULL;
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	if (val) {
		*val = _vala_val;
	} else {
		_gee_lazy_unref0 (_vala_val);
	}
	block9_data_unref (_data9_);
	_data9_ = NULL;
}


static GeeTraversableStream ___lambda13__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self) {
	GeeTraversableStream result;
	result = __lambda13_ (self, state, g, lazy);
	return result;
}


static GeeIterator* gee_traversable_real_scan (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed) {
	GeeIterator* result = NULL;
	Block8Data* _data8_;
	GeeFoldFunc _tmp0_;
	void* _tmp0__target;
	gconstpointer _tmp1_;
	GeeIterator* _tmp2_ = NULL;
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_data8_->a_type = a_type;
	_data8_->a_dup_func = a_dup_func;
	_data8_->a_destroy_func = a_destroy_func;
	_tmp0_ = f;
	_tmp0__target = f_target;
	_data8_->f = _tmp0_;
	_data8_->f_target = _tmp0__target;
	_tmp1_ = seed;
	_a_destroy_func0 (_data8_->seed);
	_data8_->seed = _tmp1_;
	_data8_->seed_emitted = FALSE;
	_tmp2_ = gee_traversable_stream (self, a_type, (GBoxedCopyFunc) a_dup_func, a_destroy_func, ___lambda13__gee_stream_func, block8_data_ref (_data8_), block8_data_unref);
	result = _tmp2_;
	block8_data_unref (_data8_);
	_data8_ = NULL;
	return result;
}


GeeIterator* gee_traversable_scan (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->scan (self, a_type, a_dup_func, a_destroy_func, f, f_target, seed);
}


/**
 * Creates a new iterator that contains only values that fullfills the
 * pedicate.
 *
 * ''Note:'' There is implementation {@link filter_impl}.
 *
 * ''{@link Iterator} implementation:'' Resulting iterator is valid. Using the parent
 * iterator is not allowed befor the inner iterator {@link Iterator.next
 * next} return false and then it points on its last element.
 *
 * @param f Folding function
 * @param seed original seed value
 * @return Iterator containing values of subsequent values of seed
 */
GeeIterator* gee_traversable_filter (GeeTraversable* self, GeePredicate f, void* f_target, GDestroyNotify f_target_destroy_notify) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->filter (self, f, f_target, f_target_destroy_notify);
}


/**
 * Creates a new iterator which contains elements from iterable. The
 * first argument states the offset i.e. number of elements the iterator
 * skips by default.
 *
 * ''Note:'' There is implementation {@link chop_impl}.
 *
 * ''{@link Iterator} implementation:'' Resulting iterator is valid when
 * parent iterator is valid and the offset is 0. Using the parent
 * iterator is not allowed befor the inner iterator {@link Iterator.next
 * next} return false and then it points on its last element.
 *
 * ''{@link Iterable} implementation:'' Resurling iterator is invalid.
 *
 * @param offset the offset to first element the iterator is pointing to
 * @param length maximum number of elements iterator may return. Negative
 *        value means that the number is unbounded
 */
GeeIterator* gee_traversable_chop (GeeTraversable* self, gint offset, gint length) {
	g_return_val_if_fail (self != NULL, NULL);
	return GEE_TRAVERSABLE_GET_INTERFACE (self)->chop (self, offset, length);
}


/**
 * Implementation based on {@link stream} for {@link filter}.
 *
 * @param input The current Traversable
 * @param pred Predicate
 * @returns Filtered iterator
 * @see filter
 * @see stream
 */
static Block10Data* block10_data_ref (Block10Data* _data10_) {
	g_atomic_int_inc (&_data10_->_ref_count_);
	return _data10_;
}


static void block10_data_unref (Block10Data* _data10_) {
	if (g_atomic_int_dec_and_test (&_data10_->_ref_count_)) {
		(_data10_->pred_target_destroy_notify == NULL) ? NULL : (_data10_->pred_target_destroy_notify (_data10_->pred_target), NULL);
		_data10_->pred = NULL;
		_data10_->pred_target = NULL;
		_data10_->pred_target_destroy_notify = NULL;
		g_slice_free (Block10Data, _data10_);
	}
}


static gpointer _gee_lazy_ref0 (gpointer self) {
	return self ? gee_lazy_ref (self) : NULL;
}


static GeeTraversableStream __lambda3_ (Block10Data* _data10_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val) {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeLazy* _vala_val = NULL;
	GeeTraversableStream result = 0;
	GeeTraversableStream _tmp0_;
	g_type = _data10_->g_type;
	g_dup_func = _data10_->g_dup_func;
	g_destroy_func = _data10_->g_destroy_func;
	_tmp0_ = state;
	switch (_tmp0_) {
		case GEE_TRAVERSABLE_STREAM_YIELD:
		{
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			result = GEE_TRAVERSABLE_STREAM_CONTINUE;
			_gee_lazy_unref0 (item);
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
		{
			GeeLazy* _tmp1_;
			gpointer _tmp2_ = NULL;
			gpointer g;
			GeePredicate _tmp3_;
			void* _tmp3__target;
			gconstpointer _tmp4_;
			gboolean _tmp5_ = FALSE;
			_tmp1_ = item;
			_tmp2_ = gee_lazy_get (_tmp1_);
			g = _tmp2_;
			_tmp3_ = _data10_->pred;
			_tmp3__target = _data10_->pred_target;
			_tmp4_ = g;
			_tmp5_ = _tmp3_ (_tmp4_, _tmp3__target);
			if (_tmp5_) {
				GeeLazy* _tmp6_;
				GeeLazy* _tmp7_;
				_tmp6_ = item;
				_tmp7_ = _gee_lazy_ref0 (_tmp6_);
				_gee_lazy_unref0 (_vala_val);
				_vala_val = _tmp7_;
				result = GEE_TRAVERSABLE_STREAM_YIELD;
				_g_destroy_func0 (g);
				_gee_lazy_unref0 (item);
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			} else {
				_gee_lazy_unref0 (_vala_val);
				_vala_val = NULL;
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
				_g_destroy_func0 (g);
				_gee_lazy_unref0 (item);
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			}
			_g_destroy_func0 (g);
		}
		case GEE_TRAVERSABLE_STREAM_END:
		{
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			result = GEE_TRAVERSABLE_STREAM_END;
			_gee_lazy_unref0 (item);
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_gee_lazy_unref0 (item);
	if (val) {
		*val = _vala_val;
	} else {
		_gee_lazy_unref0 (_vala_val);
	}
}


static GeeTraversableStream ___lambda3__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self) {
	GeeTraversableStream result;
	result = __lambda3_ (self, state, g, lazy);
	return result;
}


GeeIterator* gee_traversable_filter_impl (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTraversable* input, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify) {
	GeeIterator* result = NULL;
	Block10Data* _data10_;
	GeePredicate _tmp0_;
	void* _tmp0__target;
	GeeTraversable* _tmp1_;
	GeeIterator* _tmp2_ = NULL;
	g_return_val_if_fail (input != NULL, NULL);
	_data10_ = g_slice_new0 (Block10Data);
	_data10_->_ref_count_ = 1;
	_data10_->g_type = g_type;
	_data10_->g_dup_func = g_dup_func;
	_data10_->g_destroy_func = g_destroy_func;
	_tmp0_ = pred;
	_tmp0__target = pred_target;
	(_data10_->pred_target_destroy_notify == NULL) ? NULL : (_data10_->pred_target_destroy_notify (_data10_->pred_target), NULL);
	_data10_->pred = NULL;
	_data10_->pred_target = NULL;
	_data10_->pred_target_destroy_notify = NULL;
	_data10_->pred = _tmp0_;
	_data10_->pred_target = _tmp0__target;
	_data10_->pred_target_destroy_notify = pred_target_destroy_notify;
	_tmp1_ = input;
	_tmp2_ = gee_traversable_stream (_tmp1_, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, ___lambda3__gee_stream_func, block10_data_ref (_data10_), block10_data_unref);
	result = _tmp2_;
	block10_data_unref (_data10_);
	_data10_ = NULL;
	return result;
}


/**
 * Implementation based on {@link stream} for {@link filter}.
 *
 * @param input The current Traversable
 * @param offset The offset
 * @param length The length
 */
static Block11Data* block11_data_ref (Block11Data* _data11_) {
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}


static void block11_data_unref (Block11Data* _data11_) {
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		g_slice_free (Block11Data, _data11_);
	}
}


static GeeTraversableStream __lambda4_ (Block11Data* _data11_, GeeTraversableStream state, GeeLazy* item, GeeLazy** val) {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeLazy* _vala_val = NULL;
	GeeTraversableStream result = 0;
	GeeTraversableStream _tmp0_;
	g_type = _data11_->g_type;
	g_dup_func = _data11_->g_dup_func;
	g_destroy_func = _data11_->g_destroy_func;
	_tmp0_ = state;
	switch (_tmp0_) {
		case GEE_TRAVERSABLE_STREAM_YIELD:
		{
			gint _tmp1_;
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			_tmp1_ = _data11_->offset;
			if (_tmp1_ > 0) {
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
				_gee_lazy_unref0 (item);
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			} else {
				gint _tmp2_;
				_tmp2_ = _data11_->length;
				if (_tmp2_ > 0) {
					gint _tmp3_;
					GeeTraversableStream _tmp4_ = 0;
					gint _tmp5_;
					GeeTraversableStream _tmp6_;
					_tmp3_ = _data11_->length;
					_data11_->length = _tmp3_ - 1;
					_tmp5_ = _data11_->length;
					if (_tmp5_ != 0) {
						_tmp4_ = GEE_TRAVERSABLE_STREAM_CONTINUE;
					} else {
						_tmp4_ = GEE_TRAVERSABLE_STREAM_END;
					}
					_tmp6_ = _tmp4_;
					result = _tmp6_;
					_gee_lazy_unref0 (item);
					if (val) {
						*val = _vala_val;
					} else {
						_gee_lazy_unref0 (_vala_val);
					}
					return result;
				} else {
					gint _tmp7_;
					_tmp7_ = _data11_->length;
					if (_tmp7_ == 0) {
						result = GEE_TRAVERSABLE_STREAM_END;
						_gee_lazy_unref0 (item);
						if (val) {
							*val = _vala_val;
						} else {
							_gee_lazy_unref0 (_vala_val);
						}
						return result;
					} else {
						result = GEE_TRAVERSABLE_STREAM_CONTINUE;
						_gee_lazy_unref0 (item);
						if (val) {
							*val = _vala_val;
						} else {
							_gee_lazy_unref0 (_vala_val);
						}
						return result;
					}
				}
			}
		}
		case GEE_TRAVERSABLE_STREAM_CONTINUE:
		{
			gint _tmp8_;
			_tmp8_ = _data11_->offset;
			if (_tmp8_ == 0) {
				GeeLazy* _tmp9_;
				GeeLazy* _tmp10_;
				_tmp9_ = item;
				_tmp10_ = _gee_lazy_ref0 (_tmp9_);
				_gee_lazy_unref0 (_vala_val);
				_vala_val = _tmp10_;
				result = GEE_TRAVERSABLE_STREAM_YIELD;
				_gee_lazy_unref0 (item);
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			} else {
				gint _tmp11_;
				_gee_lazy_unref0 (_vala_val);
				_vala_val = NULL;
				_tmp11_ = _data11_->offset;
				_data11_->offset = _tmp11_ - 1;
				result = GEE_TRAVERSABLE_STREAM_CONTINUE;
				_gee_lazy_unref0 (item);
				if (val) {
					*val = _vala_val;
				} else {
					_gee_lazy_unref0 (_vala_val);
				}
				return result;
			}
		}
		case GEE_TRAVERSABLE_STREAM_END:
		{
			_gee_lazy_unref0 (_vala_val);
			_vala_val = NULL;
			result = GEE_TRAVERSABLE_STREAM_END;
			_gee_lazy_unref0 (item);
			if (val) {
				*val = _vala_val;
			} else {
				_gee_lazy_unref0 (_vala_val);
			}
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	_gee_lazy_unref0 (item);
	if (val) {
		*val = _vala_val;
	} else {
		_gee_lazy_unref0 (_vala_val);
	}
}


static GeeTraversableStream ___lambda4__gee_stream_func (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, gpointer self) {
	GeeTraversableStream result;
	result = __lambda4_ (self, state, g, lazy);
	return result;
}


GeeIterator* gee_traversable_chop_impl (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTraversable* input, gint offset, gint length) {
	GeeIterator* result = NULL;
	Block11Data* _data11_;
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeTraversable* _tmp3_;
	GeeIterator* _tmp4_ = NULL;
	g_return_val_if_fail (input != NULL, NULL);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->g_type = g_type;
	_data11_->g_dup_func = g_dup_func;
	_data11_->g_destroy_func = g_destroy_func;
	_tmp0_ = offset;
	_data11_->offset = _tmp0_;
	_tmp1_ = length;
	_data11_->length = _tmp1_;
	_tmp2_ = _data11_->offset;
	g_assert (_tmp2_ >= 0);
	_tmp3_ = input;
	_tmp4_ = gee_traversable_stream (_tmp3_, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func, ___lambda4__gee_stream_func, block11_data_ref (_data11_), block11_data_unref);
	result = _tmp4_;
	block11_data_unref (_data11_);
	_data11_ = NULL;
	return result;
}


static void gee_traversable_base_init (GeeTraversableIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		iface->fold = gee_traversable_real_fold;
		iface->map = gee_traversable_real_map;
		iface->scan = gee_traversable_real_scan;
	}
}


/**
 * It's a common interface for {@link Iterator} and {@link Iterable}. It
 * provides a fast, high level functions.
 *
 * ''{@link Iterator} implementation:'' Please note that most of the functions
 * affect the state of the iterator by moving it forward.
 * Even if the iterator is {@link BidirIterator bidirectional} it ''must not''
 * rewind the state.
 *
 * ''{@link Iterable} implementation:'' {@link Iterator.valid validity}
 * of returned iterator is the same as for {@link Iterator.valid invalid}
 * iterator. In other words the following code is semantically equivalemnt:
 *
 * {{
 *     var x = iterable.function (args);
 *     var x = iterable.iterator ().function(args);
 * }}
 *
 * @since 0.7.0
 */
GType gee_traversable_get_type (void) {
	static volatile gsize gee_traversable_type_id__volatile = 0;
	if (g_once_init_enter (&gee_traversable_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTraversableIface), (GBaseInitFunc) gee_traversable_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_traversable_type_id;
		gee_traversable_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeTraversable", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_traversable_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gee_traversable_type_id__volatile, gee_traversable_type_id);
	}
	return gee_traversable_type_id__volatile;
}



