/* benchmark.c generated by valac 0.11.5, the Vala compiler
 * generated from benchmark.vala, do not modify */

/* benchmark.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee-internals.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <float.h>
#include <stdio.h>


#define GEE_BENCHMARK_TYPE_FACTORY (gee_benchmark_factory_get_type ())
#define GEE_BENCHMARK_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_FACTORY, GeeBenchmarkFactory))
#define GEE_BENCHMARK_IS_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_FACTORY))
#define GEE_BENCHMARK_FACTORY_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_BENCHMARK_TYPE_FACTORY, GeeBenchmarkFactoryIface))

typedef struct _GeeBenchmarkFactory GeeBenchmarkFactory;
typedef struct _GeeBenchmarkFactoryIface GeeBenchmarkFactoryIface;

#define GEE_BENCHMARK_TYPE_GENERATOR (gee_benchmark_generator_get_type ())
#define GEE_BENCHMARK_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_GENERATOR, GeeBenchmarkGenerator))
#define GEE_BENCHMARK_IS_GENERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_GENERATOR))
#define GEE_BENCHMARK_GENERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_BENCHMARK_TYPE_GENERATOR, GeeBenchmarkGeneratorIface))

typedef struct _GeeBenchmarkGenerator GeeBenchmarkGenerator;
typedef struct _GeeBenchmarkGeneratorIface GeeBenchmarkGeneratorIface;

#define GEE_BENCHMARK_TYPE_ALGORITHM (gee_benchmark_algorithm_get_type ())
#define GEE_BENCHMARK_ALGORITHM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_ALGORITHM, GeeBenchmarkAlgorithm))
#define GEE_BENCHMARK_IS_ALGORITHM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_ALGORITHM))
#define GEE_BENCHMARK_ALGORITHM_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_BENCHMARK_TYPE_ALGORITHM, GeeBenchmarkAlgorithmIface))

typedef struct _GeeBenchmarkAlgorithm GeeBenchmarkAlgorithm;
typedef struct _GeeBenchmarkAlgorithmIface GeeBenchmarkAlgorithmIface;

#define GEE_BENCHMARK_TYPE_RANDOM_INT32 (gee_benchmark_random_int32_get_type ())
#define GEE_BENCHMARK_RANDOM_INT32(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_RANDOM_INT32, GeeBenchmarkRandomInt32))
#define GEE_BENCHMARK_RANDOM_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_BENCHMARK_TYPE_RANDOM_INT32, GeeBenchmarkRandomInt32Class))
#define GEE_BENCHMARK_IS_RANDOM_INT32(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_RANDOM_INT32))
#define GEE_BENCHMARK_IS_RANDOM_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_BENCHMARK_TYPE_RANDOM_INT32))
#define GEE_BENCHMARK_RANDOM_INT32_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_BENCHMARK_TYPE_RANDOM_INT32, GeeBenchmarkRandomInt32Class))

typedef struct _GeeBenchmarkRandomInt32 GeeBenchmarkRandomInt32;
typedef struct _GeeBenchmarkRandomInt32Class GeeBenchmarkRandomInt32Class;
typedef struct _GeeBenchmarkRandomInt32Private GeeBenchmarkRandomInt32Private;

#define GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32 (gee_benchmark_fixed_variance_int32_get_type ())
#define GEE_BENCHMARK_FIXED_VARIANCE_INT32(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32, GeeBenchmarkFixedVarianceInt32))
#define GEE_BENCHMARK_FIXED_VARIANCE_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32, GeeBenchmarkFixedVarianceInt32Class))
#define GEE_BENCHMARK_IS_FIXED_VARIANCE_INT32(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32))
#define GEE_BENCHMARK_IS_FIXED_VARIANCE_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32))
#define GEE_BENCHMARK_FIXED_VARIANCE_INT32_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32, GeeBenchmarkFixedVarianceInt32Class))

typedef struct _GeeBenchmarkFixedVarianceInt32 GeeBenchmarkFixedVarianceInt32;
typedef struct _GeeBenchmarkFixedVarianceInt32Class GeeBenchmarkFixedVarianceInt32Class;
typedef struct _GeeBenchmarkFixedVarianceInt32Private GeeBenchmarkFixedVarianceInt32Private;

#define GEE_BENCHMARK_TYPE_MOUNTS_INT32 (gee_benchmark_mounts_int32_get_type ())
#define GEE_BENCHMARK_MOUNTS_INT32(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_MOUNTS_INT32, GeeBenchmarkMountsInt32))
#define GEE_BENCHMARK_MOUNTS_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_BENCHMARK_TYPE_MOUNTS_INT32, GeeBenchmarkMountsInt32Class))
#define GEE_BENCHMARK_IS_MOUNTS_INT32(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_MOUNTS_INT32))
#define GEE_BENCHMARK_IS_MOUNTS_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_BENCHMARK_TYPE_MOUNTS_INT32))
#define GEE_BENCHMARK_MOUNTS_INT32_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_BENCHMARK_TYPE_MOUNTS_INT32, GeeBenchmarkMountsInt32Class))

typedef struct _GeeBenchmarkMountsInt32 GeeBenchmarkMountsInt32;
typedef struct _GeeBenchmarkMountsInt32Class GeeBenchmarkMountsInt32Class;
typedef struct _GeeBenchmarkMountsInt32Private GeeBenchmarkMountsInt32Private;

#define GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32 (gee_benchmark_reverse_sorted_int32_get_type ())
#define GEE_BENCHMARK_REVERSE_SORTED_INT32(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32, GeeBenchmarkReverseSortedInt32))
#define GEE_BENCHMARK_REVERSE_SORTED_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32, GeeBenchmarkReverseSortedInt32Class))
#define GEE_BENCHMARK_IS_REVERSE_SORTED_INT32(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32))
#define GEE_BENCHMARK_IS_REVERSE_SORTED_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32))
#define GEE_BENCHMARK_REVERSE_SORTED_INT32_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32, GeeBenchmarkReverseSortedInt32Class))

typedef struct _GeeBenchmarkReverseSortedInt32 GeeBenchmarkReverseSortedInt32;
typedef struct _GeeBenchmarkReverseSortedInt32Class GeeBenchmarkReverseSortedInt32Class;
typedef struct _GeeBenchmarkReverseSortedInt32Private GeeBenchmarkReverseSortedInt32Private;

#define GEE_BENCHMARK_TYPE_SORTED_INT32 (gee_benchmark_sorted_int32_get_type ())
#define GEE_BENCHMARK_SORTED_INT32(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_SORTED_INT32, GeeBenchmarkSortedInt32))
#define GEE_BENCHMARK_SORTED_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_BENCHMARK_TYPE_SORTED_INT32, GeeBenchmarkSortedInt32Class))
#define GEE_BENCHMARK_IS_SORTED_INT32(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_SORTED_INT32))
#define GEE_BENCHMARK_IS_SORTED_INT32_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_BENCHMARK_TYPE_SORTED_INT32))
#define GEE_BENCHMARK_SORTED_INT32_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_BENCHMARK_TYPE_SORTED_INT32, GeeBenchmarkSortedInt32Class))

typedef struct _GeeBenchmarkSortedInt32 GeeBenchmarkSortedInt32;
typedef struct _GeeBenchmarkSortedInt32Class GeeBenchmarkSortedInt32Class;
typedef struct _GeeBenchmarkSortedInt32Private GeeBenchmarkSortedInt32Private;

#define GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY (gee_benchmark_array_list_factory_get_type ())
#define GEE_BENCHMARK_ARRAY_LIST_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY, GeeBenchmarkArrayListFactory))
#define GEE_BENCHMARK_ARRAY_LIST_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY, GeeBenchmarkArrayListFactoryClass))
#define GEE_BENCHMARK_IS_ARRAY_LIST_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY))
#define GEE_BENCHMARK_IS_ARRAY_LIST_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY))
#define GEE_BENCHMARK_ARRAY_LIST_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY, GeeBenchmarkArrayListFactoryClass))

typedef struct _GeeBenchmarkArrayListFactory GeeBenchmarkArrayListFactory;
typedef struct _GeeBenchmarkArrayListFactoryClass GeeBenchmarkArrayListFactoryClass;
typedef struct _GeeBenchmarkArrayListFactoryPrivate GeeBenchmarkArrayListFactoryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GEE_BENCHMARK_TYPE_BENCHMARK (gee_benchmark_benchmark_get_type ())
#define GEE_BENCHMARK_BENCHMARK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_BENCHMARK_TYPE_BENCHMARK, GeeBenchmarkBenchmark))
#define GEE_BENCHMARK_BENCHMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_BENCHMARK_TYPE_BENCHMARK, GeeBenchmarkBenchmarkClass))
#define GEE_BENCHMARK_IS_BENCHMARK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_BENCHMARK_TYPE_BENCHMARK))
#define GEE_BENCHMARK_IS_BENCHMARK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_BENCHMARK_TYPE_BENCHMARK))
#define GEE_BENCHMARK_BENCHMARK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_BENCHMARK_TYPE_BENCHMARK, GeeBenchmarkBenchmarkClass))

typedef struct _GeeBenchmarkBenchmark GeeBenchmarkBenchmark;
typedef struct _GeeBenchmarkBenchmarkClass GeeBenchmarkBenchmarkClass;
typedef struct _GeeBenchmarkBenchmarkPrivate GeeBenchmarkBenchmarkPrivate;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

struct _GeeBenchmarkFactoryIface {
	GTypeInterface parent_iface;
	GeeCollection* (*create) (GeeBenchmarkFactory* self);
	GeeCollection* (*copy) (GeeBenchmarkFactory* self, GeeCollection* collection);
};

struct _GeeBenchmarkGeneratorIface {
	GTypeInterface parent_iface;
	void (*generate_collection) (GeeBenchmarkGenerator* self, gint size, GeeCollection* collection);
	const gchar* (*get_name) (GeeBenchmarkGenerator* self);
};

struct _GeeBenchmarkAlgorithmIface {
	GTypeInterface parent_iface;
	void (*process_collection) (GeeBenchmarkAlgorithm* self, GeeCollection* collection);
	const gchar* (*get_name) (GeeBenchmarkAlgorithm* self);
};

struct _GeeBenchmarkRandomInt32 {
	GObject parent_instance;
	GeeBenchmarkRandomInt32Private * priv;
};

struct _GeeBenchmarkRandomInt32Class {
	GObjectClass parent_class;
};

struct _GeeBenchmarkFixedVarianceInt32 {
	GObject parent_instance;
	GeeBenchmarkFixedVarianceInt32Private * priv;
};

struct _GeeBenchmarkFixedVarianceInt32Class {
	GObjectClass parent_class;
};

struct _GeeBenchmarkMountsInt32 {
	GObject parent_instance;
	GeeBenchmarkMountsInt32Private * priv;
};

struct _GeeBenchmarkMountsInt32Class {
	GObjectClass parent_class;
};

struct _GeeBenchmarkReverseSortedInt32 {
	GObject parent_instance;
	GeeBenchmarkReverseSortedInt32Private * priv;
};

struct _GeeBenchmarkReverseSortedInt32Class {
	GObjectClass parent_class;
};

struct _GeeBenchmarkSortedInt32 {
	GObject parent_instance;
	GeeBenchmarkSortedInt32Private * priv;
};

struct _GeeBenchmarkSortedInt32Class {
	GObjectClass parent_class;
};

struct _GeeBenchmarkArrayListFactory {
	GObject parent_instance;
	GeeBenchmarkArrayListFactoryPrivate * priv;
};

struct _GeeBenchmarkArrayListFactoryClass {
	GObjectClass parent_class;
};

struct _GeeBenchmarkArrayListFactoryPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

struct _GeeBenchmarkBenchmark {
	GObject parent_instance;
	GeeBenchmarkBenchmarkPrivate * priv;
};

struct _GeeBenchmarkBenchmarkClass {
	GObjectClass parent_class;
};

struct _GeeBenchmarkBenchmarkPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeBenchmarkFactory* factory;
	gint* sizes;
	gint sizes_length1;
	gint _sizes_size_;
	GeeList* generators;
	GeeList* algorithms;
	gint iteration_count;
	gdouble* results_sum;
	gint results_sum_length1;
	gint results_sum_length2;
	gint results_sum_length3;
	gdouble* results_squared_sum;
	gint results_squared_sum_length1;
	gint results_squared_sum_length2;
	gint results_squared_sum_length3;
};


static gpointer gee_benchmark_random_int32_parent_class = NULL;
static GeeBenchmarkGeneratorIface* gee_benchmark_random_int32_gee_benchmark_generator_parent_iface = NULL;
static gpointer gee_benchmark_fixed_variance_int32_parent_class = NULL;
static GeeBenchmarkGeneratorIface* gee_benchmark_fixed_variance_int32_gee_benchmark_generator_parent_iface = NULL;
static gpointer gee_benchmark_mounts_int32_parent_class = NULL;
static GeeBenchmarkGeneratorIface* gee_benchmark_mounts_int32_gee_benchmark_generator_parent_iface = NULL;
static gpointer gee_benchmark_reverse_sorted_int32_parent_class = NULL;
static GeeBenchmarkGeneratorIface* gee_benchmark_reverse_sorted_int32_gee_benchmark_generator_parent_iface = NULL;
static gpointer gee_benchmark_sorted_int32_parent_class = NULL;
static GeeBenchmarkGeneratorIface* gee_benchmark_sorted_int32_gee_benchmark_generator_parent_iface = NULL;
static gpointer gee_benchmark_array_list_factory_parent_class = NULL;
static GeeBenchmarkFactoryIface* gee_benchmark_array_list_factory_gee_benchmark_factory_parent_iface = NULL;
static gpointer gee_benchmark_benchmark_parent_class = NULL;

GType gee_benchmark_factory_get_type (void) G_GNUC_CONST;
GeeCollection* gee_benchmark_factory_create (GeeBenchmarkFactory* self);
GeeCollection* gee_benchmark_factory_copy (GeeBenchmarkFactory* self, GeeCollection* collection);
GType gee_benchmark_generator_get_type (void) G_GNUC_CONST;
void gee_benchmark_generator_generate_collection (GeeBenchmarkGenerator* self, gint size, GeeCollection* collection);
const gchar* gee_benchmark_generator_get_name (GeeBenchmarkGenerator* self);
GType gee_benchmark_algorithm_get_type (void) G_GNUC_CONST;
void gee_benchmark_algorithm_process_collection (GeeBenchmarkAlgorithm* self, GeeCollection* collection);
const gchar* gee_benchmark_algorithm_get_name (GeeBenchmarkAlgorithm* self);
GType gee_benchmark_random_int32_get_type (void) G_GNUC_CONST;
enum  {
	GEE_BENCHMARK_RANDOM_INT32_DUMMY_PROPERTY,
	GEE_BENCHMARK_RANDOM_INT32_NAME
};
static void gee_benchmark_random_int32_real_generate_collection (GeeBenchmarkGenerator* base, gint size, GeeCollection* collection);
GeeBenchmarkRandomInt32* gee_benchmark_random_int32_new (void);
GeeBenchmarkRandomInt32* gee_benchmark_random_int32_construct (GType object_type);
static void _vala_gee_benchmark_random_int32_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType gee_benchmark_fixed_variance_int32_get_type (void) G_GNUC_CONST;
enum  {
	GEE_BENCHMARK_FIXED_VARIANCE_INT32_DUMMY_PROPERTY,
	GEE_BENCHMARK_FIXED_VARIANCE_INT32_NAME
};
static void gee_benchmark_fixed_variance_int32_real_generate_collection (GeeBenchmarkGenerator* base, gint size, GeeCollection* collection);
GeeBenchmarkFixedVarianceInt32* gee_benchmark_fixed_variance_int32_new (void);
GeeBenchmarkFixedVarianceInt32* gee_benchmark_fixed_variance_int32_construct (GType object_type);
static void _vala_gee_benchmark_fixed_variance_int32_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType gee_benchmark_mounts_int32_get_type (void) G_GNUC_CONST;
enum  {
	GEE_BENCHMARK_MOUNTS_INT32_DUMMY_PROPERTY,
	GEE_BENCHMARK_MOUNTS_INT32_NAME
};
static void gee_benchmark_mounts_int32_real_generate_collection (GeeBenchmarkGenerator* base, gint size, GeeCollection* collection);
GeeBenchmarkMountsInt32* gee_benchmark_mounts_int32_new (void);
GeeBenchmarkMountsInt32* gee_benchmark_mounts_int32_construct (GType object_type);
static void _vala_gee_benchmark_mounts_int32_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType gee_benchmark_reverse_sorted_int32_get_type (void) G_GNUC_CONST;
enum  {
	GEE_BENCHMARK_REVERSE_SORTED_INT32_DUMMY_PROPERTY,
	GEE_BENCHMARK_REVERSE_SORTED_INT32_NAME
};
static void gee_benchmark_reverse_sorted_int32_real_generate_collection (GeeBenchmarkGenerator* base, gint size, GeeCollection* collection);
GeeBenchmarkReverseSortedInt32* gee_benchmark_reverse_sorted_int32_new (void);
GeeBenchmarkReverseSortedInt32* gee_benchmark_reverse_sorted_int32_construct (GType object_type);
static void _vala_gee_benchmark_reverse_sorted_int32_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType gee_benchmark_sorted_int32_get_type (void) G_GNUC_CONST;
enum  {
	GEE_BENCHMARK_SORTED_INT32_DUMMY_PROPERTY,
	GEE_BENCHMARK_SORTED_INT32_NAME
};
static void gee_benchmark_sorted_int32_real_generate_collection (GeeBenchmarkGenerator* base, gint size, GeeCollection* collection);
GeeBenchmarkSortedInt32* gee_benchmark_sorted_int32_new (void);
GeeBenchmarkSortedInt32* gee_benchmark_sorted_int32_construct (GType object_type);
static void _vala_gee_benchmark_sorted_int32_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
GType gee_benchmark_array_list_factory_get_type (void) G_GNUC_CONST;
#define GEE_BENCHMARK_ARRAY_LIST_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY, GeeBenchmarkArrayListFactoryPrivate))
enum  {
	GEE_BENCHMARK_ARRAY_LIST_FACTORY_DUMMY_PROPERTY,
	GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_TYPE,
	GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_DUP_FUNC,
	GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_DESTROY_FUNC
};
static GeeCollection* gee_benchmark_array_list_factory_real_create (GeeBenchmarkFactory* base);
static GeeCollection* gee_benchmark_array_list_factory_real_copy (GeeBenchmarkFactory* base, GeeCollection* collection);
GeeBenchmarkArrayListFactory* gee_benchmark_array_list_factory_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GeeBenchmarkArrayListFactory* gee_benchmark_array_list_factory_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
static void _vala_gee_benchmark_array_list_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_benchmark_array_list_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType gee_benchmark_benchmark_get_type (void) G_GNUC_CONST;
#define GEE_BENCHMARK_BENCHMARK_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_BENCHMARK_TYPE_BENCHMARK, GeeBenchmarkBenchmarkPrivate))
enum  {
	GEE_BENCHMARK_BENCHMARK_DUMMY_PROPERTY,
	GEE_BENCHMARK_BENCHMARK_G_TYPE,
	GEE_BENCHMARK_BENCHMARK_G_DUP_FUNC,
	GEE_BENCHMARK_BENCHMARK_G_DESTROY_FUNC
};
GeeBenchmarkBenchmark* gee_benchmark_benchmark_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeBenchmarkFactory* factory, GeeList* algorithms, GeeList* generators, gint* sizes, int sizes_length1, gint iteration_count);
GeeBenchmarkBenchmark* gee_benchmark_benchmark_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeBenchmarkFactory* factory, GeeList* algorithms, GeeList* generators, gint* sizes, int sizes_length1, gint iteration_count);
static gint* _vala_array_dup1 (gint* self, int length);
void gee_benchmark_benchmark_run (GeeBenchmarkBenchmark* self);
void gee_benchmark_benchmark_display_results (GeeBenchmarkBenchmark* self, gint iteration);
static void gee_benchmark_benchmark_finalize (GObject* obj);
static void _vala_gee_benchmark_benchmark_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gee_benchmark_benchmark_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GeeCollection* gee_benchmark_factory_create (GeeBenchmarkFactory* self) {
	return GEE_BENCHMARK_FACTORY_GET_INTERFACE (self)->create (self);
}


GeeCollection* gee_benchmark_factory_copy (GeeBenchmarkFactory* self, GeeCollection* collection) {
	return GEE_BENCHMARK_FACTORY_GET_INTERFACE (self)->copy (self, collection);
}


static void gee_benchmark_factory_base_init (GeeBenchmarkFactoryIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType gee_benchmark_factory_get_type (void) {
	static volatile gsize gee_benchmark_factory_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkFactoryIface), (GBaseInitFunc) gee_benchmark_factory_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_benchmark_factory_type_id;
		gee_benchmark_factory_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeBenchmarkFactory", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_benchmark_factory_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gee_benchmark_factory_type_id__volatile, gee_benchmark_factory_type_id);
	}
	return gee_benchmark_factory_type_id__volatile;
}


void gee_benchmark_generator_generate_collection (GeeBenchmarkGenerator* self, gint size, GeeCollection* collection) {
	GEE_BENCHMARK_GENERATOR_GET_INTERFACE (self)->generate_collection (self, size, collection);
}


const gchar* gee_benchmark_generator_get_name (GeeBenchmarkGenerator* self) {
	return GEE_BENCHMARK_GENERATOR_GET_INTERFACE (self)->get_name (self);
}


static void gee_benchmark_generator_base_init (GeeBenchmarkGeneratorIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	}
}


GType gee_benchmark_generator_get_type (void) {
	static volatile gsize gee_benchmark_generator_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_generator_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkGeneratorIface), (GBaseInitFunc) gee_benchmark_generator_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_benchmark_generator_type_id;
		gee_benchmark_generator_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeBenchmarkGenerator", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_benchmark_generator_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gee_benchmark_generator_type_id__volatile, gee_benchmark_generator_type_id);
	}
	return gee_benchmark_generator_type_id__volatile;
}


void gee_benchmark_algorithm_process_collection (GeeBenchmarkAlgorithm* self, GeeCollection* collection) {
	GEE_BENCHMARK_ALGORITHM_GET_INTERFACE (self)->process_collection (self, collection);
}


const gchar* gee_benchmark_algorithm_get_name (GeeBenchmarkAlgorithm* self) {
	return GEE_BENCHMARK_ALGORITHM_GET_INTERFACE (self)->get_name (self);
}


static void gee_benchmark_algorithm_base_init (GeeBenchmarkAlgorithmIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_object_interface_install_property (iface, g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	}
}


GType gee_benchmark_algorithm_get_type (void) {
	static volatile gsize gee_benchmark_algorithm_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_algorithm_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkAlgorithmIface), (GBaseInitFunc) gee_benchmark_algorithm_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_benchmark_algorithm_type_id;
		gee_benchmark_algorithm_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeBenchmarkAlgorithm", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_benchmark_algorithm_type_id, G_TYPE_OBJECT);
		g_once_init_leave (&gee_benchmark_algorithm_type_id__volatile, gee_benchmark_algorithm_type_id);
	}
	return gee_benchmark_algorithm_type_id__volatile;
}


static void gee_benchmark_random_int32_real_generate_collection (GeeBenchmarkGenerator* base, gint size, GeeCollection* collection) {
	GeeBenchmarkRandomInt32 * self;
	self = (GeeBenchmarkRandomInt32*) base;
	g_return_if_fail (collection != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint32 _tmp1_;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < size)) {
					break;
				}
				_tmp1_ = g_random_int_range ((gint32) 0, (gint32) (size - 1));
				gee_collection_add (collection, GINT_TO_POINTER (_tmp1_));
			}
		}
	}
}


GeeBenchmarkRandomInt32* gee_benchmark_random_int32_construct (GType object_type) {
	GeeBenchmarkRandomInt32 * self = NULL;
	self = (GeeBenchmarkRandomInt32*) g_object_new (object_type, NULL);
	return self;
}


GeeBenchmarkRandomInt32* gee_benchmark_random_int32_new (void) {
	return gee_benchmark_random_int32_construct (GEE_BENCHMARK_TYPE_RANDOM_INT32);
}


static const gchar* gee_benchmark_random_int32_real_get_name (GeeBenchmarkGenerator* base) {
	const gchar* result;
	GeeBenchmarkRandomInt32* self;
	self = (GeeBenchmarkRandomInt32*) base;
	result = "FullRandom";
	return result;
}


static void gee_benchmark_random_int32_class_init (GeeBenchmarkRandomInt32Class * klass) {
	gee_benchmark_random_int32_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_benchmark_random_int32_get_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_RANDOM_INT32_NAME, "name");
}


static void gee_benchmark_random_int32_gee_benchmark_generator_interface_init (GeeBenchmarkGeneratorIface * iface) {
	gee_benchmark_random_int32_gee_benchmark_generator_parent_iface = g_type_interface_peek_parent (iface);
	iface->generate_collection = (void (*)(GeeBenchmarkGenerator* ,gint ,GeeCollection*)) gee_benchmark_random_int32_real_generate_collection;
	iface->get_name = gee_benchmark_random_int32_real_get_name;
}


static void gee_benchmark_random_int32_instance_init (GeeBenchmarkRandomInt32 * self) {
}


GType gee_benchmark_random_int32_get_type (void) {
	static volatile gsize gee_benchmark_random_int32_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_random_int32_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkRandomInt32Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_random_int32_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeBenchmarkRandomInt32), 0, (GInstanceInitFunc) gee_benchmark_random_int32_instance_init, NULL };
		static const GInterfaceInfo gee_benchmark_generator_info = { (GInterfaceInitFunc) gee_benchmark_random_int32_gee_benchmark_generator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_benchmark_random_int32_type_id;
		gee_benchmark_random_int32_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeBenchmarkRandomInt32", &g_define_type_info, 0);
		g_type_add_interface_static (gee_benchmark_random_int32_type_id, GEE_BENCHMARK_TYPE_GENERATOR, &gee_benchmark_generator_info);
		g_once_init_leave (&gee_benchmark_random_int32_type_id__volatile, gee_benchmark_random_int32_type_id);
	}
	return gee_benchmark_random_int32_type_id__volatile;
}


static void _vala_gee_benchmark_random_int32_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeBenchmarkRandomInt32 * self;
	self = GEE_BENCHMARK_RANDOM_INT32 (object);
	switch (property_id) {
		case GEE_BENCHMARK_RANDOM_INT32_NAME:
		g_value_set_string (value, gee_benchmark_generator_get_name ((GeeBenchmarkGenerator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_benchmark_fixed_variance_int32_real_generate_collection (GeeBenchmarkGenerator* base, gint size, GeeCollection* collection) {
	GeeBenchmarkFixedVarianceInt32 * self;
	gdouble _tmp0_;
	gint variance;
	self = (GeeBenchmarkFixedVarianceInt32*) base;
	g_return_if_fail (collection != NULL);
	_tmp0_ = sqrt ((gdouble) size);
	variance = (gint) _tmp0_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint32 _tmp2_;
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				if (!(i < size)) {
					break;
				}
				_tmp2_ = g_random_int_range ((gint32) 0, (gint32) variance);
				gee_collection_add (collection, GINT_TO_POINTER ((gint32) ((i + _tmp2_) - (variance / 2))));
			}
		}
	}
}


GeeBenchmarkFixedVarianceInt32* gee_benchmark_fixed_variance_int32_construct (GType object_type) {
	GeeBenchmarkFixedVarianceInt32 * self = NULL;
	self = (GeeBenchmarkFixedVarianceInt32*) g_object_new (object_type, NULL);
	return self;
}


GeeBenchmarkFixedVarianceInt32* gee_benchmark_fixed_variance_int32_new (void) {
	return gee_benchmark_fixed_variance_int32_construct (GEE_BENCHMARK_TYPE_FIXED_VARIANCE_INT32);
}


static const gchar* gee_benchmark_fixed_variance_int32_real_get_name (GeeBenchmarkGenerator* base) {
	const gchar* result;
	GeeBenchmarkFixedVarianceInt32* self;
	self = (GeeBenchmarkFixedVarianceInt32*) base;
	result = "FixedVariance";
	return result;
}


static void gee_benchmark_fixed_variance_int32_class_init (GeeBenchmarkFixedVarianceInt32Class * klass) {
	gee_benchmark_fixed_variance_int32_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_benchmark_fixed_variance_int32_get_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_FIXED_VARIANCE_INT32_NAME, "name");
}


static void gee_benchmark_fixed_variance_int32_gee_benchmark_generator_interface_init (GeeBenchmarkGeneratorIface * iface) {
	gee_benchmark_fixed_variance_int32_gee_benchmark_generator_parent_iface = g_type_interface_peek_parent (iface);
	iface->generate_collection = (void (*)(GeeBenchmarkGenerator* ,gint ,GeeCollection*)) gee_benchmark_fixed_variance_int32_real_generate_collection;
	iface->get_name = gee_benchmark_fixed_variance_int32_real_get_name;
}


static void gee_benchmark_fixed_variance_int32_instance_init (GeeBenchmarkFixedVarianceInt32 * self) {
}


GType gee_benchmark_fixed_variance_int32_get_type (void) {
	static volatile gsize gee_benchmark_fixed_variance_int32_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_fixed_variance_int32_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkFixedVarianceInt32Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_fixed_variance_int32_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeBenchmarkFixedVarianceInt32), 0, (GInstanceInitFunc) gee_benchmark_fixed_variance_int32_instance_init, NULL };
		static const GInterfaceInfo gee_benchmark_generator_info = { (GInterfaceInitFunc) gee_benchmark_fixed_variance_int32_gee_benchmark_generator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_benchmark_fixed_variance_int32_type_id;
		gee_benchmark_fixed_variance_int32_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeBenchmarkFixedVarianceInt32", &g_define_type_info, 0);
		g_type_add_interface_static (gee_benchmark_fixed_variance_int32_type_id, GEE_BENCHMARK_TYPE_GENERATOR, &gee_benchmark_generator_info);
		g_once_init_leave (&gee_benchmark_fixed_variance_int32_type_id__volatile, gee_benchmark_fixed_variance_int32_type_id);
	}
	return gee_benchmark_fixed_variance_int32_type_id__volatile;
}


static void _vala_gee_benchmark_fixed_variance_int32_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeBenchmarkFixedVarianceInt32 * self;
	self = GEE_BENCHMARK_FIXED_VARIANCE_INT32 (object);
	switch (property_id) {
		case GEE_BENCHMARK_FIXED_VARIANCE_INT32_NAME:
		g_value_set_string (value, gee_benchmark_generator_get_name ((GeeBenchmarkGenerator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_benchmark_mounts_int32_real_generate_collection (GeeBenchmarkGenerator* base, gint size, GeeCollection* collection) {
	GeeBenchmarkMountsInt32 * self;
	gint index;
	gint last;
	gdouble _tmp0_;
	gint variance;
	self = (GeeBenchmarkMountsInt32*) base;
	g_return_if_fail (collection != NULL);
	index = 0;
	last = 0;
	_tmp0_ = sqrt ((gdouble) size);
	variance = (gint) _tmp0_;
	while (TRUE) {
		gint32 _tmp1_;
		gint width;
		gint32 _tmp2_;
		gint height;
		if (!(index < size)) {
			break;
		}
		_tmp1_ = g_random_int_range ((gint32) 0, (gint32) variance);
		width = (gint) _tmp1_;
		_tmp2_ = g_random_int_range ((gint32) ((-variance) / 2), (gint32) (variance / 2));
		height = (gint) _tmp2_;
		{
			gint i;
			i = 0;
			{
				gboolean _tmp3_;
				_tmp3_ = TRUE;
				while (TRUE) {
					if (!_tmp3_) {
						i++;
					}
					_tmp3_ = FALSE;
					if (!(i < width)) {
						break;
					}
					gee_collection_add (collection, GINT_TO_POINTER ((gint32) (last + (height / width))));
				}
			}
		}
		index = index + width;
		last = last + height;
	}
}


GeeBenchmarkMountsInt32* gee_benchmark_mounts_int32_construct (GType object_type) {
	GeeBenchmarkMountsInt32 * self = NULL;
	self = (GeeBenchmarkMountsInt32*) g_object_new (object_type, NULL);
	return self;
}


GeeBenchmarkMountsInt32* gee_benchmark_mounts_int32_new (void) {
	return gee_benchmark_mounts_int32_construct (GEE_BENCHMARK_TYPE_MOUNTS_INT32);
}


static const gchar* gee_benchmark_mounts_int32_real_get_name (GeeBenchmarkGenerator* base) {
	const gchar* result;
	GeeBenchmarkMountsInt32* self;
	self = (GeeBenchmarkMountsInt32*) base;
	result = "Mounts";
	return result;
}


static void gee_benchmark_mounts_int32_class_init (GeeBenchmarkMountsInt32Class * klass) {
	gee_benchmark_mounts_int32_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_benchmark_mounts_int32_get_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_MOUNTS_INT32_NAME, "name");
}


static void gee_benchmark_mounts_int32_gee_benchmark_generator_interface_init (GeeBenchmarkGeneratorIface * iface) {
	gee_benchmark_mounts_int32_gee_benchmark_generator_parent_iface = g_type_interface_peek_parent (iface);
	iface->generate_collection = (void (*)(GeeBenchmarkGenerator* ,gint ,GeeCollection*)) gee_benchmark_mounts_int32_real_generate_collection;
	iface->get_name = gee_benchmark_mounts_int32_real_get_name;
}


static void gee_benchmark_mounts_int32_instance_init (GeeBenchmarkMountsInt32 * self) {
}


GType gee_benchmark_mounts_int32_get_type (void) {
	static volatile gsize gee_benchmark_mounts_int32_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_mounts_int32_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkMountsInt32Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_mounts_int32_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeBenchmarkMountsInt32), 0, (GInstanceInitFunc) gee_benchmark_mounts_int32_instance_init, NULL };
		static const GInterfaceInfo gee_benchmark_generator_info = { (GInterfaceInitFunc) gee_benchmark_mounts_int32_gee_benchmark_generator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_benchmark_mounts_int32_type_id;
		gee_benchmark_mounts_int32_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeBenchmarkMountsInt32", &g_define_type_info, 0);
		g_type_add_interface_static (gee_benchmark_mounts_int32_type_id, GEE_BENCHMARK_TYPE_GENERATOR, &gee_benchmark_generator_info);
		g_once_init_leave (&gee_benchmark_mounts_int32_type_id__volatile, gee_benchmark_mounts_int32_type_id);
	}
	return gee_benchmark_mounts_int32_type_id__volatile;
}


static void _vala_gee_benchmark_mounts_int32_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeBenchmarkMountsInt32 * self;
	self = GEE_BENCHMARK_MOUNTS_INT32 (object);
	switch (property_id) {
		case GEE_BENCHMARK_MOUNTS_INT32_NAME:
		g_value_set_string (value, gee_benchmark_generator_get_name ((GeeBenchmarkGenerator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_benchmark_reverse_sorted_int32_real_generate_collection (GeeBenchmarkGenerator* base, gint size, GeeCollection* collection) {
	GeeBenchmarkReverseSortedInt32 * self;
	self = (GeeBenchmarkReverseSortedInt32*) base;
	g_return_if_fail (collection != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < size)) {
					break;
				}
				gee_collection_add (collection, GINT_TO_POINTER ((gint32) ((size - i) - 1)));
			}
		}
	}
}


GeeBenchmarkReverseSortedInt32* gee_benchmark_reverse_sorted_int32_construct (GType object_type) {
	GeeBenchmarkReverseSortedInt32 * self = NULL;
	self = (GeeBenchmarkReverseSortedInt32*) g_object_new (object_type, NULL);
	return self;
}


GeeBenchmarkReverseSortedInt32* gee_benchmark_reverse_sorted_int32_new (void) {
	return gee_benchmark_reverse_sorted_int32_construct (GEE_BENCHMARK_TYPE_REVERSE_SORTED_INT32);
}


static const gchar* gee_benchmark_reverse_sorted_int32_real_get_name (GeeBenchmarkGenerator* base) {
	const gchar* result;
	GeeBenchmarkReverseSortedInt32* self;
	self = (GeeBenchmarkReverseSortedInt32*) base;
	result = "ReverseSorted";
	return result;
}


static void gee_benchmark_reverse_sorted_int32_class_init (GeeBenchmarkReverseSortedInt32Class * klass) {
	gee_benchmark_reverse_sorted_int32_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_benchmark_reverse_sorted_int32_get_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_REVERSE_SORTED_INT32_NAME, "name");
}


static void gee_benchmark_reverse_sorted_int32_gee_benchmark_generator_interface_init (GeeBenchmarkGeneratorIface * iface) {
	gee_benchmark_reverse_sorted_int32_gee_benchmark_generator_parent_iface = g_type_interface_peek_parent (iface);
	iface->generate_collection = (void (*)(GeeBenchmarkGenerator* ,gint ,GeeCollection*)) gee_benchmark_reverse_sorted_int32_real_generate_collection;
	iface->get_name = gee_benchmark_reverse_sorted_int32_real_get_name;
}


static void gee_benchmark_reverse_sorted_int32_instance_init (GeeBenchmarkReverseSortedInt32 * self) {
}


GType gee_benchmark_reverse_sorted_int32_get_type (void) {
	static volatile gsize gee_benchmark_reverse_sorted_int32_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_reverse_sorted_int32_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkReverseSortedInt32Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_reverse_sorted_int32_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeBenchmarkReverseSortedInt32), 0, (GInstanceInitFunc) gee_benchmark_reverse_sorted_int32_instance_init, NULL };
		static const GInterfaceInfo gee_benchmark_generator_info = { (GInterfaceInitFunc) gee_benchmark_reverse_sorted_int32_gee_benchmark_generator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_benchmark_reverse_sorted_int32_type_id;
		gee_benchmark_reverse_sorted_int32_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeBenchmarkReverseSortedInt32", &g_define_type_info, 0);
		g_type_add_interface_static (gee_benchmark_reverse_sorted_int32_type_id, GEE_BENCHMARK_TYPE_GENERATOR, &gee_benchmark_generator_info);
		g_once_init_leave (&gee_benchmark_reverse_sorted_int32_type_id__volatile, gee_benchmark_reverse_sorted_int32_type_id);
	}
	return gee_benchmark_reverse_sorted_int32_type_id__volatile;
}


static void _vala_gee_benchmark_reverse_sorted_int32_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeBenchmarkReverseSortedInt32 * self;
	self = GEE_BENCHMARK_REVERSE_SORTED_INT32 (object);
	switch (property_id) {
		case GEE_BENCHMARK_REVERSE_SORTED_INT32_NAME:
		g_value_set_string (value, gee_benchmark_generator_get_name ((GeeBenchmarkGenerator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_benchmark_sorted_int32_real_generate_collection (GeeBenchmarkGenerator* base, gint size, GeeCollection* collection) {
	GeeBenchmarkSortedInt32 * self;
	self = (GeeBenchmarkSortedInt32*) base;
	g_return_if_fail (collection != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < size)) {
					break;
				}
				gee_collection_add (collection, GINT_TO_POINTER ((gint32) i));
			}
		}
	}
}


GeeBenchmarkSortedInt32* gee_benchmark_sorted_int32_construct (GType object_type) {
	GeeBenchmarkSortedInt32 * self = NULL;
	self = (GeeBenchmarkSortedInt32*) g_object_new (object_type, NULL);
	return self;
}


GeeBenchmarkSortedInt32* gee_benchmark_sorted_int32_new (void) {
	return gee_benchmark_sorted_int32_construct (GEE_BENCHMARK_TYPE_SORTED_INT32);
}


static const gchar* gee_benchmark_sorted_int32_real_get_name (GeeBenchmarkGenerator* base) {
	const gchar* result;
	GeeBenchmarkSortedInt32* self;
	self = (GeeBenchmarkSortedInt32*) base;
	result = "Sorted";
	return result;
}


static void gee_benchmark_sorted_int32_class_init (GeeBenchmarkSortedInt32Class * klass) {
	gee_benchmark_sorted_int32_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_benchmark_sorted_int32_get_property;
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_SORTED_INT32_NAME, "name");
}


static void gee_benchmark_sorted_int32_gee_benchmark_generator_interface_init (GeeBenchmarkGeneratorIface * iface) {
	gee_benchmark_sorted_int32_gee_benchmark_generator_parent_iface = g_type_interface_peek_parent (iface);
	iface->generate_collection = (void (*)(GeeBenchmarkGenerator* ,gint ,GeeCollection*)) gee_benchmark_sorted_int32_real_generate_collection;
	iface->get_name = gee_benchmark_sorted_int32_real_get_name;
}


static void gee_benchmark_sorted_int32_instance_init (GeeBenchmarkSortedInt32 * self) {
}


GType gee_benchmark_sorted_int32_get_type (void) {
	static volatile gsize gee_benchmark_sorted_int32_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_sorted_int32_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkSortedInt32Class), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_sorted_int32_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeBenchmarkSortedInt32), 0, (GInstanceInitFunc) gee_benchmark_sorted_int32_instance_init, NULL };
		static const GInterfaceInfo gee_benchmark_generator_info = { (GInterfaceInitFunc) gee_benchmark_sorted_int32_gee_benchmark_generator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_benchmark_sorted_int32_type_id;
		gee_benchmark_sorted_int32_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeBenchmarkSortedInt32", &g_define_type_info, 0);
		g_type_add_interface_static (gee_benchmark_sorted_int32_type_id, GEE_BENCHMARK_TYPE_GENERATOR, &gee_benchmark_generator_info);
		g_once_init_leave (&gee_benchmark_sorted_int32_type_id__volatile, gee_benchmark_sorted_int32_type_id);
	}
	return gee_benchmark_sorted_int32_type_id__volatile;
}


static void _vala_gee_benchmark_sorted_int32_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeBenchmarkSortedInt32 * self;
	self = GEE_BENCHMARK_SORTED_INT32 (object);
	switch (property_id) {
		case GEE_BENCHMARK_SORTED_INT32_NAME:
		g_value_set_string (value, gee_benchmark_generator_get_name ((GeeBenchmarkGenerator*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static GeeCollection* gee_benchmark_array_list_factory_real_create (GeeBenchmarkFactory* base) {
	GeeBenchmarkArrayListFactory * self;
	GeeCollection* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	self = (GeeBenchmarkArrayListFactory*) base;
	_tmp0_ = gee_array_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, NULL);
	result = (GeeCollection*) _tmp0_;
	return result;
}


static GeeCollection* gee_benchmark_array_list_factory_real_copy (GeeBenchmarkFactory* base, GeeCollection* collection) {
	GeeBenchmarkArrayListFactory * self;
	GeeCollection* result = NULL;
	GeeArrayList* _tmp0_ = NULL;
	GeeArrayList* copy;
	self = (GeeBenchmarkArrayListFactory*) base;
	g_return_val_if_fail (collection != NULL, NULL);
	_tmp0_ = gee_array_list_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, NULL);
	copy = _tmp0_;
	{
		GeeIterator* _tmp1_ = NULL;
		GeeIterator* _item_it;
		_tmp1_ = gee_iterable_iterator ((GeeIterable*) collection);
		_item_it = _tmp1_;
		while (TRUE) {
			gboolean _tmp2_;
			gpointer _tmp3_ = NULL;
			gpointer item;
			_tmp2_ = gee_iterator_next (_item_it);
			if (!_tmp2_) {
				break;
			}
			_tmp3_ = gee_iterator_get (_item_it);
			item = _tmp3_;
			gee_abstract_collection_add ((GeeAbstractCollection*) copy, item);
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		}
		_g_object_unref0 (_item_it);
	}
	result = (GeeCollection*) copy;
	return result;
}


GeeBenchmarkArrayListFactory* gee_benchmark_array_list_factory_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	GeeBenchmarkArrayListFactory * self = NULL;
	self = (GeeBenchmarkArrayListFactory*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	return self;
}


GeeBenchmarkArrayListFactory* gee_benchmark_array_list_factory_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	return gee_benchmark_array_list_factory_construct (GEE_BENCHMARK_TYPE_ARRAY_LIST_FACTORY, g_type, g_dup_func, g_destroy_func);
}


static void gee_benchmark_array_list_factory_class_init (GeeBenchmarkArrayListFactoryClass * klass) {
	gee_benchmark_array_list_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeBenchmarkArrayListFactoryPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_benchmark_array_list_factory_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_benchmark_array_list_factory_set_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_benchmark_array_list_factory_gee_benchmark_factory_interface_init (GeeBenchmarkFactoryIface * iface) {
	gee_benchmark_array_list_factory_gee_benchmark_factory_parent_iface = g_type_interface_peek_parent (iface);
	iface->create = (GeeCollection* (*)(GeeBenchmarkFactory*)) gee_benchmark_array_list_factory_real_create;
	iface->copy = (GeeCollection* (*)(GeeBenchmarkFactory* ,GeeCollection*)) gee_benchmark_array_list_factory_real_copy;
}


static void gee_benchmark_array_list_factory_instance_init (GeeBenchmarkArrayListFactory * self) {
	self->priv = GEE_BENCHMARK_ARRAY_LIST_FACTORY_GET_PRIVATE (self);
}


GType gee_benchmark_array_list_factory_get_type (void) {
	static volatile gsize gee_benchmark_array_list_factory_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_array_list_factory_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkArrayListFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_array_list_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeBenchmarkArrayListFactory), 0, (GInstanceInitFunc) gee_benchmark_array_list_factory_instance_init, NULL };
		static const GInterfaceInfo gee_benchmark_factory_info = { (GInterfaceInitFunc) gee_benchmark_array_list_factory_gee_benchmark_factory_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gee_benchmark_array_list_factory_type_id;
		gee_benchmark_array_list_factory_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeBenchmarkArrayListFactory", &g_define_type_info, 0);
		g_type_add_interface_static (gee_benchmark_array_list_factory_type_id, GEE_BENCHMARK_TYPE_FACTORY, &gee_benchmark_factory_info);
		g_once_init_leave (&gee_benchmark_array_list_factory_type_id__volatile, gee_benchmark_array_list_factory_type_id);
	}
	return gee_benchmark_array_list_factory_type_id__volatile;
}


static void _vala_gee_benchmark_array_list_factory_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeBenchmarkArrayListFactory * self;
	self = GEE_BENCHMARK_ARRAY_LIST_FACTORY (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_benchmark_array_list_factory_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeBenchmarkArrayListFactory * self;
	self = GEE_BENCHMARK_ARRAY_LIST_FACTORY (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_BENCHMARK_ARRAY_LIST_FACTORY_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gint* _vala_array_dup1 (gint* self, int length) {
	return g_memdup (self, length * sizeof (gint));
}


GeeBenchmarkBenchmark* gee_benchmark_benchmark_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeBenchmarkFactory* factory, GeeList* algorithms, GeeList* generators, gint* sizes, int sizes_length1, gint iteration_count) {
	GeeBenchmarkBenchmark * self = NULL;
	GeeBenchmarkFactory* _tmp0_;
	GeeBenchmarkFactory* _tmp1_;
	GeeList* _tmp2_;
	GeeList* _tmp3_;
	gint* _tmp4_;
	gint* _tmp5_;
	gint* _tmp6_;
	GeeList* _tmp7_;
	GeeList* _tmp8_;
	g_return_val_if_fail (factory != NULL, NULL);
	g_return_val_if_fail (algorithms != NULL, NULL);
	g_return_val_if_fail (generators != NULL, NULL);
	self = (GeeBenchmarkBenchmark*) g_object_new (object_type, NULL);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	_tmp0_ = _g_object_ref0 (factory);
	_tmp1_ = _tmp0_;
	_g_object_unref0 (self->priv->factory);
	self->priv->factory = _tmp1_;
	_tmp2_ = _g_object_ref0 (algorithms);
	_tmp3_ = _tmp2_;
	_g_object_unref0 (self->priv->algorithms);
	self->priv->algorithms = _tmp3_;
	_tmp4_ = (_tmp5_ = sizes, (_tmp5_ == NULL) ? ((gpointer) _tmp5_) : _vala_array_dup1 (_tmp5_, sizes_length1));
	_tmp6_ = _tmp4_;
	self->priv->sizes = (g_free (self->priv->sizes), NULL);
	self->priv->sizes_length1 = sizes_length1;
	self->priv->_sizes_size_ = self->priv->sizes_length1;
	self->priv->sizes = _tmp6_;
	_tmp7_ = _g_object_ref0 (generators);
	_tmp8_ = _tmp7_;
	_g_object_unref0 (self->priv->generators);
	self->priv->generators = _tmp8_;
	self->priv->iteration_count = iteration_count;
	return self;
}


GeeBenchmarkBenchmark* gee_benchmark_benchmark_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeBenchmarkFactory* factory, GeeList* algorithms, GeeList* generators, gint* sizes, int sizes_length1, gint iteration_count) {
	return gee_benchmark_benchmark_construct (GEE_BENCHMARK_TYPE_BENCHMARK, g_type, g_dup_func, g_destroy_func, factory, algorithms, generators, sizes, sizes_length1, iteration_count);
}


void gee_benchmark_benchmark_run (GeeBenchmarkBenchmark* self) {
	gint _tmp0_;
	gint _tmp1_;
	gdouble* _tmp2_ = NULL;
	gdouble* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gdouble* _tmp6_ = NULL;
	gdouble* _tmp7_;
	GTimer* _tmp13_ = NULL;
	GTimer* timer;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_collection_get_size ((GeeCollection*) self->priv->generators);
	_tmp1_ = gee_collection_get_size ((GeeCollection*) self->priv->algorithms);
	_tmp2_ = g_new0 (gdouble, (self->priv->sizes_length1 * _tmp0_) * _tmp1_);
	_tmp3_ = _tmp2_;
	self->priv->results_sum = (g_free (self->priv->results_sum), NULL);
	self->priv->results_sum_length1 = self->priv->sizes_length1;
	self->priv->results_sum_length2 = _tmp0_;
	self->priv->results_sum_length3 = _tmp1_;
	self->priv->results_sum = _tmp3_;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) self->priv->generators);
	_tmp5_ = gee_collection_get_size ((GeeCollection*) self->priv->algorithms);
	_tmp6_ = g_new0 (gdouble, (self->priv->sizes_length1 * _tmp4_) * _tmp5_);
	_tmp7_ = _tmp6_;
	self->priv->results_squared_sum = (g_free (self->priv->results_squared_sum), NULL);
	self->priv->results_squared_sum_length1 = self->priv->sizes_length1;
	self->priv->results_squared_sum_length2 = _tmp4_;
	self->priv->results_squared_sum_length3 = _tmp5_;
	self->priv->results_squared_sum = _tmp7_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp8_;
			_tmp8_ = TRUE;
			while (TRUE) {
				if (!_tmp8_) {
					i++;
				}
				_tmp8_ = FALSE;
				if (!(i < self->priv->sizes_length1)) {
					break;
				}
				{
					gint j;
					j = 0;
					{
						gboolean _tmp9_;
						_tmp9_ = TRUE;
						while (TRUE) {
							gint _tmp10_;
							if (!_tmp9_) {
								j++;
							}
							_tmp9_ = FALSE;
							_tmp10_ = gee_collection_get_size ((GeeCollection*) self->priv->generators);
							if (!(j < _tmp10_)) {
								break;
							}
							{
								gint k;
								k = 0;
								{
									gboolean _tmp11_;
									_tmp11_ = TRUE;
									while (TRUE) {
										gint _tmp12_;
										if (!_tmp11_) {
											k++;
										}
										_tmp11_ = FALSE;
										_tmp12_ = gee_collection_get_size ((GeeCollection*) self->priv->algorithms);
										if (!(k < _tmp12_)) {
											break;
										}
										self->priv->results_sum[(((i * self->priv->results_sum_length2) + j) * self->priv->results_sum_length3) + k] = (gdouble) 0;
										self->priv->results_squared_sum[(((i * self->priv->results_squared_sum_length2) + j) * self->priv->results_squared_sum_length3) + k] = (gdouble) 0;
									}
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp13_ = g_timer_new ();
	timer = _tmp13_;
	{
		gint iteration;
		iteration = 1;
		{
			gboolean _tmp14_;
			_tmp14_ = TRUE;
			while (TRUE) {
				if (!_tmp14_) {
					iteration++;
				}
				_tmp14_ = FALSE;
				if (!(iteration <= self->priv->iteration_count)) {
					break;
				}
				{
					gint i;
					i = 0;
					{
						gboolean _tmp15_;
						_tmp15_ = TRUE;
						while (TRUE) {
							gint size;
							if (!_tmp15_) {
								i++;
							}
							_tmp15_ = FALSE;
							if (!(i < self->priv->sizes_length1)) {
								break;
							}
							size = self->priv->sizes[i];
							{
								gint j;
								j = 0;
								{
									gboolean _tmp16_;
									_tmp16_ = TRUE;
									while (TRUE) {
										gint _tmp17_;
										GeeCollection* _tmp18_ = NULL;
										GeeCollection* collection;
										gpointer _tmp19_ = NULL;
										GeeBenchmarkGenerator* _tmp20_;
										if (!_tmp16_) {
											j++;
										}
										_tmp16_ = FALSE;
										_tmp17_ = gee_collection_get_size ((GeeCollection*) self->priv->generators);
										if (!(j < _tmp17_)) {
											break;
										}
										_tmp18_ = gee_benchmark_factory_create (self->priv->factory);
										collection = _tmp18_;
										_tmp19_ = gee_list_get (self->priv->generators, j);
										_tmp20_ = (GeeBenchmarkGenerator*) _tmp19_;
										gee_benchmark_generator_generate_collection (_tmp20_, size, collection);
										_g_object_unref0 (_tmp20_);
										{
											gint k;
											k = 0;
											{
												gboolean _tmp21_;
												_tmp21_ = TRUE;
												while (TRUE) {
													gint _tmp22_;
													GeeCollection* _tmp23_ = NULL;
													GeeCollection* copy;
													gpointer _tmp24_ = NULL;
													GeeBenchmarkAlgorithm* _tmp25_;
													gdouble _tmp26_;
													gdouble elapsed;
													gdouble _tmp27_;
													if (!_tmp21_) {
														k++;
													}
													_tmp21_ = FALSE;
													_tmp22_ = gee_collection_get_size ((GeeCollection*) self->priv->algorithms);
													if (!(k < _tmp22_)) {
														break;
													}
													_tmp23_ = gee_benchmark_factory_copy (self->priv->factory, collection);
													copy = _tmp23_;
													g_timer_reset (timer);
													g_timer_start (timer);
													_tmp24_ = gee_list_get (self->priv->algorithms, k);
													_tmp25_ = (GeeBenchmarkAlgorithm*) _tmp24_;
													gee_benchmark_algorithm_process_collection (_tmp25_, copy);
													_g_object_unref0 (_tmp25_);
													g_timer_stop (timer);
													_tmp26_ = g_timer_elapsed (timer, NULL);
													elapsed = _tmp26_;
													self->priv->results_sum[(((i * self->priv->results_sum_length2) + j) * self->priv->results_sum_length3) + k] += elapsed;
													_tmp27_ = pow (elapsed, (gdouble) 2);
													self->priv->results_squared_sum[(((i * self->priv->results_squared_sum_length2) + j) * self->priv->results_squared_sum_length3) + k] += _tmp27_;
													_g_object_unref0 (copy);
												}
											}
										}
										_g_object_unref0 (collection);
									}
								}
							}
						}
					}
				}
				if ((iteration % 10) == 0) {
					fprintf (stdout, "|");
				} else {
					fprintf (stdout, "*");
				}
				fflush (stdout);
				if ((iteration % 100) == 0) {
					fprintf (stdout, "\n\n");
					gee_benchmark_benchmark_display_results (self, iteration);
				}
			}
		}
	}
	_g_timer_destroy0 (timer);
}


void gee_benchmark_benchmark_display_results (GeeBenchmarkBenchmark* self, gint iteration) {
	g_return_if_fail (self != NULL);
	fprintf (stdout, "After %d iterations: (average [sample standard deviation] in seconds)\n" \
"\n", iteration);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < self->priv->sizes_length1)) {
					break;
				}
				fprintf (stdout, "%d elements:\n", self->priv->sizes[i]);
				fprintf (stdout, "%20s\t", "");
				{
					gint k;
					k = 0;
					{
						gboolean _tmp1_;
						_tmp1_ = TRUE;
						while (TRUE) {
							gint _tmp2_;
							gpointer _tmp3_ = NULL;
							GeeBenchmarkAlgorithm* _tmp4_;
							const gchar* _tmp5_ = NULL;
							if (!_tmp1_) {
								k++;
							}
							_tmp1_ = FALSE;
							_tmp2_ = gee_collection_get_size ((GeeCollection*) self->priv->algorithms);
							if (!(k < _tmp2_)) {
								break;
							}
							_tmp3_ = gee_list_get (self->priv->algorithms, k);
							_tmp4_ = (GeeBenchmarkAlgorithm*) _tmp3_;
							_tmp5_ = gee_benchmark_algorithm_get_name (_tmp4_);
							fprintf (stdout, "%-20s\t", _tmp5_);
							_g_object_unref0 (_tmp4_);
						}
					}
				}
				fprintf (stdout, "\n");
				{
					gint j;
					j = 0;
					{
						gboolean _tmp6_;
						_tmp6_ = TRUE;
						while (TRUE) {
							gint _tmp7_;
							gpointer _tmp8_ = NULL;
							GeeBenchmarkGenerator* _tmp9_;
							const gchar* _tmp10_ = NULL;
							if (!_tmp6_) {
								j++;
							}
							_tmp6_ = FALSE;
							_tmp7_ = gee_collection_get_size ((GeeCollection*) self->priv->generators);
							if (!(j < _tmp7_)) {
								break;
							}
							_tmp8_ = gee_list_get (self->priv->generators, j);
							_tmp9_ = (GeeBenchmarkGenerator*) _tmp8_;
							_tmp10_ = gee_benchmark_generator_get_name (_tmp9_);
							fprintf (stdout, "%20s\t", _tmp10_);
							_g_object_unref0 (_tmp9_);
							{
								gint k;
								k = 0;
								{
									gboolean _tmp11_;
									_tmp11_ = TRUE;
									while (TRUE) {
										gint _tmp12_;
										gdouble average;
										gdouble _tmp13_;
										gdouble squared_deviation;
										gdouble _tmp14_;
										gdouble deviation;
										if (!_tmp11_) {
											k++;
										}
										_tmp11_ = FALSE;
										_tmp12_ = gee_collection_get_size ((GeeCollection*) self->priv->algorithms);
										if (!(k < _tmp12_)) {
											break;
										}
										average = self->priv->results_sum[(((i * self->priv->results_sum_length2) + j) * self->priv->results_sum_length3) + k] / iteration;
										_tmp13_ = pow (average, (gdouble) 2);
										squared_deviation = (self->priv->results_squared_sum[(((i * self->priv->results_squared_sum_length2) + j) * self->priv->results_squared_sum_length3) + k] - (((gdouble) iteration) * _tmp13_)) / (iteration - 1);
										_tmp14_ = sqrt (squared_deviation);
										deviation = _tmp14_;
										fprintf (stdout, "%8f [%8f] \t", average, deviation);
									}
								}
							}
							fprintf (stdout, "\n");
						}
					}
				}
				fprintf (stdout, "\n");
			}
		}
	}
	fprintf (stdout, "\n\n");
}


static void gee_benchmark_benchmark_class_init (GeeBenchmarkBenchmarkClass * klass) {
	gee_benchmark_benchmark_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeBenchmarkBenchmarkPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_gee_benchmark_benchmark_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gee_benchmark_benchmark_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_benchmark_benchmark_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_BENCHMARK_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_BENCHMARK_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_BENCHMARK_BENCHMARK_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_benchmark_benchmark_instance_init (GeeBenchmarkBenchmark * self) {
	self->priv = GEE_BENCHMARK_BENCHMARK_GET_PRIVATE (self);
}


static void gee_benchmark_benchmark_finalize (GObject* obj) {
	GeeBenchmarkBenchmark * self;
	self = GEE_BENCHMARK_BENCHMARK (obj);
	_g_object_unref0 (self->priv->factory);
	self->priv->sizes = (g_free (self->priv->sizes), NULL);
	_g_object_unref0 (self->priv->generators);
	_g_object_unref0 (self->priv->algorithms);
	self->priv->results_sum = (g_free (self->priv->results_sum), NULL);
	self->priv->results_squared_sum = (g_free (self->priv->results_squared_sum), NULL);
	G_OBJECT_CLASS (gee_benchmark_benchmark_parent_class)->finalize (obj);
}


GType gee_benchmark_benchmark_get_type (void) {
	static volatile gsize gee_benchmark_benchmark_type_id__volatile = 0;
	if (g_once_init_enter (&gee_benchmark_benchmark_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeBenchmarkBenchmarkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_benchmark_benchmark_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeBenchmarkBenchmark), 0, (GInstanceInitFunc) gee_benchmark_benchmark_instance_init, NULL };
		GType gee_benchmark_benchmark_type_id;
		gee_benchmark_benchmark_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeBenchmarkBenchmark", &g_define_type_info, 0);
		g_once_init_leave (&gee_benchmark_benchmark_type_id__volatile, gee_benchmark_benchmark_type_id);
	}
	return gee_benchmark_benchmark_type_id__volatile;
}


static void _vala_gee_benchmark_benchmark_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeBenchmarkBenchmark * self;
	self = GEE_BENCHMARK_BENCHMARK (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gee_benchmark_benchmark_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeBenchmarkBenchmark * self;
	self = GEE_BENCHMARK_BENCHMARK (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_BENCHMARK_BENCHMARK_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_BENCHMARK_BENCHMARK_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_BENCHMARK_BENCHMARK_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}



