/* testsortedset.c generated by valac 0.9.8.14-51a7, the Vala compiler
 * generated from testsortedset.vala, do not modify */

/* testsortedset.vala
 *
 * Copyright (C) 2009  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;

#define TYPE_SET_TESTS (set_tests_get_type ())
#define SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SET_TESTS, SetTests))
#define SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SET_TESTS, SetTestsClass))
#define IS_SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SET_TESTS))
#define IS_SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SET_TESTS))
#define SET_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SET_TESTS, SetTestsClass))

typedef struct _SetTests SetTests;
typedef struct _SetTestsClass SetTestsClass;
typedef struct _SetTestsPrivate SetTestsPrivate;

#define TYPE_SORTED_SET_TESTS (sorted_set_tests_get_type ())
#define SORTED_SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SORTED_SET_TESTS, SortedSetTests))
#define SORTED_SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SORTED_SET_TESTS, SortedSetTestsClass))
#define IS_SORTED_SET_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SORTED_SET_TESTS))
#define IS_SORTED_SET_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SORTED_SET_TESTS))
#define SORTED_SET_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SORTED_SET_TESTS, SortedSetTestsClass))

typedef struct _SortedSetTests SortedSetTests;
typedef struct _SortedSetTestsClass SortedSetTestsClass;
typedef struct _SortedSetTestsPrivate SortedSetTestsPrivate;

#define SORTED_SET_TESTS_SUB_SET_TYPE_TYPE (sorted_set_tests_sub_set_type_get_type ())

#define SORTED_SET_TESTS_TYPE_SUB_SET (sorted_set_tests_sub_set_get_type ())
#define SORTED_SET_TESTS_SUB_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SORTED_SET_TESTS_TYPE_SUB_SET, SortedSetTestsSubSet))
#define SORTED_SET_TESTS_SUB_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SORTED_SET_TESTS_TYPE_SUB_SET, SortedSetTestsSubSetClass))
#define SORTED_SET_TESTS_IS_SUB_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SORTED_SET_TESTS_TYPE_SUB_SET))
#define SORTED_SET_TESTS_IS_SUB_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SORTED_SET_TESTS_TYPE_SUB_SET))
#define SORTED_SET_TESTS_SUB_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SORTED_SET_TESTS_TYPE_SUB_SET, SortedSetTestsSubSetClass))

typedef struct _SortedSetTestsSubSet SortedSetTestsSubSet;
typedef struct _SortedSetTestsSubSetClass SortedSetTestsSubSetClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _SortedSetTestsSubSetPrivate SortedSetTestsSubSetPrivate;

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

struct _SetTests {
	CollectionTests parent_instance;
	SetTestsPrivate * priv;
};

struct _SetTestsClass {
	CollectionTestsClass parent_class;
	void (*test_duplicates_are_ignored) (SetTests* self);
};

struct _SortedSetTests {
	SetTests parent_instance;
	SortedSetTestsPrivate * priv;
};

struct _SortedSetTestsClass {
	SetTestsClass parent_class;
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);
typedef enum  {
	SORTED_SET_TESTS_SUB_SET_TYPE_HEAD,
	SORTED_SET_TESTS_SUB_SET_TYPE_TAIL,
	SORTED_SET_TESTS_SUB_SET_TYPE_SUB,
	SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY
} SortedSetTestsSubSetType;

struct _SortedSetTestsSubSet {
	GeeTestCase parent_instance;
	SortedSetTestsSubSetPrivate * priv;
};

struct _SortedSetTestsSubSetClass {
	GeeTestCaseClass parent_class;
};

struct _SortedSetTestsSubSetPrivate {
	GeeSortedSet* master;
	GeeSortedSet* subset;
	SortedSetTests* test;
	SortedSetTestsSubSetType type;
};


static gpointer sorted_set_tests_sub_set_parent_class = NULL;
static gpointer sorted_set_tests_parent_class = NULL;

GType gee_test_case_get_type (void) G_GNUC_CONST;
GType collection_tests_get_type (void) G_GNUC_CONST;
GType set_tests_get_type (void) G_GNUC_CONST;
GType sorted_set_tests_get_type (void) G_GNUC_CONST;
enum  {
	SORTED_SET_TESTS_DUMMY_PROPERTY
};
SortedSetTests* sorted_set_tests_construct (GType object_type, const char* name);
SetTests* set_tests_construct (GType object_type, const char* name);
void gee_test_case_add_test (GeeTestCase* self, const char* name, GeeTestCaseTestMethod test, void* test_target);
void sorted_set_tests_test_first (SortedSetTests* self);
static void _sorted_set_tests_test_first_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_last (SortedSetTests* self);
static void _sorted_set_tests_test_last_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_ordering (SortedSetTests* self);
static void _sorted_set_tests_test_ordering_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_iterator_at (SortedSetTests* self);
static void _sorted_set_tests_test_iterator_at_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_lower (SortedSetTests* self);
static void _sorted_set_tests_test_lower_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_higher (SortedSetTests* self);
static void _sorted_set_tests_test_higher_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_floor (SortedSetTests* self);
static void _sorted_set_tests_test_floor_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_ceil (SortedSetTests* self);
static void _sorted_set_tests_test_ceil_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_bidir_iterator_can_go_backward (SortedSetTests* self);
static void _sorted_set_tests_test_bidir_iterator_can_go_backward_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_mutable_bidir_iterator (SortedSetTests* self);
static void _sorted_set_tests_test_mutable_bidir_iterator_gee_test_case_test_method (gpointer self);
void sorted_set_tests_test_bidir_iterator_last (SortedSetTests* self);
static void _sorted_set_tests_test_bidir_iterator_last_gee_test_case_test_method (gpointer self);
GTestSuite* gee_test_case_get_suite (GeeTestCase* self);
GType sorted_set_tests_sub_set_type_get_type (void) G_GNUC_CONST;
SortedSetTestsSubSet* sorted_set_tests_sub_set_new (SortedSetTests* test, SortedSetTestsSubSetType type);
SortedSetTestsSubSet* sorted_set_tests_sub_set_construct (GType object_type, SortedSetTests* test, SortedSetTestsSubSetType type);
GType sorted_set_tests_sub_set_get_type (void) G_GNUC_CONST;
#define SORTED_SET_TESTS_SUB_SET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), SORTED_SET_TESTS_TYPE_SUB_SET, SortedSetTestsSubSetPrivate))
enum  {
	SORTED_SET_TESTS_SUB_SET_DUMMY_PROPERTY
};
const char* sorted_set_tests_sub_set_type_to_string (SortedSetTestsSubSetType self);
GeeTestCase* gee_test_case_construct (GType object_type, const char* name);
void sorted_set_tests_sub_set_test_size (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_size_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_contains (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_contains_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_add (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_add_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_remove (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_remove_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_iterator (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_iterator_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_clear (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_clear_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_iterator_at (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_iterator_at_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_lower (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_lower_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_higher (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_higher_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_ceil (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_ceil_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_floor (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_floor_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_subsets (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_subsets_gee_test_case_test_method (gpointer self);
void sorted_set_tests_sub_set_test_boundaries (SortedSetTestsSubSet* self);
static void _sorted_set_tests_sub_set_test_boundaries_gee_test_case_test_method (gpointer self);
static void sorted_set_tests_sub_set_real_set_up (GeeTestCase* base);
void gee_test_case_set_up (GeeTestCase* self);
static void sorted_set_tests_sub_set_real_tear_down (GeeTestCase* base);
void gee_test_case_tear_down (GeeTestCase* self);
static void sorted_set_tests_sub_set_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _sorted_set_tests_test_first_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_first (self);
}


static void _sorted_set_tests_test_last_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_last (self);
}


static void _sorted_set_tests_test_ordering_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_ordering (self);
}


static void _sorted_set_tests_test_iterator_at_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_iterator_at (self);
}


static void _sorted_set_tests_test_lower_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_lower (self);
}


static void _sorted_set_tests_test_higher_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_higher (self);
}


static void _sorted_set_tests_test_floor_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_floor (self);
}


static void _sorted_set_tests_test_ceil_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_ceil (self);
}


static void _sorted_set_tests_test_bidir_iterator_can_go_backward_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_bidir_iterator_can_go_backward (self);
}


static void _sorted_set_tests_test_mutable_bidir_iterator_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_mutable_bidir_iterator (self);
}


static void _sorted_set_tests_test_bidir_iterator_last_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_test_bidir_iterator_last (self);
}


SortedSetTests* sorted_set_tests_construct (GType object_type, const char* name) {
	SortedSetTests * self;
	SortedSetTestsSubSet* _tmp0_;
	SortedSetTestsSubSet* _tmp1_;
	SortedSetTestsSubSet* _tmp2_;
	SortedSetTestsSubSet* _tmp3_;
	g_return_val_if_fail (name != NULL, NULL);
	self = (SortedSetTests*) set_tests_construct (object_type, name);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] first", _sorted_set_tests_test_first_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] last", _sorted_set_tests_test_last_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] ordering", _sorted_set_tests_test_ordering_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] iterator at", _sorted_set_tests_test_iterator_at_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] lower", _sorted_set_tests_test_lower_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] higher", _sorted_set_tests_test_higher_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] floor", _sorted_set_tests_test_floor_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] ceil", _sorted_set_tests_test_ceil_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] bi-directional iterators can go backward", _sorted_set_tests_test_bidir_iterator_can_go_backward_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] bi-directional iterators are mutable", _sorted_set_tests_test_mutable_bidir_iterator_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] bi-directional iterators can to end", _sorted_set_tests_test_bidir_iterator_last_gee_test_case_test_method, self);
	g_test_suite_add_suite (gee_test_case_get_suite ((GeeTestCase*) self), gee_test_case_get_suite ((GeeTestCase*) (_tmp0_ = sorted_set_tests_sub_set_new (self, SORTED_SET_TESTS_SUB_SET_TYPE_HEAD))));
	_g_object_unref0 (_tmp0_);
	g_test_suite_add_suite (gee_test_case_get_suite ((GeeTestCase*) self), gee_test_case_get_suite ((GeeTestCase*) (_tmp1_ = sorted_set_tests_sub_set_new (self, SORTED_SET_TESTS_SUB_SET_TYPE_TAIL))));
	_g_object_unref0 (_tmp1_);
	g_test_suite_add_suite (gee_test_case_get_suite ((GeeTestCase*) self), gee_test_case_get_suite ((GeeTestCase*) (_tmp2_ = sorted_set_tests_sub_set_new (self, SORTED_SET_TESTS_SUB_SET_TYPE_SUB))));
	_g_object_unref0 (_tmp2_);
	g_test_suite_add_suite (gee_test_case_get_suite ((GeeTestCase*) self), gee_test_case_get_suite ((GeeTestCase*) (_tmp3_ = sorted_set_tests_sub_set_new (self, SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY))));
	_g_object_unref0 (_tmp3_);
	return self;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void sorted_set_tests_test_ordering (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* test_set;
	GeeIterator* iterator;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	char* _tmp12_;
	g_return_if_fail (self != NULL);
	test_set = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	g_assert (test_set != NULL);
	gee_collection_add ((GeeCollection*) test_set, "one");
	gee_collection_add ((GeeCollection*) test_set, "two");
	gee_collection_add ((GeeCollection*) test_set, "three");
	gee_collection_add ((GeeCollection*) test_set, "four");
	gee_collection_add ((GeeCollection*) test_set, "five");
	gee_collection_add ((GeeCollection*) test_set, "six");
	gee_collection_add ((GeeCollection*) test_set, "seven");
	gee_collection_add ((GeeCollection*) test_set, "eight");
	gee_collection_add ((GeeCollection*) test_set, "nine");
	gee_collection_add ((GeeCollection*) test_set, "ten");
	gee_collection_add ((GeeCollection*) test_set, "eleven");
	gee_collection_add ((GeeCollection*) test_set, "twelve");
	iterator = gee_iterable_iterator ((GeeIterable*) test_set);
	g_assert (gee_iterator_next (iterator));
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_iterator_get (iterator), "eight") == 0);
	_g_free0 (_tmp1_);
	g_assert (gee_iterator_next (iterator));
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_iterator_get (iterator), "eleven") == 0);
	_g_free0 (_tmp2_);
	g_assert (gee_iterator_next (iterator));
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_iterator_get (iterator), "five") == 0);
	_g_free0 (_tmp3_);
	g_assert (gee_iterator_next (iterator));
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_iterator_get (iterator), "four") == 0);
	_g_free0 (_tmp4_);
	g_assert (gee_iterator_next (iterator));
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_iterator_get (iterator), "nine") == 0);
	_g_free0 (_tmp5_);
	g_assert (gee_iterator_next (iterator));
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_iterator_get (iterator), "one") == 0);
	_g_free0 (_tmp6_);
	g_assert (gee_iterator_next (iterator));
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_iterator_get (iterator), "seven") == 0);
	_g_free0 (_tmp7_);
	g_assert (gee_iterator_next (iterator));
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_iterator_get (iterator), "six") == 0);
	_g_free0 (_tmp8_);
	g_assert (gee_iterator_next (iterator));
	g_assert (_vala_strcmp0 (_tmp9_ = (char*) gee_iterator_get (iterator), "ten") == 0);
	_g_free0 (_tmp9_);
	g_assert (gee_iterator_next (iterator));
	g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_iterator_get (iterator), "three") == 0);
	_g_free0 (_tmp10_);
	g_assert (gee_iterator_next (iterator));
	g_assert (_vala_strcmp0 (_tmp11_ = (char*) gee_iterator_get (iterator), "twelve") == 0);
	_g_free0 (_tmp11_);
	g_assert (gee_iterator_next (iterator));
	g_assert (_vala_strcmp0 (_tmp12_ = (char*) gee_iterator_get (iterator), "two") == 0);
	_g_free0 (_tmp12_);
	g_assert (gee_iterator_next (iterator) == FALSE);
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_first (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* test_set;
	char* _tmp2_;
	g_return_if_fail (self != NULL);
	test_set = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp1_;
		_tmp1_ = (char*) gee_sorted_set_first (test_set);
		_g_free0 (_tmp1_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_add ((GeeCollection*) test_set, "one"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "two"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "three"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "four"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "five"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "six"));
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_sorted_set_first (test_set), "five") == 0);
	_g_free0 (_tmp2_);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_last (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* test_set;
	char* _tmp2_;
	g_return_if_fail (self != NULL);
	test_set = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp1_;
		_tmp1_ = (char*) gee_sorted_set_last (test_set);
		_g_free0 (_tmp1_);
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_add ((GeeCollection*) test_set, "one"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "two"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "three"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "four"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "five"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "six"));
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_sorted_set_last (test_set), "two") == 0);
	_g_free0 (_tmp2_);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_iterator_at (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* test_set;
	GeeBidirIterator* iter;
	char* _tmp1_;
	GeeBidirIterator* _tmp2_;
	char* _tmp3_;
	GeeBidirIterator* _tmp4_;
	char* _tmp5_;
	GeeBidirIterator* _tmp6_;
	g_return_if_fail (self != NULL);
	test_set = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "one"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "two"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "three"));
	iter = gee_sorted_set_iterator_at (test_set, "one");
	g_assert (iter != NULL);
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_iterator_get ((GeeIterator*) iter), "one") == 0);
	_g_free0 (_tmp1_);
	iter = (_tmp2_ = gee_sorted_set_iterator_at (test_set, "two"), _g_object_unref0 (iter), _tmp2_);
	g_assert (iter != NULL);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_iterator_get ((GeeIterator*) iter), "two") == 0);
	_g_free0 (_tmp3_);
	iter = (_tmp4_ = gee_sorted_set_iterator_at (test_set, "three"), _g_object_unref0 (iter), _tmp4_);
	g_assert (iter != NULL);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_iterator_get ((GeeIterator*) iter), "three") == 0);
	_g_free0 (_tmp5_);
	iter = (_tmp6_ = gee_sorted_set_iterator_at (test_set, "zero"), _g_object_unref0 (iter), _tmp6_);
	g_assert (iter == NULL);
	_g_object_unref0 (iter);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_lower (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* test_set;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	g_return_if_fail (self != NULL);
	test_set = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	g_assert ((_tmp1_ = (char*) gee_sorted_set_lower (test_set, "one")) == NULL);
	_g_free0 (_tmp1_);
	g_assert (gee_collection_add ((GeeCollection*) test_set, "one"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "two"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "three"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "four"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "five"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "six"));
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_sorted_set_lower (test_set, "one"), "four") == 0);
	_g_free0 (_tmp2_);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_sorted_set_lower (test_set, "o"), "four") == 0);
	_g_free0 (_tmp3_);
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_sorted_set_lower (test_set, "two"), "three") == 0);
	_g_free0 (_tmp4_);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_sorted_set_lower (test_set, "t"), "six") == 0);
	_g_free0 (_tmp5_);
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_sorted_set_lower (test_set, "three"), "six") == 0);
	_g_free0 (_tmp6_);
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_sorted_set_lower (test_set, "four"), "five") == 0);
	_g_free0 (_tmp7_);
	g_assert ((_tmp8_ = (char*) gee_sorted_set_lower (test_set, "f")) == NULL);
	_g_free0 (_tmp8_);
	g_assert ((_tmp9_ = (char*) gee_sorted_set_lower (test_set, "five")) == NULL);
	_g_free0 (_tmp9_);
	g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_sorted_set_lower (test_set, "six"), "one") == 0);
	_g_free0 (_tmp10_);
	g_assert (_vala_strcmp0 (_tmp11_ = (char*) gee_sorted_set_lower (test_set, "s"), "one") == 0);
	_g_free0 (_tmp11_);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_higher (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* test_set;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	g_return_if_fail (self != NULL);
	test_set = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	g_assert ((_tmp1_ = (char*) gee_sorted_set_higher (test_set, "one")) == NULL);
	_g_free0 (_tmp1_);
	g_assert (gee_collection_add ((GeeCollection*) test_set, "one"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "two"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "three"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "four"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "five"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "six"));
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_sorted_set_higher (test_set, "one"), "six") == 0);
	_g_free0 (_tmp2_);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_sorted_set_higher (test_set, "o"), "one") == 0);
	_g_free0 (_tmp3_);
	g_assert ((_tmp4_ = (char*) gee_sorted_set_higher (test_set, "two")) == NULL);
	_g_free0 (_tmp4_);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_sorted_set_higher (test_set, "t"), "three") == 0);
	_g_free0 (_tmp5_);
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_sorted_set_higher (test_set, "three"), "two") == 0);
	_g_free0 (_tmp6_);
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_sorted_set_higher (test_set, "four"), "one") == 0);
	_g_free0 (_tmp7_);
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_sorted_set_higher (test_set, "f"), "five") == 0);
	_g_free0 (_tmp8_);
	g_assert (_vala_strcmp0 (_tmp9_ = (char*) gee_sorted_set_higher (test_set, "five"), "four") == 0);
	_g_free0 (_tmp9_);
	g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_sorted_set_higher (test_set, "six"), "three") == 0);
	_g_free0 (_tmp10_);
	g_assert (_vala_strcmp0 (_tmp11_ = (char*) gee_sorted_set_higher (test_set, "s"), "six") == 0);
	_g_free0 (_tmp11_);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_floor (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* test_set;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	g_return_if_fail (self != NULL);
	test_set = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	g_assert ((_tmp1_ = (char*) gee_sorted_set_floor (test_set, "one")) == NULL);
	_g_free0 (_tmp1_);
	g_assert (gee_collection_add ((GeeCollection*) test_set, "one"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "two"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "three"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "four"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "five"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "six"));
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_sorted_set_floor (test_set, "one"), "one") == 0);
	_g_free0 (_tmp2_);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_sorted_set_floor (test_set, "o"), "four") == 0);
	_g_free0 (_tmp3_);
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_sorted_set_floor (test_set, "two"), "two") == 0);
	_g_free0 (_tmp4_);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_sorted_set_floor (test_set, "t"), "six") == 0);
	_g_free0 (_tmp5_);
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_sorted_set_floor (test_set, "three"), "three") == 0);
	_g_free0 (_tmp6_);
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_sorted_set_floor (test_set, "four"), "four") == 0);
	_g_free0 (_tmp7_);
	g_assert ((_tmp8_ = (char*) gee_sorted_set_floor (test_set, "f")) == NULL);
	_g_free0 (_tmp8_);
	g_assert (_vala_strcmp0 (_tmp9_ = (char*) gee_sorted_set_floor (test_set, "five"), "five") == 0);
	_g_free0 (_tmp9_);
	g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_sorted_set_floor (test_set, "six"), "six") == 0);
	_g_free0 (_tmp10_);
	g_assert (_vala_strcmp0 (_tmp11_ = (char*) gee_sorted_set_floor (test_set, "s"), "one") == 0);
	_g_free0 (_tmp11_);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_ceil (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* test_set;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	g_return_if_fail (self != NULL);
	test_set = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	g_assert ((_tmp1_ = (char*) gee_sorted_set_ceil (test_set, "one")) == NULL);
	_g_free0 (_tmp1_);
	g_assert (gee_collection_add ((GeeCollection*) test_set, "one"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "two"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "three"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "four"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "five"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "six"));
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_sorted_set_ceil (test_set, "one"), "one") == 0);
	_g_free0 (_tmp2_);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_sorted_set_ceil (test_set, "o"), "one") == 0);
	_g_free0 (_tmp3_);
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_sorted_set_ceil (test_set, "two"), "two") == 0);
	_g_free0 (_tmp4_);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_sorted_set_ceil (test_set, "t"), "three") == 0);
	_g_free0 (_tmp5_);
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_sorted_set_ceil (test_set, "three"), "three") == 0);
	_g_free0 (_tmp6_);
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_sorted_set_ceil (test_set, "four"), "four") == 0);
	_g_free0 (_tmp7_);
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_sorted_set_ceil (test_set, "f"), "five") == 0);
	_g_free0 (_tmp8_);
	g_assert (_vala_strcmp0 (_tmp9_ = (char*) gee_sorted_set_ceil (test_set, "five"), "five") == 0);
	_g_free0 (_tmp9_);
	g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_sorted_set_ceil (test_set, "six"), "six") == 0);
	_g_free0 (_tmp10_);
	g_assert (_vala_strcmp0 (_tmp11_ = (char*) gee_sorted_set_ceil (test_set, "s"), "six") == 0);
	_g_free0 (_tmp11_);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_bidir_iterator_can_go_backward (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* test_set;
	GeeBidirIterator* iterator;
	GeeBidirIterator* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	char* _tmp12_;
	char* _tmp13_;
	g_return_if_fail (self != NULL);
	test_set = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	iterator = gee_sorted_set_bidir_iterator (test_set);
	g_assert (!gee_bidir_iterator_has_previous (iterator));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "one"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "two"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "three"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "four"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "five"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "six"));
	iterator = (_tmp1_ = gee_sorted_set_bidir_iterator (test_set), _g_object_unref0 (iterator), _tmp1_);
	g_assert (gee_iterator_next ((GeeIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "five") == 0);
	_g_free0 (_tmp2_);
	g_assert (!gee_bidir_iterator_has_previous (iterator));
	g_assert (gee_iterator_next ((GeeIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "four") == 0);
	_g_free0 (_tmp3_);
	g_assert (gee_bidir_iterator_has_previous (iterator));
	g_assert (gee_iterator_next ((GeeIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "one") == 0);
	_g_free0 (_tmp4_);
	g_assert (gee_bidir_iterator_has_previous (iterator));
	g_assert (gee_iterator_next ((GeeIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "six") == 0);
	_g_free0 (_tmp5_);
	g_assert (gee_bidir_iterator_has_previous (iterator));
	g_assert (gee_iterator_next ((GeeIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "three") == 0);
	_g_free0 (_tmp6_);
	g_assert (gee_bidir_iterator_has_previous (iterator));
	g_assert (gee_iterator_next ((GeeIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "two") == 0);
	_g_free0 (_tmp7_);
	g_assert (gee_bidir_iterator_has_previous (iterator));
	g_assert (!gee_iterator_next ((GeeIterator*) iterator));
	g_assert (gee_bidir_iterator_previous (iterator));
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "three") == 0);
	_g_free0 (_tmp8_);
	g_assert (gee_bidir_iterator_previous (iterator));
	g_assert (_vala_strcmp0 (_tmp9_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "six") == 0);
	_g_free0 (_tmp9_);
	g_assert (gee_bidir_iterator_previous (iterator));
	g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "one") == 0);
	_g_free0 (_tmp10_);
	g_assert (gee_bidir_iterator_previous (iterator));
	g_assert (_vala_strcmp0 (_tmp11_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "four") == 0);
	_g_free0 (_tmp11_);
	g_assert (gee_bidir_iterator_previous (iterator));
	g_assert (_vala_strcmp0 (_tmp12_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "five") == 0);
	_g_free0 (_tmp12_);
	g_assert (!gee_bidir_iterator_previous (iterator));
	g_assert (_vala_strcmp0 (_tmp13_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "five") == 0);
	_g_free0 (_tmp13_);
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_bidir_iterator_last (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* test_set;
	GeeBidirIterator* iterator;
	GeeBidirIterator* _tmp1_;
	char* _tmp2_;
	g_return_if_fail (self != NULL);
	test_set = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	iterator = gee_sorted_set_bidir_iterator (test_set);
	g_assert (!gee_bidir_iterator_last (iterator));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "one"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "two"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "three"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "four"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "five"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "six"));
	iterator = (_tmp1_ = gee_sorted_set_bidir_iterator (test_set), _g_object_unref0 (iterator), _tmp1_);
	g_assert (gee_bidir_iterator_last (iterator));
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "two") == 0);
	_g_free0 (_tmp2_);
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_set);
}


void sorted_set_tests_test_mutable_bidir_iterator (SortedSetTests* self) {
	GeeCollection* _tmp0_;
	GeeSortedSet* test_set;
	GeeBidirIterator* iterator;
	GeeBidirIterator* _tmp1_;
	char* _tmp2_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	g_return_if_fail (self != NULL);
	test_set = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL));
	iterator = gee_sorted_set_bidir_iterator (test_set);
	g_assert (!gee_bidir_iterator_has_previous (iterator));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "one"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "two"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "three"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "four"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "five"));
	g_assert (gee_collection_add ((GeeCollection*) test_set, "six"));
	iterator = (_tmp1_ = gee_sorted_set_bidir_iterator (test_set), _g_object_unref0 (iterator), _tmp1_);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_iterator_remove ((GeeIterator*) iterator);
		exit (0);
	}
	g_test_trap_assert_failed ();
	g_assert (gee_iterator_next ((GeeIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "five") == 0);
	_g_free0 (_tmp2_);
	gee_iterator_remove ((GeeIterator*) iterator);
	g_assert (!gee_collection_contains ((GeeCollection*) test_set, "five"));
	g_assert (gee_iterator_has_next ((GeeIterator*) iterator));
	g_assert (!gee_bidir_iterator_has_previous (iterator));
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp3_;
		_tmp3_ = (char*) gee_iterator_get ((GeeIterator*) iterator);
		_g_free0 (_tmp3_);
		exit (0);
	}
	g_assert (!gee_bidir_iterator_previous (iterator));
	g_assert (gee_iterator_next ((GeeIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "four") == 0);
	_g_free0 (_tmp4_);
	g_assert (gee_iterator_next ((GeeIterator*) iterator));
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "one") == 0);
	_g_free0 (_tmp5_);
	gee_iterator_remove ((GeeIterator*) iterator);
	g_assert (!gee_collection_contains ((GeeCollection*) test_set, "one"));
	g_assert (gee_iterator_has_next ((GeeIterator*) iterator));
	g_assert (gee_bidir_iterator_has_previous (iterator));
	g_assert (gee_bidir_iterator_previous (iterator));
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_iterator_get ((GeeIterator*) iterator), "four") == 0);
	_g_free0 (_tmp6_);
	_g_object_unref0 (iterator);
	_g_object_unref0 (test_set);
}


const char* sorted_set_tests_sub_set_type_to_string (SortedSetTestsSubSetType self) {
	const char* result = NULL;
	switch (self) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			result = "Head";
			return result;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			result = "Tail";
			return result;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			result = "Range";
			return result;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			result = "Empty";
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


GType sorted_set_tests_sub_set_type_get_type (void) {
	static volatile gsize sorted_set_tests_sub_set_type_type_id__volatile = 0;
	if (g_once_init_enter (&sorted_set_tests_sub_set_type_type_id__volatile)) {
		static const GEnumValue values[] = {{SORTED_SET_TESTS_SUB_SET_TYPE_HEAD, "SORTED_SET_TESTS_SUB_SET_TYPE_HEAD", "head"}, {SORTED_SET_TESTS_SUB_SET_TYPE_TAIL, "SORTED_SET_TESTS_SUB_SET_TYPE_TAIL", "tail"}, {SORTED_SET_TESTS_SUB_SET_TYPE_SUB, "SORTED_SET_TESTS_SUB_SET_TYPE_SUB", "sub"}, {SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY, "SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY", "empty"}, {0, NULL, NULL}};
		GType sorted_set_tests_sub_set_type_type_id;
		sorted_set_tests_sub_set_type_type_id = g_enum_register_static ("SortedSetTestsSubSetType", values);
		g_once_init_leave (&sorted_set_tests_sub_set_type_type_id__volatile, sorted_set_tests_sub_set_type_type_id);
	}
	return sorted_set_tests_sub_set_type_type_id__volatile;
}


static void _sorted_set_tests_sub_set_test_size_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_size (self);
}


static void _sorted_set_tests_sub_set_test_contains_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_contains (self);
}


static void _sorted_set_tests_sub_set_test_add_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_add (self);
}


static void _sorted_set_tests_sub_set_test_remove_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_remove (self);
}


static void _sorted_set_tests_sub_set_test_iterator_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_iterator (self);
}


static void _sorted_set_tests_sub_set_test_clear_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_clear (self);
}


static void _sorted_set_tests_sub_set_test_iterator_at_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_iterator_at (self);
}


static void _sorted_set_tests_sub_set_test_lower_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_lower (self);
}


static void _sorted_set_tests_sub_set_test_higher_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_higher (self);
}


static void _sorted_set_tests_sub_set_test_ceil_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_ceil (self);
}


static void _sorted_set_tests_sub_set_test_floor_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_floor (self);
}


static void _sorted_set_tests_sub_set_test_subsets_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_subsets (self);
}


static void _sorted_set_tests_sub_set_test_boundaries_gee_test_case_test_method (gpointer self) {
	sorted_set_tests_sub_set_test_boundaries (self);
}


SortedSetTestsSubSet* sorted_set_tests_sub_set_construct (GType object_type, SortedSetTests* test, SortedSetTestsSubSetType type) {
	SortedSetTestsSubSet * self;
	char* _tmp0_;
	SortedSetTests* _tmp1_;
	g_return_val_if_fail (test != NULL, NULL);
	self = (SortedSetTestsSubSet*) gee_test_case_construct (object_type, _tmp0_ = g_strdup_printf ("%s Subset", sorted_set_tests_sub_set_type_to_string (type)));
	_g_free0 (_tmp0_);
	self->priv->test = (_tmp1_ = _g_object_ref0 (test), _g_object_unref0 (self->priv->test), _tmp1_);
	self->priv->type = type;
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] size", _sorted_set_tests_sub_set_test_size_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] contains", _sorted_set_tests_sub_set_test_contains_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] add", _sorted_set_tests_sub_set_test_add_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] remove", _sorted_set_tests_sub_set_test_remove_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] iterator", _sorted_set_tests_sub_set_test_iterator_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[Collection] clear", _sorted_set_tests_sub_set_test_clear_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] iterator at", _sorted_set_tests_sub_set_test_iterator_at_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] lower", _sorted_set_tests_sub_set_test_lower_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] higher", _sorted_set_tests_sub_set_test_higher_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] ceil", _sorted_set_tests_sub_set_test_ceil_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] floor", _sorted_set_tests_sub_set_test_floor_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] subsets", _sorted_set_tests_sub_set_test_subsets_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[SortedSet] boundaries", _sorted_set_tests_sub_set_test_boundaries_gee_test_case_test_method, self);
	return self;
}


SortedSetTestsSubSet* sorted_set_tests_sub_set_new (SortedSetTests* test, SortedSetTestsSubSetType type) {
	return sorted_set_tests_sub_set_construct (SORTED_SET_TESTS_TYPE_SUB_SET, test, type);
}


static void sorted_set_tests_sub_set_real_set_up (GeeTestCase* base) {
	SortedSetTestsSubSet * self;
	GeeCollection* _tmp0_;
	GeeSortedSet* _tmp1_;
	self = (SortedSetTestsSubSet*) base;
	gee_test_case_set_up ((GeeTestCase*) self->priv->test);
	self->priv->master = (_tmp1_ = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self->priv->test)->test_collection, GEE_IS_SORTED_SET (_tmp0_) ? ((GeeSortedSet*) _tmp0_) : NULL)), _g_object_unref0 (self->priv->master), _tmp1_);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			GeeSortedSet* _tmp2_;
			self->priv->subset = (_tmp2_ = gee_sorted_set_head_set (self->priv->master, "one"), _g_object_unref0 (self->priv->subset), _tmp2_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			GeeSortedSet* _tmp3_;
			self->priv->subset = (_tmp3_ = gee_sorted_set_tail_set (self->priv->master, "six"), _g_object_unref0 (self->priv->subset), _tmp3_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			GeeSortedSet* _tmp4_;
			self->priv->subset = (_tmp4_ = gee_sorted_set_sub_set (self->priv->master, "four", "three"), _g_object_unref0 (self->priv->subset), _tmp4_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			GeeSortedSet* _tmp5_;
			self->priv->subset = (_tmp5_ = gee_sorted_set_sub_set (self->priv->master, "three", "four"), _g_object_unref0 (self->priv->subset), _tmp5_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static void sorted_set_tests_sub_set_real_tear_down (GeeTestCase* base) {
	SortedSetTestsSubSet * self;
	self = (SortedSetTestsSubSet*) base;
	gee_test_case_tear_down ((GeeTestCase*) self->priv->test);
}


void sorted_set_tests_sub_set_test_size (SortedSetTestsSubSet* self) {
	g_return_if_fail (self != NULL);
	g_assert (gee_collection_get_is_empty ((GeeCollection*) self->priv->subset));
	g_assert (gee_collection_get_size ((GeeCollection*) self->priv->subset) == 0);
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "one"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "two"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "three"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "four"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "five"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "six"));
	g_assert (gee_collection_get_size ((GeeCollection*) self->priv->master) == 6);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			g_assert (!gee_collection_get_is_empty ((GeeCollection*) self->priv->subset));
			g_assert (gee_collection_get_size ((GeeCollection*) self->priv->subset) == 2);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			g_assert (!gee_collection_get_is_empty ((GeeCollection*) self->priv->subset));
			g_assert (gee_collection_get_size ((GeeCollection*) self->priv->subset) == 3);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			g_assert (!gee_collection_get_is_empty ((GeeCollection*) self->priv->subset));
			g_assert (gee_collection_get_size ((GeeCollection*) self->priv->subset) == 3);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			g_assert (gee_collection_get_is_empty ((GeeCollection*) self->priv->subset));
			g_assert (gee_collection_get_size ((GeeCollection*) self->priv->subset) == 0);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


void sorted_set_tests_sub_set_test_contains (SortedSetTestsSubSet* self) {
	gint contains_length1;
	gint _contains_size_;
	char** contains;
	gint not_contains_length1;
	gint _not_contains_size_;
	char** not_contains;
	g_return_if_fail (self != NULL);
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "one"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "two"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "three"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "four"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "five"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "six"));
	g_assert (gee_collection_get_size ((GeeCollection*) self->priv->master) == 6);
	contains = (contains_length1 = 0, NULL);
	not_contains = (not_contains_length1 = 0, NULL);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			char** _tmp0_ = NULL;
			char** _tmp1_;
			char** _tmp2_ = NULL;
			char** _tmp3_;
			contains = (_tmp1_ = (_tmp0_ = g_new0 (char*, 2 + 1), _tmp0_[0] = g_strdup ("four"), _tmp0_[1] = g_strdup ("five"), _tmp0_), contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL), contains_length1 = 2, _contains_size_ = contains_length1, _tmp1_);
			not_contains = (_tmp3_ = (_tmp2_ = g_new0 (char*, 4 + 1), _tmp2_[0] = g_strdup ("one"), _tmp2_[1] = g_strdup ("two"), _tmp2_[2] = g_strdup ("three"), _tmp2_[3] = g_strdup ("six"), _tmp2_), not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL), not_contains_length1 = 4, _not_contains_size_ = not_contains_length1, _tmp3_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			char** _tmp4_ = NULL;
			char** _tmp5_;
			char** _tmp6_ = NULL;
			char** _tmp7_;
			contains = (_tmp5_ = (_tmp4_ = g_new0 (char*, 3 + 1), _tmp4_[0] = g_strdup ("two"), _tmp4_[1] = g_strdup ("three"), _tmp4_[2] = g_strdup ("six"), _tmp4_), contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL), contains_length1 = 3, _contains_size_ = contains_length1, _tmp5_);
			not_contains = (_tmp7_ = (_tmp6_ = g_new0 (char*, 3 + 1), _tmp6_[0] = g_strdup ("one"), _tmp6_[1] = g_strdup ("four"), _tmp6_[2] = g_strdup ("five"), _tmp6_), not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL), not_contains_length1 = 3, _not_contains_size_ = not_contains_length1, _tmp7_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			char** _tmp8_ = NULL;
			char** _tmp9_;
			char** _tmp10_ = NULL;
			char** _tmp11_;
			contains = (_tmp9_ = (_tmp8_ = g_new0 (char*, 3 + 1), _tmp8_[0] = g_strdup ("one"), _tmp8_[1] = g_strdup ("four"), _tmp8_[2] = g_strdup ("six"), _tmp8_), contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL), contains_length1 = 3, _contains_size_ = contains_length1, _tmp9_);
			not_contains = (_tmp11_ = (_tmp10_ = g_new0 (char*, 3 + 1), _tmp10_[0] = g_strdup ("two"), _tmp10_[1] = g_strdup ("three"), _tmp10_[2] = g_strdup ("five"), _tmp10_), not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL), not_contains_length1 = 3, _not_contains_size_ = not_contains_length1, _tmp11_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			char** _tmp12_ = NULL;
			char** _tmp13_;
			char** _tmp14_ = NULL;
			char** _tmp15_;
			contains = (_tmp13_ = (_tmp12_ = g_new0 (char*, 0 + 1), _tmp12_), contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL), contains_length1 = 0, _contains_size_ = contains_length1, _tmp13_);
			not_contains = (_tmp15_ = (_tmp14_ = g_new0 (char*, 6 + 1), _tmp14_[0] = g_strdup ("one"), _tmp14_[1] = g_strdup ("two"), _tmp14_[2] = g_strdup ("three"), _tmp14_[3] = g_strdup ("four"), _tmp14_[4] = g_strdup ("five"), _tmp14_[5] = g_strdup ("six"), _tmp14_), not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL), not_contains_length1 = 6, _not_contains_size_ = not_contains_length1, _tmp15_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	{
		char** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = contains;
		s_collection_length1 = contains_length1;
		for (s_it = 0; s_it < contains_length1; s_it = s_it + 1) {
			char* s;
			s = g_strdup (s_collection[s_it]);
			{
				g_assert (gee_collection_contains ((GeeCollection*) self->priv->subset, s));
				_g_free0 (s);
			}
		}
	}
	{
		char** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = not_contains;
		s_collection_length1 = not_contains_length1;
		for (s_it = 0; s_it < not_contains_length1; s_it = s_it + 1) {
			char* s;
			s = g_strdup (s_collection[s_it]);
			{
				g_assert (!gee_collection_contains ((GeeCollection*) self->priv->subset, s));
				_g_free0 (s);
			}
		}
	}
	not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
}


void sorted_set_tests_sub_set_test_add (SortedSetTestsSubSet* self) {
	gint success_length1;
	gint _success_size_;
	char** success;
	gint fail_length1;
	gint _fail_size_;
	char** fail;
	g_return_if_fail (self != NULL);
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "one"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "two"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "three"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "four"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "five"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "six"));
	g_assert (gee_collection_get_size ((GeeCollection*) self->priv->master) == 6);
	success = (success_length1 = 0, NULL);
	fail = (fail_length1 = 0, NULL);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			char** _tmp0_ = NULL;
			char** _tmp1_;
			char** _tmp2_ = NULL;
			char** _tmp3_;
			success = (_tmp1_ = (_tmp0_ = g_new0 (char*, 2 + 1), _tmp0_[0] = g_strdup ("a"), _tmp0_[1] = g_strdup ("o"), _tmp0_), success = (_vala_array_free (success, success_length1, (GDestroyNotify) g_free), NULL), success_length1 = 2, _success_size_ = success_length1, _tmp1_);
			fail = (_tmp3_ = (_tmp2_ = g_new0 (char*, 2 + 1), _tmp2_[0] = g_strdup ("oz"), _tmp2_[1] = g_strdup ("z"), _tmp2_), fail = (_vala_array_free (fail, fail_length1, (GDestroyNotify) g_free), NULL), fail_length1 = 2, _fail_size_ = fail_length1, _tmp3_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			char** _tmp4_ = NULL;
			char** _tmp5_;
			char** _tmp6_ = NULL;
			char** _tmp7_;
			success = (_tmp5_ = (_tmp4_ = g_new0 (char*, 2 + 1), _tmp4_[0] = g_strdup ("siz"), _tmp4_[1] = g_strdup ("z"), _tmp4_), success = (_vala_array_free (success, success_length1, (GDestroyNotify) g_free), NULL), success_length1 = 2, _success_size_ = success_length1, _tmp5_);
			fail = (_tmp7_ = (_tmp6_ = g_new0 (char*, 2 + 1), _tmp6_[0] = g_strdup ("sia"), _tmp6_[1] = g_strdup ("a"), _tmp6_), fail = (_vala_array_free (fail, fail_length1, (GDestroyNotify) g_free), NULL), fail_length1 = 2, _fail_size_ = fail_length1, _tmp7_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			char** _tmp8_ = NULL;
			char** _tmp9_;
			char** _tmp10_ = NULL;
			char** _tmp11_;
			success = (_tmp9_ = (_tmp8_ = g_new0 (char*, 2 + 1), _tmp8_[0] = g_strdup ("o"), _tmp8_[1] = g_strdup ("th"), _tmp8_), success = (_vala_array_free (success, success_length1, (GDestroyNotify) g_free), NULL), success_length1 = 2, _success_size_ = success_length1, _tmp9_);
			fail = (_tmp11_ = (_tmp10_ = g_new0 (char*, 2 + 1), _tmp10_[0] = g_strdup ("f"), _tmp10_[1] = g_strdup ("u"), _tmp10_), fail = (_vala_array_free (fail, fail_length1, (GDestroyNotify) g_free), NULL), fail_length1 = 2, _fail_size_ = fail_length1, _tmp11_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			char** _tmp12_ = NULL;
			char** _tmp13_;
			char** _tmp14_ = NULL;
			char** _tmp15_;
			success = (_tmp13_ = (_tmp12_ = g_new0 (char*, 0 + 1), _tmp12_), success = (_vala_array_free (success, success_length1, (GDestroyNotify) g_free), NULL), success_length1 = 0, _success_size_ = success_length1, _tmp13_);
			fail = (_tmp15_ = (_tmp14_ = g_new0 (char*, 4 + 1), _tmp14_[0] = g_strdup ("o"), _tmp14_[1] = g_strdup ("th"), _tmp14_[2] = g_strdup ("f"), _tmp14_[3] = g_strdup ("u"), _tmp14_), fail = (_vala_array_free (fail, fail_length1, (GDestroyNotify) g_free), NULL), fail_length1 = 4, _fail_size_ = fail_length1, _tmp15_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	{
		char** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = success;
		s_collection_length1 = success_length1;
		for (s_it = 0; s_it < success_length1; s_it = s_it + 1) {
			char* s;
			s = g_strdup (s_collection[s_it]);
			{
				g_assert (gee_collection_add ((GeeCollection*) self->priv->subset, s));
				g_assert (gee_collection_contains ((GeeCollection*) self->priv->subset, s));
				g_assert (gee_collection_contains ((GeeCollection*) self->priv->master, s));
				_g_free0 (s);
			}
		}
	}
	{
		char** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = fail;
		s_collection_length1 = fail_length1;
		for (s_it = 0; s_it < fail_length1; s_it = s_it + 1) {
			char* s;
			s = g_strdup (s_collection[s_it]);
			{
				g_assert (!gee_collection_add ((GeeCollection*) self->priv->subset, s));
				g_assert (!gee_collection_contains ((GeeCollection*) self->priv->subset, s));
				g_assert (!gee_collection_contains ((GeeCollection*) self->priv->master, s));
				_g_free0 (s);
			}
		}
	}
	g_assert (gee_collection_get_size ((GeeCollection*) self->priv->master) == (6 + success_length1));
	fail = (_vala_array_free (fail, fail_length1, (GDestroyNotify) g_free), NULL);
	success = (_vala_array_free (success, success_length1, (GDestroyNotify) g_free), NULL);
}


void sorted_set_tests_sub_set_test_remove (SortedSetTestsSubSet* self) {
	gint contains_length1;
	gint _contains_size_;
	char** contains;
	gint not_contains_length1;
	gint _not_contains_size_;
	char** not_contains;
	g_return_if_fail (self != NULL);
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "one"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "two"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "three"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "four"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "five"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "six"));
	g_assert (gee_collection_get_size ((GeeCollection*) self->priv->master) == 6);
	contains = (contains_length1 = 0, NULL);
	not_contains = (not_contains_length1 = 0, NULL);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			char** _tmp0_ = NULL;
			char** _tmp1_;
			char** _tmp2_ = NULL;
			char** _tmp3_;
			contains = (_tmp1_ = (_tmp0_ = g_new0 (char*, 2 + 1), _tmp0_[0] = g_strdup ("four"), _tmp0_[1] = g_strdup ("five"), _tmp0_), contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL), contains_length1 = 2, _contains_size_ = contains_length1, _tmp1_);
			not_contains = (_tmp3_ = (_tmp2_ = g_new0 (char*, 4 + 1), _tmp2_[0] = g_strdup ("one"), _tmp2_[1] = g_strdup ("two"), _tmp2_[2] = g_strdup ("three"), _tmp2_[3] = g_strdup ("six"), _tmp2_), not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL), not_contains_length1 = 4, _not_contains_size_ = not_contains_length1, _tmp3_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			char** _tmp4_ = NULL;
			char** _tmp5_;
			char** _tmp6_ = NULL;
			char** _tmp7_;
			contains = (_tmp5_ = (_tmp4_ = g_new0 (char*, 3 + 1), _tmp4_[0] = g_strdup ("two"), _tmp4_[1] = g_strdup ("three"), _tmp4_[2] = g_strdup ("six"), _tmp4_), contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL), contains_length1 = 3, _contains_size_ = contains_length1, _tmp5_);
			not_contains = (_tmp7_ = (_tmp6_ = g_new0 (char*, 3 + 1), _tmp6_[0] = g_strdup ("one"), _tmp6_[1] = g_strdup ("four"), _tmp6_[2] = g_strdup ("five"), _tmp6_), not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL), not_contains_length1 = 3, _not_contains_size_ = not_contains_length1, _tmp7_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			char** _tmp8_ = NULL;
			char** _tmp9_;
			char** _tmp10_ = NULL;
			char** _tmp11_;
			contains = (_tmp9_ = (_tmp8_ = g_new0 (char*, 3 + 1), _tmp8_[0] = g_strdup ("one"), _tmp8_[1] = g_strdup ("four"), _tmp8_[2] = g_strdup ("six"), _tmp8_), contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL), contains_length1 = 3, _contains_size_ = contains_length1, _tmp9_);
			not_contains = (_tmp11_ = (_tmp10_ = g_new0 (char*, 3 + 1), _tmp10_[0] = g_strdup ("two"), _tmp10_[1] = g_strdup ("three"), _tmp10_[2] = g_strdup ("five"), _tmp10_), not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL), not_contains_length1 = 3, _not_contains_size_ = not_contains_length1, _tmp11_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			char** _tmp12_ = NULL;
			char** _tmp13_;
			char** _tmp14_ = NULL;
			char** _tmp15_;
			contains = (_tmp13_ = (_tmp12_ = g_new0 (char*, 0 + 1), _tmp12_), contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL), contains_length1 = 0, _contains_size_ = contains_length1, _tmp13_);
			not_contains = (_tmp15_ = (_tmp14_ = g_new0 (char*, 6 + 1), _tmp14_[0] = g_strdup ("one"), _tmp14_[1] = g_strdup ("two"), _tmp14_[2] = g_strdup ("three"), _tmp14_[3] = g_strdup ("four"), _tmp14_[4] = g_strdup ("five"), _tmp14_[5] = g_strdup ("six"), _tmp14_), not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL), not_contains_length1 = 6, _not_contains_size_ = not_contains_length1, _tmp15_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	{
		char** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = contains;
		s_collection_length1 = contains_length1;
		for (s_it = 0; s_it < contains_length1; s_it = s_it + 1) {
			char* s;
			s = g_strdup (s_collection[s_it]);
			{
				g_assert (gee_collection_remove ((GeeCollection*) self->priv->subset, s));
				g_assert (!gee_collection_contains ((GeeCollection*) self->priv->master, s));
				_g_free0 (s);
			}
		}
	}
	{
		char** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = not_contains;
		s_collection_length1 = not_contains_length1;
		for (s_it = 0; s_it < not_contains_length1; s_it = s_it + 1) {
			char* s;
			s = g_strdup (s_collection[s_it]);
			{
				g_assert (!gee_collection_remove ((GeeCollection*) self->priv->subset, s));
				g_assert (gee_collection_contains ((GeeCollection*) self->priv->master, s));
				_g_free0 (s);
			}
		}
	}
	g_assert (gee_collection_get_size ((GeeCollection*) self->priv->master) == (6 - contains_length1));
	not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
}


void sorted_set_tests_sub_set_test_iterator (SortedSetTestsSubSet* self) {
	gint contains_length1;
	gint _contains_size_;
	char** contains;
	guint i;
	GeeBidirIterator* iter;
	g_return_if_fail (self != NULL);
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "one"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "two"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "three"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "four"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "five"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "six"));
	g_assert (gee_collection_get_size ((GeeCollection*) self->priv->master) == 6);
	contains = (contains_length1 = 0, NULL);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			char** _tmp0_ = NULL;
			char** _tmp1_;
			contains = (_tmp1_ = (_tmp0_ = g_new0 (char*, 2 + 1), _tmp0_[0] = g_strdup ("five"), _tmp0_[1] = g_strdup ("four"), _tmp0_), contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL), contains_length1 = 2, _contains_size_ = contains_length1, _tmp1_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			char** _tmp2_ = NULL;
			char** _tmp3_;
			contains = (_tmp3_ = (_tmp2_ = g_new0 (char*, 3 + 1), _tmp2_[0] = g_strdup ("six"), _tmp2_[1] = g_strdup ("three"), _tmp2_[2] = g_strdup ("two"), _tmp2_), contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL), contains_length1 = 3, _contains_size_ = contains_length1, _tmp3_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			char** _tmp4_ = NULL;
			char** _tmp5_;
			contains = (_tmp5_ = (_tmp4_ = g_new0 (char*, 3 + 1), _tmp4_[0] = g_strdup ("four"), _tmp4_[1] = g_strdup ("one"), _tmp4_[2] = g_strdup ("six"), _tmp4_), contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL), contains_length1 = 3, _contains_size_ = contains_length1, _tmp5_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			char** _tmp6_ = NULL;
			char** _tmp7_;
			contains = (_tmp7_ = (_tmp6_ = g_new0 (char*, 0 + 1), _tmp6_), contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL), contains_length1 = 0, _contains_size_ = contains_length1, _tmp7_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	i = (guint) 0;
	{
		GeeIterator* _e_it;
		_e_it = gee_iterable_iterator ((GeeIterable*) self->priv->subset);
		while (TRUE) {
			char* e;
			if (!gee_iterator_next (_e_it)) {
				break;
			}
			e = (char*) gee_iterator_get (_e_it);
			g_assert (_vala_strcmp0 (e, contains[i++]) == 0);
			_g_free0 (e);
		}
		_g_object_unref0 (_e_it);
	}
	g_assert (i == contains_length1);
	iter = gee_sorted_set_bidir_iterator (self->priv->subset);
	if (self->priv->type != SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY) {
		char* _tmp8_;
		char* _tmp9_;
		char* _tmp10_;
		char* _tmp11_;
		g_assert (gee_bidir_iterator_last (iter));
		g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_iterator_get ((GeeIterator*) iter), contains[contains_length1 - 1]) == 0);
		_g_free0 (_tmp8_);
		g_assert (gee_iterator_first ((GeeIterator*) iter));
		g_assert (_vala_strcmp0 (_tmp9_ = (char*) gee_iterator_get ((GeeIterator*) iter), contains[0]) == 0);
		_g_free0 (_tmp9_);
		g_assert (gee_iterator_has_next ((GeeIterator*) iter));
		g_assert (gee_iterator_next ((GeeIterator*) iter));
		g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_iterator_get ((GeeIterator*) iter), contains[1]) == 0);
		_g_free0 (_tmp10_);
		g_assert (gee_bidir_iterator_has_previous (iter));
		gee_iterator_remove ((GeeIterator*) iter);
		g_assert (gee_bidir_iterator_has_previous (iter));
		if (self->priv->type != SORTED_SET_TESTS_SUB_SET_TYPE_HEAD) {
			g_assert (gee_iterator_has_next ((GeeIterator*) iter));
		} else {
			g_assert (!gee_iterator_has_next ((GeeIterator*) iter));
		}
		g_assert (gee_bidir_iterator_previous (iter));
		g_assert (_vala_strcmp0 (_tmp11_ = (char*) gee_iterator_get ((GeeIterator*) iter), contains[0]) == 0);
		_g_free0 (_tmp11_);
	} else {
		g_assert (!gee_iterator_first ((GeeIterator*) iter));
		if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
			gee_iterator_remove ((GeeIterator*) iter);
			exit (0);
		}
		g_test_trap_assert_failed ();
	}
	_g_object_unref0 (iter);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
}


void sorted_set_tests_sub_set_test_clear (SortedSetTestsSubSet* self) {
	gint contains_length1;
	gint _contains_size_;
	char** contains;
	gint not_contains_length1;
	gint _not_contains_size_;
	char** not_contains;
	g_return_if_fail (self != NULL);
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "one"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "two"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "three"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "four"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "five"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "six"));
	g_assert (gee_collection_get_size ((GeeCollection*) self->priv->master) == 6);
	contains = (contains_length1 = 0, NULL);
	not_contains = (not_contains_length1 = 0, NULL);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			char** _tmp0_ = NULL;
			char** _tmp1_;
			char** _tmp2_ = NULL;
			char** _tmp3_;
			contains = (_tmp1_ = (_tmp0_ = g_new0 (char*, 2 + 1), _tmp0_[0] = g_strdup ("four"), _tmp0_[1] = g_strdup ("five"), _tmp0_), contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL), contains_length1 = 2, _contains_size_ = contains_length1, _tmp1_);
			not_contains = (_tmp3_ = (_tmp2_ = g_new0 (char*, 4 + 1), _tmp2_[0] = g_strdup ("one"), _tmp2_[1] = g_strdup ("two"), _tmp2_[2] = g_strdup ("three"), _tmp2_[3] = g_strdup ("six"), _tmp2_), not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL), not_contains_length1 = 4, _not_contains_size_ = not_contains_length1, _tmp3_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			char** _tmp4_ = NULL;
			char** _tmp5_;
			char** _tmp6_ = NULL;
			char** _tmp7_;
			contains = (_tmp5_ = (_tmp4_ = g_new0 (char*, 3 + 1), _tmp4_[0] = g_strdup ("two"), _tmp4_[1] = g_strdup ("three"), _tmp4_[2] = g_strdup ("six"), _tmp4_), contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL), contains_length1 = 3, _contains_size_ = contains_length1, _tmp5_);
			not_contains = (_tmp7_ = (_tmp6_ = g_new0 (char*, 3 + 1), _tmp6_[0] = g_strdup ("one"), _tmp6_[1] = g_strdup ("four"), _tmp6_[2] = g_strdup ("five"), _tmp6_), not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL), not_contains_length1 = 3, _not_contains_size_ = not_contains_length1, _tmp7_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			char** _tmp8_ = NULL;
			char** _tmp9_;
			char** _tmp10_ = NULL;
			char** _tmp11_;
			contains = (_tmp9_ = (_tmp8_ = g_new0 (char*, 3 + 1), _tmp8_[0] = g_strdup ("one"), _tmp8_[1] = g_strdup ("four"), _tmp8_[2] = g_strdup ("six"), _tmp8_), contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL), contains_length1 = 3, _contains_size_ = contains_length1, _tmp9_);
			not_contains = (_tmp11_ = (_tmp10_ = g_new0 (char*, 3 + 1), _tmp10_[0] = g_strdup ("two"), _tmp10_[1] = g_strdup ("three"), _tmp10_[2] = g_strdup ("five"), _tmp10_), not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL), not_contains_length1 = 3, _not_contains_size_ = not_contains_length1, _tmp11_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			char** _tmp12_ = NULL;
			char** _tmp13_;
			char** _tmp14_ = NULL;
			char** _tmp15_;
			contains = (_tmp13_ = (_tmp12_ = g_new0 (char*, 0 + 1), _tmp12_), contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL), contains_length1 = 0, _contains_size_ = contains_length1, _tmp13_);
			not_contains = (_tmp15_ = (_tmp14_ = g_new0 (char*, 6 + 1), _tmp14_[0] = g_strdup ("one"), _tmp14_[1] = g_strdup ("two"), _tmp14_[2] = g_strdup ("three"), _tmp14_[3] = g_strdup ("four"), _tmp14_[4] = g_strdup ("five"), _tmp14_[5] = g_strdup ("six"), _tmp14_), not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL), not_contains_length1 = 6, _not_contains_size_ = not_contains_length1, _tmp15_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	gee_collection_clear ((GeeCollection*) self->priv->subset);
	{
		char** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = contains;
		s_collection_length1 = contains_length1;
		for (s_it = 0; s_it < contains_length1; s_it = s_it + 1) {
			char* s;
			s = g_strdup (s_collection[s_it]);
			{
				g_assert (!gee_collection_contains ((GeeCollection*) self->priv->master, s));
				_g_free0 (s);
			}
		}
	}
	{
		char** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = not_contains;
		s_collection_length1 = not_contains_length1;
		for (s_it = 0; s_it < not_contains_length1; s_it = s_it + 1) {
			char* s;
			s = g_strdup (s_collection[s_it]);
			{
				g_assert (gee_collection_contains ((GeeCollection*) self->priv->master, s));
				_g_free0 (s);
			}
		}
	}
	not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
}


void sorted_set_tests_sub_set_test_boundaries (SortedSetTestsSubSet* self) {
	g_return_if_fail (self != NULL);
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "one"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "two"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "three"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "four"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "five"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "six"));
	g_assert (gee_collection_get_size ((GeeCollection*) self->priv->master) == 6);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			char* _tmp0_;
			char* _tmp1_;
			g_assert (_vala_strcmp0 (_tmp0_ = (char*) gee_sorted_set_first (self->priv->subset), "five") == 0);
			_g_free0 (_tmp0_);
			g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_sorted_set_last (self->priv->subset), "four") == 0);
			_g_free0 (_tmp1_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			char* _tmp2_;
			char* _tmp3_;
			g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_sorted_set_first (self->priv->subset), "six") == 0);
			_g_free0 (_tmp2_);
			g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_sorted_set_last (self->priv->subset), "two") == 0);
			_g_free0 (_tmp3_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			char* _tmp4_;
			char* _tmp5_;
			g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_sorted_set_first (self->priv->subset), "four") == 0);
			_g_free0 (_tmp4_);
			g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_sorted_set_last (self->priv->subset), "six") == 0);
			_g_free0 (_tmp5_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
				char* _tmp6_;
				_tmp6_ = (char*) gee_sorted_set_first (self->priv->subset);
				_g_free0 (_tmp6_);
				exit (0);
			}
			g_test_trap_assert_failed ();
			if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
				char* _tmp7_;
				_tmp7_ = (char*) gee_sorted_set_last (self->priv->subset);
				_g_free0 (_tmp7_);
				exit (0);
			}
			g_test_trap_assert_failed ();
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


void sorted_set_tests_sub_set_test_iterator_at (SortedSetTestsSubSet* self) {
	gint contains_length1;
	gint _contains_size_;
	char** contains;
	gint not_contains_length1;
	gint _not_contains_size_;
	char** not_contains;
	g_return_if_fail (self != NULL);
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "one"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "two"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "three"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "four"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "five"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "six"));
	g_assert (gee_collection_get_size ((GeeCollection*) self->priv->master) == 6);
	contains = (contains_length1 = 0, NULL);
	not_contains = (not_contains_length1 = 0, NULL);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			char** _tmp0_ = NULL;
			char** _tmp1_;
			char** _tmp2_ = NULL;
			char** _tmp3_;
			contains = (_tmp1_ = (_tmp0_ = g_new0 (char*, 2 + 1), _tmp0_[0] = g_strdup ("four"), _tmp0_[1] = g_strdup ("five"), _tmp0_), contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL), contains_length1 = 2, _contains_size_ = contains_length1, _tmp1_);
			not_contains = (_tmp3_ = (_tmp2_ = g_new0 (char*, 4 + 1), _tmp2_[0] = g_strdup ("one"), _tmp2_[1] = g_strdup ("two"), _tmp2_[2] = g_strdup ("three"), _tmp2_[3] = g_strdup ("six"), _tmp2_), not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL), not_contains_length1 = 4, _not_contains_size_ = not_contains_length1, _tmp3_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			char** _tmp4_ = NULL;
			char** _tmp5_;
			char** _tmp6_ = NULL;
			char** _tmp7_;
			contains = (_tmp5_ = (_tmp4_ = g_new0 (char*, 3 + 1), _tmp4_[0] = g_strdup ("two"), _tmp4_[1] = g_strdup ("three"), _tmp4_[2] = g_strdup ("six"), _tmp4_), contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL), contains_length1 = 3, _contains_size_ = contains_length1, _tmp5_);
			not_contains = (_tmp7_ = (_tmp6_ = g_new0 (char*, 3 + 1), _tmp6_[0] = g_strdup ("one"), _tmp6_[1] = g_strdup ("four"), _tmp6_[2] = g_strdup ("five"), _tmp6_), not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL), not_contains_length1 = 3, _not_contains_size_ = not_contains_length1, _tmp7_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			char** _tmp8_ = NULL;
			char** _tmp9_;
			char** _tmp10_ = NULL;
			char** _tmp11_;
			contains = (_tmp9_ = (_tmp8_ = g_new0 (char*, 3 + 1), _tmp8_[0] = g_strdup ("one"), _tmp8_[1] = g_strdup ("four"), _tmp8_[2] = g_strdup ("six"), _tmp8_), contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL), contains_length1 = 3, _contains_size_ = contains_length1, _tmp9_);
			not_contains = (_tmp11_ = (_tmp10_ = g_new0 (char*, 3 + 1), _tmp10_[0] = g_strdup ("two"), _tmp10_[1] = g_strdup ("three"), _tmp10_[2] = g_strdup ("five"), _tmp10_), not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL), not_contains_length1 = 3, _not_contains_size_ = not_contains_length1, _tmp11_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			char** _tmp12_ = NULL;
			char** _tmp13_;
			char** _tmp14_ = NULL;
			char** _tmp15_;
			contains = (_tmp13_ = (_tmp12_ = g_new0 (char*, 0 + 1), _tmp12_), contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL), contains_length1 = 0, _contains_size_ = contains_length1, _tmp13_);
			not_contains = (_tmp15_ = (_tmp14_ = g_new0 (char*, 6 + 1), _tmp14_[0] = g_strdup ("one"), _tmp14_[1] = g_strdup ("two"), _tmp14_[2] = g_strdup ("three"), _tmp14_[3] = g_strdup ("four"), _tmp14_[4] = g_strdup ("five"), _tmp14_[5] = g_strdup ("six"), _tmp14_), not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL), not_contains_length1 = 6, _not_contains_size_ = not_contains_length1, _tmp15_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
	{
		char** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = contains;
		s_collection_length1 = contains_length1;
		for (s_it = 0; s_it < contains_length1; s_it = s_it + 1) {
			char* s;
			s = g_strdup (s_collection[s_it]);
			{
				GeeBidirIterator* iter;
				char* _tmp16_;
				iter = gee_sorted_set_iterator_at (self->priv->subset, s);
				g_assert (iter != NULL);
				g_assert (_vala_strcmp0 (_tmp16_ = (char*) gee_iterator_get ((GeeIterator*) iter), s) == 0);
				_g_free0 (_tmp16_);
				_g_object_unref0 (iter);
				_g_free0 (s);
			}
		}
	}
	{
		char** s_collection;
		int s_collection_length1;
		int s_it;
		s_collection = not_contains;
		s_collection_length1 = not_contains_length1;
		for (s_it = 0; s_it < not_contains_length1; s_it = s_it + 1) {
			char* s;
			s = g_strdup (s_collection[s_it]);
			{
				GeeBidirIterator* iter;
				iter = gee_sorted_set_iterator_at (self->priv->subset, s);
				g_assert (iter == NULL);
				_g_object_unref0 (iter);
				_g_free0 (s);
			}
		}
	}
	not_contains = (_vala_array_free (not_contains, not_contains_length1, (GDestroyNotify) g_free), NULL);
	contains = (_vala_array_free (contains, contains_length1, (GDestroyNotify) g_free), NULL);
}


void sorted_set_tests_sub_set_test_lower (SortedSetTestsSubSet* self) {
	g_return_if_fail (self != NULL);
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "one"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "two"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "three"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "four"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "five"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "six"));
	g_assert (gee_collection_get_size ((GeeCollection*) self->priv->master) == 6);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			char* _tmp0_;
			char* _tmp1_;
			char* _tmp2_;
			char* _tmp3_;
			g_assert ((_tmp0_ = (char*) gee_sorted_set_lower (self->priv->subset, "a")) == NULL);
			_g_free0 (_tmp0_);
			g_assert ((_tmp1_ = (char*) gee_sorted_set_lower (self->priv->subset, "five")) == NULL);
			_g_free0 (_tmp1_);
			g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_sorted_set_lower (self->priv->subset, "four"), "five") == 0);
			_g_free0 (_tmp2_);
			g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_sorted_set_lower (self->priv->subset, "six"), "four") == 0);
			_g_free0 (_tmp3_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			char* _tmp4_;
			char* _tmp5_;
			char* _tmp6_;
			char* _tmp7_;
			char* _tmp8_;
			g_assert ((_tmp4_ = (char*) gee_sorted_set_lower (self->priv->subset, "one")) == NULL);
			_g_free0 (_tmp4_);
			g_assert ((_tmp5_ = (char*) gee_sorted_set_lower (self->priv->subset, "six")) == NULL);
			_g_free0 (_tmp5_);
			g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_sorted_set_lower (self->priv->subset, "three"), "six") == 0);
			_g_free0 (_tmp6_);
			g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_sorted_set_lower (self->priv->subset, "two"), "three") == 0);
			_g_free0 (_tmp7_);
			g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_sorted_set_lower (self->priv->subset, "z"), "two") == 0);
			_g_free0 (_tmp8_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			char* _tmp9_;
			char* _tmp10_;
			char* _tmp11_;
			char* _tmp12_;
			char* _tmp13_;
			g_assert ((_tmp9_ = (char*) gee_sorted_set_lower (self->priv->subset, "five")) == NULL);
			_g_free0 (_tmp9_);
			g_assert ((_tmp10_ = (char*) gee_sorted_set_lower (self->priv->subset, "four")) == NULL);
			_g_free0 (_tmp10_);
			g_assert (_vala_strcmp0 (_tmp11_ = (char*) gee_sorted_set_lower (self->priv->subset, "one"), "four") == 0);
			_g_free0 (_tmp11_);
			g_assert (_vala_strcmp0 (_tmp12_ = (char*) gee_sorted_set_lower (self->priv->subset, "six"), "one") == 0);
			_g_free0 (_tmp12_);
			g_assert (_vala_strcmp0 (_tmp13_ = (char*) gee_sorted_set_lower (self->priv->subset, "three"), "six") == 0);
			_g_free0 (_tmp13_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			char* _tmp14_;
			g_assert ((_tmp14_ = (char*) gee_sorted_set_lower (self->priv->subset, "six")) == NULL);
			_g_free0 (_tmp14_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


void sorted_set_tests_sub_set_test_higher (SortedSetTestsSubSet* self) {
	g_return_if_fail (self != NULL);
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "one"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "two"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "three"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "four"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "five"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "six"));
	g_assert (gee_collection_get_size ((GeeCollection*) self->priv->master) == 6);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			char* _tmp0_;
			char* _tmp1_;
			char* _tmp2_;
			char* _tmp3_;
			g_assert (_vala_strcmp0 (_tmp0_ = (char*) gee_sorted_set_higher (self->priv->subset, "a"), "five") == 0);
			_g_free0 (_tmp0_);
			g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_sorted_set_higher (self->priv->subset, "five"), "four") == 0);
			_g_free0 (_tmp1_);
			g_assert ((_tmp2_ = (char*) gee_sorted_set_higher (self->priv->subset, "four")) == NULL);
			_g_free0 (_tmp2_);
			g_assert ((_tmp3_ = (char*) gee_sorted_set_higher (self->priv->subset, "six")) == NULL);
			_g_free0 (_tmp3_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			char* _tmp4_;
			char* _tmp5_;
			char* _tmp6_;
			char* _tmp7_;
			char* _tmp8_;
			g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_sorted_set_higher (self->priv->subset, "one"), "six") == 0);
			_g_free0 (_tmp4_);
			g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_sorted_set_higher (self->priv->subset, "six"), "three") == 0);
			_g_free0 (_tmp5_);
			g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_sorted_set_higher (self->priv->subset, "three"), "two") == 0);
			_g_free0 (_tmp6_);
			g_assert ((_tmp7_ = (char*) gee_sorted_set_higher (self->priv->subset, "two")) == NULL);
			_g_free0 (_tmp7_);
			g_assert ((_tmp8_ = (char*) gee_sorted_set_higher (self->priv->subset, "z")) == NULL);
			_g_free0 (_tmp8_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			char* _tmp9_;
			char* _tmp10_;
			char* _tmp11_;
			char* _tmp12_;
			char* _tmp13_;
			g_assert (_vala_strcmp0 (_tmp9_ = (char*) gee_sorted_set_higher (self->priv->subset, "five"), "four") == 0);
			_g_free0 (_tmp9_);
			g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_sorted_set_higher (self->priv->subset, "four"), "one") == 0);
			_g_free0 (_tmp10_);
			g_assert (_vala_strcmp0 (_tmp11_ = (char*) gee_sorted_set_higher (self->priv->subset, "one"), "six") == 0);
			_g_free0 (_tmp11_);
			g_assert ((_tmp12_ = (char*) gee_sorted_set_higher (self->priv->subset, "six")) == NULL);
			_g_free0 (_tmp12_);
			g_assert ((_tmp13_ = (char*) gee_sorted_set_higher (self->priv->subset, "three")) == NULL);
			_g_free0 (_tmp13_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			char* _tmp14_;
			g_assert ((_tmp14_ = (char*) gee_sorted_set_higher (self->priv->subset, "six")) == NULL);
			_g_free0 (_tmp14_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


void sorted_set_tests_sub_set_test_floor (SortedSetTestsSubSet* self) {
	g_return_if_fail (self != NULL);
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "one"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "two"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "three"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "four"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "five"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "six"));
	g_assert (gee_collection_get_size ((GeeCollection*) self->priv->master) == 6);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			char* _tmp0_;
			char* _tmp1_;
			char* _tmp2_;
			char* _tmp3_;
			g_assert ((_tmp0_ = (char*) gee_sorted_set_floor (self->priv->subset, "a")) == NULL);
			_g_free0 (_tmp0_);
			g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_sorted_set_floor (self->priv->subset, "five"), "five") == 0);
			_g_free0 (_tmp1_);
			g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_sorted_set_floor (self->priv->subset, "four"), "four") == 0);
			_g_free0 (_tmp2_);
			g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_sorted_set_floor (self->priv->subset, "six"), "four") == 0);
			_g_free0 (_tmp3_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			char* _tmp4_;
			char* _tmp5_;
			char* _tmp6_;
			char* _tmp7_;
			char* _tmp8_;
			g_assert ((_tmp4_ = (char*) gee_sorted_set_floor (self->priv->subset, "one")) == NULL);
			_g_free0 (_tmp4_);
			g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_sorted_set_floor (self->priv->subset, "six"), "six") == 0);
			_g_free0 (_tmp5_);
			g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_sorted_set_floor (self->priv->subset, "three"), "three") == 0);
			_g_free0 (_tmp6_);
			g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_sorted_set_floor (self->priv->subset, "two"), "two") == 0);
			_g_free0 (_tmp7_);
			g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_sorted_set_floor (self->priv->subset, "z"), "two") == 0);
			_g_free0 (_tmp8_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			char* _tmp9_;
			char* _tmp10_;
			char* _tmp11_;
			char* _tmp12_;
			char* _tmp13_;
			g_assert ((_tmp9_ = (char*) gee_sorted_set_floor (self->priv->subset, "five")) == NULL);
			_g_free0 (_tmp9_);
			g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_sorted_set_floor (self->priv->subset, "four"), "four") == 0);
			_g_free0 (_tmp10_);
			g_assert (_vala_strcmp0 (_tmp11_ = (char*) gee_sorted_set_floor (self->priv->subset, "one"), "one") == 0);
			_g_free0 (_tmp11_);
			g_assert (_vala_strcmp0 (_tmp12_ = (char*) gee_sorted_set_floor (self->priv->subset, "six"), "six") == 0);
			_g_free0 (_tmp12_);
			g_assert (_vala_strcmp0 (_tmp13_ = (char*) gee_sorted_set_floor (self->priv->subset, "three"), "six") == 0);
			_g_free0 (_tmp13_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			char* _tmp14_;
			g_assert ((_tmp14_ = (char*) gee_sorted_set_floor (self->priv->subset, "six")) == NULL);
			_g_free0 (_tmp14_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


void sorted_set_tests_sub_set_test_ceil (SortedSetTestsSubSet* self) {
	g_return_if_fail (self != NULL);
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "one"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "two"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "three"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "four"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "five"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "six"));
	g_assert (gee_collection_get_size ((GeeCollection*) self->priv->master) == 6);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			char* _tmp0_;
			char* _tmp1_;
			char* _tmp2_;
			char* _tmp3_;
			g_assert (_vala_strcmp0 (_tmp0_ = (char*) gee_sorted_set_ceil (self->priv->subset, "a"), "five") == 0);
			_g_free0 (_tmp0_);
			g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_sorted_set_ceil (self->priv->subset, "five"), "five") == 0);
			_g_free0 (_tmp1_);
			g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_sorted_set_ceil (self->priv->subset, "four"), "four") == 0);
			_g_free0 (_tmp2_);
			g_assert ((_tmp3_ = (char*) gee_sorted_set_ceil (self->priv->subset, "six")) == NULL);
			_g_free0 (_tmp3_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			char* _tmp4_;
			char* _tmp5_;
			char* _tmp6_;
			char* _tmp7_;
			char* _tmp8_;
			g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_sorted_set_ceil (self->priv->subset, "one"), "six") == 0);
			_g_free0 (_tmp4_);
			g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_sorted_set_ceil (self->priv->subset, "six"), "six") == 0);
			_g_free0 (_tmp5_);
			g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_sorted_set_ceil (self->priv->subset, "three"), "three") == 0);
			_g_free0 (_tmp6_);
			g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_sorted_set_ceil (self->priv->subset, "two"), "two") == 0);
			_g_free0 (_tmp7_);
			g_assert ((_tmp8_ = (char*) gee_sorted_set_ceil (self->priv->subset, "z")) == NULL);
			_g_free0 (_tmp8_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			char* _tmp9_;
			char* _tmp10_;
			char* _tmp11_;
			char* _tmp12_;
			char* _tmp13_;
			g_assert (_vala_strcmp0 (_tmp9_ = (char*) gee_sorted_set_ceil (self->priv->subset, "five"), "four") == 0);
			_g_free0 (_tmp9_);
			g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_sorted_set_ceil (self->priv->subset, "four"), "four") == 0);
			_g_free0 (_tmp10_);
			g_assert (_vala_strcmp0 (_tmp11_ = (char*) gee_sorted_set_ceil (self->priv->subset, "one"), "one") == 0);
			_g_free0 (_tmp11_);
			g_assert (_vala_strcmp0 (_tmp12_ = (char*) gee_sorted_set_ceil (self->priv->subset, "six"), "six") == 0);
			_g_free0 (_tmp12_);
			g_assert ((_tmp13_ = (char*) gee_sorted_set_ceil (self->priv->subset, "three")) == NULL);
			_g_free0 (_tmp13_);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			char* _tmp14_;
			g_assert ((_tmp14_ = (char*) gee_sorted_set_ceil (self->priv->subset, "six")) == NULL);
			_g_free0 (_tmp14_);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


void sorted_set_tests_sub_set_test_subsets (SortedSetTestsSubSet* self) {
	g_return_if_fail (self != NULL);
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "one"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "two"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "three"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "four"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "five"));
	g_assert (gee_collection_add ((GeeCollection*) self->priv->master, "six"));
	g_assert (gee_collection_get_size ((GeeCollection*) self->priv->master) == 6);
	switch (self->priv->type) {
		case SORTED_SET_TESTS_SUB_SET_TYPE_HEAD:
		{
			GeeSortedSet* subsubset;
			GeeSortedSet* _tmp0_;
			GeeSortedSet* _tmp1_;
			GeeSortedSet* _tmp2_;
			subsubset = gee_sorted_set_head_set (self->priv->subset, "four");
			g_assert (gee_collection_get_size ((GeeCollection*) subsubset) == 1);
			subsubset = (_tmp0_ = gee_sorted_set_tail_set (self->priv->subset, "four"), _g_object_unref0 (subsubset), _tmp0_);
			g_assert (gee_collection_get_size ((GeeCollection*) subsubset) == 1);
			subsubset = (_tmp1_ = gee_sorted_set_sub_set (self->priv->subset, "four", "one"), _g_object_unref0 (subsubset), _tmp1_);
			g_assert (gee_collection_get_size ((GeeCollection*) subsubset) == 1);
			subsubset = (_tmp2_ = gee_sorted_set_sub_set (self->priv->subset, "four", "four"), _g_object_unref0 (subsubset), _tmp2_);
			g_assert (gee_collection_get_size ((GeeCollection*) subsubset) == 0);
			_g_object_unref0 (subsubset);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_TAIL:
		{
			GeeSortedSet* subsubset;
			GeeSortedSet* _tmp3_;
			GeeSortedSet* _tmp4_;
			subsubset = gee_sorted_set_head_set (self->priv->subset, "two");
			g_assert (gee_collection_get_size ((GeeCollection*) subsubset) == 2);
			subsubset = (_tmp3_ = gee_sorted_set_tail_set (self->priv->subset, "three"), _g_object_unref0 (subsubset), _tmp3_);
			g_assert (gee_collection_get_size ((GeeCollection*) subsubset) == 2);
			subsubset = (_tmp4_ = gee_sorted_set_sub_set (self->priv->subset, "three", "two"), _g_object_unref0 (subsubset), _tmp4_);
			g_assert (gee_collection_get_size ((GeeCollection*) subsubset) == 1);
			_g_object_unref0 (subsubset);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_SUB:
		{
			GeeSortedSet* subsubset;
			GeeSortedSet* _tmp5_;
			GeeSortedSet* _tmp6_;
			GeeSortedSet* _tmp7_;
			subsubset = gee_sorted_set_head_set (self->priv->subset, "six");
			g_assert (gee_collection_get_size ((GeeCollection*) subsubset) == 2);
			subsubset = (_tmp5_ = gee_sorted_set_tail_set (self->priv->subset, "one"), _g_object_unref0 (subsubset), _tmp5_);
			g_assert (gee_collection_get_size ((GeeCollection*) subsubset) == 2);
			subsubset = (_tmp6_ = gee_sorted_set_sub_set (self->priv->subset, "one", "six"), _g_object_unref0 (subsubset), _tmp6_);
			g_assert (gee_collection_get_size ((GeeCollection*) subsubset) == 1);
			subsubset = (_tmp7_ = gee_sorted_set_sub_set (self->priv->subset, "five", "two"), _g_object_unref0 (subsubset), _tmp7_);
			g_assert (gee_collection_get_size ((GeeCollection*) subsubset) == 3);
			_g_object_unref0 (subsubset);
			break;
		}
		case SORTED_SET_TESTS_SUB_SET_TYPE_EMPTY:
		{
			GeeSortedSet* subsubset;
			GeeSortedSet* _tmp8_;
			GeeSortedSet* _tmp9_;
			subsubset = gee_sorted_set_head_set (self->priv->subset, "six");
			g_assert (gee_collection_get_size ((GeeCollection*) subsubset) == 0);
			subsubset = (_tmp8_ = gee_sorted_set_tail_set (self->priv->subset, "three"), _g_object_unref0 (subsubset), _tmp8_);
			g_assert (gee_collection_get_size ((GeeCollection*) subsubset) == 0);
			subsubset = (_tmp9_ = gee_sorted_set_sub_set (self->priv->subset, "one", "six"), _g_object_unref0 (subsubset), _tmp9_);
			g_assert (gee_collection_get_size ((GeeCollection*) subsubset) == 0);
			_g_object_unref0 (subsubset);
			break;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}


static void sorted_set_tests_sub_set_class_init (SortedSetTestsSubSetClass * klass) {
	sorted_set_tests_sub_set_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (SortedSetTestsSubSetPrivate));
	GEE_TEST_CASE_CLASS (klass)->set_up = sorted_set_tests_sub_set_real_set_up;
	GEE_TEST_CASE_CLASS (klass)->tear_down = sorted_set_tests_sub_set_real_tear_down;
	G_OBJECT_CLASS (klass)->finalize = sorted_set_tests_sub_set_finalize;
}


static void sorted_set_tests_sub_set_instance_init (SortedSetTestsSubSet * self) {
	self->priv = SORTED_SET_TESTS_SUB_SET_GET_PRIVATE (self);
}


static void sorted_set_tests_sub_set_finalize (GObject* obj) {
	SortedSetTestsSubSet * self;
	self = SORTED_SET_TESTS_SUB_SET (obj);
	_g_object_unref0 (self->priv->master);
	_g_object_unref0 (self->priv->subset);
	_g_object_unref0 (self->priv->test);
	G_OBJECT_CLASS (sorted_set_tests_sub_set_parent_class)->finalize (obj);
}


GType sorted_set_tests_sub_set_get_type (void) {
	static volatile gsize sorted_set_tests_sub_set_type_id__volatile = 0;
	if (g_once_init_enter (&sorted_set_tests_sub_set_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SortedSetTestsSubSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sorted_set_tests_sub_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SortedSetTestsSubSet), 0, (GInstanceInitFunc) sorted_set_tests_sub_set_instance_init, NULL };
		GType sorted_set_tests_sub_set_type_id;
		sorted_set_tests_sub_set_type_id = g_type_register_static (GEE_TYPE_TEST_CASE, "SortedSetTestsSubSet", &g_define_type_info, 0);
		g_once_init_leave (&sorted_set_tests_sub_set_type_id__volatile, sorted_set_tests_sub_set_type_id);
	}
	return sorted_set_tests_sub_set_type_id__volatile;
}


static void sorted_set_tests_class_init (SortedSetTestsClass * klass) {
	sorted_set_tests_parent_class = g_type_class_peek_parent (klass);
}


static void sorted_set_tests_instance_init (SortedSetTests * self) {
}


GType sorted_set_tests_get_type (void) {
	static volatile gsize sorted_set_tests_type_id__volatile = 0;
	if (g_once_init_enter (&sorted_set_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (SortedSetTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sorted_set_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SortedSetTests), 0, (GInstanceInitFunc) sorted_set_tests_instance_init, NULL };
		GType sorted_set_tests_type_id;
		sorted_set_tests_type_id = g_type_register_static (TYPE_SET_TESTS, "SortedSetTests", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
		g_once_init_leave (&sorted_set_tests_type_id__volatile, sorted_set_tests_type_id);
	}
	return sorted_set_tests_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




