/* testarraylist.c generated by valac, the Vala compiler
 * generated from testarraylist.vala, do not modify */

/* testarraylist.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 * Copyright (C) 2009  Didier Villevalois, Julien Peeters
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 * 	Julien Peeters <contact@julienpeeters.fr>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_TEST_CASE (gee_test_case_get_type ())
#define GEE_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TEST_CASE, GeeTestCase))
#define GEE_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TEST_CASE, GeeTestCaseClass))
#define GEE_IS_TEST_CASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TEST_CASE))
#define GEE_IS_TEST_CASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TEST_CASE))
#define GEE_TEST_CASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TEST_CASE, GeeTestCaseClass))

typedef struct _GeeTestCase GeeTestCase;
typedef struct _GeeTestCaseClass GeeTestCaseClass;
typedef struct _GeeTestCasePrivate GeeTestCasePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;

#define TYPE_LIST_TESTS (list_tests_get_type ())
#define LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LIST_TESTS, ListTests))
#define LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LIST_TESTS, ListTestsClass))
#define IS_LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LIST_TESTS))
#define IS_LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LIST_TESTS))
#define LIST_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LIST_TESTS, ListTestsClass))

typedef struct _ListTests ListTests;
typedef struct _ListTestsClass ListTestsClass;
typedef struct _ListTestsPrivate ListTestsPrivate;

#define TYPE_ARRAY_LIST_TESTS (array_list_tests_get_type ())
#define ARRAY_LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ARRAY_LIST_TESTS, ArrayListTests))
#define ARRAY_LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ARRAY_LIST_TESTS, ArrayListTestsClass))
#define IS_ARRAY_LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ARRAY_LIST_TESTS))
#define IS_ARRAY_LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ARRAY_LIST_TESTS))
#define ARRAY_LIST_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ARRAY_LIST_TESTS, ArrayListTestsClass))

typedef struct _ArrayListTests ArrayListTests;
typedef struct _ArrayListTestsClass ArrayListTestsClass;
typedef struct _ArrayListTestsPrivate ArrayListTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GeeTestCase {
	GObject parent_instance;
	GeeTestCasePrivate * priv;
};

struct _GeeTestCaseClass {
	GObjectClass parent_class;
	void (*set_up) (GeeTestCase* self);
	void (*tear_down) (GeeTestCase* self);
};

struct _CollectionTests {
	GeeTestCase parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* test_collection;
};

struct _CollectionTestsClass {
	GeeTestCaseClass parent_class;
};

struct _ListTests {
	CollectionTests parent_instance;
	ListTestsPrivate * priv;
};

struct _ListTestsClass {
	CollectionTestsClass parent_class;
	void (*test_duplicates_are_retained) (ListTests* self);
};

struct _ArrayListTests {
	ListTests parent_instance;
	ArrayListTestsPrivate * priv;
};

struct _ArrayListTestsClass {
	ListTestsClass parent_class;
};

typedef void (*GeeTestCaseTestMethod) (void* user_data);

static gpointer array_list_tests_parent_class = NULL;

GType gee_test_case_get_type (void);
GType collection_tests_get_type (void);
GType list_tests_get_type (void);
GType array_list_tests_get_type (void);
enum  {
	ARRAY_LIST_TESTS_DUMMY_PROPERTY
};
#define ARRAY_LIST_TESTS_BIG_SORT_SIZE 1000000
ListTests* list_tests_construct (GType object_type, const char* name);
void gee_test_case_add_test (GeeTestCase* self, const char* name, GeeTestCaseTestMethod test, void* test_target);
void array_list_tests_test_selected_functions (ArrayListTests* self);
static void _array_list_tests_test_selected_functions_gee_test_case_test_method (gpointer self);
void array_list_tests_test_gobject_properties (ArrayListTests* self);
static void _array_list_tests_test_gobject_properties_gee_test_case_test_method (gpointer self);
static void array_list_tests_test_small_sort (ArrayListTests* self);
static void _array_list_tests_test_small_sort_gee_test_case_test_method (gpointer self);
static void array_list_tests_test_big_sort (ArrayListTests* self);
static void _array_list_tests_test_big_sort_gee_test_case_test_method (gpointer self);
ArrayListTests* array_list_tests_new (void);
ArrayListTests* array_list_tests_construct (GType object_type);
static void array_list_tests_real_set_up (GeeTestCase* base);
static void array_list_tests_real_tear_down (GeeTestCase* base);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _array_list_tests_test_selected_functions_gee_test_case_test_method (gpointer self) {
	array_list_tests_test_selected_functions (self);
}


static void _array_list_tests_test_gobject_properties_gee_test_case_test_method (gpointer self) {
	array_list_tests_test_gobject_properties (self);
}


static void _array_list_tests_test_small_sort_gee_test_case_test_method (gpointer self) {
	array_list_tests_test_small_sort (self);
}


static void _array_list_tests_test_big_sort_gee_test_case_test_method (gpointer self) {
	array_list_tests_test_big_sort (self);
}


ArrayListTests* array_list_tests_construct (GType object_type) {
	ArrayListTests * self;
	self = (ArrayListTests*) list_tests_construct (object_type, "ArrayList");
	gee_test_case_add_test ((GeeTestCase*) self, "[ArrayList] selected functions", _array_list_tests_test_selected_functions_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[ArrayList] GObject properties", _array_list_tests_test_gobject_properties_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[ArrayList] small sort (insertion)", _array_list_tests_test_small_sort_gee_test_case_test_method, self);
	gee_test_case_add_test ((GeeTestCase*) self, "[ArrayList] big sort (timsort)", _array_list_tests_test_big_sort_gee_test_case_test_method, self);
	return self;
}


ArrayListTests* array_list_tests_new (void) {
	return array_list_tests_construct (TYPE_ARRAY_LIST_TESTS);
}


static void array_list_tests_real_set_up (GeeTestCase* base) {
	ArrayListTests * self;
	GeeCollection* _tmp0_;
	self = (ArrayListTests*) base;
	((CollectionTests*) self)->test_collection = (_tmp0_ = (GeeCollection*) gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, NULL), _g_object_unref0 (((CollectionTests*) self)->test_collection), _tmp0_);
}


static void array_list_tests_real_tear_down (GeeTestCase* base) {
	ArrayListTests * self;
	GeeCollection* _tmp0_;
	self = (ArrayListTests*) base;
	((CollectionTests*) self)->test_collection = (_tmp0_ = NULL, _g_object_unref0 (((CollectionTests*) self)->test_collection), _tmp0_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void array_list_tests_test_selected_functions (ArrayListTests* self) {
	GeeCollection* _tmp0_;
	GeeArrayList* test_list;
	g_return_if_fail (self != NULL);
	test_list = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_ARRAY_LIST (_tmp0_) ? ((GeeArrayList*) _tmp0_) : NULL));
	g_assert (test_list != NULL);
	g_assert (gee_array_list_get_equal_func (test_list) == g_str_equal);
	_g_object_unref0 (test_list);
}


void array_list_tests_test_gobject_properties (ArrayListTests* self) {
	GeeCollection* _tmp0_;
	GeeArrayList* test_list;
	GValue value = {0};
	GValue _tmp2_;
	GValue _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	test_list = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_ARRAY_LIST (_tmp0_) ? ((GeeArrayList*) _tmp0_) : NULL));
	g_assert (test_list != NULL);
	value = (_tmp2_ = (g_value_init (&_tmp1_, G_TYPE_POINTER), _tmp1_), G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL, _tmp2_);
	g_object_get_property ((GObject*) test_list, "equal-func", &value);
	g_assert (g_value_get_pointer (&value) == ((void*) gee_array_list_get_equal_func (test_list)));
	g_value_unset (&value);
	_g_object_unref0 (test_list);
	G_IS_VALUE (&value) ? (g_value_unset (&value), NULL) : NULL;
}


static void array_list_tests_test_small_sort (ArrayListTests* self) {
	GeeCollection* _tmp0_;
	GeeArrayList* test_list;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	char* _tmp12_;
	g_return_if_fail (self != NULL);
	test_list = _g_object_ref0 ((_tmp0_ = ((CollectionTests*) self)->test_collection, GEE_IS_ARRAY_LIST (_tmp0_) ? ((GeeArrayList*) _tmp0_) : NULL));
	g_assert (test_list != NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "one");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "two");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "three");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "four");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "five");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "six");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "seven");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "eight");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "nine");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "ten");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "eleven");
	gee_abstract_collection_add ((GeeAbstractCollection*) test_list, "twelve");
	gee_list_sort ((GeeList*) test_list, NULL);
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_abstract_list_get ((GeeAbstractList*) test_list, 0), "eight") == 0);
	_g_free0 (_tmp1_);
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_abstract_list_get ((GeeAbstractList*) test_list, 1), "eleven") == 0);
	_g_free0 (_tmp2_);
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_abstract_list_get ((GeeAbstractList*) test_list, 2), "five") == 0);
	_g_free0 (_tmp3_);
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_abstract_list_get ((GeeAbstractList*) test_list, 3), "four") == 0);
	_g_free0 (_tmp4_);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_abstract_list_get ((GeeAbstractList*) test_list, 4), "nine") == 0);
	_g_free0 (_tmp5_);
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_abstract_list_get ((GeeAbstractList*) test_list, 5), "one") == 0);
	_g_free0 (_tmp6_);
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_abstract_list_get ((GeeAbstractList*) test_list, 6), "seven") == 0);
	_g_free0 (_tmp7_);
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_abstract_list_get ((GeeAbstractList*) test_list, 7), "six") == 0);
	_g_free0 (_tmp8_);
	g_assert (_vala_strcmp0 (_tmp9_ = (char*) gee_abstract_list_get ((GeeAbstractList*) test_list, 8), "ten") == 0);
	_g_free0 (_tmp9_);
	g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_abstract_list_get ((GeeAbstractList*) test_list, 9), "three") == 0);
	_g_free0 (_tmp10_);
	g_assert (_vala_strcmp0 (_tmp11_ = (char*) gee_abstract_list_get ((GeeAbstractList*) test_list, 10), "twelve") == 0);
	_g_free0 (_tmp11_);
	g_assert (_vala_strcmp0 (_tmp12_ = (char*) gee_abstract_list_get ((GeeAbstractList*) test_list, 11), "two") == 0);
	_g_free0 (_tmp12_);
	_g_object_unref0 (test_list);
}


static void array_list_tests_test_big_sort (ArrayListTests* self) {
	GeeList* big_test_list;
	g_return_if_fail (self != NULL);
	big_test_list = (GeeList*) gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < ARRAY_LIST_TESTS_BIG_SORT_SIZE)) {
					break;
				}
				gee_collection_add ((GeeCollection*) big_test_list, GINT_TO_POINTER (g_random_int_range ((gint32) 1, (gint32) (ARRAY_LIST_TESTS_BIG_SORT_SIZE - 1))));
			}
		}
	}
	gee_list_sort (big_test_list, NULL);
	{
		gint i;
		i = 1;
		{
			gboolean _tmp1_;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					i++;
				}
				_tmp1_ = FALSE;
				if (!(i < ARRAY_LIST_TESTS_BIG_SORT_SIZE)) {
					break;
				}
				g_assert (GPOINTER_TO_INT (gee_list_get (big_test_list, i - 1)) <= GPOINTER_TO_INT (gee_list_get (big_test_list, i)));
			}
		}
	}
	_g_object_unref0 (big_test_list);
}


static void array_list_tests_class_init (ArrayListTestsClass * klass) {
	array_list_tests_parent_class = g_type_class_peek_parent (klass);
	GEE_TEST_CASE_CLASS (klass)->set_up = array_list_tests_real_set_up;
	GEE_TEST_CASE_CLASS (klass)->tear_down = array_list_tests_real_tear_down;
}


static void array_list_tests_instance_init (ArrayListTests * self) {
}


GType array_list_tests_get_type (void) {
	static volatile gsize array_list_tests_type_id__volatile = 0;
	if (g_once_init_enter (&array_list_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ArrayListTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) array_list_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ArrayListTests), 0, (GInstanceInitFunc) array_list_tests_instance_init, NULL };
		GType array_list_tests_type_id;
		array_list_tests_type_id = g_type_register_static (TYPE_LIST_TESTS, "ArrayListTests", &g_define_type_info, 0);
		g_once_init_leave (&array_list_tests_type_id__volatile, array_list_tests_type_id);
	}
	return array_list_tests_type_id__volatile;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




