/* functions.c generated by valac, the Vala compiler
 * generated from functions.vala, do not modify */

/* functions.vala
 *
 * Copyright (C) 2009  Didier Villevalois, Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes' Villevalois <ptitjes@free.fr>
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>


#define GEE_TYPE_COMPARABLE (gee_comparable_get_type ())
#define GEE_COMPARABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COMPARABLE, GeeComparable))
#define GEE_IS_COMPARABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COMPARABLE))
#define GEE_COMPARABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COMPARABLE, GeeComparableIface))

typedef struct _GeeComparable GeeComparable;
typedef struct _GeeComparableIface GeeComparableIface;

struct _GeeComparableIface {
	GTypeInterface parent_iface;
	gint (*compare_to) (GeeComparable* self, gconstpointer object);
};



GEqualFunc gee_functions_get_equal_func_for (GType t);
GHashFunc gee_functions_get_hash_func_for (GType t);
GType gee_comparable_get_type (void);
gint gee_comparable_compare_to (GeeComparable* self, gconstpointer object);
gint gee_direct_compare (void* _val1, void* _val2);
GCompareFunc gee_functions_get_compare_func_for (GType t);



GEqualFunc gee_functions_get_equal_func_for (GType t) {
	GEqualFunc result = NULL;
	if (t == G_TYPE_STRING) {
		result = g_str_equal;
		return result;
	} else {
		result = g_direct_equal;
		return result;
	}
}


GHashFunc gee_functions_get_hash_func_for (GType t) {
	GHashFunc result = NULL;
	if (t == G_TYPE_STRING) {
		result = g_str_hash;
		return result;
	} else {
		result = g_direct_hash;
		return result;
	}
}


GCompareFunc gee_functions_get_compare_func_for (GType t) {
	GCompareFunc result = NULL;
	if (t == G_TYPE_STRING) {
		result = (GCompareFunc) g_strcmp0;
		return result;
	} else {
		if (g_type_is_a (t, GEE_TYPE_COMPARABLE)) {
			result = (GCompareFunc) gee_comparable_compare_to;
			return result;
		} else {
			result = (GCompareFunc) gee_direct_compare;
			return result;
		}
	}
}


gint gee_direct_compare (void* _val1, void* _val2) {
	gint result = 0;
	glong val1;
	glong val2;
	val1 = (glong) _val1;
	val2 = (glong) _val2;
	if (val1 > val2) {
		result = 1;
		return result;
	} else {
		if (val1 == val2) {
			result = 0;
			return result;
		} else {
			result = -1;
			return result;
		}
	}
}




