/* treeset.c generated by valac, the Vala compiler
 * generated from treeset.vala, do not modify */

/* treeset.vala
 *
 * Copyright (C) 2009  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_ABSTRACT_COLLECTION (gee_abstract_collection_get_type ())
#define GEE_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection))
#define GEE_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))
#define GEE_IS_ABSTRACT_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_IS_ABSTRACT_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ABSTRACT_COLLECTION))
#define GEE_ABSTRACT_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollectionClass))

typedef struct _GeeAbstractCollection GeeAbstractCollection;
typedef struct _GeeAbstractCollectionClass GeeAbstractCollectionClass;
typedef struct _GeeAbstractCollectionPrivate GeeAbstractCollectionPrivate;

#define GEE_TYPE_SET (gee_set_get_type ())
#define GEE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SET, GeeSet))
#define GEE_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SET))
#define GEE_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SET, GeeSetIface))

typedef struct _GeeSet GeeSet;
typedef struct _GeeSetIface GeeSetIface;

#define GEE_TYPE_TREE_SET (gee_tree_set_get_type ())
#define GEE_TREE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TREE_SET, GeeTreeSet))
#define GEE_TREE_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_TREE_SET, GeeTreeSetClass))
#define GEE_IS_TREE_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TREE_SET))
#define GEE_IS_TREE_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_TREE_SET))
#define GEE_TREE_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_TREE_SET, GeeTreeSetClass))

typedef struct _GeeTreeSet GeeTreeSet;
typedef struct _GeeTreeSetClass GeeTreeSetClass;
typedef struct _GeeTreeSetPrivate GeeTreeSetPrivate;
typedef struct _GeeTreeSetNode GeeTreeSetNode;
#define _gee_tree_set_node_free0(var) ((var == NULL) ? NULL : (var = (gee_tree_set_node_free (var), NULL)))

#define GEE_TREE_SET_NODE_TYPE_COLOR (gee_tree_set_node_color_get_type ())

#define GEE_TREE_SET_TYPE_ITERATOR (gee_tree_set_iterator_get_type ())
#define GEE_TREE_SET_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TREE_SET_TYPE_ITERATOR, GeeTreeSetIterator))
#define GEE_TREE_SET_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TREE_SET_TYPE_ITERATOR, GeeTreeSetIteratorClass))
#define GEE_TREE_SET_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TREE_SET_TYPE_ITERATOR))
#define GEE_TREE_SET_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TREE_SET_TYPE_ITERATOR))
#define GEE_TREE_SET_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TREE_SET_TYPE_ITERATOR, GeeTreeSetIteratorClass))

typedef struct _GeeTreeSetIterator GeeTreeSetIterator;
typedef struct _GeeTreeSetIteratorClass GeeTreeSetIteratorClass;
typedef struct _GeeTreeSetIteratorPrivate GeeTreeSetIteratorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GeeIterator* (*iterator) (GeeIterable* self);
	GType (*get_element_type) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
};

struct _GeeAbstractCollection {
	GObject parent_instance;
	GeeAbstractCollectionPrivate * priv;
};

struct _GeeAbstractCollectionClass {
	GObjectClass parent_class;
	gboolean (*contains) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*add) (GeeAbstractCollection* self, gconstpointer item);
	gboolean (*remove) (GeeAbstractCollection* self, gconstpointer item);
	void (*clear) (GeeAbstractCollection* self);
	gpointer* (*to_array) (GeeAbstractCollection* self, int* result_length1);
	gboolean (*add_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeAbstractCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeAbstractCollection* self, GeeCollection* collection);
	GeeIterator* (*iterator) (GeeAbstractCollection* self);
	gint (*get_size) (GeeAbstractCollection* self);
	gboolean (*get_is_empty) (GeeAbstractCollection* self);
};

struct _GeeSetIface {
	GTypeInterface parent_iface;
};

struct _GeeTreeSet {
	GeeAbstractCollection parent_instance;
	GeeTreeSetPrivate * priv;
};

struct _GeeTreeSetClass {
	GeeAbstractCollectionClass parent_class;
};

struct _GeeTreeSetPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GCompareFunc _compare_func;
	gint _size;
	GeeTreeSetNode* root;
	GeeTreeSetNode* first;
	gint stamp;
};

typedef enum  {
	GEE_TREE_SET_NODE_COLOR_RED,
	GEE_TREE_SET_NODE_COLOR_BLACK
} GeeTreeSetNodeColor;

struct _GeeTreeSetNode {
	gpointer key;
	GeeTreeSetNodeColor color;
	GeeTreeSetNode* left;
	GeeTreeSetNode* right;
	GeeTreeSetNode* prev;
	GeeTreeSetNode* next;
};

struct _GeeTreeSetIterator {
	GObject parent_instance;
	GeeTreeSetIteratorPrivate * priv;
};

struct _GeeTreeSetIteratorClass {
	GObjectClass parent_class;
};

struct _GeeTreeSetIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
	GeeTreeSet* _set;
	gint stamp;
	GeeTreeSetNode* current;
	gboolean run;
};


static gpointer gee_tree_set_iterator_parent_class = NULL;
static GeeIteratorIface* gee_tree_set_iterator_gee_iterator_parent_iface = NULL;
static gpointer gee_tree_set_parent_class = NULL;
static GeeSetIface* gee_tree_set_gee_set_parent_iface = NULL;

GType gee_iterator_get_type (void);
GType gee_iterable_get_type (void);
GType gee_collection_get_type (void);
GType gee_abstract_collection_get_type (void);
GType gee_set_get_type (void);
GType gee_tree_set_get_type (void);
#define GEE_TREE_SET_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_TREE_SET, GeeTreeSetPrivate))
enum  {
	GEE_TREE_SET_DUMMY_PROPERTY,
	GEE_TREE_SET_SIZE,
	GEE_TREE_SET_COMPARE_FUNC,
	GEE_TREE_SET_G_TYPE,
	GEE_TREE_SET_G_DUP_FUNC,
	GEE_TREE_SET_G_DESTROY_FUNC
};
GeeAbstractCollection* gee_abstract_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
GCompareFunc gee_functions_get_compare_func_for (GType t);
static void gee_tree_set_set_compare_func (GeeTreeSet* self, GCompareFunc value);
GeeTreeSet* gee_tree_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func);
GeeTreeSet* gee_tree_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func);
GCompareFunc gee_tree_set_get_compare_func (GeeTreeSet* self);
GType gee_tree_set_node_color_get_type (void);
static gboolean gee_tree_set_real_contains (GeeAbstractCollection* base, gconstpointer item);
static void gee_tree_set_rotate_right (GeeTreeSet* self, GeeTreeSetNode** root);
static void gee_tree_set_rotate_left (GeeTreeSet* self, GeeTreeSetNode** root);
static gboolean gee_tree_set_is_red (GeeTreeSet* self, GeeTreeSetNode* n);
static gboolean gee_tree_set_is_black (GeeTreeSet* self, GeeTreeSetNode* n);
static void gee_tree_set_fix_up (GeeTreeSet* self, GeeTreeSetNode** node);
static GeeTreeSetNode* gee_tree_set_node_new (gpointer node, GeeTreeSetNode* prev, GeeTreeSetNode* next);
static GeeTreeSetNode* gee_tree_set_node_new (gpointer node, GeeTreeSetNode* prev, GeeTreeSetNode* next);
static void gee_tree_set_node_flip (GeeTreeSetNode* self);
static gboolean gee_tree_set_add_to_node (GeeTreeSet* self, GeeTreeSetNode** node, gpointer item, GeeTreeSetNode* prev, GeeTreeSetNode* next);
static gboolean gee_tree_set_real_add (GeeAbstractCollection* base, gconstpointer item);
static void gee_tree_set_move_red_left (GeeTreeSet* self, GeeTreeSetNode** root);
static void gee_tree_set_move_red_right (GeeTreeSet* self, GeeTreeSetNode** root);
static void gee_tree_set_remove_minimal (GeeTreeSet* self, GeeTreeSetNode** node, gpointer* key);
static gboolean gee_tree_set_remove_from_node (GeeTreeSet* self, GeeTreeSetNode** node, gconstpointer item);
static gboolean gee_tree_set_real_remove (GeeAbstractCollection* base, gconstpointer item);
static void gee_tree_set_real_clear (GeeAbstractCollection* base);
static GeeTreeSetIterator* gee_tree_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set);
static GeeTreeSetIterator* gee_tree_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set);
static GType gee_tree_set_iterator_get_type (void);
static GeeIterator* gee_tree_set_real_iterator (GeeAbstractCollection* base);
static void gee_tree_set_node_free (GeeTreeSetNode* self);
static GeeTreeSetNodeColor gee_tree_set_node_color_flip (GeeTreeSetNodeColor self);
static void gee_tree_set_node_instance_init (GeeTreeSetNode * self);
#define GEE_TREE_SET_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TREE_SET_TYPE_ITERATOR, GeeTreeSetIteratorPrivate))
enum  {
	GEE_TREE_SET_ITERATOR_DUMMY_PROPERTY,
	GEE_TREE_SET_ITERATOR_SET,
	GEE_TREE_SET_ITERATOR_G_TYPE,
	GEE_TREE_SET_ITERATOR_G_DUP_FUNC,
	GEE_TREE_SET_ITERATOR_G_DESTROY_FUNC
};
static void gee_tree_set_iterator_set_set (GeeTreeSetIterator* self, GeeTreeSet* value);
static GeeTreeSet* gee_tree_set_iterator_get_set (GeeTreeSetIterator* self);
static gboolean gee_tree_set_iterator_real_next (GeeIterator* base);
static gpointer gee_tree_set_iterator_real_get (GeeIterator* base);
static GObject * gee_tree_set_iterator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void gee_tree_set_iterator_finalize (GObject* obj);
static void gee_tree_set_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_tree_set_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void gee_tree_set_finalize (GObject* obj);
gint gee_abstract_collection_get_size (GeeAbstractCollection* self);
static void gee_tree_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void gee_tree_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);



GeeTreeSet* gee_tree_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func) {
	GeeTreeSet * self;
	self = (GeeTreeSet*) gee_abstract_collection_construct (object_type, g_type, (GBoxedCopyFunc) g_dup_func, g_destroy_func);
	self->priv->g_type = g_type;
	self->priv->g_dup_func = g_dup_func;
	self->priv->g_destroy_func = g_destroy_func;
	if (compare_func == NULL) {
		compare_func = gee_functions_get_compare_func_for (g_type);
	}
	gee_tree_set_set_compare_func (self, compare_func);
	return self;
}


GeeTreeSet* gee_tree_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GCompareFunc compare_func) {
	return gee_tree_set_construct (GEE_TYPE_TREE_SET, g_type, g_dup_func, g_destroy_func, compare_func);
}


static gboolean gee_tree_set_real_contains (GeeAbstractCollection* base, gconstpointer item) {
	GeeTreeSet * self;
	gboolean result;
	GeeTreeSetNode* cur;
	self = (GeeTreeSet*) base;
	cur = self->priv->root;
	while (TRUE) {
		gint res;
		if (!(cur != NULL)) {
			break;
		}
		res = gee_tree_set_get_compare_func (self) (item, cur->key);
		if (res == 0) {
			result = TRUE;
			return result;
		} else {
			if (res < 0) {
				cur = cur->left;
			} else {
				cur = cur->right;
			}
		}
	}
	result = FALSE;
	return result;
}


static void gee_tree_set_rotate_right (GeeTreeSet* self, GeeTreeSetNode** root) {
	GeeTreeSetNode* _tmp0_;
	GeeTreeSetNode* pivot;
	GeeTreeSetNode* _tmp2_;
	GeeTreeSetNode* _tmp1_;
	GeeTreeSetNode* _tmp4_;
	GeeTreeSetNode* _tmp3_;
	GeeTreeSetNode* _tmp6_;
	GeeTreeSetNode* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root != NULL);
	pivot = (_tmp0_ = (*root)->left, (*root)->left = NULL, _tmp0_);
	pivot->color = (*root)->color;
	(*root)->color = GEE_TREE_SET_NODE_COLOR_RED;
	(*root)->left = (_tmp2_ = (_tmp1_ = pivot->right, pivot->right = NULL, _tmp1_), _gee_tree_set_node_free0 ((*root)->left), _tmp2_);
	pivot->right = (_tmp4_ = (_tmp3_ = *root, *root = NULL, _tmp3_), _gee_tree_set_node_free0 (pivot->right), _tmp4_);
	*root = (_tmp6_ = (_tmp5_ = pivot, pivot = NULL, _tmp5_), _gee_tree_set_node_free0 (*root), _tmp6_);
	_gee_tree_set_node_free0 (pivot);
}


static void gee_tree_set_rotate_left (GeeTreeSet* self, GeeTreeSetNode** root) {
	GeeTreeSetNode* _tmp0_;
	GeeTreeSetNode* pivot;
	GeeTreeSetNode* _tmp2_;
	GeeTreeSetNode* _tmp1_;
	GeeTreeSetNode* _tmp4_;
	GeeTreeSetNode* _tmp3_;
	GeeTreeSetNode* _tmp6_;
	GeeTreeSetNode* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (root != NULL);
	pivot = (_tmp0_ = (*root)->right, (*root)->right = NULL, _tmp0_);
	pivot->color = (*root)->color;
	(*root)->color = GEE_TREE_SET_NODE_COLOR_RED;
	(*root)->right = (_tmp2_ = (_tmp1_ = pivot->left, pivot->left = NULL, _tmp1_), _gee_tree_set_node_free0 ((*root)->right), _tmp2_);
	pivot->left = (_tmp4_ = (_tmp3_ = *root, *root = NULL, _tmp3_), _gee_tree_set_node_free0 (pivot->left), _tmp4_);
	*root = (_tmp6_ = (_tmp5_ = pivot, pivot = NULL, _tmp5_), _gee_tree_set_node_free0 (*root), _tmp6_);
	_gee_tree_set_node_free0 (pivot);
}


static gboolean gee_tree_set_is_red (GeeTreeSet* self, GeeTreeSetNode* n) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (n != NULL) {
		_tmp0_ = n->color == GEE_TREE_SET_NODE_COLOR_RED;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}


static gboolean gee_tree_set_is_black (GeeTreeSet* self, GeeTreeSetNode* n) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if (n == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = n->color == GEE_TREE_SET_NODE_COLOR_BLACK;
	}
	result = _tmp0_;
	return result;
}


static void gee_tree_set_fix_up (GeeTreeSet* self, GeeTreeSetNode** node) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	if (gee_tree_set_is_black (self, (*node)->left)) {
		_tmp0_ = gee_tree_set_is_red (self, (*node)->right);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gee_tree_set_rotate_left (self, node);
	}
	if (gee_tree_set_is_red (self, (*node)->left)) {
		_tmp1_ = gee_tree_set_is_black (self, (*node)->right);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gee_tree_set_rotate_right (self, node);
	}
}


static gboolean gee_tree_set_add_to_node (GeeTreeSet* self, GeeTreeSetNode** node, gpointer item, GeeTreeSetNode* prev, GeeTreeSetNode* next) {
	gboolean result;
	gboolean _tmp2_ = FALSE;
	gint cmp;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*node) == NULL) {
		GeeTreeSetNode* _tmp1_;
		gpointer _tmp0_;
		*node = (_tmp1_ = gee_tree_set_node_new ((_tmp0_ = item, item = NULL, _tmp0_), prev, next), _gee_tree_set_node_free0 (*node), _tmp1_);
		if (prev == NULL) {
			self->priv->first = *node;
		}
		self->priv->_size++;
		result = TRUE;
		((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		return result;
	}
	if (gee_tree_set_is_red (self, (*node)->left)) {
		_tmp2_ = gee_tree_set_is_red (self, (*node)->right);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gee_tree_set_node_flip (*node);
	}
	cmp = gee_tree_set_get_compare_func (self) (item, (*node)->key);
	if (cmp == 0) {
		gee_tree_set_fix_up (self, node);
		result = FALSE;
		((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
		return result;
	} else {
		if (cmp < 0) {
			gconstpointer _tmp3_;
			gboolean r;
			r = gee_tree_set_add_to_node (self, &(*node)->left, (_tmp3_ = item, ((_tmp3_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp3_) : self->priv->g_dup_func ((gpointer) _tmp3_)), (*node)->prev, *node);
			gee_tree_set_fix_up (self, node);
			result = r;
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
			return result;
		} else {
			gconstpointer _tmp4_;
			gboolean r;
			r = gee_tree_set_add_to_node (self, &(*node)->right, (_tmp4_ = item, ((_tmp4_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp4_) : self->priv->g_dup_func ((gpointer) _tmp4_)), *node, (*node)->next);
			gee_tree_set_fix_up (self, node);
			result = r;
			((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
			return result;
		}
	}
	((item == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (item = (self->priv->g_destroy_func (item), NULL));
}


static gboolean gee_tree_set_real_add (GeeAbstractCollection* base, gconstpointer item) {
	GeeTreeSet * self;
	gboolean result;
	gconstpointer _tmp0_;
	gboolean r;
	self = (GeeTreeSet*) base;
	r = gee_tree_set_add_to_node (self, &self->priv->root, (_tmp0_ = item, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_)), NULL, NULL);
	self->priv->root->color = GEE_TREE_SET_NODE_COLOR_BLACK;
	self->priv->stamp++;
	result = r;
	return result;
}


static void gee_tree_set_move_red_left (GeeTreeSet* self, GeeTreeSetNode** root) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (root != NULL);
	gee_tree_set_node_flip (*root);
	if (gee_tree_set_is_red (self, (*root)->right->left)) {
		gee_tree_set_rotate_right (self, &(*root)->right);
		gee_tree_set_rotate_left (self, root);
		gee_tree_set_node_flip (*root);
	}
}


static void gee_tree_set_move_red_right (GeeTreeSet* self, GeeTreeSetNode** root) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (root != NULL);
	gee_tree_set_node_flip (*root);
	if (gee_tree_set_is_red (self, (*root)->left->left)) {
		gee_tree_set_rotate_right (self, &(*root)->right);
		gee_tree_set_node_flip (*root);
	}
}


static void gee_tree_set_remove_minimal (GeeTreeSet* self, GeeTreeSetNode** node, gpointer* key) {
	gboolean _tmp4_ = FALSE;
	gpointer _tmp6_;
	gpointer _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	if ((*node)->left == NULL) {
		GeeTreeSetNode* _tmp0_;
		GeeTreeSetNode* n;
		gpointer _tmp2_;
		gpointer _tmp1_;
		GeeTreeSetNode* _tmp3_;
		n = (_tmp0_ = *node, *node = NULL, _tmp0_);
		*key = (_tmp2_ = (_tmp1_ = n->key, n->key = NULL, _tmp1_), (((*key) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (*key = (self->priv->g_destroy_func (*key), NULL)), _tmp2_);
		*node = (_tmp3_ = NULL, _gee_tree_set_node_free0 (*node), _tmp3_);
		_gee_tree_set_node_free0 (n);
		return;
	}
	if (gee_tree_set_is_black (self, (*node)->left)) {
		_tmp4_ = gee_tree_set_is_black (self, (*node)->left->left);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		gee_tree_set_move_red_left (self, node);
	}
	gee_tree_set_remove_minimal (self, &(*node)->left, &_tmp5_);
	*key = (_tmp6_ = _tmp5_, (((*key) == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : (*key = (self->priv->g_destroy_func (*key), NULL)), _tmp6_);
	gee_tree_set_fix_up (self, node);
}


static gboolean gee_tree_set_remove_from_node (GeeTreeSet* self, GeeTreeSetNode** node, gconstpointer item) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*node) == NULL) {
		result = FALSE;
		return result;
	} else {
		if (gee_tree_set_get_compare_func (self) (item, (*node)->key) < 0) {
			GeeTreeSetNode* left;
			gboolean _tmp0_ = FALSE;
			gboolean r;
			left = (*node)->left;
			if (left == NULL) {
				result = FALSE;
				return result;
			}
			if (gee_tree_set_is_black (self, left)) {
				_tmp0_ = gee_tree_set_is_black (self, left->left);
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				gee_tree_set_move_red_left (self, node);
			}
			r = gee_tree_set_remove_from_node (self, &(*node)->left, item);
			gee_tree_set_fix_up (self, node);
			result = r;
			return result;
		} else {
			GeeTreeSetNode* r;
			gboolean _tmp1_ = FALSE;
			gboolean _tmp3_ = FALSE;
			if (gee_tree_set_is_red (self, (*node)->left)) {
				gee_tree_set_rotate_right (self, node);
			}
			r = (*node)->right;
			if (gee_tree_set_get_compare_func (self) (item, (*node)->key) == 0) {
				_tmp1_ = r == NULL;
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				GeeTreeSetNode* _tmp2_;
				*node = (_tmp2_ = NULL, _gee_tree_set_node_free0 (*node), _tmp2_);
				self->priv->_size--;
				result = TRUE;
				return result;
			}
			if (gee_tree_set_is_black (self, r)) {
				_tmp3_ = gee_tree_set_is_black (self, r->left);
			} else {
				_tmp3_ = FALSE;
			}
			if (_tmp3_) {
				gee_tree_set_move_red_right (self, node);
			}
			if (gee_tree_set_get_compare_func (self) (item, (*node)->key) == 0) {
				gpointer _tmp5_;
				gpointer _tmp4_ = NULL;
				gee_tree_set_remove_minimal (self, &(*node)->right, &_tmp4_);
				(*node)->key = (_tmp5_ = _tmp4_, (((*node)->key == NULL) || (self->priv->g_destroy_func == NULL)) ? NULL : ((*node)->key = (self->priv->g_destroy_func ((*node)->key), NULL)), _tmp5_);
				gee_tree_set_fix_up (self, node);
				self->priv->_size--;
				result = TRUE;
				return result;
			} else {
				gboolean re;
				re = gee_tree_set_remove_from_node (self, &(*node)->right, item);
				gee_tree_set_fix_up (self, node);
				result = re;
				return result;
			}
		}
	}
}


static gboolean gee_tree_set_real_remove (GeeAbstractCollection* base, gconstpointer item) {
	GeeTreeSet * self;
	gboolean result;
	gboolean b;
	self = (GeeTreeSet*) base;
	b = gee_tree_set_remove_from_node (self, &self->priv->root, item);
	if (self->priv->root != NULL) {
		self->priv->root->color = GEE_TREE_SET_NODE_COLOR_BLACK;
	}
	self->priv->stamp++;
	result = b;
	return result;
}


static void gee_tree_set_real_clear (GeeAbstractCollection* base) {
	GeeTreeSet * self;
	GeeTreeSetNode* _tmp0_;
	self = (GeeTreeSet*) base;
	self->priv->root = (_tmp0_ = NULL, _gee_tree_set_node_free0 (self->priv->root), _tmp0_);
	self->priv->_size = 0;
	self->priv->stamp++;
}


static GeeIterator* gee_tree_set_real_iterator (GeeAbstractCollection* base) {
	GeeTreeSet * self;
	GeeIterator* result;
	self = (GeeTreeSet*) base;
	result = (GeeIterator*) gee_tree_set_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func, self);
	return result;
}


static gint gee_tree_set_real_get_size (GeeAbstractCollection* base) {
	gint result;
	GeeTreeSet* self;
	self = (GeeTreeSet*) base;
	result = self->priv->_size;
	return result;
}


GCompareFunc gee_tree_set_get_compare_func (GeeTreeSet* self) {
	GCompareFunc result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_compare_func;
	return result;
}


static void gee_tree_set_set_compare_func (GeeTreeSet* self, GCompareFunc value) {
	g_return_if_fail (self != NULL);
	self->priv->_compare_func = value;
	g_object_notify ((GObject *) self, "compare-func");
}


static GeeTreeSetNodeColor gee_tree_set_node_color_flip (GeeTreeSetNodeColor self) {
	GeeTreeSetNodeColor result;
	if (self == GEE_TREE_SET_NODE_COLOR_RED) {
		result = GEE_TREE_SET_NODE_COLOR_BLACK;
		return result;
	} else {
		result = GEE_TREE_SET_NODE_COLOR_RED;
		return result;
	}
}



GType gee_tree_set_node_color_get_type (void) {
	static GType gee_tree_set_node_color_type_id = 0;
	if (G_UNLIKELY (gee_tree_set_node_color_type_id == 0)) {
		static const GEnumValue values[] = {{GEE_TREE_SET_NODE_COLOR_RED, "GEE_TREE_SET_NODE_COLOR_RED", "red"}, {GEE_TREE_SET_NODE_COLOR_BLACK, "GEE_TREE_SET_NODE_COLOR_BLACK", "black"}, {0, NULL, NULL}};
		gee_tree_set_node_color_type_id = g_enum_register_static ("GeeTreeSetNodeColor", values);
	}
	return gee_tree_set_node_color_type_id;
}


static GeeTreeSetNode* gee_tree_set_node_new (gpointer node, GeeTreeSetNode* prev, GeeTreeSetNode* next) {
	GeeTreeSetNode* self;
	gpointer _tmp0_;
	self = g_slice_new0 (GeeTreeSetNode);
	gee_tree_set_node_instance_init (self);
	self->key = (_tmp0_ = node, node = NULL, _tmp0_);
	self->color = GEE_TREE_SET_NODE_COLOR_RED;
	self->prev = prev;
	self->next = next;
	if (prev != NULL) {
		prev->next = self;
	}
	if (next != NULL) {
		next->prev = self;
	}
	return self;
}


static void gee_tree_set_node_flip (GeeTreeSetNode* self) {
	g_return_if_fail (self != NULL);
	gee_tree_set_node_color_flip (self->color);
	if (self->left != NULL) {
		self->left->color = gee_tree_set_node_color_flip (self->left->color);
	}
	if (self->right != NULL) {
		self->right->color = gee_tree_set_node_color_flip (self->right->color);
	}
}


static void gee_tree_set_node_instance_init (GeeTreeSetNode * self) {
}


static void gee_tree_set_node_free (GeeTreeSetNode* self) {
	_gee_tree_set_node_free0 (self->left);
	_gee_tree_set_node_free0 (self->right);
	{
		if (self->prev != NULL) {
			self->prev->next = self->next;
		}
		if (self->next != NULL) {
			self->next->prev = self->prev;
		}
	}
	g_slice_free (GeeTreeSetNode, self);
}


static GeeTreeSetIterator* gee_tree_set_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set) {
	GParameter * __params;
	GParameter * __params_it;
	GeeTreeSetIterator * self;
	g_return_val_if_fail (set != NULL, NULL);
	__params = g_new0 (GParameter, 4);
	__params_it = __params;
	__params_it->name = "g-type";
	g_value_init (&__params_it->value, G_TYPE_GTYPE);
	g_value_set_gtype (&__params_it->value, g_type);
	__params_it++;
	__params_it->name = "g-dup-func";
	g_value_init (&__params_it->value, G_TYPE_POINTER);
	g_value_set_pointer (&__params_it->value, g_dup_func);
	__params_it++;
	__params_it->name = "g-destroy-func";
	g_value_init (&__params_it->value, G_TYPE_POINTER);
	g_value_set_pointer (&__params_it->value, g_destroy_func);
	__params_it++;
	__params_it->name = "set";
	g_value_init (&__params_it->value, GEE_TYPE_TREE_SET);
	g_value_set_object (&__params_it->value, set);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static GeeTreeSetIterator* gee_tree_set_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeTreeSet* set) {
	return gee_tree_set_iterator_construct (GEE_TREE_SET_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func, set);
}


static gboolean gee_tree_set_iterator_real_next (GeeIterator* base) {
	GeeTreeSetIterator * self;
	gboolean result;
	self = (GeeTreeSetIterator*) base;
	if (self->priv->current != NULL) {
		self->priv->current = self->priv->current->next;
		result = self->priv->current != NULL;
		return result;
	} else {
		if (!self->priv->run) {
			self->priv->run = TRUE;
			self->priv->current = self->priv->_set->priv->first;
			result = self->priv->current != NULL;
			return result;
		} else {
			result = FALSE;
			return result;
		}
	}
}


static gpointer gee_tree_set_iterator_real_get (GeeIterator* base) {
	GeeTreeSetIterator * self;
	gpointer result;
	gconstpointer _tmp0_;
	self = (GeeTreeSetIterator*) base;
	g_assert (self->priv->stamp == self->priv->_set->priv->stamp);
	g_assert (self->priv->current != NULL);
	result = (_tmp0_ = self->priv->current->key, ((_tmp0_ == NULL) || (self->priv->g_dup_func == NULL)) ? ((gpointer) _tmp0_) : self->priv->g_dup_func ((gpointer) _tmp0_));
	return result;
}


static GeeTreeSet* gee_tree_set_iterator_get_set (GeeTreeSetIterator* self) {
	GeeTreeSet* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_set;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void gee_tree_set_iterator_set_set (GeeTreeSetIterator* self, GeeTreeSet* value) {
	GeeTreeSet* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_set = (_tmp0_ = _g_object_ref0 (value), _g_object_unref0 (self->priv->_set), _tmp0_);
	g_object_notify ((GObject *) self, "set");
}


static GObject * gee_tree_set_iterator_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GeeTreeSetIterator * self;
	parent_class = G_OBJECT_CLASS (gee_tree_set_iterator_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GEE_TREE_SET_ITERATOR (obj);
	{
		self->priv->stamp = self->priv->_set->priv->stamp;
	}
	return obj;
}


static void gee_tree_set_iterator_class_init (GeeTreeSetIteratorClass * klass) {
	gee_tree_set_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeTreeSetIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_tree_set_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_tree_set_iterator_set_property;
	G_OBJECT_CLASS (klass)->constructor = gee_tree_set_iterator_constructor;
	G_OBJECT_CLASS (klass)->finalize = gee_tree_set_iterator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_ITERATOR_SET, g_param_spec_object ("set", "set", "set", GEE_TYPE_TREE_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_tree_set_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_tree_set_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = gee_tree_set_iterator_real_next;
	iface->get = gee_tree_set_iterator_real_get;
}


static void gee_tree_set_iterator_instance_init (GeeTreeSetIterator * self) {
	self->priv = GEE_TREE_SET_ITERATOR_GET_PRIVATE (self);
	self->priv->run = FALSE;
}


static void gee_tree_set_iterator_finalize (GObject* obj) {
	GeeTreeSetIterator * self;
	self = GEE_TREE_SET_ITERATOR (obj);
	_g_object_unref0 (self->priv->_set);
	G_OBJECT_CLASS (gee_tree_set_iterator_parent_class)->finalize (obj);
}


static GType gee_tree_set_iterator_get_type (void) {
	static GType gee_tree_set_iterator_type_id = 0;
	if (gee_tree_set_iterator_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTreeSetIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_tree_set_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeTreeSetIterator), 0, (GInstanceInitFunc) gee_tree_set_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_tree_set_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gee_tree_set_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeTreeSetIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_tree_set_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
	}
	return gee_tree_set_iterator_type_id;
}


static void gee_tree_set_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeTreeSetIterator * self;
	self = GEE_TREE_SET_ITERATOR (object);
	switch (property_id) {
		case GEE_TREE_SET_ITERATOR_SET:
		g_value_set_object (value, gee_tree_set_iterator_get_set (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_tree_set_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeTreeSetIterator * self;
	self = GEE_TREE_SET_ITERATOR (object);
	switch (property_id) {
		case GEE_TREE_SET_ITERATOR_SET:
		gee_tree_set_iterator_set_set (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_TREE_SET_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_TREE_SET_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_TREE_SET_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void gee_tree_set_class_init (GeeTreeSetClass * klass) {
	gee_tree_set_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeTreeSetPrivate));
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->contains = gee_tree_set_real_contains;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->add = gee_tree_set_real_add;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->remove = gee_tree_set_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->clear = gee_tree_set_real_clear;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->iterator = gee_tree_set_real_iterator;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gee_tree_set_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = gee_tree_set_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_tree_set_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_tree_set_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_SIZE, "size");
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_TREE_SET_COMPARE_FUNC, g_param_spec_pointer ("compare-func", "compare-func", "compare-func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void gee_tree_set_gee_set_interface_init (GeeSetIface * iface) {
	gee_tree_set_gee_set_parent_iface = g_type_interface_peek_parent (iface);
}


static void gee_tree_set_instance_init (GeeTreeSet * self) {
	self->priv = GEE_TREE_SET_GET_PRIVATE (self);
	self->priv->_size = 0;
	self->priv->stamp = 0;
}


static void gee_tree_set_finalize (GObject* obj) {
	GeeTreeSet * self;
	self = GEE_TREE_SET (obj);
	_gee_tree_set_node_free0 (self->priv->root);
	G_OBJECT_CLASS (gee_tree_set_parent_class)->finalize (obj);
}


GType gee_tree_set_get_type (void) {
	static GType gee_tree_set_type_id = 0;
	if (gee_tree_set_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeTreeSetClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_tree_set_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeTreeSet), 0, (GInstanceInitFunc) gee_tree_set_instance_init, NULL };
		static const GInterfaceInfo gee_set_info = { (GInterfaceInitFunc) gee_tree_set_gee_set_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gee_tree_set_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_COLLECTION, "GeeTreeSet", &g_define_type_info, 0);
		g_type_add_interface_static (gee_tree_set_type_id, GEE_TYPE_SET, &gee_set_info);
	}
	return gee_tree_set_type_id;
}


static void gee_tree_set_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeTreeSet * self;
	self = GEE_TREE_SET (object);
	switch (property_id) {
		case GEE_TREE_SET_SIZE:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		case GEE_TREE_SET_COMPARE_FUNC:
		g_value_set_pointer (value, gee_tree_set_get_compare_func (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_tree_set_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeTreeSet * self;
	self = GEE_TREE_SET (object);
	switch (property_id) {
		case GEE_TREE_SET_COMPARE_FUNC:
		gee_tree_set_set_compare_func (self, g_value_get_pointer (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_TREE_SET_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_TREE_SET_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_TREE_SET_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}




