/* testtreemap.c generated by valac, the Vala compiler
 * generated from testtreemap.vala, do not modify */

/* testtreeset.vala
 *
 * Copyright (C) 2008  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))



#define CODE_NOT_REACHABLE "*code should not be reached*"
void test_treemap_get (void);
void test_treemap_set (void);
void test_treemap_remove (void);
void test_treemap_contains (void);
void test_treemap_size (void);
void test_treemap_get_keys (void);
void test_treemap_get_values (void);
void test_treemap_clear (void);
static void _test_treemap_get_gcallback (void);
static void _test_treemap_set_gcallback (void);
static void _test_treemap_remove_gcallback (void);
static void _test_treemap_contains_gcallback (void);
static void _test_treemap_size_gcallback (void);
static void _test_treemap_get_keys_gcallback (void);
static void _test_treemap_get_values_gcallback (void);
static void _test_treemap_clear_gcallback (void);
void _main (char** args, int args_length1);
static int _vala_strcmp0 (const char * str1, const char * str2);



void test_treemap_get (void) {
	GeeTreeMap* treemap;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	treemap = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp, g_str_equal);
	g_assert ((_tmp0_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "foo")) == NULL);
	_g_free0 (_tmp0_);
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "key", "value");
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "key"), "value") == 0);
	_g_free0 (_tmp1_);
	g_assert ((_tmp2_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "foo")) == NULL);
	_g_free0 (_tmp2_);
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "key2", "value2");
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "key3", "value3");
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "key"), "value") == 0);
	_g_free0 (_tmp3_);
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "key2"), "value2") == 0);
	_g_free0 (_tmp4_);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "key3"), "value3") == 0);
	_g_free0 (_tmp5_);
	_g_object_unref0 (treemap);
}


void test_treemap_set (void) {
	GeeTreeMap* treemap;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	treemap = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp, g_str_equal);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 0);
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "abc", "one");
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemap, "abc"));
	g_assert (_vala_strcmp0 (_tmp0_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "abc"), "one") == 0);
	_g_free0 (_tmp0_);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 1);
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "def", "one");
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemap, "def"));
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "abc"), "one") == 0);
	_g_free0 (_tmp1_);
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "def"), "one") == 0);
	_g_free0 (_tmp2_);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 2);
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "def", "two");
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemap, "def"));
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "abc"), "one") == 0);
	_g_free0 (_tmp3_);
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "def"), "two") == 0);
	_g_free0 (_tmp4_);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 2);
	_g_object_unref0 (treemap);
}


void test_treemap_remove (void) {
	GeeTreeMap* treemap;
	char* value;
	char* _tmp2_;
	gboolean _tmp1_;
	gpointer _tmp0_ = NULL;
	char* _tmp5_;
	gboolean _tmp4_;
	gpointer _tmp3_ = NULL;
	treemap = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp, g_str_equal);
	value = NULL;
	gee_abstract_map_remove ((GeeAbstractMap*) treemap, "foo", NULL);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 0);
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "aaa", "111");
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "bbb", "222");
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "ccc", "333");
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "ddd", "444");
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 4);
	gee_abstract_map_remove ((GeeAbstractMap*) treemap, "aaa", NULL);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 3);
	_tmp1_ = gee_abstract_map_remove ((GeeAbstractMap*) treemap, "ccc", &_tmp0_);
	value = (_tmp2_ = (char*) _tmp0_, _g_free0 (value), _tmp2_);
	_tmp1_;
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 2);
	g_assert (_vala_strcmp0 (value, "333") == 0);
	gee_abstract_map_remove ((GeeAbstractMap*) treemap, "ddd", NULL);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 1);
	_tmp4_ = gee_abstract_map_remove ((GeeAbstractMap*) treemap, "bar", &_tmp3_);
	value = (_tmp5_ = (char*) _tmp3_, _g_free0 (value), _tmp5_);
	_tmp4_;
	g_assert (value == NULL);
	gee_abstract_map_remove ((GeeAbstractMap*) treemap, "bbb", NULL);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 0);
	_g_object_unref0 (treemap);
	_g_free0 (value);
}


void test_treemap_contains (void) {
	GeeTreeMap* treemap;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	GeeTreeMap* treemapOfInt;
	treemap = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp, g_str_equal);
	g_assert (!gee_abstract_map_contains ((GeeAbstractMap*) treemap, "111"));
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "10", "111");
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemap, "10"));
	g_assert (!gee_abstract_map_contains ((GeeAbstractMap*) treemap, "20"));
	g_assert (!gee_abstract_map_contains ((GeeAbstractMap*) treemap, "30"));
	g_assert (_vala_strcmp0 (_tmp0_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "10"), "111") == 0);
	_g_free0 (_tmp0_);
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "20", "222");
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemap, "10"));
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemap, "20"));
	g_assert (!gee_abstract_map_contains ((GeeAbstractMap*) treemap, "30"));
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "10"), "111") == 0);
	_g_free0 (_tmp1_);
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "20"), "222") == 0);
	_g_free0 (_tmp2_);
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "30", "333");
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemap, "10"));
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemap, "20"));
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemap, "30"));
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "10"), "111") == 0);
	_g_free0 (_tmp3_);
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "20"), "222") == 0);
	_g_free0 (_tmp4_);
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "30"), "333") == 0);
	_g_free0 (_tmp5_);
	gee_abstract_map_clear ((GeeAbstractMap*) treemap);
	g_assert (!gee_abstract_map_contains ((GeeAbstractMap*) treemap, "10"));
	g_assert (!gee_abstract_map_contains ((GeeAbstractMap*) treemap, "20"));
	g_assert (!gee_abstract_map_contains ((GeeAbstractMap*) treemap, "30"));
	treemapOfInt = gee_tree_map_new (G_TYPE_INT, NULL, NULL, G_TYPE_INT, NULL, NULL, NULL, NULL);
	gee_abstract_map_set ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (10), GINT_TO_POINTER (111));
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (10)));
	g_assert (!gee_abstract_map_contains ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (20)));
	g_assert (!gee_abstract_map_contains ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (30)));
	g_assert (GPOINTER_TO_INT (gee_abstract_map_get ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (10))) == 111);
	gee_abstract_map_set ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (20), GINT_TO_POINTER (222));
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (10)));
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (20)));
	g_assert (!gee_abstract_map_contains ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (30)));
	g_assert (GPOINTER_TO_INT (gee_abstract_map_get ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (10))) == 111);
	g_assert (GPOINTER_TO_INT (gee_abstract_map_get ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (20))) == 222);
	gee_abstract_map_set ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (30), GINT_TO_POINTER (333));
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (10)));
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (20)));
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (30)));
	g_assert (GPOINTER_TO_INT (gee_abstract_map_get ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (10))) == 111);
	g_assert (GPOINTER_TO_INT (gee_abstract_map_get ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (20))) == 222);
	g_assert (GPOINTER_TO_INT (gee_abstract_map_get ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (30))) == 333);
	_g_object_unref0 (treemap);
	_g_object_unref0 (treemapOfInt);
}


void test_treemap_size (void) {
	GeeTreeMap* treemap;
	treemap = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp, g_str_equal);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 0);
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "1", "1");
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 1);
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "2", "2");
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 2);
	gee_abstract_map_clear ((GeeAbstractMap*) treemap);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 0);
	_g_object_unref0 (treemap);
}


void test_treemap_get_keys (void) {
	GeeTreeMap* treemap;
	GeeSet* keySet;
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	treemap = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp, g_str_equal);
	keySet = gee_abstract_map_get_keys ((GeeAbstractMap*) treemap);
	g_assert (gee_collection_get_size ((GeeCollection*) keySet) == 0);
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "aaa", "111");
	g_assert (gee_collection_get_size ((GeeCollection*) keySet) == 1);
	g_assert (gee_collection_contains ((GeeCollection*) keySet, "aaa"));
	keySet = (_tmp0_ = gee_abstract_map_get_keys ((GeeAbstractMap*) treemap), _g_object_unref0 (keySet), _tmp0_);
	g_assert (gee_collection_get_size ((GeeCollection*) keySet) == 1);
	g_assert (gee_collection_contains ((GeeCollection*) keySet, "aaa"));
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_collection_add ((GeeCollection*) keySet, "ccc");
		_g_object_unref0 (treemap);
		_g_object_unref0 (keySet);
		return;
	}
	g_test_trap_assert_failed ();
	g_test_trap_assert_stderr (CODE_NOT_REACHABLE);
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "bbb", "222");
	g_assert (gee_collection_get_size ((GeeCollection*) keySet) == 2);
	g_assert (gee_collection_contains ((GeeCollection*) keySet, "aaa"));
	g_assert (gee_collection_contains ((GeeCollection*) keySet, "bbb"));
	keySet = (_tmp1_ = gee_abstract_map_get_keys ((GeeAbstractMap*) treemap), _g_object_unref0 (keySet), _tmp1_);
	g_assert (gee_collection_get_size ((GeeCollection*) keySet) == 2);
	g_assert (gee_collection_contains ((GeeCollection*) keySet, "aaa"));
	g_assert (gee_collection_contains ((GeeCollection*) keySet, "bbb"));
	gee_abstract_map_clear ((GeeAbstractMap*) treemap);
	g_assert (gee_collection_get_size ((GeeCollection*) keySet) == 0);
	keySet = (_tmp2_ = gee_abstract_map_get_keys ((GeeAbstractMap*) treemap), _g_object_unref0 (keySet), _tmp2_);
	g_assert (gee_collection_get_size ((GeeCollection*) keySet) == 0);
	_g_object_unref0 (treemap);
	_g_object_unref0 (keySet);
}


void test_treemap_get_values (void) {
	GeeTreeMap* treemap;
	GeeCollection* valueCollection;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	treemap = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp, g_str_equal);
	valueCollection = gee_abstract_map_get_values ((GeeAbstractMap*) treemap);
	g_assert (gee_collection_get_size (valueCollection) == 0);
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "aaa", "111");
	g_assert (gee_collection_get_size (valueCollection) == 1);
	g_assert (gee_collection_contains (valueCollection, "111"));
	valueCollection = (_tmp0_ = gee_abstract_map_get_values ((GeeAbstractMap*) treemap), _g_object_unref0 (valueCollection), _tmp0_);
	g_assert (gee_collection_get_size (valueCollection) == 1);
	g_assert (gee_collection_contains (valueCollection, "111"));
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_collection_add (valueCollection, "ccc");
		_g_object_unref0 (treemap);
		_g_object_unref0 (valueCollection);
		return;
	}
	g_test_trap_assert_failed ();
	g_test_trap_assert_stderr (CODE_NOT_REACHABLE);
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "bbb", "222");
	g_assert (gee_collection_get_size (valueCollection) == 2);
	g_assert (gee_collection_contains (valueCollection, "111"));
	g_assert (gee_collection_contains (valueCollection, "222"));
	valueCollection = (_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) treemap), _g_object_unref0 (valueCollection), _tmp1_);
	g_assert (gee_collection_get_size (valueCollection) == 2);
	g_assert (gee_collection_contains (valueCollection, "111"));
	g_assert (gee_collection_contains (valueCollection, "222"));
	gee_abstract_map_clear ((GeeAbstractMap*) treemap);
	g_assert (gee_collection_get_size (valueCollection) == 0);
	valueCollection = (_tmp2_ = gee_abstract_map_get_values ((GeeAbstractMap*) treemap), _g_object_unref0 (valueCollection), _tmp2_);
	g_assert (gee_collection_get_size (valueCollection) == 0);
	_g_object_unref0 (treemap);
	_g_object_unref0 (valueCollection);
}


void test_treemap_clear (void) {
	GeeTreeMap* treemap;
	treemap = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp, g_str_equal);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 0);
	gee_abstract_map_clear ((GeeAbstractMap*) treemap);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 0);
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "1", "1");
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 1);
	gee_abstract_map_clear ((GeeAbstractMap*) treemap);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 0);
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "1", "1");
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "2", "2");
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "3", "3");
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 3);
	gee_abstract_map_clear ((GeeAbstractMap*) treemap);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 0);
	_g_object_unref0 (treemap);
}


static void _test_treemap_get_gcallback (void) {
	test_treemap_get ();
}


static void _test_treemap_set_gcallback (void) {
	test_treemap_set ();
}


static void _test_treemap_remove_gcallback (void) {
	test_treemap_remove ();
}


static void _test_treemap_contains_gcallback (void) {
	test_treemap_contains ();
}


static void _test_treemap_size_gcallback (void) {
	test_treemap_size ();
}


static void _test_treemap_get_keys_gcallback (void) {
	test_treemap_get_keys ();
}


static void _test_treemap_get_values_gcallback (void) {
	test_treemap_get_values ();
}


static void _test_treemap_clear_gcallback (void) {
	test_treemap_clear ();
}


void _main (char** args, int args_length1) {
	g_test_init (&args_length1, &args, NULL);
	g_test_add_func ("/TreeMap/Map/get", _test_treemap_get_gcallback);
	g_test_add_func ("/TreeMap/Map/set", _test_treemap_set_gcallback);
	g_test_add_func ("/TreeMap/Map/remove", _test_treemap_remove_gcallback);
	g_test_add_func ("/TreeMap/Map/contains", _test_treemap_contains_gcallback);
	g_test_add_func ("/TreeMap/Map/size", _test_treemap_size_gcallback);
	g_test_add_func ("/TreeMap/Map/get_keys", _test_treemap_get_keys_gcallback);
	g_test_add_func ("/TreeMap/Map/get_values", _test_treemap_get_values_gcallback);
	g_test_add_func ("/TreeMap/Map/clear", _test_treemap_clear_gcallback);
	g_test_run ();
}


int main (int argc, char ** argv) {
	g_type_init ();
	_main (argv, argc);
	return 0;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




