/* testtreeset.vala
 *
 * Copyright (C) 2008  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>




#define CODE_NOT_REACHABLE "*code should not be reached*"
void test_treemap_get (void);
void test_treemap_set (void);
void test_treemap_remove (void);
void test_treemap_contains (void);
void test_treemap_size (void);
void test_treemap_get_keys (void);
void test_treemap_get_values (void);
void test_treemap_clear (void);
static void _test_treemap_get_gcallback (void);
static void _test_treemap_set_gcallback (void);
static void _test_treemap_remove_gcallback (void);
static void _test_treemap_contains_gcallback (void);
static void _test_treemap_size_gcallback (void);
static void _test_treemap_get_keys_gcallback (void);
static void _test_treemap_get_values_gcallback (void);
static void _test_treemap_clear_gcallback (void);
void _main (char** args, int args_length1);
static int _vala_strcmp0 (const char * str1, const char * str2);



void test_treemap_get (void) {
	GeeTreeMap* treemap;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	treemap = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp, g_str_equal);
	/* Check get from empty map*/
	_tmp0_ = NULL;
	g_assert ((_tmp0_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "foo")) == NULL);
	_tmp0_ = (g_free (_tmp0_), NULL);
	/* Check get from map with one items*/
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "key", "value");
	_tmp1_ = NULL;
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "key"), "value") == 0);
	_tmp1_ = (g_free (_tmp1_), NULL);
	/* Check get from non-existing key*/
	_tmp2_ = NULL;
	g_assert ((_tmp2_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "foo")) == NULL);
	_tmp2_ = (g_free (_tmp2_), NULL);
	/* Check get from map with multiple items*/
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "key2", "value2");
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "key3", "value3");
	_tmp3_ = NULL;
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "key"), "value") == 0);
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp4_ = NULL;
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "key2"), "value2") == 0);
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp5_ = NULL;
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "key3"), "value3") == 0);
	_tmp5_ = (g_free (_tmp5_), NULL);
	(treemap == NULL) ? NULL : (treemap = (g_object_unref (treemap), NULL));
}


void test_treemap_set (void) {
	GeeTreeMap* treemap;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	treemap = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp, g_str_equal);
	/* check map is empty*/
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 0);
	/* check set an item to map*/
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "abc", "one");
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemap, "abc"));
	_tmp0_ = NULL;
	g_assert (_vala_strcmp0 (_tmp0_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "abc"), "one") == 0);
	_tmp0_ = (g_free (_tmp0_), NULL);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 1);
	/* check set an item to map with same value*/
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "def", "one");
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemap, "def"));
	_tmp1_ = NULL;
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "abc"), "one") == 0);
	_tmp1_ = (g_free (_tmp1_), NULL);
	_tmp2_ = NULL;
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "def"), "one") == 0);
	_tmp2_ = (g_free (_tmp2_), NULL);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 2);
	/* check set with same key*/
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "def", "two");
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemap, "def"));
	_tmp3_ = NULL;
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "abc"), "one") == 0);
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp4_ = NULL;
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "def"), "two") == 0);
	_tmp4_ = (g_free (_tmp4_), NULL);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 2);
	(treemap == NULL) ? NULL : (treemap = (g_object_unref (treemap), NULL));
}


void test_treemap_remove (void) {
	GeeTreeMap* treemap;
	char* value;
	char* _tmp2_;
	gboolean _tmp1_;
	gpointer _tmp0_;
	char* _tmp5_;
	gboolean _tmp4_;
	gpointer _tmp3_;
	treemap = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp, g_str_equal);
	value = NULL;
	/* check removing when map is empty*/
	gee_abstract_map_remove ((GeeAbstractMap*) treemap, "foo", NULL);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 0);
	/* add items*/
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "aaa", "111");
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "bbb", "222");
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "ccc", "333");
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "ddd", "444");
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 4);
	/* check remove on first place*/
	gee_abstract_map_remove ((GeeAbstractMap*) treemap, "aaa", NULL);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 3);
	/* check remove in between */
	_tmp2_ = NULL;
	_tmp0_ = NULL;
	_tmp1_ = gee_abstract_map_remove ((GeeAbstractMap*) treemap, "ccc", &_tmp0_);
	value = (_tmp2_ = (char*) _tmp0_, value = (g_free (value), NULL), _tmp2_);
	_tmp1_;
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 2);
	g_assert (_vala_strcmp0 (value, "333") == 0);
	/* check remove in last place*/
	gee_abstract_map_remove ((GeeAbstractMap*) treemap, "ddd", NULL);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 1);
	/* check remove invalid key*/
	_tmp5_ = NULL;
	_tmp3_ = NULL;
	_tmp4_ = gee_abstract_map_remove ((GeeAbstractMap*) treemap, "bar", &_tmp3_);
	value = (_tmp5_ = (char*) _tmp3_, value = (g_free (value), NULL), _tmp5_);
	_tmp4_;
	g_assert (value == NULL);
	/* check remove last in map*/
	gee_abstract_map_remove ((GeeAbstractMap*) treemap, "bbb", NULL);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 0);
	(treemap == NULL) ? NULL : (treemap = (g_object_unref (treemap), NULL));
	value = (g_free (value), NULL);
}


void test_treemap_contains (void) {
	GeeTreeMap* treemap;
	char* _tmp0_;
	char* _tmp1_;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	GeeTreeMap* treemapOfInt;
	treemap = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp, g_str_equal);
	/* Check on empty map*/
	g_assert (!gee_abstract_map_contains ((GeeAbstractMap*) treemap, "111"));
	/* Check items*/
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "10", "111");
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemap, "10"));
	g_assert (!gee_abstract_map_contains ((GeeAbstractMap*) treemap, "20"));
	g_assert (!gee_abstract_map_contains ((GeeAbstractMap*) treemap, "30"));
	_tmp0_ = NULL;
	g_assert (_vala_strcmp0 (_tmp0_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "10"), "111") == 0);
	_tmp0_ = (g_free (_tmp0_), NULL);
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "20", "222");
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemap, "10"));
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemap, "20"));
	g_assert (!gee_abstract_map_contains ((GeeAbstractMap*) treemap, "30"));
	_tmp1_ = NULL;
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "10"), "111") == 0);
	_tmp1_ = (g_free (_tmp1_), NULL);
	_tmp2_ = NULL;
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "20"), "222") == 0);
	_tmp2_ = (g_free (_tmp2_), NULL);
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "30", "333");
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemap, "10"));
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemap, "20"));
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemap, "30"));
	_tmp3_ = NULL;
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "10"), "111") == 0);
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp4_ = NULL;
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "20"), "222") == 0);
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp5_ = NULL;
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_abstract_map_get ((GeeAbstractMap*) treemap, "30"), "333") == 0);
	_tmp5_ = (g_free (_tmp5_), NULL);
	/* Clear and recheck*/
	gee_abstract_map_clear ((GeeAbstractMap*) treemap);
	g_assert (!gee_abstract_map_contains ((GeeAbstractMap*) treemap, "10"));
	g_assert (!gee_abstract_map_contains ((GeeAbstractMap*) treemap, "20"));
	g_assert (!gee_abstract_map_contains ((GeeAbstractMap*) treemap, "30"));
	treemapOfInt = gee_tree_map_new (G_TYPE_INT, NULL, NULL, G_TYPE_INT, NULL, NULL, gee_direct_compare, g_direct_equal);
	/* Check items*/
	gee_abstract_map_set ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (10), GINT_TO_POINTER (111));
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (10)));
	g_assert (!gee_abstract_map_contains ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (20)));
	g_assert (!gee_abstract_map_contains ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (30)));
	g_assert (GPOINTER_TO_INT (gee_abstract_map_get ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (10))) == 111);
	gee_abstract_map_set ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (20), GINT_TO_POINTER (222));
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (10)));
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (20)));
	g_assert (!gee_abstract_map_contains ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (30)));
	g_assert (GPOINTER_TO_INT (gee_abstract_map_get ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (10))) == 111);
	g_assert (GPOINTER_TO_INT (gee_abstract_map_get ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (20))) == 222);
	gee_abstract_map_set ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (30), GINT_TO_POINTER (333));
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (10)));
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (20)));
	g_assert (gee_abstract_map_contains ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (30)));
	g_assert (GPOINTER_TO_INT (gee_abstract_map_get ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (10))) == 111);
	g_assert (GPOINTER_TO_INT (gee_abstract_map_get ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (20))) == 222);
	g_assert (GPOINTER_TO_INT (gee_abstract_map_get ((GeeAbstractMap*) treemapOfInt, GINT_TO_POINTER (30))) == 333);
	(treemap == NULL) ? NULL : (treemap = (g_object_unref (treemap), NULL));
	(treemapOfInt == NULL) ? NULL : (treemapOfInt = (g_object_unref (treemapOfInt), NULL));
}


void test_treemap_size (void) {
	GeeTreeMap* treemap;
	treemap = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp, g_str_equal);
	/* Check empty map*/
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 0);
	/* Check when one item*/
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "1", "1");
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 1);
	/* Check when more items*/
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "2", "2");
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 2);
	/* Check when items cleared*/
	gee_abstract_map_clear ((GeeAbstractMap*) treemap);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 0);
	(treemap == NULL) ? NULL : (treemap = (g_object_unref (treemap), NULL));
}


void test_treemap_get_keys (void) {
	GeeTreeMap* treemap;
	GeeSet* keySet;
	GeeSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	treemap = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp, g_str_equal);
	/* Check keys on empty map*/
	keySet = gee_abstract_map_get_keys ((GeeAbstractMap*) treemap);
	g_assert (gee_collection_get_size ((GeeCollection*) keySet) == 0);
	/* Check keys on map with one item*/
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "aaa", "111");
	g_assert (gee_collection_get_size ((GeeCollection*) keySet) == 1);
	g_assert (gee_collection_contains ((GeeCollection*) keySet, "aaa"));
	_tmp0_ = NULL;
	keySet = (_tmp0_ = gee_abstract_map_get_keys ((GeeAbstractMap*) treemap), (keySet == NULL) ? NULL : (keySet = (g_object_unref (keySet), NULL)), _tmp0_);
	g_assert (gee_collection_get_size ((GeeCollection*) keySet) == 1);
	g_assert (gee_collection_contains ((GeeCollection*) keySet, "aaa"));
	/* Check modify key set directly*/
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_collection_add ((GeeCollection*) keySet, "ccc");
		(treemap == NULL) ? NULL : (treemap = (g_object_unref (treemap), NULL));
		(keySet == NULL) ? NULL : (keySet = (g_object_unref (keySet), NULL));
		return;
	}
	g_test_trap_assert_failed ();
	g_test_trap_assert_stderr (CODE_NOT_REACHABLE);
	/* Check keys on map with multiple items*/
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "bbb", "222");
	g_assert (gee_collection_get_size ((GeeCollection*) keySet) == 2);
	g_assert (gee_collection_contains ((GeeCollection*) keySet, "aaa"));
	g_assert (gee_collection_contains ((GeeCollection*) keySet, "bbb"));
	_tmp1_ = NULL;
	keySet = (_tmp1_ = gee_abstract_map_get_keys ((GeeAbstractMap*) treemap), (keySet == NULL) ? NULL : (keySet = (g_object_unref (keySet), NULL)), _tmp1_);
	g_assert (gee_collection_get_size ((GeeCollection*) keySet) == 2);
	g_assert (gee_collection_contains ((GeeCollection*) keySet, "aaa"));
	g_assert (gee_collection_contains ((GeeCollection*) keySet, "bbb"));
	/* Check keys on map clear*/
	gee_abstract_map_clear ((GeeAbstractMap*) treemap);
	g_assert (gee_collection_get_size ((GeeCollection*) keySet) == 0);
	_tmp2_ = NULL;
	keySet = (_tmp2_ = gee_abstract_map_get_keys ((GeeAbstractMap*) treemap), (keySet == NULL) ? NULL : (keySet = (g_object_unref (keySet), NULL)), _tmp2_);
	g_assert (gee_collection_get_size ((GeeCollection*) keySet) == 0);
	(treemap == NULL) ? NULL : (treemap = (g_object_unref (treemap), NULL));
	(keySet == NULL) ? NULL : (keySet = (g_object_unref (keySet), NULL));
}


void test_treemap_get_values (void) {
	GeeTreeMap* treemap;
	GeeCollection* valueCollection;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	treemap = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp, g_str_equal);
	/* Check keys on empty map*/
	valueCollection = gee_abstract_map_get_values ((GeeAbstractMap*) treemap);
	g_assert (gee_collection_get_size (valueCollection) == 0);
	/* Check keys on map with one item*/
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "aaa", "111");
	g_assert (gee_collection_get_size (valueCollection) == 1);
	g_assert (gee_collection_contains (valueCollection, "111"));
	_tmp0_ = NULL;
	valueCollection = (_tmp0_ = gee_abstract_map_get_values ((GeeAbstractMap*) treemap), (valueCollection == NULL) ? NULL : (valueCollection = (g_object_unref (valueCollection), NULL)), _tmp0_);
	g_assert (gee_collection_get_size (valueCollection) == 1);
	g_assert (gee_collection_contains (valueCollection, "111"));
	/* Check modify key set directly*/
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_collection_add (valueCollection, "ccc");
		(treemap == NULL) ? NULL : (treemap = (g_object_unref (treemap), NULL));
		(valueCollection == NULL) ? NULL : (valueCollection = (g_object_unref (valueCollection), NULL));
		return;
	}
	g_test_trap_assert_failed ();
	g_test_trap_assert_stderr (CODE_NOT_REACHABLE);
	/* Check keys on map with multiple items*/
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "bbb", "222");
	g_assert (gee_collection_get_size (valueCollection) == 2);
	g_assert (gee_collection_contains (valueCollection, "111"));
	g_assert (gee_collection_contains (valueCollection, "222"));
	_tmp1_ = NULL;
	valueCollection = (_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) treemap), (valueCollection == NULL) ? NULL : (valueCollection = (g_object_unref (valueCollection), NULL)), _tmp1_);
	g_assert (gee_collection_get_size (valueCollection) == 2);
	g_assert (gee_collection_contains (valueCollection, "111"));
	g_assert (gee_collection_contains (valueCollection, "222"));
	/* Check keys on map clear*/
	gee_abstract_map_clear ((GeeAbstractMap*) treemap);
	g_assert (gee_collection_get_size (valueCollection) == 0);
	_tmp2_ = NULL;
	valueCollection = (_tmp2_ = gee_abstract_map_get_values ((GeeAbstractMap*) treemap), (valueCollection == NULL) ? NULL : (valueCollection = (g_object_unref (valueCollection), NULL)), _tmp2_);
	g_assert (gee_collection_get_size (valueCollection) == 0);
	(treemap == NULL) ? NULL : (treemap = (g_object_unref (treemap), NULL));
	(valueCollection == NULL) ? NULL : (valueCollection = (g_object_unref (valueCollection), NULL));
}


void test_treemap_clear (void) {
	GeeTreeMap* treemap;
	treemap = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp, g_str_equal);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 0);
	/* Check clear on empty map*/
	gee_abstract_map_clear ((GeeAbstractMap*) treemap);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 0);
	/* Check clear one item*/
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "1", "1");
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 1);
	gee_abstract_map_clear ((GeeAbstractMap*) treemap);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 0);
	/* Check clear multiple items*/
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "1", "1");
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "2", "2");
	gee_abstract_map_set ((GeeAbstractMap*) treemap, "3", "3");
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 3);
	gee_abstract_map_clear ((GeeAbstractMap*) treemap);
	g_assert (gee_map_get_size ((GeeMap*) treemap) == 0);
	(treemap == NULL) ? NULL : (treemap = (g_object_unref (treemap), NULL));
}


static void _test_treemap_get_gcallback (void) {
	test_treemap_get ();
}


static void _test_treemap_set_gcallback (void) {
	test_treemap_set ();
}


static void _test_treemap_remove_gcallback (void) {
	test_treemap_remove ();
}


static void _test_treemap_contains_gcallback (void) {
	test_treemap_contains ();
}


static void _test_treemap_size_gcallback (void) {
	test_treemap_size ();
}


static void _test_treemap_get_keys_gcallback (void) {
	test_treemap_get_keys ();
}


static void _test_treemap_get_values_gcallback (void) {
	test_treemap_get_values ();
}


static void _test_treemap_clear_gcallback (void) {
	test_treemap_clear ();
}


void _main (char** args, int args_length1) {
	g_test_init (&args_length1, &args, NULL);
	g_test_add_func ("/TreeMap/Map/get", (GCallback) _test_treemap_get_gcallback);
	g_test_add_func ("/TreeMap/Map/set", (GCallback) _test_treemap_set_gcallback);
	g_test_add_func ("/TreeMap/Map/remove", (GCallback) _test_treemap_remove_gcallback);
	g_test_add_func ("/TreeMap/Map/contains", (GCallback) _test_treemap_contains_gcallback);
	g_test_add_func ("/TreeMap/Map/size", (GCallback) _test_treemap_size_gcallback);
	g_test_add_func ("/TreeMap/Map/get_keys", (GCallback) _test_treemap_get_keys_gcallback);
	g_test_add_func ("/TreeMap/Map/get_values", (GCallback) _test_treemap_get_values_gcallback);
	g_test_add_func ("/TreeMap/Map/clear", (GCallback) _test_treemap_clear_gcallback);
	g_test_run ();
}


int main (int argc, char ** argv) {
	g_type_init ();
	_main (argv, argc);
	return 0;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




