/* testtreeset.vala
 *
 * Copyright (C) 2008  Maciej Piechotka
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Maciej Piechotka <uzytkownik2@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>




void test_treeset_add (void);
void test_treeset_clear (void);
void test_treeset_contains (void);
void test_treeset_remove (void);
void test_treeset_size (void);
void test_treeset_iterator (void);
static void _test_treeset_add_gcallback (void);
static void _test_treeset_clear_gcallback (void);
static void _test_treeset_contains_gcallback (void);
static void _test_treeset_remove_gcallback (void);
static void _test_treeset_size_gcallback (void);
static void _test_treeset_iterator_gcallback (void);
void _main (char** args, int args_length1);
static int _vala_strcmp0 (const char * str1, const char * str2);



void test_treeset_add (void) {
	GeeTreeSet* treeset;
	GeeTreeSet* treesetInt;
	GeeTreeSet* treesetObject;
	GObject* fooObject;
	GObject* fooObject2;
	/* Check adding of strings*/
	treeset = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp);
	gee_abstract_collection_add ((GeeAbstractCollection*) treeset, "42");
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treeset, "42"));
	g_assert (gee_collection_get_size ((GeeCollection*) treeset) == 1);
	gee_abstract_collection_add ((GeeAbstractCollection*) treeset, "43");
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treeset, "42"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treeset, "43"));
	g_assert (gee_collection_get_size ((GeeCollection*) treeset) == 2);
	/* Check add same element*/
	g_assert (gee_collection_get_size ((GeeCollection*) treeset) == 2);
	gee_abstract_collection_add ((GeeAbstractCollection*) treeset, "43");
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treeset, "42"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treeset, "43"));
	g_assert (gee_collection_get_size ((GeeCollection*) treeset) == 2);
	/* Check adding of ints*/
	treesetInt = gee_tree_set_new (G_TYPE_INT, NULL, NULL, gee_direct_compare);
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (42));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (42)));
	g_assert (gee_collection_get_size ((GeeCollection*) treesetInt) == 1);
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (43));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (42)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (43)));
	g_assert (gee_collection_get_size ((GeeCollection*) treesetInt) == 2);
	/* Check add same element*/
	g_assert (gee_collection_get_size ((GeeCollection*) treesetInt) == 2);
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (43));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (42)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (43)));
	g_assert (gee_collection_get_size ((GeeCollection*) treesetInt) == 2);
	/* Check adding of objects*/
	treesetObject = gee_tree_set_new (G_TYPE_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, gee_direct_compare);
	fooObject = g_object_new (G_TYPE_OBJECT, NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetObject, fooObject);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetObject, fooObject));
	g_assert (gee_collection_get_size ((GeeCollection*) treesetObject) == 1);
	fooObject2 = g_object_new (G_TYPE_OBJECT, NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetObject, fooObject2);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetObject, fooObject));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetObject, fooObject2));
	g_assert (gee_collection_get_size ((GeeCollection*) treesetObject) == 2);
	/* Check add same element*/
	g_assert (gee_collection_get_size ((GeeCollection*) treesetObject) == 2);
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetObject, fooObject2);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetObject, fooObject));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetObject, fooObject2));
	g_assert (gee_collection_get_size ((GeeCollection*) treesetObject) == 2);
	(treeset == NULL) ? NULL : (treeset = (g_object_unref (treeset), NULL));
	(treesetInt == NULL) ? NULL : (treesetInt = (g_object_unref (treesetInt), NULL));
	(treesetObject == NULL) ? NULL : (treesetObject = (g_object_unref (treesetObject), NULL));
	(fooObject == NULL) ? NULL : (fooObject = (g_object_unref (fooObject), NULL));
	(fooObject2 == NULL) ? NULL : (fooObject2 = (g_object_unref (fooObject2), NULL));
}


void test_treeset_clear (void) {
	GeeTreeSet* treeset;
	treeset = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp);
	g_assert (gee_collection_get_size ((GeeCollection*) treeset) == 0);
	/* Check clear on empty set*/
	gee_abstract_collection_clear ((GeeAbstractCollection*) treeset);
	g_assert (gee_collection_get_size ((GeeCollection*) treeset) == 0);
	/* Check clear one item*/
	gee_abstract_collection_add ((GeeAbstractCollection*) treeset, "1");
	g_assert (gee_collection_get_size ((GeeCollection*) treeset) == 1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) treeset);
	g_assert (gee_collection_get_size ((GeeCollection*) treeset) == 0);
	/* Check clear multiple items*/
	gee_abstract_collection_add ((GeeAbstractCollection*) treeset, "1");
	gee_abstract_collection_add ((GeeAbstractCollection*) treeset, "2");
	gee_abstract_collection_add ((GeeAbstractCollection*) treeset, "3");
	g_assert (gee_collection_get_size ((GeeCollection*) treeset) == 3);
	gee_abstract_collection_clear ((GeeAbstractCollection*) treeset);
	g_assert (gee_collection_get_size ((GeeCollection*) treeset) == 0);
	(treeset == NULL) ? NULL : (treeset = (g_object_unref (treeset), NULL));
}


void test_treeset_contains (void) {
	GeeTreeSet* treesetString;
	GeeTreeSet* treesetInt;
	treesetString = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp);
	/* Check on empty set*/
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "1"));
	/* Check items*/
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetString, "10");
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "10"));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "20"));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "30"));
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetString, "20");
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "10"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "20"));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "30"));
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetString, "30");
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "10"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "20"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "30"));
	/* Clear and recheck*/
	gee_abstract_collection_clear ((GeeAbstractCollection*) treesetString);
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "10"));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "20"));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "30"));
	treesetInt = gee_tree_set_new (G_TYPE_INT, NULL, NULL, gee_direct_compare);
	/* Check items*/
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (10));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (10)));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (20)));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (30)));
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (20));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (10)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (20)));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (30)));
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (30));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (10)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (20)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (30)));
	/* Clear and recheck*/
	gee_abstract_collection_clear ((GeeAbstractCollection*) treesetInt);
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (10)));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (20)));
	g_assert (!gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (30)));
	(treesetString == NULL) ? NULL : (treesetString = (g_object_unref (treesetString), NULL));
	(treesetInt == NULL) ? NULL : (treesetInt = (g_object_unref (treesetInt), NULL));
}


void test_treeset_remove (void) {
	GeeTreeSet* treesetString;
	GeeTreeSet* treesetInt;
	treesetString = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp);
	/* Check remove if list is empty*/
	gee_abstract_collection_remove ((GeeAbstractCollection*) treesetString, "42");
	/* Add 5 different elements*/
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetString, "42");
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetString, "43");
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetString, "44");
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetString, "45");
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetString, "46");
	g_assert (gee_collection_get_size ((GeeCollection*) treesetString) == 5);
	/* Check remove first*/
	gee_abstract_collection_remove ((GeeAbstractCollection*) treesetString, "42");
	g_assert (gee_collection_get_size ((GeeCollection*) treesetString) == 4);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "43"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "44"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "45"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "46"));
	/* Check remove last*/
	gee_abstract_collection_remove ((GeeAbstractCollection*) treesetString, "46");
	g_assert (gee_collection_get_size ((GeeCollection*) treesetString) == 3);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "43"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "44"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "45"));
	/* Check remove in between*/
	gee_abstract_collection_remove ((GeeAbstractCollection*) treesetString, "44");
	g_assert (gee_collection_get_size ((GeeCollection*) treesetString) == 2);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "43"));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetString, "45"));
	/* Check removing of int element*/
	treesetInt = gee_tree_set_new (G_TYPE_INT, NULL, NULL, gee_direct_compare);
	/* Add 5 different elements*/
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (42));
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (43));
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (44));
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (45));
	gee_abstract_collection_add ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (46));
	g_assert (gee_collection_get_size ((GeeCollection*) treesetInt) == 5);
	/* Remove first*/
	gee_abstract_collection_remove ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (42));
	g_assert (gee_collection_get_size ((GeeCollection*) treesetInt) == 4);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (43)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (44)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (45)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (46)));
	/* Remove last*/
	gee_abstract_collection_remove ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (46));
	g_assert (gee_collection_get_size ((GeeCollection*) treesetInt) == 3);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (43)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (44)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (45)));
	/* Remove in between*/
	gee_abstract_collection_remove ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (44));
	g_assert (gee_collection_get_size ((GeeCollection*) treesetInt) == 2);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (43)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treesetInt, GINT_TO_POINTER (45)));
	(treesetString == NULL) ? NULL : (treesetString = (g_object_unref (treesetString), NULL));
	(treesetInt == NULL) ? NULL : (treesetInt = (g_object_unref (treesetInt), NULL));
}


void test_treeset_size (void) {
	GeeTreeSet* treeset;
	treeset = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp);
	/* Check empty list*/
	g_assert (gee_collection_get_size ((GeeCollection*) treeset) == 0);
	/* Check when one item*/
	gee_abstract_collection_add ((GeeAbstractCollection*) treeset, "1");
	g_assert (gee_collection_get_size ((GeeCollection*) treeset) == 1);
	/* Check when more items*/
	gee_abstract_collection_add ((GeeAbstractCollection*) treeset, "2");
	g_assert (gee_collection_get_size ((GeeCollection*) treeset) == 2);
	/* Check when items cleared*/
	gee_abstract_collection_clear ((GeeAbstractCollection*) treeset);
	g_assert (gee_collection_get_size ((GeeCollection*) treeset) == 0);
	(treeset == NULL) ? NULL : (treeset = (g_object_unref (treeset), NULL));
}


void test_treeset_iterator (void) {
	GeeTreeSet* treeset;
	GeeIterator* iterator;
	GeeIterator* _tmp0_;
	char* firstString;
	char* secondString;
	treeset = gee_tree_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, (GCompareFunc) strcmp);
	/* Check iterate empty list*/
	iterator = gee_abstract_collection_iterator ((GeeAbstractCollection*) treeset);
	g_assert (!gee_iterator_next (iterator));
	/* Check iterate list*/
	gee_abstract_collection_add ((GeeAbstractCollection*) treeset, "42");
	gee_abstract_collection_add ((GeeAbstractCollection*) treeset, "43");
	_tmp0_ = NULL;
	iterator = (_tmp0_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) treeset), (iterator == NULL) ? NULL : (iterator = (g_object_unref (iterator), NULL)), _tmp0_);
	g_assert (gee_iterator_next (iterator));
	firstString = (char*) gee_iterator_get (iterator);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treeset, firstString));
	g_assert (_vala_strcmp0 (firstString, "42") == 0);
	g_assert (gee_iterator_next (iterator));
	secondString = (char*) gee_iterator_get (iterator);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) treeset, secondString));
	g_assert (_vala_strcmp0 (secondString, "43") == 0);
	g_assert (!gee_iterator_next (iterator));
	(treeset == NULL) ? NULL : (treeset = (g_object_unref (treeset), NULL));
	(iterator == NULL) ? NULL : (iterator = (g_object_unref (iterator), NULL));
	firstString = (g_free (firstString), NULL);
	secondString = (g_free (secondString), NULL);
}


static void _test_treeset_add_gcallback (void) {
	test_treeset_add ();
}


static void _test_treeset_clear_gcallback (void) {
	test_treeset_clear ();
}


static void _test_treeset_contains_gcallback (void) {
	test_treeset_contains ();
}


static void _test_treeset_remove_gcallback (void) {
	test_treeset_remove ();
}


static void _test_treeset_size_gcallback (void) {
	test_treeset_size ();
}


static void _test_treeset_iterator_gcallback (void) {
	test_treeset_iterator ();
}


void _main (char** args, int args_length1) {
	g_test_init (&args_length1, &args, NULL);
	g_test_add_func ("/TreeSet/Collection/add", (GCallback) _test_treeset_add_gcallback);
	g_test_add_func ("/TreeSet/Collection/clear", (GCallback) _test_treeset_clear_gcallback);
	g_test_add_func ("/TreeSet/Collection/contains", (GCallback) _test_treeset_contains_gcallback);
	g_test_add_func ("/TreeSet/Collection/remove", (GCallback) _test_treeset_remove_gcallback);
	g_test_add_func ("/TreeSet/Collection/size", (GCallback) _test_treeset_size_gcallback);
	g_test_add_func ("/TreeSet/Iterable/iterator", (GCallback) _test_treeset_iterator_gcallback);
	g_test_run ();
}


int main (int argc, char ** argv) {
	g_type_init ();
	_main (argv, argc);
	return 0;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




