/* testhashmap.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_TEST_FIXTURE (test_fixture_get_type ())
#define TEST_FIXTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TEST_FIXTURE, TestFixture))
#define TEST_FIXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TEST_FIXTURE, TestFixtureClass))
#define IS_TEST_FIXTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TEST_FIXTURE))
#define IS_TEST_FIXTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TEST_FIXTURE))
#define TEST_FIXTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TEST_FIXTURE, TestFixtureClass))

typedef struct _TestFixture TestFixture;
typedef struct _TestFixtureClass TestFixtureClass;
typedef struct _TestFixturePrivate TestFixturePrivate;

#define TYPE_COLLECTION_TESTS (collection_tests_get_type ())
#define COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COLLECTION_TESTS, CollectionTests))
#define COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COLLECTION_TESTS, CollectionTestsClass))
#define IS_COLLECTION_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COLLECTION_TESTS))
#define IS_COLLECTION_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COLLECTION_TESTS))
#define COLLECTION_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COLLECTION_TESTS, CollectionTestsClass))

typedef struct _CollectionTests CollectionTests;
typedef struct _CollectionTestsClass CollectionTestsClass;
typedef struct _CollectionTestsPrivate CollectionTestsPrivate;

#define TYPE_ARRAY_LIST_TESTS (array_list_tests_get_type ())
#define ARRAY_LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ARRAY_LIST_TESTS, ArrayListTests))
#define ARRAY_LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ARRAY_LIST_TESTS, ArrayListTestsClass))
#define IS_ARRAY_LIST_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ARRAY_LIST_TESTS))
#define IS_ARRAY_LIST_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ARRAY_LIST_TESTS))
#define ARRAY_LIST_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ARRAY_LIST_TESTS, ArrayListTestsClass))

typedef struct _ArrayListTests ArrayListTests;
typedef struct _ArrayListTestsClass ArrayListTestsClass;
typedef struct _ArrayListTestsPrivate ArrayListTestsPrivate;

struct _TestFixture {
	GObject parent_instance;
	TestFixturePrivate * priv;
};

struct _TestFixtureClass {
	GObjectClass parent_class;
	void (*setup) (TestFixture* self);
	void (*teardown) (TestFixture* self);
};

struct _CollectionTests {
	TestFixture parent_instance;
	CollectionTestsPrivate * priv;
	GeeCollection* int_collection;
	GeeCollection* string_collection;
	GeeCollection* object_collection;
};

struct _CollectionTestsClass {
	TestFixtureClass parent_class;
};

struct _ArrayListTests {
	CollectionTests parent_instance;
	ArrayListTestsPrivate * priv;
};

struct _ArrayListTestsClass {
	CollectionTestsClass parent_class;
};

typedef void (*TestFixtureTestMethod) (void* user_data);

static gpointer array_list_tests_parent_class = NULL;

GType test_fixture_get_type (void);
GType collection_tests_get_type (void);
GType array_list_tests_get_type (void);
enum  {
	ARRAY_LIST_TESTS_DUMMY_PROPERTY
};
CollectionTests* collection_tests_new (const char* name);
CollectionTests* collection_tests_construct (GType object_type, const char* name);
void test_fixture_add_test (TestFixture* self, const char* name, TestFixtureTestMethod test, void* test_target);
static void array_list_tests_test_arraylist_get (ArrayListTests* self);
static void _array_list_tests_test_arraylist_get_test_fixture_test_method (gpointer self);
static void array_list_tests_test_arraylist_set (ArrayListTests* self);
static void _array_list_tests_test_arraylist_set_test_fixture_test_method (gpointer self);
static void array_list_tests_test_arraylist_insert (ArrayListTests* self);
static void _array_list_tests_test_arraylist_insert_test_fixture_test_method (gpointer self);
static void array_list_tests_test_arraylist_remove_at (ArrayListTests* self);
static void _array_list_tests_test_arraylist_remove_at_test_fixture_test_method (gpointer self);
static void array_list_tests_test_arraylist_index_of (ArrayListTests* self);
static void _array_list_tests_test_arraylist_index_of_test_fixture_test_method (gpointer self);
static void array_list_tests_test_arraylist_first (ArrayListTests* self);
static void _array_list_tests_test_arraylist_first_test_fixture_test_method (gpointer self);
static void array_list_tests_test_arraylist_last (ArrayListTests* self);
static void _array_list_tests_test_arraylist_last_test_fixture_test_method (gpointer self);
static void array_list_tests_test_arraylist_insert_all (ArrayListTests* self);
static void _array_list_tests_test_arraylist_insert_all_test_fixture_test_method (gpointer self);
static void array_list_tests_test_arraylist_add (ArrayListTests* self);
static void _array_list_tests_test_arraylist_add_test_fixture_test_method (gpointer self);
static void array_list_tests_test_arraylist_clear (ArrayListTests* self);
static void _array_list_tests_test_arraylist_clear_test_fixture_test_method (gpointer self);
static void array_list_tests_test_arraylist_contains (ArrayListTests* self);
static void _array_list_tests_test_arraylist_contains_test_fixture_test_method (gpointer self);
static void array_list_tests_test_arraylist_remove (ArrayListTests* self);
static void _array_list_tests_test_arraylist_remove_test_fixture_test_method (gpointer self);
static void array_list_tests_test_arraylist_size (ArrayListTests* self);
static void _array_list_tests_test_arraylist_size_test_fixture_test_method (gpointer self);
static void array_list_tests_test_arraylist_empty (ArrayListTests* self);
static void _array_list_tests_test_arraylist_empty_test_fixture_test_method (gpointer self);
static void array_list_tests_test_arraylist_add_all (ArrayListTests* self);
static void _array_list_tests_test_arraylist_add_all_test_fixture_test_method (gpointer self);
static void array_list_tests_test_arraylist_contains_all (ArrayListTests* self);
static void _array_list_tests_test_arraylist_contains_all_test_fixture_test_method (gpointer self);
static void array_list_tests_test_arraylist_remove_all (ArrayListTests* self);
static void _array_list_tests_test_arraylist_remove_all_test_fixture_test_method (gpointer self);
static void array_list_tests_test_arraylist_retain_all (ArrayListTests* self);
static void _array_list_tests_test_arraylist_retain_all_test_fixture_test_method (gpointer self);
static void array_list_tests_test_arraylist_iterator (ArrayListTests* self);
static void _array_list_tests_test_arraylist_iterator_test_fixture_test_method (gpointer self);
ArrayListTests* array_list_tests_new (void);
ArrayListTests* array_list_tests_construct (GType object_type);
static void array_list_tests_real_setup (TestFixture* base);
static void array_list_tests_real_teardown (TestFixture* base);
GTestSuite* test_fixture_get_suite (TestFixture* self);
void _main (char** args, int args_length1);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _array_list_tests_test_arraylist_get_test_fixture_test_method (gpointer self) {
	array_list_tests_test_arraylist_get (self);
}


static void _array_list_tests_test_arraylist_set_test_fixture_test_method (gpointer self) {
	array_list_tests_test_arraylist_set (self);
}


static void _array_list_tests_test_arraylist_insert_test_fixture_test_method (gpointer self) {
	array_list_tests_test_arraylist_insert (self);
}


static void _array_list_tests_test_arraylist_remove_at_test_fixture_test_method (gpointer self) {
	array_list_tests_test_arraylist_remove_at (self);
}


static void _array_list_tests_test_arraylist_index_of_test_fixture_test_method (gpointer self) {
	array_list_tests_test_arraylist_index_of (self);
}


static void _array_list_tests_test_arraylist_first_test_fixture_test_method (gpointer self) {
	array_list_tests_test_arraylist_first (self);
}


static void _array_list_tests_test_arraylist_last_test_fixture_test_method (gpointer self) {
	array_list_tests_test_arraylist_last (self);
}


static void _array_list_tests_test_arraylist_insert_all_test_fixture_test_method (gpointer self) {
	array_list_tests_test_arraylist_insert_all (self);
}


static void _array_list_tests_test_arraylist_add_test_fixture_test_method (gpointer self) {
	array_list_tests_test_arraylist_add (self);
}


static void _array_list_tests_test_arraylist_clear_test_fixture_test_method (gpointer self) {
	array_list_tests_test_arraylist_clear (self);
}


static void _array_list_tests_test_arraylist_contains_test_fixture_test_method (gpointer self) {
	array_list_tests_test_arraylist_contains (self);
}


static void _array_list_tests_test_arraylist_remove_test_fixture_test_method (gpointer self) {
	array_list_tests_test_arraylist_remove (self);
}


static void _array_list_tests_test_arraylist_size_test_fixture_test_method (gpointer self) {
	array_list_tests_test_arraylist_size (self);
}


static void _array_list_tests_test_arraylist_empty_test_fixture_test_method (gpointer self) {
	array_list_tests_test_arraylist_empty (self);
}


static void _array_list_tests_test_arraylist_add_all_test_fixture_test_method (gpointer self) {
	array_list_tests_test_arraylist_add_all (self);
}


static void _array_list_tests_test_arraylist_contains_all_test_fixture_test_method (gpointer self) {
	array_list_tests_test_arraylist_contains_all (self);
}


static void _array_list_tests_test_arraylist_remove_all_test_fixture_test_method (gpointer self) {
	array_list_tests_test_arraylist_remove_all (self);
}


static void _array_list_tests_test_arraylist_retain_all_test_fixture_test_method (gpointer self) {
	array_list_tests_test_arraylist_retain_all (self);
}


static void _array_list_tests_test_arraylist_iterator_test_fixture_test_method (gpointer self) {
	array_list_tests_test_arraylist_iterator (self);
}


ArrayListTests* array_list_tests_construct (GType object_type) {
	ArrayListTests * self;
	self = (ArrayListTests*) collection_tests_construct (object_type, "ArrayList");
	test_fixture_add_test ((TestFixture*) self, "get", (TestFixtureTestMethod) _array_list_tests_test_arraylist_get_test_fixture_test_method, self);
	test_fixture_add_test ((TestFixture*) self, "set", (TestFixtureTestMethod) _array_list_tests_test_arraylist_set_test_fixture_test_method, self);
	test_fixture_add_test ((TestFixture*) self, "insert", (TestFixtureTestMethod) _array_list_tests_test_arraylist_insert_test_fixture_test_method, self);
	test_fixture_add_test ((TestFixture*) self, "remove_at", (TestFixtureTestMethod) _array_list_tests_test_arraylist_remove_at_test_fixture_test_method, self);
	test_fixture_add_test ((TestFixture*) self, "index_of", (TestFixtureTestMethod) _array_list_tests_test_arraylist_index_of_test_fixture_test_method, self);
	test_fixture_add_test ((TestFixture*) self, "first", (TestFixtureTestMethod) _array_list_tests_test_arraylist_first_test_fixture_test_method, self);
	test_fixture_add_test ((TestFixture*) self, "last", (TestFixtureTestMethod) _array_list_tests_test_arraylist_last_test_fixture_test_method, self);
	test_fixture_add_test ((TestFixture*) self, "insert_all", (TestFixtureTestMethod) _array_list_tests_test_arraylist_insert_all_test_fixture_test_method, self);
	test_fixture_add_test ((TestFixture*) self, "add", (TestFixtureTestMethod) _array_list_tests_test_arraylist_add_test_fixture_test_method, self);
	test_fixture_add_test ((TestFixture*) self, "clear", (TestFixtureTestMethod) _array_list_tests_test_arraylist_clear_test_fixture_test_method, self);
	test_fixture_add_test ((TestFixture*) self, "contains", (TestFixtureTestMethod) _array_list_tests_test_arraylist_contains_test_fixture_test_method, self);
	test_fixture_add_test ((TestFixture*) self, "remove", (TestFixtureTestMethod) _array_list_tests_test_arraylist_remove_test_fixture_test_method, self);
	test_fixture_add_test ((TestFixture*) self, "size", (TestFixtureTestMethod) _array_list_tests_test_arraylist_size_test_fixture_test_method, self);
	test_fixture_add_test ((TestFixture*) self, "empty", (TestFixtureTestMethod) _array_list_tests_test_arraylist_empty_test_fixture_test_method, self);
	test_fixture_add_test ((TestFixture*) self, "add_all", (TestFixtureTestMethod) _array_list_tests_test_arraylist_add_all_test_fixture_test_method, self);
	test_fixture_add_test ((TestFixture*) self, "contains_all", (TestFixtureTestMethod) _array_list_tests_test_arraylist_contains_all_test_fixture_test_method, self);
	test_fixture_add_test ((TestFixture*) self, "remove_all", (TestFixtureTestMethod) _array_list_tests_test_arraylist_remove_all_test_fixture_test_method, self);
	test_fixture_add_test ((TestFixture*) self, "retain_all", (TestFixtureTestMethod) _array_list_tests_test_arraylist_retain_all_test_fixture_test_method, self);
	test_fixture_add_test ((TestFixture*) self, "iterator", (TestFixtureTestMethod) _array_list_tests_test_arraylist_iterator_test_fixture_test_method, self);
	return self;
}


ArrayListTests* array_list_tests_new (void) {
	return array_list_tests_construct (TYPE_ARRAY_LIST_TESTS);
}


static void array_list_tests_real_setup (TestFixture* base) {
	ArrayListTests * self;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	self = (ArrayListTests*) base;
	_tmp0_ = NULL;
	((CollectionTests*) self)->int_collection = (_tmp0_ = (GeeCollection*) gee_array_list_new (G_TYPE_INT, NULL, NULL, g_direct_equal), (((CollectionTests*) self)->int_collection == NULL) ? NULL : (((CollectionTests*) self)->int_collection = (g_object_unref (((CollectionTests*) self)->int_collection), NULL)), _tmp0_);
	_tmp1_ = NULL;
	((CollectionTests*) self)->string_collection = (_tmp1_ = (GeeCollection*) gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_str_equal), (((CollectionTests*) self)->string_collection == NULL) ? NULL : (((CollectionTests*) self)->string_collection = (g_object_unref (((CollectionTests*) self)->string_collection), NULL)), _tmp1_);
	_tmp2_ = NULL;
	((CollectionTests*) self)->object_collection = (_tmp2_ = (GeeCollection*) gee_array_list_new (G_TYPE_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal), (((CollectionTests*) self)->object_collection == NULL) ? NULL : (((CollectionTests*) self)->object_collection = (g_object_unref (((CollectionTests*) self)->object_collection), NULL)), _tmp2_);
}


static void array_list_tests_real_teardown (TestFixture* base) {
	ArrayListTests * self;
	GeeCollection* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	self = (ArrayListTests*) base;
	_tmp0_ = NULL;
	((CollectionTests*) self)->int_collection = (_tmp0_ = NULL, (((CollectionTests*) self)->int_collection == NULL) ? NULL : (((CollectionTests*) self)->int_collection = (g_object_unref (((CollectionTests*) self)->int_collection), NULL)), _tmp0_);
	_tmp1_ = NULL;
	((CollectionTests*) self)->string_collection = (_tmp1_ = NULL, (((CollectionTests*) self)->string_collection == NULL) ? NULL : (((CollectionTests*) self)->string_collection = (g_object_unref (((CollectionTests*) self)->string_collection), NULL)), _tmp1_);
	_tmp2_ = NULL;
	((CollectionTests*) self)->object_collection = (_tmp2_ = NULL, (((CollectionTests*) self)->object_collection == NULL) ? NULL : (((CollectionTests*) self)->object_collection = (g_object_unref (((CollectionTests*) self)->object_collection), NULL)), _tmp2_);
}


static void array_list_tests_test_arraylist_get (ArrayListTests* self) {
	GeeList* _tmp1_;
	GeeCollection* _tmp0_;
	GeeList* arraylistOfString;
	char* _tmp3_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	arraylistOfString = (_tmp1_ = (_tmp0_ = ((CollectionTests*) self)->string_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_));
	/* Check get for empty list*/
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp2_;
		_tmp2_ = NULL;
		_tmp2_ = (char*) gee_list_get (arraylistOfString, 0);
		_tmp2_ = (g_free (_tmp2_), NULL);
		(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
		return;
	}
	g_test_trap_assert_failed ();
	/* Check get for valid index in list with one element*/
	gee_collection_add ((GeeCollection*) arraylistOfString, "1");
	_tmp3_ = NULL;
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_list_get (arraylistOfString, 0), "1") == 0);
	_tmp3_ = (g_free (_tmp3_), NULL);
	/* Check get for indexes out of range*/
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp4_;
		_tmp4_ = NULL;
		_tmp4_ = (char*) gee_list_get (arraylistOfString, 1);
		_tmp4_ = (g_free (_tmp4_), NULL);
		(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
		return;
	}
	g_test_trap_assert_failed ();
	/* Check get for invalid index number*/
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp5_;
		_tmp5_ = NULL;
		_tmp5_ = (char*) gee_list_get (arraylistOfString, -1);
		_tmp5_ = (g_free (_tmp5_), NULL);
		(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
		return;
	}
	g_test_trap_assert_failed ();
	/* Check get for valid indexes in list with multiple element*/
	gee_collection_add ((GeeCollection*) arraylistOfString, "2");
	gee_collection_add ((GeeCollection*) arraylistOfString, "3");
	_tmp6_ = NULL;
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_list_get (arraylistOfString, 0), "1") == 0);
	_tmp6_ = (g_free (_tmp6_), NULL);
	_tmp7_ = NULL;
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_list_get (arraylistOfString, 1), "2") == 0);
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp8_ = NULL;
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_list_get (arraylistOfString, 2), "3") == 0);
	_tmp8_ = (g_free (_tmp8_), NULL);
	/* Check get if list is cleared and empty again*/
	gee_collection_clear ((GeeCollection*) arraylistOfString);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp9_;
		_tmp9_ = NULL;
		_tmp9_ = (char*) gee_list_get (arraylistOfString, 0);
		_tmp9_ = (g_free (_tmp9_), NULL);
		(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
		return;
	}
	g_test_trap_assert_failed ();
	(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
}


static void array_list_tests_test_arraylist_set (ArrayListTests* self) {
	GeeList* _tmp1_;
	GeeCollection* _tmp0_;
	GeeList* arraylistOfString;
	char* _tmp2_;
	char* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	arraylistOfString = (_tmp1_ = (_tmp0_ = ((CollectionTests*) self)->string_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_));
	/* Check set when list is empty.*/
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfString) == 0);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_set (arraylistOfString, 0, "0");
		(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
		return;
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfString) == 0);
	/* Check set when one item is in list*/
	gee_collection_add ((GeeCollection*) arraylistOfString, "1");
	/* Add item "1"*/
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfString) == 1);
	_tmp2_ = NULL;
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_list_get (arraylistOfString, 0), "1") == 0);
	_tmp2_ = (g_free (_tmp2_), NULL);
	gee_list_set (arraylistOfString, 0, "2");
	/* Set the item to value 2*/
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfString) == 1);
	_tmp3_ = NULL;
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_list_get (arraylistOfString, 0), "2") == 0);
	_tmp3_ = (g_free (_tmp3_), NULL);
	/* Check set when index out of range*/
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfString) == 1);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_set (arraylistOfString, 1, "0");
		(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
		return;
	}
	g_test_trap_assert_failed ();
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfString) == 1);
	(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
}


static void array_list_tests_test_arraylist_insert (ArrayListTests* self) {
	GeeList* _tmp1_;
	GeeCollection* _tmp0_;
	GeeList* arraylistOfString;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	arraylistOfString = (_tmp1_ = (_tmp0_ = ((CollectionTests*) self)->string_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_));
	/* Check inserting in empty list
	 Inserting at index 1*/
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_insert (arraylistOfString, 1, "0");
		(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
		return;
	}
	g_test_trap_assert_failed ();
	/* Inserting at index 0*/
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfString) == 0);
	gee_list_insert (arraylistOfString, 0, "10");
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfString) == 1);
	_tmp2_ = NULL;
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_list_get (arraylistOfString, 0), "10") == 0);
	_tmp2_ = (g_free (_tmp2_), NULL);
	/* Check insert to the beginning*/
	gee_list_insert (arraylistOfString, 0, "5");
	_tmp3_ = NULL;
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_list_get (arraylistOfString, 0), "5") == 0);
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp4_ = NULL;
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_list_get (arraylistOfString, 1), "10") == 0);
	_tmp4_ = (g_free (_tmp4_), NULL);
	/* Check insert in between*/
	gee_list_insert (arraylistOfString, 1, "7");
	_tmp5_ = NULL;
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_list_get (arraylistOfString, 0), "5") == 0);
	_tmp5_ = (g_free (_tmp5_), NULL);
	_tmp6_ = NULL;
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_list_get (arraylistOfString, 1), "7") == 0);
	_tmp6_ = (g_free (_tmp6_), NULL);
	_tmp7_ = NULL;
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_list_get (arraylistOfString, 2), "10") == 0);
	_tmp7_ = (g_free (_tmp7_), NULL);
	/* Check insert into index out of current range*/
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_insert (arraylistOfString, 4, "20");
		(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
		return;
	}
	g_test_trap_assert_failed ();
	/* Check insert to the end*/
	gee_list_insert (arraylistOfString, 3, "20");
	_tmp8_ = NULL;
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_list_get (arraylistOfString, 0), "5") == 0);
	_tmp8_ = (g_free (_tmp8_), NULL);
	_tmp9_ = NULL;
	g_assert (_vala_strcmp0 (_tmp9_ = (char*) gee_list_get (arraylistOfString, 1), "7") == 0);
	_tmp9_ = (g_free (_tmp9_), NULL);
	_tmp10_ = NULL;
	g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_list_get (arraylistOfString, 2), "10") == 0);
	_tmp10_ = (g_free (_tmp10_), NULL);
	_tmp11_ = NULL;
	g_assert (_vala_strcmp0 (_tmp11_ = (char*) gee_list_get (arraylistOfString, 3), "20") == 0);
	_tmp11_ = (g_free (_tmp11_), NULL);
	/* Check insert into invalid index*/
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_insert (arraylistOfString, -1, "0");
		(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
		return;
	}
	g_test_trap_assert_failed ();
	(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
}


static void array_list_tests_test_arraylist_remove_at (ArrayListTests* self) {
	GeeList* _tmp1_;
	GeeCollection* _tmp0_;
	GeeList* arraylistOfString;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	arraylistOfString = (_tmp1_ = (_tmp0_ = ((CollectionTests*) self)->string_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_));
	/* Check removing in empty list*/
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_remove_at (arraylistOfString, 0);
		(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
		return;
	}
	g_test_trap_assert_failed ();
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_remove_at (arraylistOfString, 1);
		(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
		return;
	}
	g_test_trap_assert_failed ();
	/* add 5 items*/
	gee_collection_add ((GeeCollection*) arraylistOfString, "1");
	gee_collection_add ((GeeCollection*) arraylistOfString, "2");
	gee_collection_add ((GeeCollection*) arraylistOfString, "3");
	gee_collection_add ((GeeCollection*) arraylistOfString, "4");
	gee_collection_add ((GeeCollection*) arraylistOfString, "5");
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfString) == 5);
	/* Check remove_at first*/
	gee_list_remove_at (arraylistOfString, 0);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfString) == 4);
	_tmp2_ = NULL;
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_list_get (arraylistOfString, 0), "2") == 0);
	_tmp2_ = (g_free (_tmp2_), NULL);
	_tmp3_ = NULL;
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_list_get (arraylistOfString, 1), "3") == 0);
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp4_ = NULL;
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_list_get (arraylistOfString, 2), "4") == 0);
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp5_ = NULL;
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_list_get (arraylistOfString, 3), "5") == 0);
	_tmp5_ = (g_free (_tmp5_), NULL);
	/* Check remove_at last*/
	gee_list_remove_at (arraylistOfString, 3);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfString) == 3);
	_tmp6_ = NULL;
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_list_get (arraylistOfString, 0), "2") == 0);
	_tmp6_ = (g_free (_tmp6_), NULL);
	_tmp7_ = NULL;
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_list_get (arraylistOfString, 1), "3") == 0);
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp8_ = NULL;
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_list_get (arraylistOfString, 2), "4") == 0);
	_tmp8_ = (g_free (_tmp8_), NULL);
	/* Check remove_at in between*/
	gee_list_remove_at (arraylistOfString, 1);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfString) == 2);
	_tmp9_ = NULL;
	g_assert (_vala_strcmp0 (_tmp9_ = (char*) gee_list_get (arraylistOfString, 0), "2") == 0);
	_tmp9_ = (g_free (_tmp9_), NULL);
	_tmp10_ = NULL;
	g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_list_get (arraylistOfString, 1), "4") == 0);
	_tmp10_ = (g_free (_tmp10_), NULL);
	/* Check remove_at when index out of range*/
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_remove_at (arraylistOfString, 2);
		(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
		return;
	}
	g_test_trap_assert_failed ();
	/* Check remove_at when invalid index*/
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_list_remove_at (arraylistOfString, -1);
		(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
		return;
	}
	g_test_trap_assert_failed ();
	(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
}


static void array_list_tests_test_arraylist_index_of (ArrayListTests* self) {
	GeeList* _tmp1_;
	GeeCollection* _tmp0_;
	GeeList* arraylistOfString;
	GeeList* _tmp3_;
	GeeCollection* _tmp2_;
	GeeList* arraylistOfInt;
	GeeList* _tmp5_;
	GeeCollection* _tmp4_;
	GeeList* arraylistOfObjects;
	GObject* object1;
	GObject* object2;
	GObject* object3;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	arraylistOfString = (_tmp1_ = (_tmp0_ = ((CollectionTests*) self)->string_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_));
	/* Check empty list*/
	g_assert (gee_list_index_of (arraylistOfString, "one") == (-1));
	/* Check one item*/
	gee_collection_add ((GeeCollection*) arraylistOfString, "one");
	g_assert (gee_list_index_of (arraylistOfString, "one") == 0);
	g_assert (gee_list_index_of (arraylistOfString, "two") == (-1));
	/* Check more items*/
	gee_collection_add ((GeeCollection*) arraylistOfString, "two");
	gee_collection_add ((GeeCollection*) arraylistOfString, "three");
	gee_collection_add ((GeeCollection*) arraylistOfString, "four");
	g_assert (gee_list_index_of (arraylistOfString, "one") == 0);
	g_assert (gee_list_index_of (arraylistOfString, "two") == 1);
	g_assert (gee_list_index_of (arraylistOfString, "three") == 2);
	g_assert (gee_list_index_of (arraylistOfString, "four") == 3);
	g_assert (gee_list_index_of (arraylistOfString, "five") == (-1));
	/* Check list of ints*/
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	arraylistOfInt = (_tmp3_ = (_tmp2_ = ((CollectionTests*) self)->int_collection, GEE_IS_LIST (_tmp2_) ? ((GeeList*) _tmp2_) : NULL), (_tmp3_ == NULL) ? NULL : g_object_ref (_tmp3_));
	/* Check more items*/
	gee_collection_add ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (1));
	gee_collection_add ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (2));
	gee_collection_add ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (3));
	g_assert (gee_list_index_of (arraylistOfInt, GINT_TO_POINTER (1)) == 0);
	g_assert (gee_list_index_of (arraylistOfInt, GINT_TO_POINTER (2)) == 1);
	g_assert (gee_list_index_of (arraylistOfInt, GINT_TO_POINTER (3)) == 2);
	g_assert (gee_list_index_of (arraylistOfInt, GINT_TO_POINTER (4)) == (-1));
	/* Check list of objects*/
	_tmp5_ = NULL;
	_tmp4_ = NULL;
	arraylistOfObjects = (_tmp5_ = (_tmp4_ = ((CollectionTests*) self)->object_collection, GEE_IS_LIST (_tmp4_) ? ((GeeList*) _tmp4_) : NULL), (_tmp5_ == NULL) ? NULL : g_object_ref (_tmp5_));
	object1 = g_object_new (G_TYPE_OBJECT, NULL);
	object2 = g_object_new (G_TYPE_OBJECT, NULL);
	object3 = g_object_new (G_TYPE_OBJECT, NULL);
	gee_collection_add ((GeeCollection*) arraylistOfObjects, object1);
	gee_collection_add ((GeeCollection*) arraylistOfObjects, object2);
	gee_collection_add ((GeeCollection*) arraylistOfObjects, object3);
	g_assert (gee_list_index_of (arraylistOfObjects, object1) == 0);
	g_assert (gee_list_index_of (arraylistOfObjects, object2) == 1);
	g_assert (gee_list_index_of (arraylistOfObjects, object3) == 2);
	(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
	(arraylistOfInt == NULL) ? NULL : (arraylistOfInt = (g_object_unref (arraylistOfInt), NULL));
	(arraylistOfObjects == NULL) ? NULL : (arraylistOfObjects = (g_object_unref (arraylistOfObjects), NULL));
	(object1 == NULL) ? NULL : (object1 = (g_object_unref (object1), NULL));
	(object2 == NULL) ? NULL : (object2 = (g_object_unref (object2), NULL));
	(object3 == NULL) ? NULL : (object3 = (g_object_unref (object3), NULL));
}


static void array_list_tests_test_arraylist_add (ArrayListTests* self) {
	GeeList* _tmp1_;
	GeeCollection* _tmp0_;
	GeeList* arraylistOfString;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	GeeList* _tmp7_;
	GeeCollection* _tmp6_;
	GeeList* arrayListOfInt;
	GeeArrayList* arrayListOfGLibObject;
	GObject* fooObject;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	arraylistOfString = (_tmp1_ = (_tmp0_ = ((CollectionTests*) self)->string_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_));
	gee_collection_add ((GeeCollection*) arraylistOfString, "42");
	g_assert (gee_collection_contains ((GeeCollection*) arraylistOfString, "42"));
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfString) == 1);
	/* check for correct order of elements*/
	gee_collection_add ((GeeCollection*) arraylistOfString, "43");
	gee_collection_add ((GeeCollection*) arraylistOfString, "44");
	gee_collection_add ((GeeCollection*) arraylistOfString, "45");
	_tmp2_ = NULL;
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_list_get (arraylistOfString, 0), "42") == 0);
	_tmp2_ = (g_free (_tmp2_), NULL);
	_tmp3_ = NULL;
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_list_get (arraylistOfString, 1), "43") == 0);
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp4_ = NULL;
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_list_get (arraylistOfString, 2), "44") == 0);
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp5_ = NULL;
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_list_get (arraylistOfString, 3), "45") == 0);
	_tmp5_ = (g_free (_tmp5_), NULL);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfString) == 4);
	/* check adding of ints*/
	_tmp7_ = NULL;
	_tmp6_ = NULL;
	arrayListOfInt = (_tmp7_ = (_tmp6_ = ((CollectionTests*) self)->int_collection, GEE_IS_LIST (_tmp6_) ? ((GeeList*) _tmp6_) : NULL), (_tmp7_ == NULL) ? NULL : g_object_ref (_tmp7_));
	gee_collection_add ((GeeCollection*) arrayListOfInt, GINT_TO_POINTER (42));
	g_assert (gee_collection_contains ((GeeCollection*) arrayListOfInt, GINT_TO_POINTER (42)));
	g_assert (gee_collection_get_size ((GeeCollection*) arrayListOfInt) == 1);
	/* check adding of objects*/
	arrayListOfGLibObject = gee_array_list_new (G_TYPE_OBJECT, (GBoxedCopyFunc) g_object_ref, g_object_unref, g_direct_equal);
	fooObject = g_object_new (G_TYPE_OBJECT, NULL);
	gee_abstract_collection_add ((GeeAbstractCollection*) arrayListOfGLibObject, fooObject);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) arrayListOfGLibObject, fooObject));
	g_assert (gee_collection_get_size ((GeeCollection*) arrayListOfGLibObject) == 1);
	(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
	(arrayListOfInt == NULL) ? NULL : (arrayListOfInt = (g_object_unref (arrayListOfInt), NULL));
	(arrayListOfGLibObject == NULL) ? NULL : (arrayListOfGLibObject = (g_object_unref (arrayListOfGLibObject), NULL));
	(fooObject == NULL) ? NULL : (fooObject = (g_object_unref (fooObject), NULL));
}


static void array_list_tests_test_arraylist_clear (ArrayListTests* self) {
	GeeCollection* _tmp1_;
	GeeCollection* _tmp0_;
	GeeCollection* arraylistOfString;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	arraylistOfString = (_tmp1_ = (_tmp0_ = ((CollectionTests*) self)->string_collection, GEE_IS_COLLECTION (_tmp0_) ? ((GeeCollection*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_));
	g_assert (gee_collection_get_size (arraylistOfString) == 0);
	/* Check clear on empty list*/
	gee_collection_clear (arraylistOfString);
	g_assert (gee_collection_get_size (arraylistOfString) == 0);
	/* Check clear one item*/
	gee_collection_add (arraylistOfString, "1");
	g_assert (gee_collection_get_size (arraylistOfString) == 1);
	gee_collection_clear (arraylistOfString);
	g_assert (gee_collection_get_size (arraylistOfString) == 0);
	/* Check clear multiple items*/
	gee_collection_add (arraylistOfString, "1");
	gee_collection_add (arraylistOfString, "2");
	gee_collection_add (arraylistOfString, "3");
	g_assert (gee_collection_get_size (arraylistOfString) == 3);
	gee_collection_clear (arraylistOfString);
	g_assert (gee_collection_get_size (arraylistOfString) == 0);
	(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
}


static void array_list_tests_test_arraylist_contains (ArrayListTests* self) {
	GeeList* _tmp1_;
	GeeCollection* _tmp0_;
	GeeList* arraylistOfString;
	GeeList* _tmp3_;
	GeeCollection* _tmp2_;
	GeeList* arraylistOfInt;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	arraylistOfString = (_tmp1_ = (_tmp0_ = ((CollectionTests*) self)->string_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_));
	/* Check on empty list*/
	g_assert (!gee_collection_contains ((GeeCollection*) arraylistOfString, "1"));
	/* Check items*/
	gee_collection_add ((GeeCollection*) arraylistOfString, "10");
	g_assert (gee_collection_contains ((GeeCollection*) arraylistOfString, "10"));
	g_assert (!gee_collection_contains ((GeeCollection*) arraylistOfString, "20"));
	g_assert (!gee_collection_contains ((GeeCollection*) arraylistOfString, "30"));
	gee_collection_add ((GeeCollection*) arraylistOfString, "20");
	g_assert (gee_collection_contains ((GeeCollection*) arraylistOfString, "10"));
	g_assert (gee_collection_contains ((GeeCollection*) arraylistOfString, "20"));
	g_assert (!gee_collection_contains ((GeeCollection*) arraylistOfString, "30"));
	gee_collection_add ((GeeCollection*) arraylistOfString, "30");
	g_assert (gee_collection_contains ((GeeCollection*) arraylistOfString, "10"));
	g_assert (gee_collection_contains ((GeeCollection*) arraylistOfString, "20"));
	g_assert (gee_collection_contains ((GeeCollection*) arraylistOfString, "30"));
	/* Clear and recheck*/
	gee_collection_clear ((GeeCollection*) arraylistOfString);
	g_assert (!gee_collection_contains ((GeeCollection*) arraylistOfString, "10"));
	g_assert (!gee_collection_contains ((GeeCollection*) arraylistOfString, "20"));
	g_assert (!gee_collection_contains ((GeeCollection*) arraylistOfString, "30"));
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	arraylistOfInt = (_tmp3_ = (_tmp2_ = ((CollectionTests*) self)->int_collection, GEE_IS_LIST (_tmp2_) ? ((GeeList*) _tmp2_) : NULL), (_tmp3_ == NULL) ? NULL : g_object_ref (_tmp3_));
	/* Check items*/
	gee_collection_add ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (10));
	g_assert (gee_collection_contains ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (10)));
	g_assert (!gee_collection_contains ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (20)));
	g_assert (!gee_collection_contains ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (30)));
	gee_collection_add ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (20));
	g_assert (gee_collection_contains ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (10)));
	g_assert (gee_collection_contains ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (20)));
	g_assert (!gee_collection_contains ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (30)));
	gee_collection_add ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (30));
	g_assert (gee_collection_contains ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (10)));
	g_assert (gee_collection_contains ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (20)));
	g_assert (gee_collection_contains ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (30)));
	/* Clear and recheck*/
	gee_collection_clear ((GeeCollection*) arraylistOfInt);
	g_assert (!gee_collection_contains ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (10)));
	g_assert (!gee_collection_contains ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (20)));
	g_assert (!gee_collection_contains ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (30)));
	(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
	(arraylistOfInt == NULL) ? NULL : (arraylistOfInt = (g_object_unref (arraylistOfInt), NULL));
}


static void array_list_tests_test_arraylist_remove (ArrayListTests* self) {
	GeeList* _tmp1_;
	GeeCollection* _tmp0_;
	GeeList* arraylistOfString;
	char* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	char* _tmp6_;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	GeeList* _tmp12_;
	GeeCollection* _tmp11_;
	GeeList* arraylistOfInt;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	arraylistOfString = (_tmp1_ = (_tmp0_ = ((CollectionTests*) self)->string_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_));
	/* Add 5 same elements*/
	gee_collection_add ((GeeCollection*) arraylistOfString, "42");
	gee_collection_add ((GeeCollection*) arraylistOfString, "42");
	gee_collection_add ((GeeCollection*) arraylistOfString, "42");
	gee_collection_add ((GeeCollection*) arraylistOfString, "42");
	gee_collection_add ((GeeCollection*) arraylistOfString, "42");
	/* Check remove one element*/
	gee_collection_remove ((GeeCollection*) arraylistOfString, "42");
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfString) == 4);
	g_assert (gee_collection_contains ((GeeCollection*) arraylistOfString, "42"));
	/* Check remove another one element*/
	gee_collection_remove ((GeeCollection*) arraylistOfString, "42");
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfString) == 3);
	g_assert (gee_collection_contains ((GeeCollection*) arraylistOfString, "42"));
	/* Clear the list to start from scratch*/
	gee_collection_clear ((GeeCollection*) arraylistOfString);
	/* Add 5 different elements*/
	gee_collection_add ((GeeCollection*) arraylistOfString, "42");
	gee_collection_add ((GeeCollection*) arraylistOfString, "43");
	gee_collection_add ((GeeCollection*) arraylistOfString, "44");
	gee_collection_add ((GeeCollection*) arraylistOfString, "45");
	gee_collection_add ((GeeCollection*) arraylistOfString, "46");
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfString) == 5);
	/* Check remove first*/
	gee_collection_remove ((GeeCollection*) arraylistOfString, "42");
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfString) == 4);
	_tmp2_ = NULL;
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_list_get (arraylistOfString, 0), "43") == 0);
	_tmp2_ = (g_free (_tmp2_), NULL);
	_tmp3_ = NULL;
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_list_get (arraylistOfString, 1), "44") == 0);
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp4_ = NULL;
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_list_get (arraylistOfString, 2), "45") == 0);
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp5_ = NULL;
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_list_get (arraylistOfString, 3), "46") == 0);
	_tmp5_ = (g_free (_tmp5_), NULL);
	/* Check remove last*/
	gee_collection_remove ((GeeCollection*) arraylistOfString, "46");
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfString) == 3);
	_tmp6_ = NULL;
	g_assert (_vala_strcmp0 (_tmp6_ = (char*) gee_list_get (arraylistOfString, 0), "43") == 0);
	_tmp6_ = (g_free (_tmp6_), NULL);
	_tmp7_ = NULL;
	g_assert (_vala_strcmp0 (_tmp7_ = (char*) gee_list_get (arraylistOfString, 1), "44") == 0);
	_tmp7_ = (g_free (_tmp7_), NULL);
	_tmp8_ = NULL;
	g_assert (_vala_strcmp0 (_tmp8_ = (char*) gee_list_get (arraylistOfString, 2), "45") == 0);
	_tmp8_ = (g_free (_tmp8_), NULL);
	/* Check remove in between*/
	gee_collection_remove ((GeeCollection*) arraylistOfString, "44");
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfString) == 2);
	_tmp9_ = NULL;
	g_assert (_vala_strcmp0 (_tmp9_ = (char*) gee_list_get (arraylistOfString, 0), "43") == 0);
	_tmp9_ = (g_free (_tmp9_), NULL);
	_tmp10_ = NULL;
	g_assert (_vala_strcmp0 (_tmp10_ = (char*) gee_list_get (arraylistOfString, 1), "45") == 0);
	_tmp10_ = (g_free (_tmp10_), NULL);
	/* Check removing of int element*/
	_tmp12_ = NULL;
	_tmp11_ = NULL;
	arraylistOfInt = (_tmp12_ = (_tmp11_ = ((CollectionTests*) self)->int_collection, GEE_IS_LIST (_tmp11_) ? ((GeeList*) _tmp11_) : NULL), (_tmp12_ == NULL) ? NULL : g_object_ref (_tmp12_));
	/* Add 5 different elements*/
	gee_collection_add ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (42));
	gee_collection_add ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (43));
	gee_collection_add ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (44));
	gee_collection_add ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (45));
	gee_collection_add ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (46));
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfInt) == 5);
	/* Remove first*/
	gee_collection_remove ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (42));
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfInt) == 4);
	g_assert (GPOINTER_TO_INT (gee_list_get (arraylistOfInt, 0)) == 43);
	g_assert (GPOINTER_TO_INT (gee_list_get (arraylistOfInt, 1)) == 44);
	g_assert (GPOINTER_TO_INT (gee_list_get (arraylistOfInt, 2)) == 45);
	g_assert (GPOINTER_TO_INT (gee_list_get (arraylistOfInt, 3)) == 46);
	/* Remove last*/
	gee_collection_remove ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (46));
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfInt) == 3);
	g_assert (GPOINTER_TO_INT (gee_list_get (arraylistOfInt, 0)) == 43);
	g_assert (GPOINTER_TO_INT (gee_list_get (arraylistOfInt, 1)) == 44);
	g_assert (GPOINTER_TO_INT (gee_list_get (arraylistOfInt, 2)) == 45);
	/* Remove in between*/
	gee_collection_remove ((GeeCollection*) arraylistOfInt, GINT_TO_POINTER (44));
	g_assert (gee_collection_get_size ((GeeCollection*) arraylistOfInt) == 2);
	g_assert (GPOINTER_TO_INT (gee_list_get (arraylistOfInt, 0)) == 43);
	g_assert (GPOINTER_TO_INT (gee_list_get (arraylistOfInt, 1)) == 45);
	(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
	(arraylistOfInt == NULL) ? NULL : (arraylistOfInt = (g_object_unref (arraylistOfInt), NULL));
}


static void array_list_tests_test_arraylist_size (ArrayListTests* self) {
	GeeList* _tmp1_;
	GeeCollection* _tmp0_;
	GeeList* arraylist;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	arraylist = (_tmp1_ = (_tmp0_ = ((CollectionTests*) self)->string_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_));
	/* Check empty list*/
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist) == 0);
	/* Check when one item*/
	gee_collection_add ((GeeCollection*) arraylist, "1");
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist) == 1);
	/* Check when more items*/
	gee_collection_add ((GeeCollection*) arraylist, "2");
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist) == 2);
	/* Check when items cleared*/
	gee_collection_clear ((GeeCollection*) arraylist);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist) == 0);
	(arraylist == NULL) ? NULL : (arraylist = (g_object_unref (arraylist), NULL));
}


static void array_list_tests_test_arraylist_iterator (ArrayListTests* self) {
	GeeList* _tmp1_;
	GeeCollection* _tmp0_;
	GeeList* arraylistOfString;
	GeeIterator* iterator;
	GeeIterator* _tmp2_;
	char* _tmp3_;
	char* _tmp4_;
	char* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp1_ = NULL;
	_tmp0_ = NULL;
	arraylistOfString = (_tmp1_ = (_tmp0_ = ((CollectionTests*) self)->string_collection, GEE_IS_LIST (_tmp0_) ? ((GeeList*) _tmp0_) : NULL), (_tmp1_ == NULL) ? NULL : g_object_ref (_tmp1_));
	/* Check iterate empty list*/
	iterator = gee_iterable_iterator ((GeeIterable*) arraylistOfString);
	g_assert (!gee_iterator_next (iterator));
	/* Check iterate list*/
	gee_collection_add ((GeeCollection*) arraylistOfString, "42");
	gee_collection_add ((GeeCollection*) arraylistOfString, "43");
	gee_collection_add ((GeeCollection*) arraylistOfString, "44");
	_tmp2_ = NULL;
	iterator = (_tmp2_ = gee_iterable_iterator ((GeeIterable*) arraylistOfString), (iterator == NULL) ? NULL : (iterator = (g_object_unref (iterator), NULL)), _tmp2_);
	g_assert (gee_iterator_next (iterator));
	_tmp3_ = NULL;
	g_assert (_vala_strcmp0 (_tmp3_ = (char*) gee_iterator_get (iterator), "42") == 0);
	_tmp3_ = (g_free (_tmp3_), NULL);
	g_assert (gee_iterator_next (iterator));
	_tmp4_ = NULL;
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_iterator_get (iterator), "43") == 0);
	_tmp4_ = (g_free (_tmp4_), NULL);
	g_assert (gee_iterator_next (iterator));
	_tmp5_ = NULL;
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_iterator_get (iterator), "44") == 0);
	_tmp5_ = (g_free (_tmp5_), NULL);
	g_assert (!gee_iterator_next (iterator));
	(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
	(iterator == NULL) ? NULL : (iterator = (g_object_unref (iterator), NULL));
}


static void array_list_tests_test_arraylist_empty (ArrayListTests* self) {
	GeeArrayList* arraylist;
	g_return_if_fail (self != NULL);
	arraylist = gee_array_list_new (G_TYPE_INT, NULL, NULL, g_direct_equal);
	/* Check empty list*/
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) arraylist));
	/* Check when one item*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist, GINT_TO_POINTER (1));
	g_assert (!gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) arraylist));
	/* Check when more items*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist, GINT_TO_POINTER (2));
	g_assert (!gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) arraylist));
	/* Check when items cleared*/
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist);
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) arraylist));
	(arraylist == NULL) ? NULL : (arraylist = (g_object_unref (arraylist), NULL));
}


static void array_list_tests_test_arraylist_add_all (ArrayListTests* self) {
	GeeArrayList* list1;
	GeeArrayList* list2;
	g_return_if_fail (self != NULL);
	list1 = gee_array_list_new (G_TYPE_INT, NULL, NULL, g_direct_equal);
	list2 = gee_array_list_new (G_TYPE_INT, NULL, NULL, g_direct_equal);
	/* Check lists empty*/
	gee_abstract_collection_add_all ((GeeAbstractCollection*) list1, (GeeCollection*) list2);
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) list1));
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) list2));
	/* Check list1 not empty, list2 is empty*/
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (1));
	gee_abstract_collection_add_all ((GeeAbstractCollection*) list1, (GeeCollection*) list2);
	g_assert (gee_collection_get_size ((GeeCollection*) list1) == 1);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) list1, GINT_TO_POINTER (1)));
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) list2));
	gee_abstract_collection_clear ((GeeAbstractCollection*) list1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) list2);
	/* Check list1 empty, list2 contains 1 element*/
	gee_abstract_collection_add ((GeeAbstractCollection*) list2, GINT_TO_POINTER (1));
	gee_abstract_collection_add_all ((GeeAbstractCollection*) list1, (GeeCollection*) list2);
	g_assert (gee_collection_get_size ((GeeCollection*) list1) == 1);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) list1, GINT_TO_POINTER (1)));
	g_assert (gee_collection_get_size ((GeeCollection*) list2) == 1);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) list2, GINT_TO_POINTER (1)));
	gee_abstract_collection_clear ((GeeAbstractCollection*) list1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) list2);
	/* Check correct order with more elements*/
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (0));
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) list2, GINT_TO_POINTER (3));
	gee_abstract_collection_add ((GeeAbstractCollection*) list2, GINT_TO_POINTER (4));
	gee_abstract_collection_add ((GeeAbstractCollection*) list2, GINT_TO_POINTER (5));
	gee_abstract_collection_add_all ((GeeAbstractCollection*) list1, (GeeCollection*) list2);
	g_assert (gee_collection_get_size ((GeeCollection*) list1) == 6);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) list1, 0)) == 0);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) list1, 1)) == 1);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) list1, 2)) == 2);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) list1, 3)) == 3);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) list1, 4)) == 4);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) list1, 5)) == 5);
	g_assert (gee_collection_get_size ((GeeCollection*) list2) == 3);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) list2, 0)) == 3);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) list2, 1)) == 4);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) list2, 2)) == 5);
	gee_abstract_collection_clear ((GeeAbstractCollection*) list1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) list2);
	/* Add large collections*/
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (0));
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (2));
	{
		gint i;
		i = 3;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < 103)) {
					break;
				}
				gee_abstract_collection_add ((GeeAbstractCollection*) list2, GINT_TO_POINTER (i));
			}
		}
	}
	gee_abstract_collection_add_all ((GeeAbstractCollection*) list1, (GeeCollection*) list2);
	g_assert (gee_collection_get_size ((GeeCollection*) list1) == 103);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) list1, 0)) == 0);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) list1, 1)) == 1);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) list1, 2)) == 2);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) list1, 3)) == 3);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) list1, 4)) == 4);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) list1, 99)) == 99);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) list1, 100)) == 100);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) list1, 101)) == 101);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) list1, 102)) == 102);
	g_assert (gee_collection_get_size ((GeeCollection*) list2) == 100);
	gee_abstract_collection_clear ((GeeAbstractCollection*) list1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) list2);
	(list1 == NULL) ? NULL : (list1 = (g_object_unref (list1), NULL));
	(list2 == NULL) ? NULL : (list2 = (g_object_unref (list2), NULL));
}


static void array_list_tests_test_arraylist_contains_all (ArrayListTests* self) {
	GeeArrayList* list1;
	GeeArrayList* list2;
	g_return_if_fail (self != NULL);
	list1 = gee_array_list_new (G_TYPE_INT, NULL, NULL, g_direct_equal);
	list2 = gee_array_list_new (G_TYPE_INT, NULL, NULL, g_direct_equal);
	/* Check empty*/
	g_assert (gee_abstract_collection_contains_all ((GeeAbstractCollection*) list1, (GeeCollection*) list2));
	/* list1 has elements, list2 is empty*/
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (1));
	g_assert (gee_abstract_collection_contains_all ((GeeAbstractCollection*) list1, (GeeCollection*) list2));
	gee_abstract_collection_clear ((GeeAbstractCollection*) list1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) list2);
	/* list1 is empty, list2 has elements*/
	gee_abstract_collection_add ((GeeAbstractCollection*) list2, GINT_TO_POINTER (1));
	g_assert (!gee_abstract_collection_contains_all ((GeeAbstractCollection*) list1, (GeeCollection*) list2));
	gee_abstract_collection_clear ((GeeAbstractCollection*) list1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) list2);
	/* list1 and list2 are the same*/
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) list2, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (2));
	g_assert (gee_abstract_collection_contains_all ((GeeAbstractCollection*) list1, (GeeCollection*) list2));
	gee_abstract_collection_clear ((GeeAbstractCollection*) list1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) list2);
	/* list1 and list2 are the same*/
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) list2, GINT_TO_POINTER (2));
	g_assert (!gee_abstract_collection_contains_all ((GeeAbstractCollection*) list1, (GeeCollection*) list2));
	gee_abstract_collection_clear ((GeeAbstractCollection*) list1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) list2);
	/* list1 has a subset of list2*/
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (3));
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (4));
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (5));
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (6));
	gee_abstract_collection_add ((GeeAbstractCollection*) list2, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) list2, GINT_TO_POINTER (4));
	gee_abstract_collection_add ((GeeAbstractCollection*) list2, GINT_TO_POINTER (6));
	g_assert (gee_abstract_collection_contains_all ((GeeAbstractCollection*) list1, (GeeCollection*) list2));
	gee_abstract_collection_clear ((GeeAbstractCollection*) list1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) list2);
	/* list1 has a subset of in all but one element list2*/
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (3));
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (4));
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (5));
	gee_abstract_collection_add ((GeeAbstractCollection*) list1, GINT_TO_POINTER (6));
	gee_abstract_collection_add ((GeeAbstractCollection*) list2, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) list2, GINT_TO_POINTER (4));
	gee_abstract_collection_add ((GeeAbstractCollection*) list2, GINT_TO_POINTER (6));
	gee_abstract_collection_add ((GeeAbstractCollection*) list2, GINT_TO_POINTER (7));
	g_assert (!gee_abstract_collection_contains_all ((GeeAbstractCollection*) list1, (GeeCollection*) list2));
	gee_abstract_collection_clear ((GeeAbstractCollection*) list1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) list2);
	(list1 == NULL) ? NULL : (list1 = (g_object_unref (list1), NULL));
	(list2 == NULL) ? NULL : (list2 = (g_object_unref (list2), NULL));
}


static void array_list_tests_test_arraylist_remove_all (ArrayListTests* self) {
	GeeArrayList* arraylist1;
	GeeArrayList* arraylist2;
	g_return_if_fail (self != NULL);
	arraylist1 = gee_array_list_new (G_TYPE_INT, NULL, NULL, g_direct_equal);
	arraylist2 = gee_array_list_new (G_TYPE_INT, NULL, NULL, g_direct_equal);
	/* Check empty*/
	gee_abstract_collection_remove_all ((GeeAbstractCollection*) arraylist1, (GeeCollection*) arraylist2);
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) arraylist1));
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) arraylist2));
	/* Arraylist1 and arraylist2 have no common elements -> nothing is removed in arraylist1*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (3));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (4));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (5));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (6));
	gee_abstract_collection_remove_all ((GeeAbstractCollection*) arraylist1, (GeeCollection*) arraylist2);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 3);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist2);
	/* Arraylist1 and arraylist2 have all elements the same -> everything is removed in arraylist1 but not arraylist2*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (3));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (3));
	gee_abstract_collection_remove_all ((GeeAbstractCollection*) arraylist1, (GeeCollection*) arraylist2);
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) arraylist1));
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 3);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist2);
	/* Removing of same elements*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (1));
	gee_abstract_collection_remove_all ((GeeAbstractCollection*) arraylist1, (GeeCollection*) arraylist2);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 2);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist2);
	(arraylist1 == NULL) ? NULL : (arraylist1 = (g_object_unref (arraylist1), NULL));
	(arraylist2 == NULL) ? NULL : (arraylist2 = (g_object_unref (arraylist2), NULL));
}


static void array_list_tests_test_arraylist_retain_all (ArrayListTests* self) {
	GeeArrayList* arraylist1;
	GeeArrayList* arraylist2;
	g_return_if_fail (self != NULL);
	arraylist1 = gee_array_list_new (G_TYPE_INT, NULL, NULL, g_direct_equal);
	arraylist2 = gee_array_list_new (G_TYPE_INT, NULL, NULL, g_direct_equal);
	/* Check empty*/
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) arraylist1));
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) arraylist2));
	gee_abstract_collection_retain_all ((GeeAbstractCollection*) arraylist1, (GeeCollection*) arraylist2);
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) arraylist1));
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) arraylist2));
	/* Arraylist1 has elements, arraylist2 is empty -> everything in arraylist1 is removed*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (3));
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 0);
	gee_abstract_collection_retain_all ((GeeAbstractCollection*) arraylist1, (GeeCollection*) arraylist2);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 0);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist2);
	/* Arraylist1 is empty and arraylist2 has elements -> nothing changes*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (4));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (5));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (6));
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 3);
	gee_abstract_collection_retain_all ((GeeAbstractCollection*) arraylist1, (GeeCollection*) arraylist2);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 3);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist2);
	/* Arraylist1 and arraylist2 have no common elements -> everything is removed in arraylist1*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (3));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (4));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (5));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (6));
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 3);
	gee_abstract_collection_retain_all ((GeeAbstractCollection*) arraylist1, (GeeCollection*) arraylist2);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 3);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist2);
	/* Arraylist1 and arraylist2 have all elements the same -> nothing is removed in arraylist1*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (3));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (3));
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 3);
	gee_abstract_collection_retain_all ((GeeAbstractCollection*) arraylist1, (GeeCollection*) arraylist2);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 3);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist2);
	/* Arraylist1 and arraylist2 have 2 common elements but each also has his own elements -> arraylist1 only retains what is in arraylist2*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (3));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (4));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (5));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (0));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (3));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (7));
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 5);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 4);
	gee_abstract_collection_retain_all ((GeeAbstractCollection*) arraylist1, (GeeCollection*) arraylist2);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 2);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 4);
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (2)));
	g_assert (gee_abstract_collection_contains ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (3)));
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist2);
	/* Removing of same elements when arraylist2 has the same element -> nothing changes*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (1));
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 4);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 1);
	gee_abstract_collection_retain_all ((GeeAbstractCollection*) arraylist1, (GeeCollection*) arraylist2);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 4);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist2);
	/* Removing of same elements when arraylist2 has the NOT same element -> everything is removed*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (2));
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 4);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 1);
	gee_abstract_collection_retain_all ((GeeAbstractCollection*) arraylist1, (GeeCollection*) arraylist2);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 0);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist2);
	(arraylist1 == NULL) ? NULL : (arraylist1 = (g_object_unref (arraylist1), NULL));
	(arraylist2 == NULL) ? NULL : (arraylist2 = (g_object_unref (arraylist2), NULL));
}


static void array_list_tests_test_arraylist_first (ArrayListTests* self) {
	GeeArrayList* arraylistOfString;
	char* _tmp1_;
	char* _tmp3_;
	char* _tmp2_;
	char* _tmp4_;
	char* _tmp6_;
	char* _tmp5_;
	g_return_if_fail (self != NULL);
	arraylistOfString = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	/* Check first for empty list*/
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp0_;
		_tmp0_ = NULL;
		_tmp0_ = (char*) gee_abstract_list_first ((GeeAbstractList*) arraylistOfString);
		_tmp0_ = (g_free (_tmp0_), NULL);
		(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
		return;
	}
	g_test_trap_assert_failed ();
	/* Check first for list with one element*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylistOfString, "1");
	_tmp1_ = NULL;
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_abstract_list_first ((GeeAbstractList*) arraylistOfString), "1") == 0);
	_tmp1_ = (g_free (_tmp1_), NULL);
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_abstract_list_first ((GeeAbstractList*) arraylistOfString), _tmp3_ = (char*) gee_abstract_list_get ((GeeAbstractList*) arraylistOfString, 0)) == 0);
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp2_ = (g_free (_tmp2_), NULL);
	/* Check first for for list with multiple element*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylistOfString, "2");
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylistOfString, "3");
	_tmp4_ = NULL;
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_abstract_list_first ((GeeAbstractList*) arraylistOfString), "1") == 0);
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp6_ = NULL;
	_tmp5_ = NULL;
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_abstract_list_first ((GeeAbstractList*) arraylistOfString), _tmp6_ = (char*) gee_abstract_list_get ((GeeAbstractList*) arraylistOfString, 0)) == 0);
	_tmp6_ = (g_free (_tmp6_), NULL);
	_tmp5_ = (g_free (_tmp5_), NULL);
	/* Check first if list is cleared and empty again*/
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylistOfString);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp7_;
		_tmp7_ = NULL;
		_tmp7_ = (char*) gee_abstract_list_first ((GeeAbstractList*) arraylistOfString);
		_tmp7_ = (g_free (_tmp7_), NULL);
		(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
		return;
	}
	g_test_trap_assert_failed ();
	(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
}


static void array_list_tests_test_arraylist_last (ArrayListTests* self) {
	GeeArrayList* arraylistOfString;
	char* _tmp1_;
	char* _tmp3_;
	char* _tmp2_;
	char* _tmp4_;
	char* _tmp6_;
	char* _tmp5_;
	g_return_if_fail (self != NULL);
	arraylistOfString = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, g_free, g_direct_equal);
	/* Check last for empty list*/
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp0_;
		_tmp0_ = NULL;
		_tmp0_ = (char*) gee_abstract_list_last ((GeeAbstractList*) arraylistOfString);
		_tmp0_ = (g_free (_tmp0_), NULL);
		(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
		return;
	}
	g_test_trap_assert_failed ();
	/* Check last for list with one element*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylistOfString, "1");
	_tmp1_ = NULL;
	g_assert (_vala_strcmp0 (_tmp1_ = (char*) gee_abstract_list_last ((GeeAbstractList*) arraylistOfString), "1") == 0);
	_tmp1_ = (g_free (_tmp1_), NULL);
	_tmp3_ = NULL;
	_tmp2_ = NULL;
	g_assert (_vala_strcmp0 (_tmp2_ = (char*) gee_abstract_list_last ((GeeAbstractList*) arraylistOfString), _tmp3_ = (char*) gee_abstract_list_get ((GeeAbstractList*) arraylistOfString, gee_collection_get_size ((GeeCollection*) arraylistOfString) - 1)) == 0);
	_tmp3_ = (g_free (_tmp3_), NULL);
	_tmp2_ = (g_free (_tmp2_), NULL);
	/* Check last for for list with multiple element*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylistOfString, "2");
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylistOfString, "3");
	_tmp4_ = NULL;
	g_assert (_vala_strcmp0 (_tmp4_ = (char*) gee_abstract_list_last ((GeeAbstractList*) arraylistOfString), "3") == 0);
	_tmp4_ = (g_free (_tmp4_), NULL);
	_tmp6_ = NULL;
	_tmp5_ = NULL;
	g_assert (_vala_strcmp0 (_tmp5_ = (char*) gee_abstract_list_last ((GeeAbstractList*) arraylistOfString), _tmp6_ = (char*) gee_abstract_list_get ((GeeAbstractList*) arraylistOfString, gee_collection_get_size ((GeeCollection*) arraylistOfString) - 1)) == 0);
	_tmp6_ = (g_free (_tmp6_), NULL);
	_tmp5_ = (g_free (_tmp5_), NULL);
	/* Check last if list is cleared and empty again*/
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylistOfString);
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		char* _tmp7_;
		_tmp7_ = NULL;
		_tmp7_ = (char*) gee_abstract_list_last ((GeeAbstractList*) arraylistOfString);
		_tmp7_ = (g_free (_tmp7_), NULL);
		(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
		return;
	}
	g_test_trap_assert_failed ();
	(arraylistOfString == NULL) ? NULL : (arraylistOfString = (g_object_unref (arraylistOfString), NULL));
}


static void array_list_tests_test_arraylist_insert_all (ArrayListTests* self) {
	GeeArrayList* arraylist1;
	GeeArrayList* arraylist2;
	g_return_if_fail (self != NULL);
	arraylist1 = gee_array_list_new (G_TYPE_INT, NULL, NULL, g_direct_equal);
	arraylist2 = gee_array_list_new (G_TYPE_INT, NULL, NULL, g_direct_equal);
	/* Insert an empty list*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (0));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (2));
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 3);
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) arraylist2));
	gee_abstract_list_insert_all ((GeeAbstractList*) arraylist1, 0, (GeeCollection*) arraylist2);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 3);
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) arraylist2));
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist2);
	/* Insert into an empty list at index 0*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (0));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (2));
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) arraylist1));
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 3);
	gee_abstract_list_insert_all ((GeeAbstractList*) arraylist1, 0, (GeeCollection*) arraylist2);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 3);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist2);
	/* Insert all into empty list as index 1*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (0));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (2));
	g_assert (gee_abstract_collection_get_is_empty ((GeeAbstractCollection*) arraylist1));
	if (g_test_trap_fork ((guint64) 0, G_TEST_TRAP_SILENCE_STDOUT | G_TEST_TRAP_SILENCE_STDERR)) {
		gee_abstract_list_insert_all ((GeeAbstractList*) arraylist1, 1, (GeeCollection*) arraylist2);
		(arraylist1 == NULL) ? NULL : (arraylist1 = (g_object_unref (arraylist1), NULL));
		(arraylist2 == NULL) ? NULL : (arraylist2 = (g_object_unref (arraylist2), NULL));
		return;
	}
	g_test_trap_assert_failed ();
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist2);
	/* Insert all in the beginnig*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (3));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (4));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (5));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (0));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (2));
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 3);
	gee_abstract_list_insert_all ((GeeAbstractList*) arraylist1, 0, (GeeCollection*) arraylist2);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 6);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 3);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) arraylist1, 0)) == 0);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) arraylist1, 1)) == 1);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) arraylist1, 2)) == 2);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) arraylist1, 3)) == 3);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) arraylist1, 4)) == 4);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) arraylist1, 5)) == 5);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist2);
	/* Insert all in the middle*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (0));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (5));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (6));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (3));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (4));
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 4);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 3);
	gee_abstract_list_insert_all ((GeeAbstractList*) arraylist1, 2, (GeeCollection*) arraylist2);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 7);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 3);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) arraylist1, 0)) == 0);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) arraylist1, 1)) == 1);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) arraylist1, 2)) == 2);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) arraylist1, 3)) == 3);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) arraylist1, 4)) == 4);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) arraylist1, 5)) == 5);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) arraylist1, 6)) == 6);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist2);
	/* Insert all in at the end*/
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (0));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (1));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist1, GINT_TO_POINTER (2));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (3));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (4));
	gee_abstract_collection_add ((GeeAbstractCollection*) arraylist2, GINT_TO_POINTER (5));
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 3);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 3);
	gee_abstract_list_insert_all ((GeeAbstractList*) arraylist1, 3, (GeeCollection*) arraylist2);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist1) == 6);
	g_assert (gee_collection_get_size ((GeeCollection*) arraylist2) == 3);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) arraylist1, 0)) == 0);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) arraylist1, 1)) == 1);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) arraylist1, 2)) == 2);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) arraylist1, 3)) == 3);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) arraylist1, 4)) == 4);
	g_assert (GPOINTER_TO_INT (gee_abstract_list_get ((GeeAbstractList*) arraylist1, 5)) == 5);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist1);
	gee_abstract_collection_clear ((GeeAbstractCollection*) arraylist2);
	(arraylist1 == NULL) ? NULL : (arraylist1 = (g_object_unref (arraylist1), NULL));
	(arraylist2 == NULL) ? NULL : (arraylist2 = (g_object_unref (arraylist2), NULL));
}


static void array_list_tests_class_init (ArrayListTestsClass * klass) {
	array_list_tests_parent_class = g_type_class_peek_parent (klass);
	TEST_FIXTURE_CLASS (klass)->setup = array_list_tests_real_setup;
	TEST_FIXTURE_CLASS (klass)->teardown = array_list_tests_real_teardown;
}


static void array_list_tests_instance_init (ArrayListTests * self) {
}


GType array_list_tests_get_type (void) {
	static GType array_list_tests_type_id = 0;
	if (array_list_tests_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (ArrayListTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) array_list_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ArrayListTests), 0, (GInstanceInitFunc) array_list_tests_instance_init, NULL };
		array_list_tests_type_id = g_type_register_static (TYPE_COLLECTION_TESTS, "ArrayListTests", &g_define_type_info, 0);
	}
	return array_list_tests_type_id;
}


void _main (char** args, int args_length1) {
	ArrayListTests* tests;
	g_test_init (&args_length1, &args, NULL);
	tests = array_list_tests_new ();
	g_test_suite_add_suite (g_test_get_root (), test_fixture_get_suite ((TestFixture*) tests));
	g_test_run ();
	(tests == NULL) ? NULL : (tests = (g_object_unref (tests), NULL));
}


int main (int argc, char ** argv) {
	g_type_init ();
	_main (argv, argc);
	return 0;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




