/* queue.c generated by valac 0.20.1.66-2886, the Vala compiler
 * generated from queue.vala, do not modify */

/* queue.vala
 *
 * Copyright (C) 2009  Didier Villevalois
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Didier 'Ptitjes Villevalois <ptitjes@free.fr>
 */

#include <glib.h>
#include <glib-object.h>


#define GEE_TYPE_TRAVERSABLE (gee_traversable_get_type ())
#define GEE_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversable))
#define GEE_IS_TRAVERSABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_TRAVERSABLE))
#define GEE_TRAVERSABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_TRAVERSABLE, GeeTraversableIface))

typedef struct _GeeTraversable GeeTraversable;
typedef struct _GeeTraversableIface GeeTraversableIface;

#define GEE_TRAVERSABLE_TYPE_STREAM (gee_traversable_stream_get_type ())

#define GEE_TYPE_LAZY (gee_lazy_get_type ())
#define GEE_LAZY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LAZY, GeeLazy))
#define GEE_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_LAZY, GeeLazyClass))
#define GEE_IS_LAZY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LAZY))
#define GEE_IS_LAZY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_LAZY))
#define GEE_LAZY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_LAZY, GeeLazyClass))

typedef struct _GeeLazy GeeLazy;
typedef struct _GeeLazyClass GeeLazyClass;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_QUEUE (gee_queue_get_type ())
#define GEE_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_QUEUE, GeeQueue))
#define GEE_IS_QUEUE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_QUEUE))
#define GEE_QUEUE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_QUEUE, GeeQueueIface))

typedef struct _GeeQueue GeeQueue;
typedef struct _GeeQueueIface GeeQueueIface;

typedef gboolean (*GeeForallFunc) (gpointer g, void* user_data);
typedef enum  {
	GEE_TRAVERSABLE_STREAM_YIELD,
	GEE_TRAVERSABLE_STREAM_CONTINUE,
	GEE_TRAVERSABLE_STREAM_END
} GeeTraversableStream;

typedef GeeTraversableStream (*GeeStreamFunc) (GeeTraversableStream state, GeeLazy* g, GeeLazy** lazy, void* user_data);
struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gboolean (*has_next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
	void (*remove) (GeeIterator* self);
	gboolean (*get_valid) (GeeIterator* self);
	gboolean (*get_read_only) (GeeIterator* self);
};

typedef gpointer (*GeeFoldFunc) (gpointer g, gpointer a, void* user_data);
typedef gpointer (*GeeMapFunc) (gpointer g, void* user_data);
typedef gboolean (*GeePredicate) (gconstpointer g, void* user_data);
struct _GeeTraversableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeTraversable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeTraversable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeTraversable* self);
	gboolean (*foreach) (GeeTraversable* self, GeeForallFunc f, void* f_target);
	GeeIterator* (*stream) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeStreamFunc f, void* f_target, GDestroyNotify f_target_destroy_notify);
	gpointer (*fold) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*map) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeMapFunc f, void* f_target);
	GeeIterator* (*scan) (GeeTraversable* self, GType a_type, GBoxedCopyFunc a_dup_func, GDestroyNotify a_destroy_func, GeeFoldFunc f, void* f_target, gpointer seed);
	GeeIterator* (*filter) (GeeTraversable* self, GeePredicate pred, void* pred_target, GDestroyNotify pred_target_destroy_notify);
	GeeIterator* (*chop) (GeeTraversable* self, gint offset, gint length);
	GType (*get_element_type) (GeeTraversable* self);
};

struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeIterable* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeIterable* self);
	GDestroyNotify (*get_g_destroy_func) (GeeIterable* self);
	GeeIterator* (*iterator) (GeeIterable* self);
};

struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeCollection* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeCollection* self);
	GDestroyNotify (*get_g_destroy_func) (GeeCollection* self);
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gboolean (*add_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*contains_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*remove_all) (GeeCollection* self, GeeCollection* collection);
	gboolean (*retain_all) (GeeCollection* self, GeeCollection* collection);
	gpointer* (*to_array) (GeeCollection* self, int* result_length1);
	gint (*get_size) (GeeCollection* self);
	gboolean (*get_is_empty) (GeeCollection* self);
	gboolean (*get_read_only) (GeeCollection* self);
	GeeCollection* (*get_read_only_view) (GeeCollection* self);
};

struct _GeeQueueIface {
	GTypeInterface parent_iface;
	GType (*get_g_type) (GeeQueue* self);
	GBoxedCopyFunc (*get_g_dup_func) (GeeQueue* self);
	GDestroyNotify (*get_g_destroy_func) (GeeQueue* self);
	gboolean (*offer) (GeeQueue* self, gconstpointer element);
	gpointer (*peek) (GeeQueue* self);
	gpointer (*poll) (GeeQueue* self);
	gint (*drain) (GeeQueue* self, GeeCollection* recipient, gint amount);
	gint (*get_capacity) (GeeQueue* self);
	gint (*get_remaining_capacity) (GeeQueue* self);
	gboolean (*get_is_full) (GeeQueue* self);
};



GType gee_traversable_stream_get_type (void) G_GNUC_CONST;
gpointer gee_lazy_ref (gpointer instance);
void gee_lazy_unref (gpointer instance);
GParamSpec* gee_param_spec_lazy (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void gee_value_set_lazy (GValue* value, gpointer v_object);
void gee_value_take_lazy (GValue* value, gpointer v_object);
gpointer gee_value_get_lazy (const GValue* value);
GType gee_lazy_get_type (void) G_GNUC_CONST;
GType gee_iterator_get_type (void) G_GNUC_CONST;
GType gee_traversable_get_type (void) G_GNUC_CONST;
GType gee_iterable_get_type (void) G_GNUC_CONST;
GType gee_collection_get_type (void) G_GNUC_CONST;
GType gee_queue_get_type (void) G_GNUC_CONST;
gboolean gee_queue_offer (GeeQueue* self, gconstpointer element);
static gboolean gee_queue_real_offer (GeeQueue* self, gconstpointer element);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
gpointer gee_queue_peek (GeeQueue* self);
gpointer gee_queue_poll (GeeQueue* self);
gint gee_queue_drain (GeeQueue* self, GeeCollection* recipient, gint amount);
static gint gee_queue_real_drain (GeeQueue* self, GeeCollection* recipient, gint amount);
#define GEE_QUEUE_UNBOUNDED_CAPACITY (-1)
gint gee_queue_get_capacity (GeeQueue* self);
gint gee_queue_get_remaining_capacity (GeeQueue* self);
gboolean gee_queue_get_is_full (GeeQueue* self);


/**
 * Offers the specified element to this queue.
 *
 * @param element the element to offer to the queue
 *
 * @return        ``true`` if the element was added to the queue
 */
static gboolean gee_queue_real_offer (GeeQueue* self, gconstpointer element) {
	gboolean result = FALSE;
	gconstpointer _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
#line 78 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	_tmp0_ = element;
#line 78 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	_tmp1_ = gee_collection_add ((GeeCollection*) self, _tmp0_);
#line 78 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	result = _tmp1_;
#line 78 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	return result;
#line 208 "queue.c"
}


gboolean gee_queue_offer (GeeQueue* self, gconstpointer element) {
#line 77 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 77 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	return GEE_QUEUE_GET_INTERFACE (self)->offer (self, element);
#line 217 "queue.c"
}


/**
 * Peeks (retrieves, but not remove) an element from this queue.
 *
 * @return the element peeked from the queue (or ``null`` if none was
 *         available)
 */
gpointer gee_queue_peek (GeeQueue* self) {
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 87 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	return GEE_QUEUE_GET_INTERFACE (self)->peek (self);
#line 232 "queue.c"
}


/**
 * Polls (retrieves and remove) an element from this queue.
 *
 * @return the element polled from the queue (or ``null`` if none was
 *         available)
 */
gpointer gee_queue_poll (GeeQueue* self) {
#line 95 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 95 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	return GEE_QUEUE_GET_INTERFACE (self)->poll (self);
#line 247 "queue.c"
}


/**
 * Drains the specified amount of elements from this queue in the specified
 * recipient collection.
 *
 * @param recipient the recipient collection to drain the elements to
 * @param amount    the amount of elements to drain
 *
 * @return          the amount of elements that were actually drained
 */
static gint gee_queue_real_drain (GeeQueue* self, GeeCollection* recipient, gint amount) {
	gint result = 0;
	gpointer item = NULL;
	gint drained = 0;
#line 106 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	g_return_val_if_fail (recipient != NULL, 0);
#line 107 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	item = NULL;
#line 108 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	drained = 0;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	while (TRUE) {
#line 272 "queue.c"
		gboolean _tmp0_ = FALSE;
		gboolean _tmp1_ = FALSE;
		gint _tmp2_ = 0;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp8_ = FALSE;
		GeeCollection* _tmp9_ = NULL;
		gconstpointer _tmp10_ = NULL;
		gint _tmp11_ = 0;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
		_tmp2_ = amount;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
		if (_tmp2_ == (-1)) {
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
			_tmp1_ = TRUE;
#line 287 "queue.c"
		} else {
			gint _tmp3_ = 0;
			gint _tmp4_ = 0;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
			_tmp3_ = amount;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
			amount = _tmp3_ - 1;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
			_tmp4_ = amount;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
			_tmp1_ = _tmp4_ >= 0;
#line 299 "queue.c"
		}
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
		_tmp5_ = _tmp1_;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
		if (_tmp5_) {
#line 305 "queue.c"
			gpointer _tmp6_ = NULL;
			gconstpointer _tmp7_ = NULL;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
			_tmp6_ = gee_queue_poll (self);
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
			((item == NULL) || (GEE_QUEUE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_QUEUE_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
			item = _tmp6_;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
			_tmp7_ = item;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
			_tmp0_ = _tmp7_ != NULL;
#line 318 "queue.c"
		} else {
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
			_tmp0_ = FALSE;
#line 322 "queue.c"
		}
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
		_tmp8_ = _tmp0_;
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
		if (!_tmp8_) {
#line 109 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
			break;
#line 330 "queue.c"
		}
#line 110 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
		_tmp9_ = recipient;
#line 110 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
		_tmp10_ = item;
#line 110 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
		gee_collection_add (_tmp9_, _tmp10_);
#line 111 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
		_tmp11_ = drained;
#line 111 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
		drained = _tmp11_ + 1;
#line 342 "queue.c"
	}
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	result = drained;
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	((item == NULL) || (GEE_QUEUE_GET_INTERFACE (self)->get_g_destroy_func (self) == NULL)) ? NULL : (item = (GEE_QUEUE_GET_INTERFACE (self)->get_g_destroy_func (self) (item), NULL));
#line 113 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	return result;
#line 350 "queue.c"
}


gint gee_queue_drain (GeeQueue* self, GeeCollection* recipient, gint amount) {
#line 106 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 106 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	return GEE_QUEUE_GET_INTERFACE (self)->drain (self, recipient, amount);
#line 359 "queue.c"
}


gint gee_queue_get_capacity (GeeQueue* self) {
#line 57 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 57 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	return GEE_QUEUE_GET_INTERFACE (self)->get_capacity (self);
#line 368 "queue.c"
}


gint gee_queue_get_remaining_capacity (GeeQueue* self) {
#line 63 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 63 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	return GEE_QUEUE_GET_INTERFACE (self)->get_remaining_capacity (self);
#line 377 "queue.c"
}


gboolean gee_queue_get_is_full (GeeQueue* self) {
#line 68 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 68 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	return GEE_QUEUE_GET_INTERFACE (self)->get_is_full (self);
#line 386 "queue.c"
}


static void gee_queue_base_init (GeeQueueIface * iface) {
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	static gboolean initialized = FALSE;
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
	if (!initialized) {
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
		initialized = TRUE;
#line 397 "queue.c"
		/**
		 * The capacity of this queue (or ``null`` if capacity is not bound).
		 */
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
		g_object_interface_install_property (iface, g_param_spec_int ("capacity", "capacity", "capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 403 "queue.c"
		/**
		 * The remaining capacity of this queue (or ``null`` if capacity is not
		 * bound).
		 */
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
		g_object_interface_install_property (iface, g_param_spec_int ("remaining-capacity", "remaining-capacity", "remaining-capacity", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 410 "queue.c"
		/**
		 * Specifies whether this queue is full.
		 */
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
		g_object_interface_install_property (iface, g_param_spec_boolean ("is-full", "is-full", "is-full", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
		iface->offer = gee_queue_real_offer;
#line 47 "/home/mpiechotka/Projects/contributions/libgee/gee/queue.vala"
		iface->drain = gee_queue_real_drain;
#line 420 "queue.c"
	}
}


/**
 * A collection designed for holding elements prior to processing.
 *
 * Although all Queue implementations do not limit the amount of elements they
 * can contain, this interface supports for capacity-bounded queues. When
 * capacity is not bound, then the {@link capacity} and
 * {@link remaining_capacity} both return {@link UNBOUNDED_CAPACITY}.
 *
 * This interface defines methods that will never fail whatever the state of
 * the queue is. For capacity-bounded queues, those methods will either return
 * ``false`` or ``null`` to specify that the insert or retrieval did not occur
 * because the queue was full or empty.
 *
 * Queue implementations are not limited to First-In-First-Out behavior and can
 * propose different ordering of their elements. Each Queue implementation have
 * to specify how it orders its elements.
 *
 * Queue implementations do not allow insertion of ``null`` elements, although
 * some implementations, such as {@link LinkedList}, do not prohibit insertion
 * of ``null``. Even in the implementations that permit it, ``null`` should not be
 * inserted into a Queue, as ``null`` is also used as a special return value by
 * the poll method to indicate that the queue contains no elements.
 */
GType gee_queue_get_type (void) {
	static volatile gsize gee_queue_type_id__volatile = 0;
	if (g_once_init_enter (&gee_queue_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeQueueIface), (GBaseInitFunc) gee_queue_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType gee_queue_type_id;
		gee_queue_type_id = g_type_register_static (G_TYPE_INTERFACE, "GeeQueue", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (gee_queue_type_id, GEE_TYPE_COLLECTION);
		g_once_init_leave (&gee_queue_type_id__volatile, gee_queue_type_id);
	}
	return gee_queue_type_id__volatile;
}



