
#ifndef __GEE_H__
#define __GEE_H__

#include <glib.h>
#include <glib-object.h>

G_BEGIN_DECLS


#define GEE_TYPE_ITERABLE (gee_iterable_get_type ())
#define GEE_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERABLE, GeeIterable))
#define GEE_IS_ITERABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERABLE))
#define GEE_ITERABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERABLE, GeeIterableIface))

typedef struct _GeeIterable GeeIterable;
typedef struct _GeeIterableIface GeeIterableIface;

#define GEE_TYPE_ITERATOR (gee_iterator_get_type ())
#define GEE_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ITERATOR, GeeIterator))
#define GEE_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ITERATOR))
#define GEE_ITERATOR_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_ITERATOR, GeeIteratorIface))

typedef struct _GeeIterator GeeIterator;
typedef struct _GeeIteratorIface GeeIteratorIface;

#define GEE_TYPE_COLLECTION (gee_collection_get_type ())
#define GEE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_COLLECTION, GeeCollection))
#define GEE_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_COLLECTION))
#define GEE_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_COLLECTION, GeeCollectionIface))

typedef struct _GeeCollection GeeCollection;
typedef struct _GeeCollectionIface GeeCollectionIface;

#define GEE_TYPE_LIST (gee_list_get_type ())
#define GEE_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_LIST, GeeList))
#define GEE_IS_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_LIST))
#define GEE_LIST_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_LIST, GeeListIface))

typedef struct _GeeList GeeList;
typedef struct _GeeListIface GeeListIface;

#define GEE_TYPE_ARRAY_LIST (gee_array_list_get_type ())
#define GEE_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayList))
#define GEE_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))
#define GEE_IS_ARRAY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_ARRAY_LIST))
#define GEE_IS_ARRAY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_ARRAY_LIST))
#define GEE_ARRAY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_ARRAY_LIST, GeeArrayListClass))

typedef struct _GeeArrayList GeeArrayList;
typedef struct _GeeArrayListClass GeeArrayListClass;
typedef struct _GeeArrayListPrivate GeeArrayListPrivate;

#define GEE_TYPE_MAP (gee_map_get_type ())
#define GEE_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_MAP, GeeMap))
#define GEE_IS_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_MAP))
#define GEE_MAP_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_MAP, GeeMapIface))

typedef struct _GeeMap GeeMap;
typedef struct _GeeMapIface GeeMapIface;

#define GEE_TYPE_SET (gee_set_get_type ())
#define GEE_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_SET, GeeSet))
#define GEE_IS_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_SET))
#define GEE_SET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GEE_TYPE_SET, GeeSetIface))

typedef struct _GeeSet GeeSet;
typedef struct _GeeSetIface GeeSetIface;

#define GEE_TYPE_HASH_MAP (gee_hash_map_get_type ())
#define GEE_HASH_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_HASH_MAP, GeeHashMap))
#define GEE_HASH_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_HASH_MAP, GeeHashMapClass))
#define GEE_IS_HASH_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_HASH_MAP))
#define GEE_IS_HASH_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_HASH_MAP))
#define GEE_HASH_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_HASH_MAP, GeeHashMapClass))

typedef struct _GeeHashMap GeeHashMap;
typedef struct _GeeHashMapClass GeeHashMapClass;
typedef struct _GeeHashMapPrivate GeeHashMapPrivate;

#define GEE_TYPE_HASH_SET (gee_hash_set_get_type ())
#define GEE_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_HASH_SET, GeeHashSet))
#define GEE_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_HASH_SET, GeeHashSetClass))
#define GEE_IS_HASH_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_HASH_SET))
#define GEE_IS_HASH_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_HASH_SET))
#define GEE_HASH_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_HASH_SET, GeeHashSetClass))

typedef struct _GeeHashSet GeeHashSet;
typedef struct _GeeHashSetClass GeeHashSetClass;
typedef struct _GeeHashSetPrivate GeeHashSetPrivate;

#define GEE_TYPE_READ_ONLY_COLLECTION (gee_read_only_collection_get_type ())
#define GEE_READ_ONLY_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollection))
#define GEE_READ_ONLY_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollectionClass))
#define GEE_IS_READ_ONLY_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_READ_ONLY_COLLECTION))
#define GEE_IS_READ_ONLY_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_READ_ONLY_COLLECTION))
#define GEE_READ_ONLY_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_READ_ONLY_COLLECTION, GeeReadOnlyCollectionClass))

typedef struct _GeeReadOnlyCollection GeeReadOnlyCollection;
typedef struct _GeeReadOnlyCollectionClass GeeReadOnlyCollectionClass;
typedef struct _GeeReadOnlyCollectionPrivate GeeReadOnlyCollectionPrivate;

#define GEE_TYPE_READ_ONLY_LIST (gee_read_only_list_get_type ())
#define GEE_READ_ONLY_LIST(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_READ_ONLY_LIST, GeeReadOnlyList))
#define GEE_READ_ONLY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_READ_ONLY_LIST, GeeReadOnlyListClass))
#define GEE_IS_READ_ONLY_LIST(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_READ_ONLY_LIST))
#define GEE_IS_READ_ONLY_LIST_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_READ_ONLY_LIST))
#define GEE_READ_ONLY_LIST_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_READ_ONLY_LIST, GeeReadOnlyListClass))

typedef struct _GeeReadOnlyList GeeReadOnlyList;
typedef struct _GeeReadOnlyListClass GeeReadOnlyListClass;
typedef struct _GeeReadOnlyListPrivate GeeReadOnlyListPrivate;

#define GEE_TYPE_READ_ONLY_MAP (gee_read_only_map_get_type ())
#define GEE_READ_ONLY_MAP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_READ_ONLY_MAP, GeeReadOnlyMap))
#define GEE_READ_ONLY_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_READ_ONLY_MAP, GeeReadOnlyMapClass))
#define GEE_IS_READ_ONLY_MAP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_READ_ONLY_MAP))
#define GEE_IS_READ_ONLY_MAP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_READ_ONLY_MAP))
#define GEE_READ_ONLY_MAP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_READ_ONLY_MAP, GeeReadOnlyMapClass))

typedef struct _GeeReadOnlyMap GeeReadOnlyMap;
typedef struct _GeeReadOnlyMapClass GeeReadOnlyMapClass;
typedef struct _GeeReadOnlyMapPrivate GeeReadOnlyMapPrivate;

#define GEE_TYPE_READ_ONLY_SET (gee_read_only_set_get_type ())
#define GEE_READ_ONLY_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_TYPE_READ_ONLY_SET, GeeReadOnlySet))
#define GEE_READ_ONLY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_TYPE_READ_ONLY_SET, GeeReadOnlySetClass))
#define GEE_IS_READ_ONLY_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_TYPE_READ_ONLY_SET))
#define GEE_IS_READ_ONLY_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_TYPE_READ_ONLY_SET))
#define GEE_READ_ONLY_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_TYPE_READ_ONLY_SET, GeeReadOnlySetClass))

typedef struct _GeeReadOnlySet GeeReadOnlySet;
typedef struct _GeeReadOnlySetClass GeeReadOnlySetClass;
typedef struct _GeeReadOnlySetPrivate GeeReadOnlySetPrivate;

/**
 * Implemented by classes that support a simple iteration over instances of the
 * collection.
 */
struct _GeeIteratorIface {
	GTypeInterface parent_iface;
	gboolean (*next) (GeeIterator* self);
	gpointer (*get) (GeeIterator* self);
};

/**
 * Implemented by classes that support a simple iteration over instances of the
 * collection.
 */
struct _GeeIterableIface {
	GTypeInterface parent_iface;
	GType (*get_element_type) (GeeIterable* self);
	GeeIterator* (*iterator) (GeeIterable* self);
};

/**
 * Serves as the base interface for implementing collection classes. Defines
 * size, iteration, and modification methods.
 */
struct _GeeCollectionIface {
	GTypeInterface parent_iface;
	gboolean (*contains) (GeeCollection* self, gconstpointer item);
	gboolean (*add) (GeeCollection* self, gconstpointer item);
	gboolean (*remove) (GeeCollection* self, gconstpointer item);
	void (*clear) (GeeCollection* self);
	gint (*get_size) (GeeCollection* self);
};

/**
 * Represents a collection of items in a well-defined order.
 */
struct _GeeListIface {
	GTypeInterface parent_iface;
	gpointer (*get) (GeeList* self, gint index);
	void (*set) (GeeList* self, gint index, gconstpointer item);
	gint (*index_of) (GeeList* self, gconstpointer item);
	void (*insert) (GeeList* self, gint index, gconstpointer item);
	void (*remove_at) (GeeList* self, gint index);
	GeeList* (*slice) (GeeList* self, gint start, gint stop);
};

/**
 * Arrays of arbitrary elements which grow automatically as elements are added.
 */
struct _GeeArrayList {
	GObject parent_instance;
	GeeArrayListPrivate * priv;
};

struct _GeeArrayListClass {
	GObjectClass parent_class;
};

/**
 * A set is a collection without duplicates.
 */
struct _GeeSetIface {
	GTypeInterface parent_iface;
};

/**
 * A map is a generic collection of key/value pairs.
 */
struct _GeeMapIface {
	GTypeInterface parent_iface;
	GeeSet* (*get_keys) (GeeMap* self);
	GeeCollection* (*get_values) (GeeMap* self);
	gboolean (*contains) (GeeMap* self, gconstpointer key);
	gpointer (*get) (GeeMap* self, gconstpointer key);
	void (*set) (GeeMap* self, gconstpointer key, gconstpointer value);
	gboolean (*remove) (GeeMap* self, gconstpointer key);
	void (*clear) (GeeMap* self);
	gint (*get_size) (GeeMap* self);
};

/**
 * Hashtable implementation of the Map interface.
 */
struct _GeeHashMap {
	GObject parent_instance;
	GeeHashMapPrivate * priv;
};

struct _GeeHashMapClass {
	GObjectClass parent_class;
};

/**
 * Hashtable implementation of the Set interface.
 */
struct _GeeHashSet {
	GObject parent_instance;
	GeeHashSetPrivate * priv;
};

struct _GeeHashSetClass {
	GObjectClass parent_class;
};

/**
 * Represents a read-only collection of items.
 */
struct _GeeReadOnlyCollection {
	GObject parent_instance;
	GeeReadOnlyCollectionPrivate * priv;
};

struct _GeeReadOnlyCollectionClass {
	GObjectClass parent_class;
};

/**
 * Represents a read-only collection of items in a well-defined order.
 */
struct _GeeReadOnlyList {
	GObject parent_instance;
	GeeReadOnlyListPrivate * priv;
};

struct _GeeReadOnlyListClass {
	GObjectClass parent_class;
};

/**
 * Represents a read-only collection of key/value pairs.
 */
struct _GeeReadOnlyMap {
	GObject parent_instance;
	GeeReadOnlyMapPrivate * priv;
};

struct _GeeReadOnlyMapClass {
	GObjectClass parent_class;
};

/**
 * Represents a read-only collection of items without duplicates.
 */
struct _GeeReadOnlySet {
	GObject parent_instance;
	GeeReadOnlySetPrivate * priv;
};

struct _GeeReadOnlySetClass {
	GObjectClass parent_class;
};


GType gee_iterator_get_type (void);
GType gee_iterable_get_type (void);
GType gee_collection_get_type (void);
GType gee_list_get_type (void);
GType gee_array_list_get_type (void);
GeeArrayList* gee_array_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
GeeArrayList* gee_array_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GEqualFunc equal_func);
void gee_array_list_set_equal_func (GeeArrayList* self, GEqualFunc value);
gboolean gee_collection_contains (GeeCollection* self, gconstpointer item);
gboolean gee_collection_add (GeeCollection* self, gconstpointer item);
gboolean gee_collection_remove (GeeCollection* self, gconstpointer item);
void gee_collection_clear (GeeCollection* self);
gint gee_collection_get_size (GeeCollection* self);
GType gee_set_get_type (void);
GType gee_map_get_type (void);
GType gee_hash_map_get_type (void);
GeeHashMap* gee_hash_map_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GHashFunc key_hash_func, GEqualFunc key_equal_func, GEqualFunc value_equal_func);
GeeHashMap* gee_hash_map_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GHashFunc key_hash_func, GEqualFunc key_equal_func, GEqualFunc value_equal_func);
void gee_hash_map_set_key_hash_func (GeeHashMap* self, GHashFunc value);
void gee_hash_map_set_key_equal_func (GeeHashMap* self, GEqualFunc value);
void gee_hash_map_set_value_equal_func (GeeHashMap* self, GEqualFunc value);
GType gee_hash_set_get_type (void);
GeeHashSet* gee_hash_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func);
GeeHashSet* gee_hash_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GHashFunc hash_func, GEqualFunc equal_func);
void gee_hash_set_set_hash_func (GeeHashSet* self, GHashFunc value);
void gee_hash_set_set_equal_func (GeeHashSet* self, GEqualFunc value);
GType gee_iterable_get_element_type (GeeIterable* self);
GeeIterator* gee_iterable_iterator (GeeIterable* self);
gboolean gee_iterator_next (GeeIterator* self);
gpointer gee_iterator_get (GeeIterator* self);
gpointer gee_list_get (GeeList* self, gint index);
void gee_list_set (GeeList* self, gint index, gconstpointer item);
gint gee_list_index_of (GeeList* self, gconstpointer item);
void gee_list_insert (GeeList* self, gint index, gconstpointer item);
void gee_list_remove_at (GeeList* self, gint index);
GeeList* gee_list_slice (GeeList* self, gint start, gint stop);
GeeSet* gee_map_get_keys (GeeMap* self);
GeeCollection* gee_map_get_values (GeeMap* self);
gboolean gee_map_contains (GeeMap* self, gconstpointer key);
gpointer gee_map_get (GeeMap* self, gconstpointer key);
void gee_map_set (GeeMap* self, gconstpointer key, gconstpointer value);
gboolean gee_map_remove (GeeMap* self, gconstpointer key);
void gee_map_clear (GeeMap* self);
gint gee_map_get_size (GeeMap* self);
GType gee_read_only_collection_get_type (void);
GeeReadOnlyCollection* gee_read_only_collection_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeCollection* collection);
GeeReadOnlyCollection* gee_read_only_collection_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeCollection* collection);
void gee_read_only_collection_set_collection (GeeReadOnlyCollection* self, GeeCollection* value);
GType gee_read_only_list_get_type (void);
GeeReadOnlyList* gee_read_only_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list);
GeeReadOnlyList* gee_read_only_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list);
void gee_read_only_list_set_list (GeeReadOnlyList* self, GeeList* value);
GType gee_read_only_map_get_type (void);
GeeReadOnlyMap* gee_read_only_map_new (GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GeeMap* map);
GeeReadOnlyMap* gee_read_only_map_construct (GType object_type, GType k_type, GBoxedCopyFunc k_dup_func, GDestroyNotify k_destroy_func, GType v_type, GBoxedCopyFunc v_dup_func, GDestroyNotify v_destroy_func, GeeMap* map);
void gee_read_only_map_set_map (GeeReadOnlyMap* self, GeeMap* value);
GType gee_read_only_set_get_type (void);
GeeReadOnlySet* gee_read_only_set_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeSet* set);
GeeReadOnlySet* gee_read_only_set_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeSet* set);
void gee_read_only_set_set_set (GeeReadOnlySet* self, GeeSet* value);


G_END_DECLS

#endif
