/* readonlylist.vala
 *
 * Copyright (C) 2007-2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <gee/readonlylist.h>


#define GEE_READ_ONLY_LIST_TYPE_ITERATOR (gee_read_only_list_iterator_get_type ())
#define GEE_READ_ONLY_LIST_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GEE_READ_ONLY_LIST_TYPE_ITERATOR, GeeReadOnlyListIterator))
#define GEE_READ_ONLY_LIST_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GEE_READ_ONLY_LIST_TYPE_ITERATOR, GeeReadOnlyListIteratorClass))
#define GEE_READ_ONLY_LIST_IS_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GEE_READ_ONLY_LIST_TYPE_ITERATOR))
#define GEE_READ_ONLY_LIST_IS_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GEE_READ_ONLY_LIST_TYPE_ITERATOR))
#define GEE_READ_ONLY_LIST_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GEE_READ_ONLY_LIST_TYPE_ITERATOR, GeeReadOnlyListIteratorClass))

typedef struct _GeeReadOnlyListIterator GeeReadOnlyListIterator;
typedef struct _GeeReadOnlyListIteratorClass GeeReadOnlyListIteratorClass;
typedef struct _GeeReadOnlyListIteratorPrivate GeeReadOnlyListIteratorPrivate;

struct _GeeReadOnlyListIterator {
	GObject parent_instance;
	GeeReadOnlyListIteratorPrivate * priv;
};

struct _GeeReadOnlyListIteratorClass {
	GObjectClass parent_class;
};



struct _GeeReadOnlyListPrivate {
	GeeList* _list;
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

#define GEE_READ_ONLY_LIST_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_TYPE_READ_ONLY_LIST, GeeReadOnlyListPrivate))
enum  {
	GEE_READ_ONLY_LIST_DUMMY_PROPERTY,
	GEE_READ_ONLY_LIST_SIZE,
	GEE_READ_ONLY_LIST_LIST,
	GEE_READ_ONLY_LIST_G_TYPE,
	GEE_READ_ONLY_LIST_G_DUP_FUNC,
	GEE_READ_ONLY_LIST_G_DESTROY_FUNC
};
static GType gee_read_only_list_real_get_element_type (GeeIterable* base);
static GeeIterator* gee_read_only_list_real_iterator (GeeIterable* base);
static gboolean gee_read_only_list_real_contains (GeeCollection* base, gconstpointer item);
static gint gee_read_only_list_real_index_of (GeeList* base, gconstpointer item);
static gboolean gee_read_only_list_real_add (GeeCollection* base, gconstpointer item);
static gboolean gee_read_only_list_real_remove (GeeCollection* base, gconstpointer item);
static void gee_read_only_list_real_insert (GeeList* base, gint index, gconstpointer item);
static void gee_read_only_list_real_remove_at (GeeList* base, gint index);
static gpointer gee_read_only_list_real_get (GeeList* base, gint index);
static void gee_read_only_list_real_set (GeeList* base, gint index, gconstpointer o);
static void gee_read_only_list_real_clear (GeeCollection* base);
static GeeList* gee_read_only_list_real_slice (GeeList* base, gint start, gint stop);
struct _GeeReadOnlyListIteratorPrivate {
	GType g_type;
	GBoxedCopyFunc g_dup_func;
	GDestroyNotify g_destroy_func;
};

#define GEE_READ_ONLY_LIST_ITERATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GEE_READ_ONLY_LIST_TYPE_ITERATOR, GeeReadOnlyListIteratorPrivate))
enum  {
	GEE_READ_ONLY_LIST_ITERATOR_DUMMY_PROPERTY,
	GEE_READ_ONLY_LIST_ITERATOR_G_TYPE,
	GEE_READ_ONLY_LIST_ITERATOR_G_DUP_FUNC,
	GEE_READ_ONLY_LIST_ITERATOR_G_DESTROY_FUNC
};
static gboolean gee_read_only_list_iterator_real_next (GeeIterator* base);
static gpointer gee_read_only_list_iterator_real_get (GeeIterator* base);
static GeeReadOnlyListIterator* gee_read_only_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
static GeeReadOnlyListIterator* gee_read_only_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func);
static gpointer gee_read_only_list_iterator_parent_class = NULL;
static GeeIteratorIface* gee_read_only_list_iterator_gee_iterator_parent_iface = NULL;
static GType gee_read_only_list_iterator_get_type (void);
static gpointer gee_read_only_list_parent_class = NULL;
static GeeIterableIface* gee_read_only_list_gee_iterable_parent_iface = NULL;
static GeeCollectionIface* gee_read_only_list_gee_collection_parent_iface = NULL;
static GeeListIface* gee_read_only_list_gee_list_parent_iface = NULL;
static void gee_read_only_list_finalize (GObject* obj);



GeeReadOnlyList* gee_read_only_list_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list) {
	GParameter * __params;
	GParameter * __params_it;
	GeeReadOnlyList * self;
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	__params_it->name = "g-type";
	g_value_init (&__params_it->value, G_TYPE_GTYPE);
	g_value_set_gtype (&__params_it->value, g_type);
	__params_it++;
	__params_it->name = "g-dup-func";
	g_value_init (&__params_it->value, G_TYPE_POINTER);
	g_value_set_pointer (&__params_it->value, g_dup_func);
	__params_it++;
	__params_it->name = "g-destroy-func";
	g_value_init (&__params_it->value, G_TYPE_POINTER);
	g_value_set_pointer (&__params_it->value, g_destroy_func);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	gee_read_only_list_set_list (self, list);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


GeeReadOnlyList* gee_read_only_list_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func, GeeList* list) {
	return gee_read_only_list_construct (GEE_TYPE_READ_ONLY_LIST, g_type, g_dup_func, g_destroy_func, list);
}


static GType gee_read_only_list_real_get_element_type (GeeIterable* base) {
	GeeReadOnlyList * self;
	self = (GeeReadOnlyList*) base;
	return self->priv->g_type;
}


static GeeIterator* gee_read_only_list_real_iterator (GeeIterable* base) {
	GeeReadOnlyList * self;
	self = (GeeReadOnlyList*) base;
	if (self->priv->_list == NULL) {
		return (GeeIterator*) gee_read_only_list_iterator_new (self->priv->g_type, (GBoxedCopyFunc) self->priv->g_dup_func, self->priv->g_destroy_func);
	}
	return gee_iterable_iterator ((GeeIterable*) self->priv->_list);
}


static gboolean gee_read_only_list_real_contains (GeeCollection* base, gconstpointer item) {
	GeeReadOnlyList * self;
	self = (GeeReadOnlyList*) base;
	if (self->priv->_list == NULL) {
		return FALSE;
	}
	return gee_collection_contains ((GeeCollection*) self->priv->_list, item);
}


static gint gee_read_only_list_real_index_of (GeeList* base, gconstpointer item) {
	GeeReadOnlyList * self;
	self = (GeeReadOnlyList*) base;
	if (self->priv->_list == NULL) {
		return -1;
	}
	return gee_list_index_of (self->priv->_list, item);
}


static gboolean gee_read_only_list_real_add (GeeCollection* base, gconstpointer item) {
	GeeReadOnlyList * self;
	self = (GeeReadOnlyList*) base;
	g_assert_not_reached ();
}


static gboolean gee_read_only_list_real_remove (GeeCollection* base, gconstpointer item) {
	GeeReadOnlyList * self;
	self = (GeeReadOnlyList*) base;
	g_assert_not_reached ();
}


static void gee_read_only_list_real_insert (GeeList* base, gint index, gconstpointer item) {
	GeeReadOnlyList * self;
	self = (GeeReadOnlyList*) base;
	g_assert_not_reached ();
}


static void gee_read_only_list_real_remove_at (GeeList* base, gint index) {
	GeeReadOnlyList * self;
	self = (GeeReadOnlyList*) base;
	g_assert_not_reached ();
}


static gpointer gee_read_only_list_real_get (GeeList* base, gint index) {
	GeeReadOnlyList * self;
	self = (GeeReadOnlyList*) base;
	if (self->priv->_list == NULL) {
		return NULL;
	}
	return gee_list_get (self->priv->_list, index);
}


static void gee_read_only_list_real_set (GeeList* base, gint index, gconstpointer o) {
	GeeReadOnlyList * self;
	self = (GeeReadOnlyList*) base;
	g_assert_not_reached ();
}


static void gee_read_only_list_real_clear (GeeCollection* base) {
	GeeReadOnlyList * self;
	self = (GeeReadOnlyList*) base;
	g_assert_not_reached ();
}


static GeeList* gee_read_only_list_real_slice (GeeList* base, gint start, gint stop) {
	GeeReadOnlyList * self;
	self = (GeeReadOnlyList*) base;
	g_assert_not_reached ();
}


static gint gee_read_only_list_real_get_size (GeeCollection* base) {
	GeeReadOnlyList* self;
	self = (GeeReadOnlyList*) base;
	return gee_collection_get_size ((GeeCollection*) self->priv->_list);
}


void gee_read_only_list_set_list (GeeReadOnlyList* self, GeeList* value) {
	GeeList* _tmp1;
	GeeList* _tmp0;
	g_return_if_fail (self != NULL);
	_tmp1 = NULL;
	_tmp0 = NULL;
	self->priv->_list = (_tmp1 = (_tmp0 = value, (_tmp0 == NULL) ? NULL : g_object_ref (_tmp0)), (self->priv->_list == NULL) ? NULL : (self->priv->_list = (g_object_unref (self->priv->_list), NULL)), _tmp1);
	g_object_notify ((GObject *) self, "list");
}


static gboolean gee_read_only_list_iterator_real_next (GeeIterator* base) {
	GeeReadOnlyListIterator * self;
	self = (GeeReadOnlyListIterator*) base;
	return FALSE;
}


static gpointer gee_read_only_list_iterator_real_get (GeeIterator* base) {
	GeeReadOnlyListIterator * self;
	self = (GeeReadOnlyListIterator*) base;
	return NULL;
}


static GeeReadOnlyListIterator* gee_read_only_list_iterator_construct (GType object_type, GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	GParameter * __params;
	GParameter * __params_it;
	GeeReadOnlyListIterator * self;
	__params = g_new0 (GParameter, 3);
	__params_it = __params;
	__params_it->name = "g-type";
	g_value_init (&__params_it->value, G_TYPE_GTYPE);
	g_value_set_gtype (&__params_it->value, g_type);
	__params_it++;
	__params_it->name = "g-dup-func";
	g_value_init (&__params_it->value, G_TYPE_POINTER);
	g_value_set_pointer (&__params_it->value, g_dup_func);
	__params_it++;
	__params_it->name = "g-destroy-func";
	g_value_init (&__params_it->value, G_TYPE_POINTER);
	g_value_set_pointer (&__params_it->value, g_destroy_func);
	__params_it++;
	self = g_object_newv (object_type, __params_it - __params, __params);
	while (__params_it > __params) {
		--__params_it;
		g_value_unset (&__params_it->value);
	}
	g_free (__params);
	return self;
}


static GeeReadOnlyListIterator* gee_read_only_list_iterator_new (GType g_type, GBoxedCopyFunc g_dup_func, GDestroyNotify g_destroy_func) {
	return gee_read_only_list_iterator_construct (GEE_READ_ONLY_LIST_TYPE_ITERATOR, g_type, g_dup_func, g_destroy_func);
}


static void gee_read_only_list_iterator_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeReadOnlyListIterator * self;
	gpointer boxed;
	self = GEE_READ_ONLY_LIST_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_read_only_list_iterator_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeReadOnlyListIterator * self;
	self = GEE_READ_ONLY_LIST_ITERATOR (object);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_READ_ONLY_LIST_ITERATOR_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_READ_ONLY_LIST_ITERATOR_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_READ_ONLY_LIST_ITERATOR_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void gee_read_only_list_iterator_class_init (GeeReadOnlyListIteratorClass * klass) {
	gee_read_only_list_iterator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeReadOnlyListIteratorPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_read_only_list_iterator_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_read_only_list_iterator_set_property;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_LIST_ITERATOR_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_LIST_ITERATOR_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_LIST_ITERATOR_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}


static void gee_read_only_list_iterator_gee_iterator_interface_init (GeeIteratorIface * iface) {
	gee_read_only_list_iterator_gee_iterator_parent_iface = g_type_interface_peek_parent (iface);
	iface->next = gee_read_only_list_iterator_real_next;
	iface->get = gee_read_only_list_iterator_real_get;
}


static void gee_read_only_list_iterator_instance_init (GeeReadOnlyListIterator * self) {
	self->priv = GEE_READ_ONLY_LIST_ITERATOR_GET_PRIVATE (self);
}


static GType gee_read_only_list_iterator_get_type (void) {
	static GType gee_read_only_list_iterator_type_id = 0;
	if (gee_read_only_list_iterator_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeReadOnlyListIteratorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_read_only_list_iterator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeReadOnlyListIterator), 0, (GInstanceInitFunc) gee_read_only_list_iterator_instance_init, NULL };
		static const GInterfaceInfo gee_iterator_info = { (GInterfaceInitFunc) gee_read_only_list_iterator_gee_iterator_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gee_read_only_list_iterator_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeReadOnlyListIterator", &g_define_type_info, 0);
		g_type_add_interface_static (gee_read_only_list_iterator_type_id, GEE_TYPE_ITERATOR, &gee_iterator_info);
	}
	return gee_read_only_list_iterator_type_id;
}


static void gee_read_only_list_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GeeReadOnlyList * self;
	gpointer boxed;
	self = GEE_READ_ONLY_LIST (object);
	switch (property_id) {
		case GEE_READ_ONLY_LIST_SIZE:
		g_value_set_int (value, gee_collection_get_size ((GeeCollection*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void gee_read_only_list_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GeeReadOnlyList * self;
	self = GEE_READ_ONLY_LIST (object);
	switch (property_id) {
		case GEE_READ_ONLY_LIST_LIST:
		gee_read_only_list_set_list (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
		case GEE_READ_ONLY_LIST_G_TYPE:
		self->priv->g_type = g_value_get_gtype (value);
		break;
		case GEE_READ_ONLY_LIST_G_DUP_FUNC:
		self->priv->g_dup_func = g_value_get_pointer (value);
		break;
		case GEE_READ_ONLY_LIST_G_DESTROY_FUNC:
		self->priv->g_destroy_func = g_value_get_pointer (value);
		break;
	}
}


static void gee_read_only_list_class_init (GeeReadOnlyListClass * klass) {
	gee_read_only_list_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GeeReadOnlyListPrivate));
	G_OBJECT_CLASS (klass)->get_property = gee_read_only_list_get_property;
	G_OBJECT_CLASS (klass)->set_property = gee_read_only_list_set_property;
	G_OBJECT_CLASS (klass)->finalize = gee_read_only_list_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_LIST_G_TYPE, g_param_spec_gtype ("g-type", "type", "type", G_TYPE_NONE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_LIST_G_DUP_FUNC, g_param_spec_pointer ("g-dup-func", "dup func", "dup func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_LIST_G_DESTROY_FUNC, g_param_spec_pointer ("g-destroy-func", "destroy func", "destroy func", G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_override_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_LIST_SIZE, "size");
	g_object_class_install_property (G_OBJECT_CLASS (klass), GEE_READ_ONLY_LIST_LIST, g_param_spec_object ("list", "list", "list", GEE_TYPE_LIST, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_WRITABLE));
}


static void gee_read_only_list_gee_iterable_interface_init (GeeIterableIface * iface) {
	gee_read_only_list_gee_iterable_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_element_type = gee_read_only_list_real_get_element_type;
	iface->iterator = gee_read_only_list_real_iterator;
}


static void gee_read_only_list_gee_collection_interface_init (GeeCollectionIface * iface) {
	gee_read_only_list_gee_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->contains = gee_read_only_list_real_contains;
	iface->add = gee_read_only_list_real_add;
	iface->remove = gee_read_only_list_real_remove;
	iface->clear = gee_read_only_list_real_clear;
	iface->get_size = gee_read_only_list_real_get_size;
}


static void gee_read_only_list_gee_list_interface_init (GeeListIface * iface) {
	gee_read_only_list_gee_list_parent_iface = g_type_interface_peek_parent (iface);
	iface->index_of = gee_read_only_list_real_index_of;
	iface->insert = gee_read_only_list_real_insert;
	iface->remove_at = gee_read_only_list_real_remove_at;
	iface->get = gee_read_only_list_real_get;
	iface->set = gee_read_only_list_real_set;
	iface->slice = gee_read_only_list_real_slice;
}


static void gee_read_only_list_instance_init (GeeReadOnlyList * self) {
	self->priv = GEE_READ_ONLY_LIST_GET_PRIVATE (self);
}


static void gee_read_only_list_finalize (GObject* obj) {
	GeeReadOnlyList * self;
	self = GEE_READ_ONLY_LIST (obj);
	(self->priv->_list == NULL) ? NULL : (self->priv->_list = (g_object_unref (self->priv->_list), NULL));
	G_OBJECT_CLASS (gee_read_only_list_parent_class)->finalize (obj);
}


GType gee_read_only_list_get_type (void) {
	static GType gee_read_only_list_type_id = 0;
	if (gee_read_only_list_type_id == 0) {
		static const GTypeInfo g_define_type_info = { sizeof (GeeReadOnlyListClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gee_read_only_list_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GeeReadOnlyList), 0, (GInstanceInitFunc) gee_read_only_list_instance_init, NULL };
		static const GInterfaceInfo gee_iterable_info = { (GInterfaceInitFunc) gee_read_only_list_gee_iterable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_collection_info = { (GInterfaceInitFunc) gee_read_only_list_gee_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		static const GInterfaceInfo gee_list_info = { (GInterfaceInitFunc) gee_read_only_list_gee_list_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		gee_read_only_list_type_id = g_type_register_static (G_TYPE_OBJECT, "GeeReadOnlyList", &g_define_type_info, 0);
		g_type_add_interface_static (gee_read_only_list_type_id, GEE_TYPE_ITERABLE, &gee_iterable_info);
		g_type_add_interface_static (gee_read_only_list_type_id, GEE_TYPE_COLLECTION, &gee_collection_info);
		g_type_add_interface_static (gee_read_only_list_type_id, GEE_TYPE_LIST, &gee_list_info);
	}
	return gee_read_only_list_type_id;
}




