/* testhashmap.vala
 *
 * Copyright (C) 2008  Jürg Billeter
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.

 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.

 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301  USA
 *
 * Author:
 * 	Jürg Billeter <j@bitron.ch>
 */

#include <tests/testhashmap.h>
#include <gee/hashmap.h>
#include <gee/map.h>
#include <stdlib.h>
#include <string.h>

static void test_hashmap_int_int_remove (void);
static void test_hashmap_int_int_set (void);
static void test_hashmap_string_string_remove (void);
static void test_hashmap_string_string_set (void);
static void _test_hashmap_int_int_remove_gcallback (void);
static void _test_hashmap_int_int_set_gcallback (void);
static void _test_hashmap_string_string_remove_gcallback (void);
static void _test_hashmap_string_string_set_gcallback (void);
static void _main (char** args, int args_length1);
static int _vala_strcmp0 (const char * str1, const char * str2);


static void test_hashmap_int_int_remove (void) {
	GeeHashMap* hashmap;
	hashmap = gee_hash_map_new (G_TYPE_INT, NULL, NULL, G_TYPE_INT, NULL, NULL, g_direct_hash, g_direct_equal, g_direct_equal);
	gee_map_set (GEE_MAP (hashmap), GINT_TO_POINTER (42), GINT_TO_POINTER (23));
	gee_map_remove (GEE_MAP (hashmap), GINT_TO_POINTER (42));
	g_assert (!gee_map_contains (GEE_MAP (hashmap), GINT_TO_POINTER (42)));
	g_assert (gee_map_get_size (GEE_MAP (hashmap)) == 0);
	(hashmap == NULL ? NULL : (hashmap = (g_object_unref (hashmap), NULL)));
}


static void test_hashmap_int_int_set (void) {
	GeeHashMap* hashmap;
	hashmap = gee_hash_map_new (G_TYPE_INT, NULL, NULL, G_TYPE_INT, NULL, NULL, g_direct_hash, g_direct_equal, g_direct_equal);
	gee_map_set (GEE_MAP (hashmap), GINT_TO_POINTER (42), GINT_TO_POINTER (23));
	g_assert (gee_map_contains (GEE_MAP (hashmap), GINT_TO_POINTER (42)));
	g_assert (GPOINTER_TO_INT (gee_map_get (GEE_MAP (hashmap), GINT_TO_POINTER (42))) == 23);
	g_assert (gee_map_get_size (GEE_MAP (hashmap)) == 1);
	(hashmap == NULL ? NULL : (hashmap = (g_object_unref (hashmap), NULL)));
}


static void test_hashmap_string_string_remove (void) {
	GeeHashMap* hashmap;
	hashmap = gee_hash_map_new (G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, g_str_hash, g_str_equal, g_str_equal);
	gee_map_set (GEE_MAP (hashmap), "hello", "world");
	gee_map_remove (GEE_MAP (hashmap), "hello");
	g_assert (!gee_map_contains (GEE_MAP (hashmap), "hello"));
	g_assert (gee_map_get_size (GEE_MAP (hashmap)) == 0);
	(hashmap == NULL ? NULL : (hashmap = (g_object_unref (hashmap), NULL)));
}


static void test_hashmap_string_string_set (void) {
	GeeHashMap* hashmap;
	char* _tmp0;
	hashmap = gee_hash_map_new (G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, G_TYPE_STRING, ((GBoxedCopyFunc) g_strdup), g_free, g_str_hash, g_str_equal, g_str_equal);
	gee_map_set (GEE_MAP (hashmap), "hello", "world");
	g_assert (gee_map_contains (GEE_MAP (hashmap), "hello"));
	_tmp0 = NULL;
	g_assert (_vala_strcmp0 ((_tmp0 = ((char*) gee_map_get (GEE_MAP (hashmap), "hello"))), "world") == 0);
	_tmp0 = (g_free (_tmp0), NULL);
	g_assert (gee_map_get_size (GEE_MAP (hashmap)) == 1);
	(hashmap == NULL ? NULL : (hashmap = (g_object_unref (hashmap), NULL)));
}


static void _test_hashmap_int_int_remove_gcallback (void) {
	test_hashmap_int_int_remove ();
}


static void _test_hashmap_int_int_set_gcallback (void) {
	test_hashmap_int_int_set ();
}


static void _test_hashmap_string_string_remove_gcallback (void) {
	test_hashmap_string_string_remove ();
}


static void _test_hashmap_string_string_set_gcallback (void) {
	test_hashmap_string_string_set ();
}


static void _main (char** args, int args_length1) {
	g_test_init (&args_length1, &args, NULL);
	g_test_add_func ("/hashmap/int-int/remove", _test_hashmap_int_int_remove_gcallback);
	g_test_add_func ("/hashmap/int-int/set", _test_hashmap_int_int_set_gcallback);
	g_test_add_func ("/hashmap/string-string/remove", _test_hashmap_string_string_remove_gcallback);
	g_test_add_func ("/hashmap/string-string/set", _test_hashmap_string_string_set_gcallback);
	g_test_run ();
}


int main (int argc, char ** argv) {
	g_type_init ();
	_main (argv, argc);
	return 0;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return (str1 != str2);
	}
	return strcmp (str1, str2);
}




