// Generated by gtkmmproc -- DO NOT MODIFY!


#include <libgdamm/connection.h>
#include <libgdamm/private/connection_p.h>

/* $Id: connection.ccg,v 1.18 2006/11/30 06:58:55 murrayc Exp $ */
// -*- C++ -*- //

/* connection.cc
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/serverprovider.h>
#include <libgdamm/metastore.h>
#include <libgda/gda-enum-types.h>
#include <libgda/gda-connection.h>
#include <sql-parser/gda-sql-parser.h> //For gda_sql_identifier_quote().
#include <libgda/libgda.h> //For GDA_GENERAL_ERROR
#include <iostream>

namespace Gnome
{

namespace Gda
{

Connection::~Connection()
{
  //Make sure the connection is closed.
  //An open connection with no associated connection object could never be closed.
  if(gobj())
  {
    if(is_opened())
      close();
  }
}

Glib::RefPtr<Connection> Connection::open_from_string(const Glib::ustring& provider_name,
                                                       const Glib::ustring& cnc_string,
                                                       const Glib::ustring& auth_string,
                                                       ConnectionOptions options)
{
  GError* gerror = 0;
  Glib::RefPtr<Connection> retval = Glib::wrap(gda_connection_open_from_string(provider_name.c_str(),
                                                                                cnc_string.c_str(),
                                                                                auth_string.c_str(),
                                                                                (GdaConnectionOptions)options,
                                                                                &gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);
  return retval;
}

void Connection::close()
{
  //gda_connection_close() does an unref, but we don't want that:
  reference();
  gda_connection_close(gobj());
}

Glib::RefPtr<Glib::Object> Connection::statement_execute(const Glib::RefPtr<const Statement>& cmd, const Glib::RefPtr<const Set>& params, StatementModelUsage model_usage, Glib::RefPtr<const Set>& last_inserted_row)
{
  GError* gerror = 0;
  GdaSet* lir = 0;
  Glib::RefPtr<Glib::Object> retval = Glib::wrap(
    gda_connection_statement_execute(gobj(), const_cast<GdaStatement*>(cmd->gobj()), const_cast<GdaSet*>(Glib::unwrap(params)), (GdaStatementModelUsage)model_usage, &lir, &gerror));

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  if(lir)
    last_inserted_row = Glib::wrap(lir);

  return retval;
}

Glib::RefPtr<Glib::Object> Connection::statement_execute(const Glib::RefPtr<const Statement>& stmt, StatementModelUsage model_usage)
{
  GError* gerror = 0;
  Glib::RefPtr<Glib::Object> retval = Glib::wrap(
    gda_connection_statement_execute(gobj(), const_cast<GdaStatement*>(Glib::unwrap(stmt)), 0, (GdaStatementModelUsage)model_usage, 0, &gerror));

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retval;
}

Glib::RefPtr<Glib::Object> Connection::statement_execute(const Glib::ustring& sql, StatementModelUsage model_usage)
{
  Glib::RefPtr<const Statement> stmt;
  Glib::RefPtr<SqlParser> parser = create_parser();
  if(parser)
  {
    stmt = parser->parse_string(sql);
  }
  else
    std::cerr << "Gda::Connection::statement_execute(): Couldn't create parser" << std::endl;

  if(!stmt)
    return Glib::RefPtr<Glib::Object>();

  return statement_execute(stmt, model_usage);
}

int Connection::statement_execute_non_select(const Glib::RefPtr<const Statement>& cmd, const Glib::RefPtr<const Set>& params, Glib::RefPtr<const Set>& last_inserted_row)
{
  GError* gerror = 0;
  GdaSet* lir = 0;
  const int retval = gda_connection_statement_execute_non_select(gobj(), const_cast<GdaStatement*>(Glib::unwrap(cmd)),  const_cast<GdaSet*>(Glib::unwrap(params)), &lir, &gerror);

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  if(lir)
    last_inserted_row = Glib::wrap(lir);

  return retval;
}

int Connection::statement_execute_non_select(const Glib::RefPtr<const Statement>& cmd, const Glib::RefPtr<const Set>& params)
{
  GError* gerror = 0;
  const int retval = gda_connection_statement_execute_non_select(gobj(), const_cast<GdaStatement*>(Glib::unwrap(cmd)),  const_cast<GdaSet*>(Glib::unwrap(params)), 0, &gerror);

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retval;
}

int Connection::statement_execute_non_select(const Glib::RefPtr<const Statement>& cmd)
{
  GError* gerror = 0;
  const int retval = gda_connection_statement_execute_non_select(gobj(), const_cast<GdaStatement*>(Glib::unwrap(cmd)), 0, 0, &gerror);

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retval;
}

int Connection::statement_execute_non_select_builder(const Glib::RefPtr<const SqlBuilder>& builder)
{
  Glib::RefPtr<Gnome::Gda::Statement> stmt = builder->get_statement(); //Allow any exceptions to be thrown up to the caller.

  if(!stmt)
     return 0;

  return statement_execute_non_select(stmt);
}

int Connection::statement_execute_non_select_builder(const Glib::RefPtr<const SqlBuilder>& builder, const Glib::RefPtr<const Set>& params)
{
  Glib::RefPtr<Gnome::Gda::Statement> stmt = builder->get_statement(); //Allow any exceptions to be thrown up to the caller.

  if(!stmt)
     return 0;

  return statement_execute_non_select(stmt, params);
}

Glib::ustring Connection::statement_to_sql(const Glib::RefPtr<const Statement>& statement, const Glib::RefPtr<const Set>& params, StatementSqlFlag flags, std::vector< Glib::RefPtr<Holder> >& params_used) const
{
  GError* gerror = 0;
  GSList* params_usedc = 0;
  const Glib::ustring retvalue = Glib::convert_return_gchar_ptr_to_ustring(gda_connection_statement_to_sql(const_cast<GdaConnection*>(gobj()), const_cast<GdaStatement*>(Glib::unwrap(statement)), const_cast<GdaSet*>(Glib::unwrap(params)), ((GdaStatementSqlFlag)(flags)), &params_usedc, &(gerror)));

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  std::vector< Glib::RefPtr<Holder> > params_usedcpp
    = Glib::SListHandler< Glib::RefPtr<Holder> >::slist_to_vector(params_usedc, Glib::OWNERSHIP_SHALLOW);
  for(std::vector< Glib::RefPtr<Holder> >::const_iterator i = params_usedcpp.begin();
       i != params_usedcpp.end(); i++)
  {
    params_used.push_back(*i);
  }

  return retvalue;
}

Glib::RefPtr<DataModel> Connection::statement_execute_select(const Glib::RefPtr<const Statement>& stmt, StatementModelUsage model_usage)
{
  GError* gerror = 0;
  Glib::RefPtr<DataModel> retvalue = Glib::wrap(gda_connection_statement_execute_select_full(gobj(), const_cast<GdaStatement*>(Glib::unwrap(stmt)), 0 /* params */, ((GdaStatementModelUsage)(model_usage)), 0 /* col_types */, &(gerror)));

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<DataModel> Connection::statement_execute_select(const Glib::RefPtr<const Statement>& stmt, const Glib::RefPtr<const Set>& params, StatementModelUsage model_usage)
{
  GError* gerror = 0;
  Glib::RefPtr<DataModel> retvalue = Glib::wrap(gda_connection_statement_execute_select_full(gobj(), const_cast<GdaStatement*>(Glib::unwrap(stmt)), const_cast<GdaSet*>(Glib::unwrap(params)), ((GdaStatementModelUsage)(model_usage)), 0 /* col_types */, &(gerror)));

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}


Glib::RefPtr<DataModel> Connection::statement_execute_select_builder(const Glib::RefPtr<const SqlBuilder>& builder, StatementModelUsage model_usage)
{
  Glib::RefPtr<Gnome::Gda::Statement> stmt = builder->get_statement(); //Allow any exceptions to be thrown up to the caller.

  if(!stmt)
     return Glib::RefPtr<DataModel>();

  return statement_execute_select(stmt, model_usage);
}


Glib::RefPtr<DataModel> Connection::statement_execute_select_builder(const Glib::RefPtr<const SqlBuilder>& builder, const Glib::RefPtr<const Set>& params, StatementModelUsage model_usage)
{
  Glib::RefPtr<Gnome::Gda::Statement> stmt = builder->get_statement(); //Allow any exceptions to be thrown up to the caller.

  if(!stmt)
     return Glib::RefPtr<DataModel>();

  return statement_execute_select(stmt, params, model_usage);
}

Glib::RefPtr<DataModel> Connection::statement_execute_select(const Glib::ustring& sql, StatementModelUsage model_usage)
{
  Glib::RefPtr<const Statement> stmt;
  Glib::RefPtr<SqlParser> parser = create_parser();
  if(parser)
  {
    stmt = parser->parse_string(sql);
  }

  if(!stmt)
    return Glib::RefPtr<DataModel>();

  GError* gerror = 0;
  Glib::RefPtr<DataModel> retvalue = Glib::wrap(gda_connection_statement_execute_select_full(gobj(), const_cast<GdaStatement*>(Glib::unwrap(stmt)), 0 /* params */, ((GdaStatementModelUsage)(model_usage)), 0 /* col_types */, &(gerror)));

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<DataModel> Connection::statement_execute_select(const Glib::ustring& sql, const Glib::RefPtr<const Set>& params, StatementModelUsage model_usage)
{
  Glib::RefPtr<const Statement> stmt;
  Glib::RefPtr<SqlParser> parser = create_parser();
  if(parser)
  {
    stmt = parser->parse_string(sql);
  }

  if(!stmt)
    return Glib::RefPtr<DataModel>();

  GError* gerror = 0;
  Glib::RefPtr<DataModel> retvalue = Glib::wrap(gda_connection_statement_execute_select_full(gobj(), const_cast<GdaStatement*>(Glib::unwrap(stmt)), const_cast<GdaSet*>(Glib::unwrap(params)), ((GdaStatementModelUsage)(model_usage)), 0 /* col_types */, &(gerror)));

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}


bool Connection::update_meta_store()
{
  GError* gerror = 0;
  const bool retvalue = gda_connection_update_meta_store(gobj(), 0, &gerror);

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

bool Connection::update_meta_store(const Glib::ustring& id)
{
  GError* gerror = 0;
  GdaMetaContext mcontext = {const_cast<gchar*>(id.c_str()), 1, 0, 0};
  const bool retvalue = gda_connection_update_meta_store(gobj(), &mcontext, &gerror);

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

Glib::RefPtr<DataModel> Connection::get_meta_store_data(ConnectionMetaType meta_type)
{
  GError* gerror = 0;
  Glib::RefPtr<DataModel> retvalue = Glib::wrap(gda_connection_get_meta_store_data_v(gobj(), ((GdaConnectionMetaType)(meta_type)), 0, &(gerror)));

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

bool Connection::update_meta_store_table(const Glib::ustring& table_name, const Glib::ustring& schema_name)
{
  // This function is needed to make sure that
  // the GdaMetaStore really gets the meta data for the table we specified, even if
  // the table name contains upper-case characters or spaces. murrayc.
  gchar* table_name_quoted = gda_meta_store_sql_identifier_quote (table_name.c_str(), gobj());
  //std::cout << "Connection::update_meta_store_table(): table_name_quoted=" << table_name_quoted << std::endl;

  GValue table_name_value = { 0 };
  g_value_init(&table_name_value, G_TYPE_STRING);
  g_value_set_static_string(&table_name_value, table_name_quoted);

  GValue table_schema_value = { 0 };
  g_value_init(&table_schema_value, G_TYPE_STRING);
  g_value_set_static_string(&table_schema_value, schema_name.c_str());

  gchar* column_names[] = { (gchar*)"table_name" , (gchar*)"table_schema"};
  GValue* column_values[] = { &table_name_value, &table_schema_value };

  GdaMetaContext mcontext = {(gchar*)"_tables", schema_name.empty() ? 1 : 2, column_names, column_values };
  GError* gerror = 0;
  const bool retval = gda_connection_update_meta_store(gobj(), &mcontext, &gerror);

  g_value_unset(&table_name_value);
  g_value_unset(&table_schema_value);

  g_free(table_name_quoted);

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retval;
}

bool Connection::update_meta_store_table_names(const Glib::ustring& schema_name)
{
  GValue table_schema_value = { 0 };
  g_value_init(&table_schema_value, G_TYPE_STRING);
  g_value_set_static_string(&table_schema_value, schema_name.c_str());

  gchar* column_names[] = { (gchar*)"table_schema"};
  GValue* column_values[] = { &table_schema_value };

  GdaMetaContext mcontext = {(gchar*)"_tables", schema_name.empty() ? 0 : 1, column_names, column_values };
  GError* gerror = 0;
  const bool retval = gda_connection_update_meta_store(gobj(), &mcontext, &gerror);

  g_value_unset(&table_schema_value);

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retval;
}

bool Connection::update_meta_store_data_types()
{
  GdaMetaContext mcontext = {(gchar*)"_builtin_data_types", 0, 0, 0 };
  GError* gerror = 0;
  const bool retval = gda_connection_update_meta_store(gobj(), &mcontext, &gerror);

  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retval;
}

Glib::RefPtr<Statement> Connection::parse_sql_string(const Glib::ustring& sql)
{
  GError* gerror = 0;
  Glib::RefPtr<Statement> retvalue = Glib::wrap(gda_connection_parse_sql_string(gobj(), sql.c_str(), 0 /* see C docs */, &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;
}

} //namespace Gda

} //namespace Gnome

namespace
{


static void Connection_signal_error_callback(GdaConnection* self, GdaConnectionEvent* p0,void* data)
{
  using namespace Gnome::Gda;
  typedef sigc::slot< void,const Glib::RefPtr<ConnectionEvent>& > SlotType;

  // Do not try to call a signal on a disassociated wrapper.
  if(Glib::ObjectBase::_get_current_wrapper((GObject*) self))
  {
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    try
    {
    #endif //GLIBMM_EXCEPTIONS_ENABLED
      if(sigc::slot_base *const slot = Glib::SignalProxyNormal::data_to_slot(data))
        (*static_cast<SlotType*>(slot))(Glib::wrap(p0, true)
);
    #ifdef GLIBMM_EXCEPTIONS_ENABLED
    }
    catch(...)
    {
      Glib::exception_handlers_invoke();
    }
    #endif //GLIBMM_EXCEPTIONS_ENABLED
  }
}

static const Glib::SignalProxyInfo Connection_signal_error_info =
{
  "error",
  (GCallback) &Connection_signal_error_callback,
  (GCallback) &Connection_signal_error_callback
};


static const Glib::SignalProxyInfo Connection_signal_conn_opened_info =
{
  "conn_opened",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Connection_signal_conn_to_close_info =
{
  "conn_to_close",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Connection_signal_conn_closed_info =
{
  "conn_closed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Connection_signal_dsn_changed_info =
{
  "dsn_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


static const Glib::SignalProxyInfo Connection_signal_transaction_status_changed_info =
{
  "transaction_status_changed",
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback,
  (GCallback) &Glib::SignalProxyNormal::slot0_void_callback
};


} // anonymous namespace


Gnome::Gda::ConnectionError::ConnectionError(Gnome::Gda::ConnectionError::Code error_code, const Glib::ustring& error_message)
:
  Glib::Error (GDA_CONNECTION_ERROR, error_code, error_message)
{}

Gnome::Gda::ConnectionError::ConnectionError(GError* gobject)
:
  Glib::Error (gobject)
{}

Gnome::Gda::ConnectionError::Code Gnome::Gda::ConnectionError::code() const
{
  return static_cast<Code>(Glib::Error::code());
}

void Gnome::Gda::ConnectionError::throw_func(GError* gobject)
{
  throw Gnome::Gda::ConnectionError(gobject);
}

// static
GType Glib::Value<Gnome::Gda::ConnectionError::Code>::value_type()
{
  return gda_connection_error_get_type();
}

// static
GType Glib::Value<Gnome::Gda::ConnectionOptions>::value_type()
{
  return gda_connection_options_get_type();
}

// static
GType Glib::Value<Gnome::Gda::ConnectionMetaType>::value_type()
{
  return gda_connection_meta_type_get_type();
}


namespace Glib
{

Glib::RefPtr<Gnome::Gda::Connection> wrap(GdaConnection* object, bool take_copy)
{
  return Glib::RefPtr<Gnome::Gda::Connection>( dynamic_cast<Gnome::Gda::Connection*> (Glib::wrap_auto ((GObject*)(object), take_copy)) );
  //We use dynamic_cast<> in case of multiple inheritance.
}

} /* namespace Glib */


namespace Gnome
{

namespace Gda
{


/* The *_Class implementation: */

const Glib::Class& Connection_Class::init()
{
  if(!gtype_) // create the GType if necessary
  {
    // Glib::Class has to know the class init function to clone custom types.
    class_init_func_ = &Connection_Class::class_init_function;

    // This is actually just optimized away, apparently with no harm.
    // Make sure that the parent type has been created.
    //CppClassParent::CppObjectType::get_type();

    // Create the wrapper type, with the same class/instance size as the base type.
    register_derived_type(gda_connection_get_type());

    // Add derived versions of interfaces, if the C type implements any interfaces:

  }

  return *this;
}


void Connection_Class::class_init_function(void* g_class, void* class_data)
{
  BaseClassType *const klass = static_cast<BaseClassType*>(g_class);
  CppClassParent::class_init_function(klass, class_data);


  klass->error = &error_callback;
  klass->conn_opened = &conn_opened_callback;
  klass->conn_to_close = &conn_to_close_callback;
  klass->conn_closed = &conn_closed_callback;
  klass->dsn_changed = &dsn_changed_callback;
  klass->transaction_status_changed = &transaction_status_changed_callback;
}


void Connection_Class::error_callback(GdaConnection* self, GdaConnectionEvent* p0)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_error(Glib::wrap(p0, true)
);
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->error)
    (*base->error)(self, p0);
}
void Connection_Class::conn_opened_callback(GdaConnection* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_conn_opened();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->conn_opened)
    (*base->conn_opened)(self);
}
void Connection_Class::conn_to_close_callback(GdaConnection* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_conn_to_close();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->conn_to_close)
    (*base->conn_to_close)(self);
}
void Connection_Class::conn_closed_callback(GdaConnection* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_conn_closed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->conn_closed)
    (*base->conn_closed)(self);
}
void Connection_Class::dsn_changed_callback(GdaConnection* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_dsn_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->dsn_changed)
    (*base->dsn_changed)(self);
}
void Connection_Class::transaction_status_changed_callback(GdaConnection* self)
{
  Glib::ObjectBase *const obj_base = static_cast<Glib::ObjectBase*>(
      Glib::ObjectBase::_get_current_wrapper((GObject*)self));

  // Non-gtkmmproc-generated custom classes implicitly call the default
  // Glib::ObjectBase constructor, which sets is_derived_. But gtkmmproc-
  // generated classes can use this optimisation, which avoids the unnecessary
  // parameter conversions if there is no possibility of the virtual function
  // being overridden:
  if(obj_base && obj_base->is_derived_())
  {
    CppObjectType *const obj = dynamic_cast<CppObjectType* const>(obj_base);
    if(obj) // This can be NULL during destruction.
    {
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      try // Trap C++ exceptions which would normally be lost because this is a C callback.
      {
      #endif //GLIBMM_EXCEPTIONS_ENABLED
        // Call the virtual member method, which derived classes might override.
        obj->on_transaction_status_changed();
        return;
      #ifdef GLIBMM_EXCEPTIONS_ENABLED
      }
      catch(...)
      {
        Glib::exception_handlers_invoke();
      }
      #endif //GLIBMM_EXCEPTIONS_ENABLED
    }
  }

  BaseClassType *const base = static_cast<BaseClassType*>(
        g_type_class_peek_parent(G_OBJECT_GET_CLASS(self)) // Get the parent class of the object class (The original underlying C class).
    );

  // Call the original underlying C function:
  if(base && base->transaction_status_changed)
    (*base->transaction_status_changed)(self);
}


Glib::ObjectBase* Connection_Class::wrap_new(GObject* object)
{
  return new Connection((GdaConnection*)object);
}


/* The implementation: */

GdaConnection* Connection::gobj_copy()
{
  reference();
  return gobj();
}

Connection::Connection(const Glib::ConstructParams& construct_params)
:
  Glib::Object(construct_params)
{

}

Connection::Connection(GdaConnection* castitem)
:
  Glib::Object((GObject*)(castitem))
{}


Connection::CppClassType Connection::connection_class_; // initialize static member

GType Connection::get_type()
{
  return connection_class_.init().get_type();
}


GType Connection::get_base_type()
{
  return gda_connection_get_type();
}


Connection::Connection()
:
  // Mark this class as non-derived to allow C++ vfuncs to be skipped.
  Glib::ObjectBase(0),
  Glib::Object(Glib::ConstructParams(connection_class_.init()))
{
  

}

Glib::RefPtr<Connection> Connection::create()
{
  return Glib::RefPtr<Connection>( new Connection() );
}

bool Connection::open()
{
  GError* gerror = 0;
  bool retvalue = gda_connection_open(gobj(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

bool Connection::is_opened() const
{
  return gda_connection_is_opened(const_cast<GdaConnection*>(gobj()));
}

ConnectionOptions Connection::get_options() const
{
  return ((ConnectionOptions)(gda_connection_get_options(const_cast<GdaConnection*>(gobj()))));
}

Glib::ustring Connection::get_dsn() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_connection_get_dsn(const_cast<GdaConnection*>(gobj())));
}

Glib::ustring Connection::get_cnc_string() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_connection_get_cnc_string(const_cast<GdaConnection*>(gobj())));
}

void Connection::clear_events_list()
{
gda_connection_clear_events_list(gobj()); 
}

Glib::RefPtr<DataModel> Connection::statement_execute_select(const Glib::RefPtr<const Statement>& stmt, const Glib::RefPtr<const Set>& params, StatementModelUsage model_usage, const std::vector<GType>& col_types)
{
  GError* gerror = 0;
  Glib::RefPtr<DataModel> retvalue = Glib::wrap(gda_connection_statement_execute_select_full(gobj(), const_cast<GdaStatement*>(Glib::unwrap(stmt)), const_cast<GdaSet*>(Glib::unwrap(params)), ((GdaStatementModelUsage)(model_usage)), const_cast<GType*>(Glib::ArrayHandler<GType>::vector_to_array(col_types).data()), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

int Connection::statement_execute_non_select(const Glib::ustring& sql)
{
  GError* gerror = 0;
  int retvalue = gda_connection_execute_non_select_command(gobj(), sql.c_str(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

guint Connection::async_statement_execute(const Glib::RefPtr<const Statement>& stmt, const Glib::RefPtr<const Set>& params, StatementModelUsage model_usage, const std::vector<GType>& col_types, bool need_last_insert_row)
{
  GError* gerror = 0;
  guint retvalue = gda_connection_async_statement_execute(gobj(), const_cast<GdaStatement*>(Glib::unwrap(stmt)), const_cast<GdaSet*>(Glib::unwrap(params)), ((GdaStatementModelUsage)(model_usage)), const_cast<GType*>(Glib::ArrayHandler<GType>::vector_to_array(col_types).data()), static_cast<int>(need_last_insert_row), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

Glib::RefPtr<Glib::Object> Connection::async_fetch_result(guint task_id, GdaSet ** last_insert_row)
{
  GError* gerror = 0;
  Glib::RefPtr<Glib::Object> retvalue = Glib::wrap(gda_connection_async_fetch_result(gobj(), task_id, last_insert_row, &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

bool Connection::async_cancel(guint task_id)
{
  GError* gerror = 0;
  bool retvalue = gda_connection_async_cancel(gobj(), task_id, &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

Glib::RefPtr<const TransactionStatus> Connection::get_transaction_status() const
{
  GError* gerror = 0;
  Glib::RefPtr<const TransactionStatus> retvalue = Glib::wrap(gda_connection_get_transaction_status(const_cast<GdaConnection*>(gobj())));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

bool Connection::begin_transaction(const Glib::ustring& name, TransactionIsolation level)
{
  GError* gerror = 0;
  bool retvalue = gda_connection_begin_transaction(gobj(), name.c_str(), ((GdaTransactionIsolation)(level)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

bool Connection::commit_transaction(const Glib::ustring& name)
{
  GError* gerror = 0;
  bool retvalue = gda_connection_commit_transaction(gobj(), name.c_str(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

bool Connection::rollback_transaction(const Glib::ustring& name)
{
  GError* gerror = 0;
  bool retvalue = gda_connection_rollback_transaction(gobj(), name.c_str(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

bool Connection::add_savepoint(const Glib::ustring& name)
{
  GError* gerror = 0;
  bool retvalue = gda_connection_add_savepoint(gobj(), name.c_str(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

bool Connection::rollback_savepoint(const Glib::ustring& name)
{
  GError* gerror = 0;
  bool retvalue = gda_connection_rollback_savepoint(gobj(), name.c_str(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

bool Connection::delete_savepoint(const Glib::ustring& name)
{
  GError* gerror = 0;
  bool retvalue = gda_connection_delete_savepoint(gobj(), name.c_str(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

std::vector< Glib::RefPtr<ConnectionEvent> > Connection::get_events()
{
  return std::vector< Glib::RefPtr<ConnectionEvent> >(Glib::ListHandler< Glib::RefPtr<ConnectionEvent> >::list_to_vector(const_cast<GList*>(gda_connection_get_events(gobj())), Glib::OWNERSHIP_NONE));
}

std::vector< Glib::RefPtr<const ConnectionEvent> > Connection::get_events() const
{
  return std::vector< Glib::RefPtr<const ConnectionEvent> >(Glib::ListHandler< Glib::RefPtr<const ConnectionEvent> >::list_to_vector(const_cast<GList*>(gda_connection_get_events(const_cast<GdaConnection*>(gobj()))), Glib::OWNERSHIP_NONE));
}

bool Connection::insert_row_into_table(const Glib::ustring& table, const std::vector<Glib::ustring>& col_names, const std::vector<Value>& values)
{
  GError* gerror = 0;
  bool retvalue = gda_connection_insert_row_into_table_v(gobj(), table.c_str(), Glib::SListHandler<Glib::ustring>::vector_to_slist(col_names).data(), Glib::SListHandler<Value, ValueTraits>::vector_to_slist(values).data(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

bool Connection::update_row_in_table(const Glib::ustring& table, const Glib::ustring& condition_column_name, const Value& condition_value, const std::vector<Glib::ustring>& col_names, const std::vector<Value>& values)
{
  GError* gerror = 0;
  bool retvalue = gda_connection_update_row_in_table_v(gobj(), table.c_str(), condition_column_name.c_str(), const_cast<GValue*>((condition_value).gobj()), Glib::SListHandler<Glib::ustring>::vector_to_slist(col_names).data(), Glib::SListHandler<Value, ValueTraits>::vector_to_slist(values).data(), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

bool Connection::delete_row_from_table(const Glib::ustring& table, const Glib::ustring& condition_column_name, const Value& condition_value)
{
  GError* gerror = 0;
  bool retvalue = gda_connection_delete_row_from_table(gobj(), table.c_str(), condition_column_name.c_str(), const_cast<GValue*>((condition_value).gobj()), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

Glib::ustring Connection::value_to_sql_string(const Value& from) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gda_connection_value_to_sql_string(const_cast<GdaConnection*>(gobj()), const_cast<GValue*>((from).gobj())));
}

bool Connection::supports_feature(ConnectionFeature feature) const
{
  return gda_connection_supports_feature(const_cast<GdaConnection*>(gobj()), ((GdaConnectionFeature)(feature)));
}

Glib::ustring Connection::get_authentication() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_connection_get_authentication(const_cast<GdaConnection*>(gobj())));
}

Glib::RefPtr<SqlParser> Connection::create_parser()
{
  return Glib::wrap(gda_connection_create_parser(gobj()));
}

Glib::ustring Connection::get_provider_name() const
{
  return Glib::convert_const_gchar_ptr_to_ustring(gda_connection_get_provider_name(const_cast<GdaConnection*>(gobj())));
}

bool Connection::statement_prepare(const Glib::RefPtr<const Statement>& stmt)
{
  GError* gerror = 0;
  bool retvalue = gda_connection_statement_prepare(gobj(), const_cast<GdaStatement*>(Glib::unwrap(stmt)), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

Glib::RefPtr<DataModel> Connection::get_meta_store_data(ConnectionMetaType meta_type, const std::vector< Glib::RefPtr<Holder> >& filters)
{
  GError* gerror = 0;
  Glib::RefPtr<DataModel> retvalue = Glib::wrap(gda_connection_get_meta_store_data_v(gobj(), ((GdaConnectionMetaType)(meta_type)), Glib::ListHandler< Glib::RefPtr<Holder> >::vector_to_list(filters).data(), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

Glib::RefPtr<MetaStore> Connection::get_meta_store()
{

  Glib::RefPtr<MetaStore> retvalue = Glib::wrap(gda_connection_get_meta_store(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const MetaStore> Connection::get_meta_store() const
{
  return const_cast<Connection*>(this)->get_meta_store();
}

std::vector< Glib::RefPtr<Glib::Object> > Connection::batch_execute(const Glib::RefPtr<Batch>& batch, const Glib::RefPtr<const Set>& params, StatementModelUsage model_usage)
{
  GError* gerror = 0;
  std::vector< Glib::RefPtr<Glib::Object> > retvalue = std::vector< Glib::RefPtr<Glib::Object> >(Glib::SListHandler< Glib::RefPtr<Glib::Object > >::slist_to_vector(gda_connection_batch_execute(gobj(), const_cast<GdaBatch*>(Glib::unwrap(batch)), const_cast<GdaSet*>(Glib::unwrap(params)), ((GdaStatementModelUsage)(model_usage)), &(gerror)), Glib::OWNERSHIP_SHALLOW));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

Glib::RefPtr<ServerOperation> Connection::create_operation(ServerOperationType type, const Glib::RefPtr<const Set>& options)
{
  GError* gerror = 0;
  Glib::RefPtr<ServerOperation> retvalue = Glib::wrap(gda_connection_create_operation(gobj(), ((GdaServerOperationType)(type)), const_cast<GdaSet*>(Glib::unwrap(options)), &(gerror)));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

bool Connection::perform_operation(const Glib::RefPtr<ServerOperation>& op)
{
  GError* gerror = 0;
  bool retvalue = gda_connection_perform_operation(gobj(), Glib::unwrap(op), &(gerror));
  if(gerror)
    ::Glib::Error::throw_exception(gerror);

  return retvalue;

}

Glib::RefPtr<ServerProvider> Connection::get_provider()
{

  Glib::RefPtr<ServerProvider> retvalue = Glib::wrap(gda_connection_get_provider(gobj()));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::RefPtr<const ServerProvider> Connection::get_provider() const
{

  Glib::RefPtr<const ServerProvider> retvalue = Glib::wrap(gda_connection_get_provider(const_cast<GdaConnection*>(gobj())));
  if(retvalue)
    retvalue->reference(); //The function does not do a ref for us.
  return retvalue;

}

Glib::ustring Connection::quote_sql_identifier(const Glib::ustring& id) const
{
  return Glib::convert_return_gchar_ptr_to_ustring(gda_connection_quote_sql_identifier(const_cast<GdaConnection*>(gobj()), id.c_str()));
}


Glib::SignalProxy1< void,const Glib::RefPtr<ConnectionEvent>& > Connection::signal_error()
{
  return Glib::SignalProxy1< void,const Glib::RefPtr<ConnectionEvent>& >(this, &Connection_signal_error_info);
}


Glib::SignalProxy0< void > Connection::signal_conn_opened()
{
  return Glib::SignalProxy0< void >(this, &Connection_signal_conn_opened_info);
}


Glib::SignalProxy0< void > Connection::signal_conn_to_close()
{
  return Glib::SignalProxy0< void >(this, &Connection_signal_conn_to_close_info);
}


Glib::SignalProxy0< void > Connection::signal_conn_closed()
{
  return Glib::SignalProxy0< void >(this, &Connection_signal_conn_closed_info);
}


Glib::SignalProxy0< void > Connection::signal_dsn_changed()
{
  return Glib::SignalProxy0< void >(this, &Connection_signal_dsn_changed_info);
}


Glib::SignalProxy0< void > Connection::signal_transaction_status_changed()
{
  return Glib::SignalProxy0< void >(this, &Connection_signal_transaction_status_changed_info);
}


#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Glib::RefPtr<ServerProvider> > Connection::property_provider() 
{
  return Glib::PropertyProxy< Glib::RefPtr<ServerProvider> >(this, "provider");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<ServerProvider> > Connection::property_provider() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<ServerProvider> >(this, "provider");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Connection::property_auth_string() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "auth-string");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Connection::property_auth_string() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "auth-string");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Connection::property_cnc_string() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "cnc-string");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Connection::property_cnc_string() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "cnc-string");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<Glib::ustring> Connection::property_dsn() 
{
  return Glib::PropertyProxy<Glib::ustring>(this, "dsn");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<Glib::ustring> Connection::property_dsn() const
{
  return Glib::PropertyProxy_ReadOnly<Glib::ustring>(this, "dsn");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy< Glib::RefPtr<MetaStore> > Connection::property_meta_store() 
{
  return Glib::PropertyProxy< Glib::RefPtr<MetaStore> >(this, "meta-store");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly< Glib::RefPtr<MetaStore> > Connection::property_meta_store() const
{
  return Glib::PropertyProxy_ReadOnly< Glib::RefPtr<MetaStore> >(this, "meta-store");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<ConnectionOptions> Connection::property_options() 
{
  return Glib::PropertyProxy<ConnectionOptions>(this, "options");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<ConnectionOptions> Connection::property_options() const
{
  return Glib::PropertyProxy_ReadOnly<ConnectionOptions>(this, "options");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Connection::property_is_wrapper() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "is-wrapper");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<bool> Connection::property_monitor_wrapped_in_mainloop() 
{
  return Glib::PropertyProxy<bool>(this, "monitor-wrapped-in-mainloop");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<bool> Connection::property_monitor_wrapped_in_mainloop() const
{
  return Glib::PropertyProxy_ReadOnly<bool>(this, "monitor-wrapped-in-mainloop");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy<int> Connection::property_events_history_size() 
{
  return Glib::PropertyProxy<int>(this, "events-history-size");
}
#endif //GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
Glib::PropertyProxy_ReadOnly<int> Connection::property_events_history_size() const
{
  return Glib::PropertyProxy_ReadOnly<int>(this, "events-history-size");
}
#endif //GLIBMM_PROPERTIES_ENABLED


void Gnome::Gda::Connection::on_error(const Glib::RefPtr<ConnectionEvent>& error)
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->error)
    (*base->error)(gobj(),Glib::unwrap(error));
}
void Gnome::Gda::Connection::on_conn_opened()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->conn_opened)
    (*base->conn_opened)(gobj());
}
void Gnome::Gda::Connection::on_conn_to_close()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->conn_to_close)
    (*base->conn_to_close)(gobj());
}
void Gnome::Gda::Connection::on_conn_closed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->conn_closed)
    (*base->conn_closed)(gobj());
}
void Gnome::Gda::Connection::on_dsn_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->dsn_changed)
    (*base->dsn_changed)(gobj());
}
void Gnome::Gda::Connection::on_transaction_status_changed()
{
  BaseClassType *const base = static_cast<BaseClassType*>(
      g_type_class_peek_parent(G_OBJECT_GET_CLASS(gobject_)) // Get the parent class of the object class (The original underlying C class).
  );

  if(base && base->transaction_status_changed)
    (*base->transaction_status_changed)(gobj());
}


} // namespace Gda

} // namespace Gnome


