// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_XATRANSACTION_H
#define _LIBGDAMM_XATRANSACTION_H


#include <glibmm.h>

// -*- C++ -*- //

/* xatransaction.h
 *
 * Copyright 2006 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or(at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <libgdamm/connection.h>

#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaXaTransaction GdaXaTransaction;
typedef struct _GdaXaTransactionClass GdaXaTransactionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class XaTransaction_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

//TODO: Convert the full C documentation to here.
/** Distributed transaction manager.
  *
  * @ingroup Connections
  */

class XaTransaction : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef XaTransaction CppObjectType;
  typedef XaTransaction_Class CppClassType;
  typedef GdaXaTransaction BaseObjectType;
  typedef GdaXaTransactionClass BaseClassType;

private:  friend class XaTransaction_Class;
  static CppClassType xatransaction_class_;

private:
  // noncopyable
  XaTransaction(const XaTransaction&);
  XaTransaction& operator=(const XaTransaction&);

protected:
  explicit XaTransaction(const Glib::ConstructParams& construct_params);
  explicit XaTransaction(GdaXaTransaction* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~XaTransaction();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaXaTransaction*       gobj()       { return reinterpret_cast<GdaXaTransaction*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaXaTransaction* gobj() const { return reinterpret_cast<GdaXaTransaction*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaXaTransaction* gobj_copy();

private:

protected:
  explicit XaTransaction(guint32 format_id, const Glib::ustring& transaction_id);
public:
  
  static Glib::RefPtr<XaTransaction> create(guint32 format_id, const Glib::ustring& transaction_id);

  
  /** Registers @a cnc to be used by @a xa_trans to create a distributed transaction.
   * 
   * @note any Gda::Connection object can only be registered with at most one Gda::XaTransaction object; also
   * some connections may not be registered at all with a Gda::XaTransaction object because the database
   * provider being used does not support it.
   * @param cnc The connection to add to @a xa_trans.
   * @param branch The branch qualifier.
   * @return <tt>true</tt> if no error occurred.
   */
  bool register_connection(const Glib::RefPtr<Connection>& cnc, const Glib::ustring& branch);
  
  /** Unregisters @a cnc to be used by @a xa_trans to create a distributed transaction. This is
   * the opposite of register_connection().
   * @param cnc The connection to add to @a xa_trans.
   */
  void unregister_connection(const Glib::RefPtr<Connection>& cnc);

  
  /** Begins a distributed transaction (managed by @a xa_trans). Please note that this phase may fail
   * for some connections if a (normal) transaction is already started (this depends on the database
   * provider being used), so it's better to avoid starting any (normal) transaction on any of the
   * connections registered with @a xa_trans.
   * @return <tt>true</tt> if no error occurred.
   */
  bool begin();
  
  /** Cancels a distributed transaction (managed by @a xa_trans).
   * @return <tt>true</tt> if no error occurred.
   */
  bool rollback();

  typedef std::vector<Glib::RefPtr<const Connection> > ConnectionVector;

  
  /** Commits a distributed transaction (managed by @a xa_trans). The commit is composed of two phases:
   * <itemizedlist>
   * <listitem>a PREPARE phase where all the connections are required to store their transaction data to a 
   * permanent place (to be able to complete the commit should a problem occur afterwards)</listitem>
   * <listitem>a COMMIT phase where the transaction data is actually written to the database</listitem>
   * </itemizedlist>
   * 
   * If the PREPARE phase fails for any of the connection registered with @a xa_trans, then the distributed commit
   * fails and <tt>false</tt> is returned. During the COMMIT phase, some commit may actually fail but the transaction can
   * still be completed because the PREPARE phase succeeded (through the recover method).
   * @param cnc_to_recover A place to store the list of connections for which the commit phase failed, or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred (there may be some connections to recover, though).
   */
  
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool commit(ConnectionVector& cnc_to_recover);
  #else
  bool commit(ConnectionVector& cnc_to_recover, std::auto_ptr<Glib::Error>& error);
  #endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Tries to commit the data prepared but which failed to commit (see commit()). This
   * method allows one to terminate a distributed transaction which succeeded but for which some
   * connections needed to be recovered.
   * @param cnc_to_recover A place to store the list of connections for which the there were data to recover and which failed to be actually committed, or <tt>0</tt>.
   * @return <tt>true</tt> if all the data which was still uncommitted has been committed.
   */
  
  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool commit_recovered(ConnectionVector& cnc_to_recover);
  #else
  bool commit_recovered(ConnectionVector& cnc_to_recover, std::auto_ptr<Glib::Error>& error);
  #endif //GLIBMM_EXCEPTIONS_ENABLED
  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_transaction_id() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** 
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<guint> property_format_id() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::XaTransaction
   */
  Glib::RefPtr<Gnome::Gda::XaTransaction> wrap(GdaXaTransaction* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_XATRANSACTION_H */

