// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_ROW_H
#define _LIBGDAMM_ROW_H


#include <glibmm.h>

/* $Id: row.hg,v 1.10 2006/11/06 04:38:05 murrayc Exp $ */
// -*- C++ -*- //

/* row.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/value.h>
#include <glibmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaRow GdaRow;
typedef struct _GdaRowClass GdaRowClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class Row_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

/** Row for a Gda::DataModelArray object.
 *
 * The GdaDataModelArray object uses GdaRow to store each row of data. 
 * Each GdaRow has the same number of GValue values (equal to the number of 
 * columns of the data model).
 * 
 * As a side note, the GdaRow object is also used internally by the implementation
 * of the data models returned when executing a SELECT statement.
 * 
 * @ingroup DataHandlers
 */

class Row : public Glib::Object
{
protected:
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Row CppObjectType;
  typedef Row_Class CppClassType;
  typedef GdaRow BaseObjectType;
  typedef GdaRowClass BaseClassType;

private:  friend class Row_Class;
  static CppClassType row_class_;

private:
  // noncopyable
  Row(const Row&);
  Row& operator=(const Row&);

protected:
  explicit Row(const Glib::ConstructParams& construct_params);
  explicit Row(GdaRow* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Row();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaRow*       gobj()       { return reinterpret_cast<GdaRow*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaRow* gobj() const { return reinterpret_cast<GdaRow*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaRow* gobj_copy();

private:


  explicit Row(int count);

public:
  // Docs say this is mainly for providers
  
  
  static Glib::RefPtr<Row> create(int count);


  /** Gets a pointer to a Value stored in a Gda::Row.
   * 
   * This is a pointer to the internal array of values. Don't try to free
   * or modify it (modifying is reserved to database provider's implementations).
   * @param num Field index.
   * @return A pointer to the Value in the position @a num of @a row.
   */
  Value get_value(int num);
  
  /** 
   * @return The number of columns that the @a row has.
   */
  int get_length();


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::Row
   */
  Glib::RefPtr<Gnome::Gda::Row> wrap(GdaRow* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_ROW_H */

