// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_CONNECTION_H
#define _LIBGDAMM_CONNECTION_H


#include <glibmm.h>

/* $Id: connection.hg,v 1.35 2006/11/30 06:58:55 murrayc Exp $ */
// -*- C++ -*- // 

/* connection.h
 * 
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <libgdamm/transactionstatus.h>
#include <libgdamm/connectionevent.h>
#include <libgdamm/datamodel.h>
#include <libgdamm/statement.h>
#include <libgdamm/sqlparser.h>
#include <libgdamm/serveroperation.h>
#include <libgdamm/value.h>

#include <libgda/gda-meta-store.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaConnection GdaConnection;
typedef struct _GdaConnectionClass GdaConnectionClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class Connection_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

class ServerProvider;
class MetaStore;
typedef GdaServerProviderInfo ServerProviderInfo;

/** Exception class for Gda connection errors.
 */
class ConnectionError : public Glib::Error
{
public:
  enum Code
  {
    CONNECTION_DSN_NOT_FOUND_ERROR,
    CONNECTION_PROVIDER_NOT_FOUND_ERROR,
    CONNECTION_PROVIDER_ERROR,
    CONNECTION_CONN_OPEN_ERROR,
    CONNECTION_DO_QUERY_ERROR,
    CONNECTION_NONEXIST_DSN_ERROR,
    CONNECTION_NO_CNC_SPEC_ERROR,
    CONNECTION_NO_PROVIDER_SPEC_ERROR,
    CONNECTION_OPEN_ERROR,
    CONNECTION_EXECUTE_COMMAND_ERROR,
    CONNECTION_STATEMENT_TYPE_ERROR
  };

  ConnectionError(Code error_code, const Glib::ustring& error_message);
  explicit ConnectionError(GError* gobject);
  Code code() const;

#ifndef DOXYGEN_SHOULD_SKIP_THIS
private:

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static void throw_func(GError* gobject);
#else
  //When not using exceptions, we just pass the Exception object around without throwing it:
  static std::auto_ptr<Glib::Error> throw_func(GError* gobject);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  friend void wrap_init(); // uses throw_func()
#endif
};

} // namespace Gda

} // namespace Gnome

#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ConnectionError::Code> : public Glib::Value_Enum<Gnome::Gda::ConnectionError::Code>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


/** @addtogroup libgdammEnums Enums and Flags */

/**
 * @ingroup libgdammEnums
 */
enum ConnectionFeature
{
  CONNECTION_FEATURE_AGGREGATES,
  CONNECTION_FEATURE_BLOBS,
  CONNECTION_FEATURE_INDEXES,
  CONNECTION_FEATURE_INHERITANCE,
  CONNECTION_FEATURE_NAMESPACES,
  CONNECTION_FEATURE_PROCEDURES,
  CONNECTION_FEATURE_SEQUENCES,
  CONNECTION_FEATURE_SQL,
  CONNECTION_FEATURE_TRANSACTIONS,
  CONNECTION_FEATURE_SAVEPOINTS,
  CONNECTION_FEATURE_SAVEPOINTS_REMOVE,
  CONNECTION_FEATURE_TRIGGERS,
  CONNECTION_FEATURE_UPDATABLE_CURSOR,
  CONNECTION_FEATURE_USERS,
  CONNECTION_FEATURE_VIEWS,
  CONNECTION_FEATURE_XA_TRANSACTIONS,
  CONNECTION_FEATURE_LAST
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ConnectionFeature> : public Glib::Value_Enum<Gnome::Gda::ConnectionFeature>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/**
 * @ingroup libgdammEnums
 */
enum ConnectionSchema
{
  CONNECTION_SCHEMA_AGGREGATES,
  CONNECTION_SCHEMA_DATABASES,
  CONNECTION_SCHEMA_FIELDS,
  CONNECTION_SCHEMA_INDEXES,
  CONNECTION_SCHEMA_LANGUAGES,
  CONNECTION_SCHEMA_NAMESPACES,
  CONNECTION_SCHEMA_PARENT_TABLES,
  CONNECTION_SCHEMA_PROCEDURES,
  CONNECTION_SCHEMA_SEQUENCES,
  CONNECTION_SCHEMA_TABLES,
  CONNECTION_SCHEMA_TRIGGERS,
  CONNECTION_SCHEMA_TYPES,
  CONNECTION_SCHEMA_USERS,
  CONNECTION_SCHEMA_VIEWS,
  CONNECTION_SCHEMA_CONSTRAINTS,
  CONNECTION_SCHEMA_TABLE_CONTENTS
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ConnectionSchema> : public Glib::Value_Enum<Gnome::Gda::ConnectionSchema>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/**
 * @ingroup libgdammEnums
 * @par Bitwise operators:
 * <tt>%ConnectionOptions operator|(ConnectionOptions, ConnectionOptions)</tt><br>
 * <tt>%ConnectionOptions operator&(ConnectionOptions, ConnectionOptions)</tt><br>
 * <tt>%ConnectionOptions operator^(ConnectionOptions, ConnectionOptions)</tt><br>
 * <tt>%ConnectionOptions operator~(ConnectionOptions)</tt><br>
 * <tt>%ConnectionOptions& operator|=(ConnectionOptions&, ConnectionOptions)</tt><br>
 * <tt>%ConnectionOptions& operator&=(ConnectionOptions&, ConnectionOptions)</tt><br>
 * <tt>%ConnectionOptions& operator^=(ConnectionOptions&, ConnectionOptions)</tt><br>
 */
enum ConnectionOptions
{
  CONNECTION_OPTIONS_NONE = 0,
  CONNECTION_OPTIONS_READ_ONLY = 1 << 0
};

/** @ingroup libgdammEnums */
inline ConnectionOptions operator|(ConnectionOptions lhs, ConnectionOptions rhs)
  { return static_cast<ConnectionOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline ConnectionOptions operator&(ConnectionOptions lhs, ConnectionOptions rhs)
  { return static_cast<ConnectionOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline ConnectionOptions operator^(ConnectionOptions lhs, ConnectionOptions rhs)
  { return static_cast<ConnectionOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs)); }

/** @ingroup libgdammEnums */
inline ConnectionOptions operator~(ConnectionOptions flags)
  { return static_cast<ConnectionOptions>(~static_cast<unsigned>(flags)); }

/** @ingroup libgdammEnums */
inline ConnectionOptions& operator|=(ConnectionOptions& lhs, ConnectionOptions rhs)
  { return (lhs = static_cast<ConnectionOptions>(static_cast<unsigned>(lhs) | static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline ConnectionOptions& operator&=(ConnectionOptions& lhs, ConnectionOptions rhs)
  { return (lhs = static_cast<ConnectionOptions>(static_cast<unsigned>(lhs) & static_cast<unsigned>(rhs))); }

/** @ingroup libgdammEnums */
inline ConnectionOptions& operator^=(ConnectionOptions& lhs, ConnectionOptions rhs)
  { return (lhs = static_cast<ConnectionOptions>(static_cast<unsigned>(lhs) ^ static_cast<unsigned>(rhs))); }

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ConnectionOptions> : public Glib::Value_Flags<Gnome::Gda::ConnectionOptions>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{

/**
 * @ingroup libgdammEnums
 */
enum ConnectionMetaType
{
  CONNECTION_META_NAMESPACES,
  CONNECTION_META_TYPES,
  CONNECTION_META_TABLES,
  CONNECTION_META_VIEWS,
  CONNECTION_META_FIELDS
};

} // namespace Gda

} // namespace Gnome


#ifndef DOXYGEN_SHOULD_SKIP_THIS
namespace Glib
{

template <>
class Value<Gnome::Gda::ConnectionMetaType> : public Glib::Value_Enum<Gnome::Gda::ConnectionMetaType>
{
public:
  static GType value_type() G_GNUC_CONST;
};

} // namespace Glib
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{


/** Manages a connection to a data source.
 * This class offers access to all operations involving an opened connection to a database. 
 * Connection objects are obtained via the Client class.
 * 
 * Once obtained, applications can use a Connection to execute commands, run transactions, and get information about all 
 * objects stored in the underlying database.
 *
 * @ingroup Connections
 */

class Connection : public Glib::Object
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Connection CppObjectType;
  typedef Connection_Class CppClassType;
  typedef GdaConnection BaseObjectType;
  typedef GdaConnectionClass BaseClassType;

private:  friend class Connection_Class;
  static CppClassType connection_class_;

private:
  // noncopyable
  Connection(const Connection&);
  Connection& operator=(const Connection&);

protected:
  explicit Connection(const Glib::ConstructParams& construct_params);
  explicit Connection(GdaConnection* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Connection();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaConnection*       gobj()       { return reinterpret_cast<GdaConnection*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaConnection* gobj() const { return reinterpret_cast<GdaConnection*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaConnection* gobj_copy();

private:

protected:

  Connection();
  

public:
  
  static Glib::RefPtr<Connection> create();


  /* This throws an error which we don't want to do in a constructor */
  
  /** Opens a connection given a provider ID and a connection string. This
   * allows applications to open connections without having to create
   * a data source (DSN) in the configuration. The format of @a cnc_string is
   * similar to PostgreSQL and MySQL connection strings. It is a semicolumn-separated
   * series of &lt;key&gt;=&lt;value&gt; pairs, where each key and value are encoded as per RFC 1738, 
   * see gda_rfc1738_encode() for more information.
   * 
   * The possible keys depend on the provider, the "gda-sql-4.0 -L" command
   * can be used to list the actual keys for each installed database provider.
   * 
   * For example the connection string to open an SQLite connection to a database
   * file named "my_data.db" in the current directory would be &lt;constant&gt;"DB_DIR=.;DB_NAME=my_data"&lt;/constant&gt;.
   * 
   * The @a cnc_string string must have the following format: 
   * "[&lt;provider&gt;://][&lt;username&gt;[:&lt;password&gt;]@]&lt;connection_params&gt;"
   * (if &lt;username&gt; and/or &lt;password&gt; are provided, and @a auth_string is <tt>0</tt>, then these username
   * and passwords will be used, and if &lt;provider&gt; is provided and @a provider_name is <tt>0</tt> then this
   * provider will be used). Note that if provided, &lt;username&gt;, &lt;password&gt; and  &lt;provider&gt;
   * must be encoded as per RFC 1738, see gda_rfc1738_encode() for more information.
   * 
   * The @a auth_string must contain the authentication information for the server
   * to accept the connection. It is a string containing semi-colon seperated named values, usually 
   * like "USERNAME=...;PASSWORD=..." where the ... are replaced by actual values. Note that each
   * name and value must be encoded as per RFC 1738, see gda_rfc1738_encode() for more information.
   * 
   * The actual named parameters required depend on the provider being used, and that list is available
   * as the &lt;parameter&gt;auth_params&lt;/parameter&gt; member of the Gda::ProviderInfo structure for each installed
   * provider (use Gda::Config::get_provider_info() to get it). Similarly to the format of the connection
   * string, use the "gda-sql-4.0 -L" command to list the possible named parameters.
   * 
   * Additionally, it is possible to have the connection string
   * respect the "&lt;provider_name&gt;://&lt;real cnc string&gt;" format, in which case the provider name
   * and the real connection string will be extracted from that string (note that if @a provider_name
   * is not <tt>0</tt> then it will still be used as the provider ID).
   * @param provider_name Provider ID to connect to, or <tt>0</tt>.
   * @param cnc_string Connection string.
   * @param auth_string Authentication string, or <tt>0</tt>.
   * @param options Options for the connection (see Gda::ConnectionOptions).
   * @return A new Gda::Connection if connection opening was sucessfull or <tt>0</tt> if there was an error.
   */

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  static Glib::RefPtr<Connection> open_from_string (const Glib::ustring& provider_name,
                                                    const Glib::ustring& cnc_string,
                                                    const Glib::ustring& auth_string,
                                                    ConnectionOptions options);
#else
  static Glib::RefPtr<Connection> open_from_string (const Glib::ustring& provider_name,
                                                    const Glib::ustring& cnc_string,
                                                    const Glib::ustring& auth_string,
                                                    ConnectionOptions options,
                                                    std::auto_ptr<Glib::Error>& error);
#endif

  
  /** Tries to open the connection.
   * @return <tt>true</tt> if the connection is opened, and <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool open();
#else
  bool open(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Closes the connection to the underlying data source, but first emits the "conn_to_close" signal.
   */
  void close();
  

  /** Checks whether a connection is open or not.
   * @return <tt>true</tt> if the connection is open, <tt>false</tt> if it's not.
   */
  bool is_opened() const;

  
  /** Gets the Gda::ConnectionOptions used to open this connection.
   * @return The connection options.
   */
  ConnectionOptions get_options() const;

  
  /** 
   * @return The data source name the connection object is connected
   * to.
   */
  Glib::ustring get_dsn() const;
  
  /** Gets the connection string used to open this connection.
   * 
   * The connection string is the string sent over to the underlying
   * database provider, which describes the parameters to be used
   * to open a connection on the underlying data source.
   * @return The connection string used when opening the connection.
   */
  Glib::ustring get_cnc_string() const;

  
  /** Adds an event to the given connection. This function is usually
   * called by providers, to inform clients of events that happened
   * during some operation.
   * 
   * As soon as a provider (or a client, it does not matter) calls this
   * function with an @a event object which is an error,
   * the connection object emits the "error" signal, to which clients can connect to be
   * informed of events.
   * 
   * WARNING: the reference to the @a event object is stolen by this function!
   * @param event Is stored internally, so you don't need to unref it.
   */
  void add_event(const Glib::RefPtr<ConnectionEvent>& event);
  
  /** Adds a new error to the given connection object. This is just a convenience
   * function that simply creates a Gda::ConnectionEvent and then calls
   * #gda_server_connection_add_error.
   * @param str A format string (see the printf(3) documentation).
   * @param Varargs The arguments to insert in the error message.
   * @return A new Gda::ConnectionEvent object, however the caller does not hold a reference to the returned
   * object, and if need be the caller must call Glib::object_ref() on it.
   */
  Glib::RefPtr<ConnectionEvent> add_event_string(const Glib::ustring& str);

  
  /** This function lets you clear the list of Gda::ConnectionEvent's of the
   * given connection.
   */
  void clear_events_list();

  
  /** Executes @a stmt. 
   * 
   * As @a stmt can, by desing (and if not abused), contain only one SQL statement, the
   * return object will either be:
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt;a Gda::DataSelect object (which is also a Gda::DataModel) if @a stmt is a SELECT statement 
   * (usually a GDA_SQL_STATEMENT_SELECT, see Gda::SqlStatementType)
   * containing the results of the SELECT. The resulting data model is by default read only, but
   * modifications can be enabled, see the Gda::DataSelect's documentation for more information.&lt;/listitem&gt;
   * &lt;listitem&gt;a Gda::Set for any other SQL statement which correctly executed. In this case
   * (if the provider supports it), then the Gda::Set may contain value holders named:
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt;a (<tt>int</tt>) Gda::Holder named "IMPACTED_ROWS"&lt;/listitem&gt;
   * &lt;listitem&gt;a (GObject) Gda::Holder named "EVENT" which contains a Gda::ConnectionEvent&lt;/listitem&gt;
   * &lt;/itemizedlist&gt;&lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * 
   * If @a last_insert_row is not <tt>0</tt> and @a stmt is an INSERT statement, then it will contain (if the
   * provider used by @a cnc supports it) a new Gda::Set object composed of value holders named "+&lt;column number&gt;"
   * starting at column 0 which contain the actual inserted values. For example if a table is composed of an 'id' column
   * which is auto incremented and a 'name' column then the execution of a "INSERT INTO mytable (name) VALUES ('joe')"
   * query will return a Gda::Set with two holders:
   * &lt;itemizedlist&gt;
   * &lt;listitem&gt;one with the '+0' ID which may for example contain 1 (note that its "name" property should be "id")&lt;/listitem&gt;
   * &lt;listitem&gt;one with the '+1' ID which will contain 'joe' (note that its "name" property should be "name")&lt;/listitem&gt;
   * &lt;/itemizedlist&gt;
   * 
   * @note If @a stmt is a SELECT statement which has some parameters and  if @params is <tt>0</tt>, then the statement can't
   * be executed and this method will return <tt>0</tt>.
   * 
   * @note If @a stmt is a SELECT statement which has some parameters and  if @params is not <tt>0</tt> but contains some
   * invalid parameters, then the statement can't be executed and this method will return <tt>0</tt>, unless the
   *  @a model_usage has the GDA_STATEMENT_MODEL_ALLOW_NOPARAM flag.
   * 
   * @note If @a stmt is a SELECT statement which has some parameters and  if @params is not <tt>0</tt> but contains some
   * invalid parameters and if @a model_usage has the GDA_STATEMENT_MODEL_ALLOW_NOPARAM flag, then the returned
   * data model will contain no row but will have all the correct columns (even though some of the columns might
   * report as GDA_TYPE_<tt>0</tt>). In this case, if (after this method call) any of @params' parameters change
   * then the resulting data model will re-run itself, see the GdaDataSelect's 
   * auto-reset property for more information.
   * 
   * @note if @a model_usage does not contain the GDA_STATEMENT_MODEL_RANDOM_ACCESS or GDA_STATEMENT_MODEL_CURSOR_FORWARD
   * flags, then the default will be to return a random access data model
   * 
   * Also see the provider's limitations, and the
   * Advanced GdaDataSelect usage sections.
   * @param stmt A Gda::Statement object.
   * @param params A Gda::Set object (which can be obtained using Gda::Statement::get_parameters()), or <tt>0</tt>.
   * @param model_usage In the case where @a stmt is a SELECT statement, specifies how the returned data model will be used.
   * @param last_insert_row A place to store a new Gda::Set object which contains the values of the last inserted row, or <tt>0</tt>.
   * @return A Object, or <tt>0</tt> if an error occurred.
   */

#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<Glib::Object> statement_execute(const Glib::RefPtr<Statement>& stmt, const Glib::RefPtr<Set>& params, StatementModelUsage model_usage, Glib::RefPtr<Set>& last_insert_row);
#else
  Glib::RefPtr<Glib::Object> statement_execute(const Glib::RefPtr<Statement>& stmt, const Glib::RefPtr<Set>& params, StatementModelUsage model_usage, Glib::RefPtr<Set>& last_insert_row, std::auto_ptr<Glib::Error>& error);
#endif // GLIBMM_EXCEPTIONS_ENABLED

  
  /** Executes a selection command on the given connection. The gda_execute_select_command() method can be easier
   * to use if one prefers to use some SQL directly.
   * 
   * This function returns a Gda::DataModel resulting from the SELECT statement, or <tt>0</tt>
   * if an error occurred.
   * 
   * This function is just a convenience function around the statement_execute()
   * function.
   * 
   * See the documentation of the statement_execute() for information
   * about the @params list of parameters.
   * @param stmt A Gda::Statement object.
   * @param params A Gda::Set object (which can be obtained using Gda::Statement::get_parameters()), or <tt>0</tt>.
   * @return A Gda::DataModel containing the data returned by the
   * data source, or <tt>0</tt> if an error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<DataModel> statement_execute_select(const Glib::RefPtr<Statement>& stmt, const Glib::RefPtr<Set>& params);
#else
  Glib::RefPtr<DataModel> statement_execute_select(const Glib::RefPtr<Statement>& stmt, const Glib::RefPtr<Set>& params, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Executes a selection command on the given connection.
   * 
   * This function returns a Gda::DataModel resulting from the SELECT statement, or <tt>0</tt>
   * if an error occurred.
   * 
   * This function is just a convenience function around the statement_execute()
   * function.
   * 
   * See the documentation of the statement_execute() for information
   * about the @params list of parameters.
   * @param stmt A Gda::Statement object.
   * @param params A Gda::Set object (which can be obtained using Gda::Statement::get_parameters()), or <tt>0</tt>.
   * @param model_usage Specifies how the returned data model will be used as a Gda::StatementModelUsage enum.
   * @param col_types An array of GType to request each returned Gda::DataModel's column's GType, terminated with the G_TYPE_NONE
   * value. Any value left to 0 will make the database provider determine the real GType. @a col_types can also be <tt>0</tt> if no
   * column type is specified.
   * @return A Gda::DataModel containing the data returned by the
   * data source, or <tt>0</tt> if an error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<DataModel> statement_execute_select_full(const Glib::RefPtr<Statement>& stmt, const Glib::RefPtr<Set>& params, StatementModelUsage model_usage, const Glib::ArrayHandle<GType>& col_types);
#else
  Glib::RefPtr<DataModel> statement_execute_select_full(const Glib::RefPtr<Statement>& stmt, const Glib::RefPtr<Set>& params, StatementModelUsage model_usage, const Glib::ArrayHandle<GType>& col_types, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Executes a non-selection statement on the given connection. The gda_execute_non_select_command() method can be easier
   * to use if one prefers to use some SQL directly.
   * 
   * This function returns the number of rows affected by the execution of @a stmt, or -1
   * if an error occurred, or -2 if the connection's provider does not return the number of rows affected.
   * 
   * This function is just a convenience function around the statement_execute()
   * function. 
   * See the documentation of the statement_execute() for information
   * about the @params list of parameters.
   * 
   * See statement_execute() form more information about @a last_insert_row.
   * @param stmt A Gda::Statement object.
   * @param params A Gda::Set object (which can be obtained using Gda::Statement::get_parameters()), or <tt>0</tt>.
   * @param last_insert_row A place to store a new Gda::Set object which contains the values of the last inserted row, or <tt>0</tt>.
   * @return The number of rows affected (&gt;=0) or -1 or -2.
   */
;
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  int statement_execute_non_select(const Glib::RefPtr<Statement>& stmt, const Glib::RefPtr<Set>& params, Glib::RefPtr<Set>& last_insert_row);
#else
  int statement_execute_non_select(const Glib::RefPtr<Statement>& stmt, const Glib::RefPtr<Set>& params, Glib::RefPtr<Set>& last_insert_row, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED  

  //Note that we do not add a non-const version of this because the documentation says that it should not be modified:
  
  /** Get the status of @a cnc regarding transactions. The returned object should not be modified
   * or destroyed; however it may be modified or destroyed by the connection itself.
   * 
   * If <tt>0</tt> is returned, then no transaction has been associated with @a cnc
   * @return A Gda::TransactionStatus object, or <tt>0</tt>.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<const TransactionStatus> get_transaction_status() const;
#else
  Glib::RefPtr<const TransactionStatus> get_transaction_status(std::auto_ptr<Glib::Error>& error) const;
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Starts a transaction on the data source, identified by the
   *  @a name parameter.
   * 
   * Before starting a transaction, you can check whether the underlying
   * provider does support transactions or not by using the
   * supports_feature() function.
   * @param name The name of the transation to start, or <tt>0</tt>.
   * @return <tt>true</tt> if the transaction was started successfully, <tt>false</tt>
   * otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool begin_transaction(const Glib::ustring& name, TransactionIsolation level);
#else
  bool begin_transaction(const Glib::ustring& name, TransactionIsolation level, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Commits the given transaction to the backend database. You need to call
   * begin_transaction() first.
   * @param name The name of the transation to commit, or <tt>0</tt>.
   * @return <tt>true</tt> if the transaction was finished successfully,
   * <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool commit_transaction(const Glib::ustring& name);
#else
  bool commit_transaction(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Rollbacks the given transaction. This means that all changes
   * made to the underlying data source since the last call to
   * #begin_transaction() or #commit_transaction()
   * will be discarded.
   * @param name The name of the transation to commit, or <tt>0</tt>.
   * @return <tt>true</tt> if the operation was successful, <tt>false</tt> otherwise.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool rollback_transaction(const Glib::ustring& name);
#else
  bool rollback_transaction(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Adds a SAVEPOINT named @a name.
   * @param name Name of the savepoint to add.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool add_savepoint(const Glib::ustring& name);
#else
  bool add_savepoint(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Rollback all the modifications made after the SAVEPOINT named @a name.
   * @param name Name of the savepoint to rollback to.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool rollback_savepoint(const Glib::ustring& name);
#else
  bool rollback_savepoint(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Delete the SAVEPOINT named @a name when not used anymore.
   * @param name Name of the savepoint to delete.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool delete_savepoint(const Glib::ustring& name);
#else
  bool delete_savepoint(const Glib::ustring& name, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


   //Use a special conversion here, because we should not own any part of the returned GList, 
   //according to the documentation for gda_connection_get_events(), 
   //and because we need to unconst the GList.:
    

  /** Retrieves a list of the last errors occurred during the connection. The returned list is
   * chronologically ordered such as that the most recent event is the Gda::ConnectionEvent of the first node.
   * 
   * Warning: the @a cnc object may change the list if connection events occur
   * @return A GList of Gda::ConnectionEvent objects (the list should not be modified).
   */
  Glib::ListHandle< Glib::RefPtr<ConnectionEvent> > get_events();
  
  /** Retrieves a list of the last errors occurred during the connection. The returned list is
   * chronologically ordered such as that the most recent event is the Gda::ConnectionEvent of the first node.
   * 
   * Warning: the @a cnc object may change the list if connection events occur
   * @return A GList of Gda::ConnectionEvent objects (the list should not be modified).
   */
  Glib::ListHandle< Glib::RefPtr<const ConnectionEvent> > get_events() const;


  /** Produces a fully quoted and escaped string from a GValue
   * @param from Value to convert from.
   * @return Escaped and quoted value or <tt>0</tt> if not supported.
   */
  Glib::ustring value_to_sql_string(const Value& from) const;

  
  /** Asks the underlying provider for if a specific feature is supported.
   * @param feature Feature to ask for.
   * @return <tt>true</tt> if the provider supports it, <tt>false</tt> if not.
   */
  bool supports_feature(ConnectionFeature feature) const;
      
  
  /** Gets the user name used to open this connection.
   * @return The user name.
   */
  Glib::ustring get_authentication() const;
  
  /** Creates a new parser object able to parse the SQL dialect understood by @a cnc. 
   * If the Gda::ServerProvider object internally used by @a cnc does not have its own parser, 
   * then <tt>0</tt> is returned, and a general SQL parser can be obtained
   * using Gda::SqlParser::new().
   * @return A new Gda::SqlParser object, or <tt>0</tt>.
   */
  Glib::RefPtr<SqlParser> create_parser();

  
  /** Get the name (identifier) of the database provider used by @a cnc
   * @return A non modifiable string.
   */
  Glib::ustring get_provider_name() const;
  
  /** Updates @a cnc's associated Gda::MetaStore. If @a context is not <tt>0</tt>, then only the parts described by
   *  @a context will be updated, and if it is <tt>0</tt>, then the complete meta store will be updated.
   * @param context Description of which part of @a cnc's associated Gda::MetaStore should be updated, or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool update_meta_store (GdaMetaContext* context);
#else
  bool update_meta_store(GdaMetaContext* context, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Ask the database accessed through the @a cnc connection to prepare the usage of @a stmt. This is only usefull
   * if @a stmt will be used more than once (however some database providers may always prepare stamements 
   * before executing them).
   * 
   * This function is also usefull to make sure @a stmt is fully understood by the database before actually executing it.
   * 
   * Note however that it is also possible that statement_prepare() fails when
   * statement_execute() does not fail (this will usually be the case with statements such as
   * &lt;![CDATA["SELECT * FROM ##tablename::string"]]&gt; because database usually don't allow variables to be used in place of a 
   * table name).
   * @param stmt A Gda::Statement object.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool statement_prepare (const Glib::RefPtr<Statement>& stmt);
#else
  bool statement_prepare(const Glib::RefPtr<Statement>& stmt, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** see #gda_connection_get_meta_store_data
   * @param meta_type Describes which data to get.
   * @param filters A GList of GdaHolders.
   * @return A Gda::DataModel containing the data required. The caller is responsible
   * for freeing the returned model using Glib::object_unref().
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<DataModel> get_meta_store_data(ConnectionMetaType meta_type, const Glib::ListHandle< Glib::RefPtr<Holder> >& filters);
#else
  Glib::RefPtr<DataModel> get_meta_store_data(ConnectionMetaType meta_type, const Glib::ListHandle< Glib::RefPtr<Holder> >& filters, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Get or initializes the Gda::MetaStore associated to @a cnc
   * @return A Gda::MetaStore object.
   */
  Glib::RefPtr<MetaStore> get_meta_store();;

   
  /** Executes all the statements contained in @a batch (in the order in which they were added to @a batch), and
   * Returns: a list of Object objects
   * @param batch A Gda::Batch object which contains all the statements to execute.
   * @param params A Gda::Set object (which can be obtained using Gda::Batch::get_parameters()), or <tt>0</tt>.
   * @param model_usage Specifies how the returned data model(s) will be used, as a Gda::StatementModelUsage enum.
   * @return A list of Object objects.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::SListHandle< Glib::RefPtr<Glib::Object> > batch_execute(const Glib::RefPtr<Batch>& batch, const Glib::RefPtr<Set>& params, StatementModelUsage model_usage);
#else
  Glib::SListHandle< Glib::RefPtr<Glib::Object> > batch_execute(const Glib::RefPtr<Batch>& batch, const Glib::RefPtr<Set>& params, StatementModelUsage model_usage, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Creates a new Gda::ServerOperation object which can be modified in order 
   * to perform the type type of action. It is a wrapper around the Gda::ServerProvider::create_operation()
   * method.
   * @param type The type of operation requested.
   * @param options An optional list of parameters.
   * @return A new Gda::ServerOperation object, or <tt>0</tt> in the connection's provider does not support the @a type type
   * of operation or if an error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::RefPtr<ServerOperation> create_operation (ServerOperationType type, const Glib::RefPtr<Set>& options);
#else
  Glib::RefPtr<ServerOperation> create_operation(ServerOperationType type, const Glib::RefPtr<Set>& options, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Performs the operation described by @a op (which should have been created using
   * create_operation()). It is a wrapper around the Gda::ServerProvider::perform_operation()
   * method.
   * @param op A Gda::ServerOperation object.
   * @return <tt>true</tt> if no error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool perform_operation (const Glib::RefPtr<ServerOperation>& op);
#else
  bool perform_operation(const Glib::RefPtr<ServerOperation>& op, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** Get a pointer to the Gda::ServerProvider object used to access the database
   * @return The Gda::ServerProvider (NEVER <tt>0</tt>).
   */
  Glib::RefPtr<ServerProvider> get_provider();
   
  
  /** Renders @a stmt as an SQL statement, adapted to the SQL dialect used by @a cnc
   * @param stmt A Gda::Statement object.
   * @param params A Gda::Set object (which can be obtained using Gda::Statement::get_parameters()), or <tt>0</tt>.
   * @param flags SQL rendering flags, as Gda::StatementSqlFlag OR'ed values.
   * @param params_used A place to store the list of individual Gda::Holder objects within @params which have been used.
   * @return A new string, or <tt>0</tt> if an error occurred.
   */

  #ifdef GLIBMM_EXCEPTIONS_ENABLED
  Glib::ustring statement_to_sql(const Glib::RefPtr<Statement>& stmt, const Glib::RefPtr<Set>& params, StatementSqlFlag flags, std::list< Glib::RefPtr<Holder> >& params_used);
  #else
  Glib::ustring statement_to_sql(const Glib::RefPtr<Statement>& stmt, const Glib::RefPtr<Set>& params, StatementSqlFlag flags, std::list< Glib::RefPtr<Holder> >& params_used, std::auto_ptr<Glib::Error>& error);
  #endif //GLIBMM_EXCEPTIONS_ENABLED
    

  /**
   * @par Prototype:
   * <tt>void on_my_%error(const Glib::RefPtr<ConnectionEvent>& error)</tt>
   */

  Glib::SignalProxy1< void,const Glib::RefPtr<ConnectionEvent>& > signal_error();


  /**
   * @par Prototype:
   * <tt>void on_my_%conn_opened()</tt>
   */

  Glib::SignalProxy0< void > signal_conn_opened();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%conn_to_close()</tt>
   */

  Glib::SignalProxy0< void > signal_conn_to_close();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%conn_closed()</tt>
   */

  Glib::SignalProxy0< void > signal_conn_closed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%dsn_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_dsn_changed();

  
  /**
   * @par Prototype:
   * <tt>void on_my_%transaction_status_changed()</tt>
   */

  Glib::SignalProxy0< void > signal_transaction_status_changed();


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Authentication string to use.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_auth_string() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Authentication string to use.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_auth_string() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Connection string to use.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_cnc_string() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Connection string to use.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_cnc_string() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** DSN to use.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<Glib::ustring> property_dsn() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** DSN to use.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<Glib::ustring> property_dsn() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** GdaMetaStore used by the connection.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::RefPtr<MetaStore> > property_meta_store() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** GdaMetaStore used by the connection.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::RefPtr<MetaStore> > property_meta_store() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Options (connection sharing).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy<ConnectionOptions> property_options() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Options (connection sharing).
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly<ConnectionOptions> property_options() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
  virtual void on_error(const Glib::RefPtr<ConnectionEvent>& error);
  virtual void on_conn_opened();
  virtual void on_conn_to_close();
  virtual void on_conn_closed();
  virtual void on_dsn_changed();
  virtual void on_transaction_status_changed();
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::Connection
   */
  Glib::RefPtr<Gnome::Gda::Connection> wrap(GdaConnection* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_CONNECTION_H */

