// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _LIBGDAMM_ROW_H
#define _LIBGDAMM_ROW_H


#include <glibmm.h>

/* $Id: row.hg,v 1.10 2006/11/06 04:38:05 murrayc Exp $ */
// -*- C++ -*- // this is for the .hg, I realize gensig puts one in

/* row.h
 *
 * Copyright 2003 libgdamm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


#include <libgdamm/value.h>
#include <glibmm/object.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdaRow GdaRow;
typedef struct _GdaRowClass GdaRowClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gnome
{

namespace Gda
{ class Row_Class; } // namespace Gda

} // namespace Gnome
namespace Gnome
{

namespace Gda
{

class DataModel;
class Value;

//TODO:

class Row : public Glib::Object
{
protected:
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef Row CppObjectType;
  typedef Row_Class CppClassType;
  typedef GdaRow BaseObjectType;
  typedef GdaRowClass BaseClassType;

private:  friend class Row_Class;
  static CppClassType row_class_;

private:
  // noncopyable
  Row(const Row&);
  Row& operator=(const Row&);

protected:
  explicit Row(const Glib::ConstructParams& construct_params);
  explicit Row(GdaRow* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~Row();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GdaRow*       gobj()       { return reinterpret_cast<GdaRow*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GdaRow* gobj() const { return reinterpret_cast<GdaRow*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GdaRow* gobj_copy();

private:


  explicit Row(const Glib::RefPtr<DataModel>& model, int count);

//TODO: Use C++ type:
  explicit Row(const Glib::RefPtr<DataModel>& model, const GList *values);

public:
  
  /** Copy constructor.
   * @return A new Gda::Row.
   */
  Glib::RefPtr<Row> copy() const;
  
  
  static Glib::RefPtr<Row> create(const Glib::RefPtr<DataModel>& model, int count);

  
  static Glib::RefPtr<Row> create(const Glib::RefPtr<DataModel>& model, const GList * values);


  /** Gets the number of the given row, that is, its position in its containing
   * data model.
   * @return The row number, or -1 if there was an error.
   */
  int get_number() const;
  
  /** Sets the row number for the given row.
   * @param number The new row number.
   */
  void set_number(int number);
  
  /** Returns: the unique identifier for this row.
   * @return The unique identifier for this row.
   */
  Glib::ustring get_id() const;
  
  /** Assigns a new identifier to the given row. This function is
   * usually called by providers.
   * @param id New identifier for the row.
   */
  void set_id(const Glib::ustring& id);

  Value get_value(int num) const;
  

  /** Sets the value stored at position @a num in @a row to be a copy of
   *  @a value.
   * @param num Field index.
   * @param value A Value to insert into @a row at the @a num position, or <tt>0</tt>.
   * @return <tt>true</tt> if no error occurred.
   */
  bool set_value(int num, const Value& value);

  
  /** Gets the Gda::DataModel the given Gda::Row belongs to.
   * @return A Gda::DataModel.
   */
  Glib::RefPtr<DataModel> get_model();  
  
  /** Gets the Gda::DataModel the given Gda::Row belongs to.
   * @return A Gda::DataModel.
   */
  Glib::RefPtr<const DataModel> get_model() const; 

  
  /** Set the Gda::DataModel the given Gda::Row belongs to. Note that calling
   * this method should be reserved to GdaDataModel implementations and should
   * therefore not be called by the user.
   * @param model A Gda::DataModel this row belongs to, or <tt>0</tt> if the row is outside any data model.
   */
  void set_model(const Glib::RefPtr<DataModel>& model);

  
  /** 
   * @return The number of columns that the @a row has.
   */
  int get_length() const;

  
  void set_is_default(int num, bool is_default = true);
  
  /** Tells if the value at column @a num in @a row must be considered as a default value
   * @param num Field index.
   */
  bool get_is_default(int num) const;

  //TODO: Properties.


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gda
} // namespace Gnome


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gnome::Gda::Row
   */
  Glib::RefPtr<Gnome::Gda::Row> wrap(GdaRow* object, bool take_copy = false);
}


#endif /* _LIBGDAMM_ROW_H */

